/*
 * Decompiled with CFR 0.152.
 */
package com.sourcetrail.name.resolver;

import com.sourcetrail.ContextList;
import com.sourcetrail.name.DeclName;
import com.sourcetrail.name.FunctionDeclName;
import com.sourcetrail.name.TypeName;
import com.sourcetrail.name.VariableDeclName;
import com.sourcetrail.name.resolver.DeclNameResolver;
import com.sourcetrail.name.resolver.NameResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;

public class BindingNameResolver
extends NameResolver {
    public static IBinding getParentBinding(IBinding binding) {
        if (binding instanceof ITypeBinding) {
            return BindingNameResolver.getParentBinding((ITypeBinding)binding);
        }
        if (binding instanceof IMethodBinding) {
            return ((IMethodBinding)binding).getDeclaringClass();
        }
        if (binding instanceof IVariableBinding) {
            return ((IVariableBinding)binding).getDeclaringClass();
        }
        return null;
    }

    public static IBinding getParentBinding(ITypeBinding binding) {
        if (binding.isLocal() || binding.isAnonymous()) {
            if (binding.getDeclaringMember() instanceof IVariableBinding) {
                IVariableBinding variableBinding = (IVariableBinding)binding.getDeclaringMember();
                if (variableBinding.getDeclaringClass() != null) {
                    return variableBinding.getDeclaringClass();
                }
                return variableBinding.getDeclaringMethod();
            }
            return binding.getDeclaringMethod();
        }
        if (binding.isMember()) {
            return binding.getDeclaringClass();
        }
        if (binding.isTypeVariable()) {
            if (binding.getDeclaringClass() != null) {
                return binding.getDeclaringClass();
            }
            return binding.getDeclaringMethod();
        }
        if (binding.isTopLevel()) {
            return binding.getPackage();
        }
        return null;
    }

    public BindingNameResolver(File currentFile, CompilationUnit compilationUnit, ContextList ignoredContexts) {
        super(currentFile, compilationUnit, ignoredContexts);
    }

    public static Optional<TypeName> getQualifiedName(ITypeBinding binding, File currentFile, CompilationUnit compilationUnit) {
        return BindingNameResolver.getQualifiedName(binding, currentFile, compilationUnit, null);
    }

    public static Optional<TypeName> getQualifiedName(ITypeBinding binding, File currentFile, CompilationUnit compilationUnit, ContextList ignoredContexts) {
        BindingNameResolver resolver = new BindingNameResolver(currentFile, compilationUnit, ignoredContexts);
        return resolver.getQualifiedName(binding);
    }

    public Optional<TypeName> getQualifiedName(ITypeBinding binding) {
        DeclName parentDeclName;
        if (binding == null) {
            return Optional.empty();
        }
        if (binding.isArray()) {
            return this.getQualifiedName(binding.getElementType());
        }
        if (binding.isAnonymous()) {
            ASTNode node = this.m_compilationUnit.findDeclaringNode((IBinding)binding);
            if (node instanceof AnonymousClassDeclaration) {
                DeclName decl = DeclNameResolver.getQualifiedDeclName((AnonymousClassDeclaration)node, this.m_currentFile, this.m_compilationUnit, this.m_ignoredContexts);
                return Optional.of(new TypeName(decl.getName(), decl.getTypeParameterNames(), null, decl.getParent()));
            }
            return Optional.empty();
        }
        if (binding.isParameterizedType()) {
            ArrayList<TypeName> typeArguments = new ArrayList<TypeName>();
            for (ITypeBinding typeArgumentBinding : binding.getTypeArguments()) {
                Optional<TypeName> typeArgument = this.getQualifiedName(typeArgumentBinding);
                if (!typeArgument.isPresent()) continue;
                typeArguments.add(typeArgument.get());
            }
            Optional<TypeName> typeName = this.getQualifiedName(binding.getTypeDeclaration());
            if (typeName.isPresent()) {
                DeclName declName = typeName.get().toDeclName();
                return Optional.of(new TypeName(declName.getName(), declName.getTypeParameterNames(), typeArguments, declName.getParent()));
            }
            return Optional.empty();
        }
        String name = binding.getName();
        ArrayList<String> typeParameterNames = null;
        if (binding.isGenericType()) {
            typeParameterNames = new ArrayList<String>();
            for (ITypeBinding typeParameter : binding.getTypeParameters()) {
                typeParameterNames.add(typeParameter.getName());
            }
        }
        if ((parentDeclName = this.getQualifiedContextName((IBinding)binding)) != null && parentDeclName.getIsUnsolved()) {
            return Optional.empty();
        }
        return Optional.of(new TypeName(name, typeParameterNames, null, parentDeclName));
    }

    public static Optional<DeclName> getQualifiedName(IMethodBinding binding, File currentFile, CompilationUnit compilationUnit) {
        return BindingNameResolver.getQualifiedName(binding, currentFile, compilationUnit, null);
    }

    public static Optional<DeclName> getQualifiedName(IMethodBinding binding, File currentFile, CompilationUnit compilationUnit, ContextList ignoredContexts) {
        BindingNameResolver resolver = new BindingNameResolver(currentFile, compilationUnit, ignoredContexts);
        return resolver.getQualifiedName(binding);
    }

    public Optional<DeclName> getQualifiedName(IMethodBinding binding) {
        TypeName returnTypeName;
        if (binding == null) {
            return Optional.empty();
        }
        String name = binding.getName();
        ArrayList<String> typeParameterNames = null;
        if (binding.isGenericMethod()) {
            typeParameterNames = new ArrayList<String>();
            for (ITypeBinding typeParameter : binding.getTypeParameters()) {
                typeParameterNames.add(typeParameter.getName());
            }
        }
        DeclName declName = null;
        boolean isStatic = Modifier.isStatic((int)binding.getModifiers());
        ContextList ignoredContexts = this.m_ignoredContexts.copy();
        ignoredContexts.add((IBinding)binding);
        TypeName typeName = returnTypeName = binding.isConstructor() ? null : BindingNameResolver.getQualifiedName(binding.getReturnType(), this.m_currentFile, this.m_compilationUnit, ignoredContexts).orElse(TypeName.unsolved());
        if (binding.isAnnotationMember()) {
            declName = new VariableDeclName(name, returnTypeName, isStatic);
        } else {
            ArrayList<TypeName> parameterTypeNames = new ArrayList<TypeName>();
            for (ITypeBinding parameterType : binding.getParameterTypes()) {
                parameterTypeNames.add(BindingNameResolver.getQualifiedName(parameterType, this.m_currentFile, this.m_compilationUnit, ignoredContexts).orElse(TypeName.unsolved()));
            }
            declName = new FunctionDeclName(name, typeParameterNames, returnTypeName, parameterTypeNames, isStatic);
        }
        DeclName parentDeclName = this.getQualifiedContextName((IBinding)binding);
        if (parentDeclName != null) {
            if (!parentDeclName.getIsUnsolved()) {
                declName.setParent(parentDeclName);
            } else {
                return Optional.empty();
            }
        }
        return Optional.of(declName);
    }

    public static Optional<DeclName> getQualifiedName(IPackageBinding binding, File currentFile, CompilationUnit compilationUnit) {
        return BindingNameResolver.getQualifiedName(binding, currentFile, compilationUnit, null);
    }

    public static Optional<DeclName> getQualifiedName(IPackageBinding binding, File currentFile, CompilationUnit compilationUnit, ContextList ignoredContexts) {
        BindingNameResolver resolver = new BindingNameResolver(currentFile, compilationUnit, ignoredContexts);
        return resolver.getQualifiedName(binding);
    }

    public Optional<DeclName> getQualifiedName(IPackageBinding binding) {
        if (!binding.isUnnamed()) {
            return Optional.of(DeclName.fromDotSeparatedString(binding.getName()));
        }
        return Optional.empty();
    }

    public static DeclName getQualifiedName(IVariableBinding binding, File currentFile, CompilationUnit compilationUnit) {
        return BindingNameResolver.getQualifiedName(binding, currentFile, compilationUnit, null);
    }

    public static DeclName getQualifiedName(IVariableBinding binding, File currentFile, CompilationUnit compilationUnit, ContextList ignoredContexts) {
        BindingNameResolver resolver = new BindingNameResolver(currentFile, compilationUnit, ignoredContexts);
        return resolver.getQualifiedName(binding);
    }

    public DeclName getQualifiedName(IVariableBinding binding) {
        if (binding == null) {
            return DeclName.unsolved();
        }
        if (binding.isField() || binding.isEnumConstant()) {
            DeclName declName;
            if (binding.isEnumConstant()) {
                declName = new DeclName(binding.getName());
            } else {
                TypeName typeName = this.getQualifiedName(binding.getType()).orElse(TypeName.unsolved());
                declName = new VariableDeclName(binding.getName(), typeName, Modifier.isStatic((int)binding.getModifiers()));
            }
            DeclName parentDeclName = this.getQualifiedContextName((IBinding)binding);
            if (parentDeclName != null) {
                if (!parentDeclName.getIsUnsolved()) {
                    declName.setParent(parentDeclName);
                } else {
                    declName = DeclName.unsolved();
                }
            }
            return declName;
        }
        if (binding.getDeclaringMethod() != null) {
            return DeclName.localSymbol(this.getQualifiedName(binding.getDeclaringMethod()).orElse(DeclName.unsolved()), binding.getVariableId());
        }
        return DeclName.globalSymbol(this.m_currentFile, binding.getVariableId());
    }

    private DeclName getQualifiedContextName(IBinding binding) {
        IBinding parentBinding = BindingNameResolver.getParentBinding(binding);
        if (parentBinding == null || this.m_ignoredContexts.contains(parentBinding)) {
            return null;
        }
        if (parentBinding instanceof ITypeBinding) {
            return this.getQualifiedName((ITypeBinding)parentBinding).map(tn -> tn.toDeclName()).orElse(DeclName.unsolved());
        }
        if (parentBinding instanceof IMethodBinding) {
            return this.getQualifiedName((IMethodBinding)parentBinding).orElse(DeclName.unsolved());
        }
        if (parentBinding instanceof IVariableBinding) {
            return this.getQualifiedName((IVariableBinding)parentBinding);
        }
        if (parentBinding instanceof IPackageBinding) {
            return this.getQualifiedName((IPackageBinding)parentBinding).orElse(null);
        }
        return null;
    }
}

