/* ASTParser.java */
/* Generated By:JavaCC: Do not edit this line. ASTParser.java */
/*
 *
 * This file is part of Java 1.8 parser and Abstract Syntax Tree.
 *
 * Java 1.8 parser and Abstract Syntax Tree is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Java 1.8 parser and Abstract Syntax Tree.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.github.javaparser;

import java.io.*;
import java.util.*;
import com.github.javaparser.ast.*;
import com.github.javaparser.ast.body.*;
import com.github.javaparser.ast.comments.*;
import com.github.javaparser.ast.expr.*;
import com.github.javaparser.ast.stmt.*;
import com.github.javaparser.ast.type.*;
import static com.github.javaparser.Range.*;
import static com.github.javaparser.Position.*;

/**
 * <p>This class was generated automatically by javacc, do not edit.</p>
 */
final class ASTParser implements ASTParserConstants {

    private final Position INVALID = pos(-1, 0);

        void reset(InputStream in, String encoding) throws IOException {
        ReInit(new StreamProvider(in, encoding));
    }

    private <T> List<T> add(List<T> list, T obj) {
        if (list == null) {
                list = new LinkedList<T>();
        }
        list.add(obj);
        return list;
    }

    private <T> List<T> add(int pos, List<T> list, T obj) {
        if (list == null) {
                list = new LinkedList<T>();
        }
        list.add(pos, obj);
        return list;
    }

        private class ModifierHolder {
                final EnumSet<Modifier> modifiers;
                final List<AnnotationExpr> annotations;
                final Position begin;

                public ModifierHolder(Position begin, EnumSet<Modifier> modifiers, List<AnnotationExpr> annotations) {
                        this.begin = begin;
                        this.modifiers = modifiers;
                        this.annotations = annotations;
                }
        }

    public void addModifier(EnumSet<Modifier> modifiers, Modifier mod, Token token) throws ParseException {
        if (modifiers.contains(mod)) {
            throwParseException("Duplicated modifier");
        }
        modifiers.add(mod);
    }

    public void addMultipleModifier(EnumSet<Modifier> modifiers, EnumSet<Modifier> mods, Token token) throws ParseException {
        if(mods == null)
            return;
        for(Modifier m : mods)
            if (modifiers.contains(m))
                throwParseException("Duplicated modifier");
        for(Modifier m : mods)
            modifiers.add(m);
    }

    /**
     * Return the list of tokens that have been encountered while parsing code using
     * this parser.
     *
     * @return a list of tokens
     */
    public List<Token> getTokens() {
        return token_source.getTokens();
    }

    private void throwParseException(String message) throws ParseException {
        StringBuilder buf = new StringBuilder();
        buf.append(message);
        buf.append(": \"");
        buf.append(token.image);
        buf.append("\" at line ");
        buf.append(token.beginLine);
        buf.append(", column ");
        buf.append(token.beginColumn);
        ParseException e = new ParseException(buf.toString());
        e.currentToken = token;
        throw e;
    }

    private Expression generateLambda(Expression ret, Statement lambdaBody) throws ParseException {
            if (ret instanceof EnclosedExpr) {
                Expression inner = ((EnclosedExpr) ret).getInner();
                if (inner != null && inner instanceof NameExpr) {
                    VariableDeclaratorId id = new VariableDeclaratorId(inner.getRange(), ((NameExpr)inner).getName(), 0);
                    List<Parameter> params = add(null, new Parameter(ret.getRange(), EnumSet.noneOf(Modifier.class), null, new UnknownType(), false, id));
                    ret = new LambdaExpr(range(ret.getBegin(), lambdaBody.getEnd()), params, lambdaBody, true);
                } else {
                    ret = new LambdaExpr(range(ret.getBegin(), lambdaBody.getEnd()), null, lambdaBody, true);
                }
            } else if (ret instanceof NameExpr) {
                    VariableDeclaratorId id = new VariableDeclaratorId(ret.getRange(), ((NameExpr)ret).getName(), 0);
                List<Parameter> params = add(null, new Parameter(ret.getRange(), EnumSet.noneOf(Modifier.class), null, new UnknownType(), false, id));
                ret = new LambdaExpr(ret.getRange(), params, lambdaBody, false);
            } else if (ret instanceof LambdaExpr) {
                ((LambdaExpr) ret).setBody(lambdaBody);
                ret.setEnd(lambdaBody.getEnd());
        } else if (ret instanceof CastExpr) {
            CastExpr castExpr = (CastExpr)ret;
            Expression inner = generateLambda(castExpr.getExpr(), lambdaBody);
            castExpr.setExpr(inner);
            } else {
                throw new ParseException("Failed to parse lambda expression! Please create an issue at https://github.com/javaparser/javaparser/issues");
            }
            return ret;
    }

    private TypeArguments createTypeArguments(List<Type> typeArgs) {
        boolean usesDiamondOperator = typeArgs != null && typeArgs.isEmpty();
        return usesDiamondOperator ? TypeArguments.withDiamondOperator() : TypeArguments.withArguments(typeArgs);
    }

    static final class GTToken extends Token {
        int realKind = ASTParserConstants.GT;

        GTToken(int kind, String image) {
            this.kind = kind;
            this.image = image;
        }

        public static Token newToken(int kind, String image) {
            return new GTToken(kind, image);
        }
    }

    private static class RangedList<T> {
        Range range = Range.UNKNOWN;
        List<T> list;
        RangedList(List<T> list) {
            this.list = list;
        }
        void beginAt(Position begin) {
            range=range.withBegin(begin);
        }
        void endAt(Position end) {
            range=range.withEnd(end);
        }
        void add(T t) {
            if (list == null) {
                list = new LinkedList<T>();
            }
            list.add(t);
        }
    }

    private Position tokenBegin() {
        return pos(token.beginLine,token.beginColumn);
    }

    private Position tokenEnd() {
        return pos(token.endLine,token.endColumn);
    }

    private Range tokenRange() {
        return range(token.beginLine, token.beginColumn, token.endLine, token.endColumn);
    }

/*****************************************
 * THE JAVA LANGUAGE GRAMMAR STARTS HERE *
 *****************************************/

/*
 * Program structuring syntax follows.
 */
  final public 
CompilationUnit CompilationUnit() throws ParseException {PackageDeclaration pakage = null;
        List<ImportDeclaration> imports = null;
        ImportDeclaration in = null;
        List<TypeDeclaration<?>> types = null;
        TypeDeclaration tn = null;
        Position begin = INVALID;
    if (jj_2_1(2147483647)) {
      pakage = PackageDeclaration();
begin = begin.orIfInvalid(pakage.getBegin());
    } else {
      ;
    }
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IMPORT:
      case SEMICOLON:{
        ;
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IMPORT:{
        in = ImportDeclaration();
begin = begin.orIfInvalid(in.getBegin()); imports = add(imports, in);
        break;
        }
      case SEMICOLON:{
        in = EmptyImportDeclaration();
begin = begin.orIfInvalid(in.getBegin()); imports = add(imports, in);
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ABSTRACT:
      case CLASS:
      case ENUM:
      case FINAL:
      case INTERFACE:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
      case STRICTFP:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOLATILE:
      case SEMICOLON:
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      tn = TypeDeclaration();
begin = begin.orIfInvalid(tn.getBegin()); types = add(types, tn);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 0:{
      jj_consume_token(0);
      break;
      }
    case 156:{
      jj_consume_token(156);
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return new CompilationUnit(begin.invalid() ? Range.UNKNOWN : range(begin, tokenEnd()), pakage, imports, types);
  }

  final public ImportDeclaration EmptyImportDeclaration() throws ParseException {Position begin;
    jj_consume_token(SEMICOLON);
begin = tokenBegin();
return ImportDeclaration.createEmptyDeclaration(range(begin, tokenEnd()));
  }

  final public PackageDeclaration PackageDeclaration() throws ParseException {List<AnnotationExpr> annotations = null;
        AnnotationExpr ann;
        NameExpr name;
        Position begin;
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        break label_3;
      }
      ann = Annotation();
annotations = add(annotations, ann);
    }
    jj_consume_token(PACKAGE);
begin = tokenBegin();
    name = Name();
    jj_consume_token(SEMICOLON);
return new PackageDeclaration(range(begin, tokenEnd()), annotations, name);
  }

  final public ImportDeclaration ImportDeclaration() throws ParseException {NameExpr name;
        boolean isStatic = false;
        boolean isAsterisk = false;
        Position begin;
    jj_consume_token(IMPORT);
begin = tokenBegin();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STATIC:{
      jj_consume_token(STATIC);
isStatic = true;
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    name = Name();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOT:{
      jj_consume_token(DOT);
      jj_consume_token(STAR);
isAsterisk = true;
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
return new ImportDeclaration(range(begin, tokenEnd()),name, isStatic, isAsterisk);
  }

/*
 * Modifiers. We match all modifiers in a single rule to reduce the chances of
 * syntax errors for simple modifier mistakes. It will also enable us to give
 * better error messages.
 */
  final public 
ModifierHolder Modifiers() throws ParseException {Position begin = INVALID;
    EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
    List<AnnotationExpr> annotations = null;
    AnnotationExpr ann;
    label_4:
    while (true) {
      if (jj_2_2(2)) {
        ;
      } else {
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PUBLIC:{
        jj_consume_token(PUBLIC);
addModifier(modifiers, Modifier.PUBLIC, token); begin = begin.orIfInvalid(tokenBegin());
        break;
        }
      case STATIC:{
        jj_consume_token(STATIC);
addModifier(modifiers, Modifier.STATIC, token); begin = begin.orIfInvalid(tokenBegin());
        break;
        }
      case PROTECTED:{
        jj_consume_token(PROTECTED);
addModifier(modifiers, Modifier.PROTECTED, token); begin = begin.orIfInvalid(tokenBegin());
        break;
        }
      case PRIVATE:{
        jj_consume_token(PRIVATE);
addModifier(modifiers, Modifier.PRIVATE, token); begin = begin.orIfInvalid(tokenBegin());
        break;
        }
      case FINAL:{
        jj_consume_token(FINAL);
addModifier(modifiers, Modifier.FINAL, token); begin = begin.orIfInvalid(tokenBegin());
        break;
        }
      case ABSTRACT:{
        jj_consume_token(ABSTRACT);
addModifier(modifiers, Modifier.ABSTRACT, token); begin = begin.orIfInvalid(tokenBegin());
        break;
        }
      case SYNCHRONIZED:{
        jj_consume_token(SYNCHRONIZED);
addModifier(modifiers, Modifier.SYNCHRONIZED, token); begin = begin.orIfInvalid(tokenBegin());
        break;
        }
      case NATIVE:{
        jj_consume_token(NATIVE);
addModifier(modifiers, Modifier.NATIVE, token); begin = begin.orIfInvalid(tokenBegin());
        break;
        }
      case TRANSIENT:{
        jj_consume_token(TRANSIENT);
addModifier(modifiers, Modifier.TRANSIENT, token); begin = begin.orIfInvalid(tokenBegin());
        break;
        }
      case VOLATILE:{
        jj_consume_token(VOLATILE);
addModifier(modifiers, Modifier.VOLATILE, token); begin = begin.orIfInvalid(tokenBegin());
        break;
        }
      case STRICTFP:{
        jj_consume_token(STRICTFP);
addModifier(modifiers, Modifier.STRICTFP, token);  begin = begin.orIfInvalid(tokenBegin());
        break;
        }
      case AT:{
        ann = Annotation();
annotations = add(annotations, ann); begin = begin.orIfInvalid(ann.getBegin());
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return new ModifierHolder(begin, modifiers, annotations);
  }

/*
 * Declaration syntax follows.
 */
  final public TypeDeclaration TypeDeclaration() throws ParseException {ModifierHolder modifier;
   TypeDeclaration ret;

    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
ret = new EmptyTypeDeclaration(tokenRange());
      break;
      }
    case ABSTRACT:
    case CLASS:
    case ENUM:
    case FINAL:
    case INTERFACE:
    case NATIVE:
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
    case STATIC:
    case STRICTFP:
    case SYNCHRONIZED:
    case TRANSIENT:
    case VOLATILE:
    case AT:{
      modifier = Modifiers();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CLASS:
      case INTERFACE:{
        ret = ClassOrInterfaceDeclaration(modifier);
        break;
        }
      case ENUM:{
        ret = EnumDeclaration(modifier);
        break;
        }
      case AT:{
        ret = AnnotationTypeDeclaration(modifier);
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
  }

  final public ClassOrInterfaceDeclaration ClassOrInterfaceDeclaration(ModifierHolder modifier) throws ParseException {boolean isInterface = false;
    NameExpr name;
    RangedList<TypeParameter> typePar = new RangedList<TypeParameter>(null);
    List<ClassOrInterfaceType> extList = null;
    List<ClassOrInterfaceType> impList = null;
    List<BodyDeclaration<?>> members;
    Position begin = modifier.begin;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CLASS:{
      jj_consume_token(CLASS);
      break;
      }
    case INTERFACE:{
      jj_consume_token(INTERFACE);
isInterface = true;
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
begin = begin.orIfInvalid(tokenBegin());
    name = Name();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LT:{
      typePar = TypeParameters();
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EXTENDS:{
      extList = ExtendsList(isInterface);
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IMPLEMENTS:{
      impList = ImplementsList(isInterface);
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    members = ClassOrInterfaceBody(isInterface);
ClassOrInterfaceDeclaration tmp = new ClassOrInterfaceDeclaration(range(begin, tokenEnd()), modifier.modifiers, modifier.annotations, isInterface, null, typePar.list, extList, impList, members);
    tmp.setNameExpr(name);
    return tmp;
  }

  final public List<ClassOrInterfaceType> ExtendsList(boolean isInterface) throws ParseException {boolean extendsMoreThanOne = false;
   List<ClassOrInterfaceType> ret = new LinkedList<ClassOrInterfaceType>();
   ClassOrInterfaceType cit;
   AnnotationExpr ann;
   List<AnnotationExpr> annotations = null;
    jj_consume_token(EXTENDS);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        break label_5;
      }
      ann = Annotation();
annotations = add(annotations, ann);
    }
    cit = ClassOrInterfaceType();
cit.setAnnotations(annotations); ret.add(cit);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        break label_6;
      }
      jj_consume_token(COMMA);
      cit = ClassOrInterfaceType();
ret.add(cit); extendsMoreThanOne = true;
    }
if (extendsMoreThanOne && !isInterface)
         throwParseException("A class cannot extend more than one other class");
return ret;
  }

  final public List<ClassOrInterfaceType> ImplementsList(boolean isInterface) throws ParseException {List<ClassOrInterfaceType> ret = new LinkedList<ClassOrInterfaceType>();
   ClassOrInterfaceType cit;
    jj_consume_token(IMPLEMENTS);
    cit = ClassOrInterfaceTypeWithAnnotations();
ret.add(cit);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        break label_7;
      }
      jj_consume_token(COMMA);
      cit = ClassOrInterfaceTypeWithAnnotations();
ret.add(cit);
    }
if (isInterface)
         throwParseException("An interface cannot implement other interfaces");
return ret;
  }

  final public EnumDeclaration EnumDeclaration(ModifierHolder modifier) throws ParseException {NameExpr name;
        List<ClassOrInterfaceType> impList = null;
        EnumConstantDeclaration entry;
        List<EnumConstantDeclaration> entries = null;
        BodyDeclaration<?> member;
        List<BodyDeclaration<?>> members = null;
        Position begin = modifier.begin;
    jj_consume_token(ENUM);
begin = begin.orIfInvalid(tokenBegin());
    name = Name();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IMPLEMENTS:{
      impList = ImplementsList(false);
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENTIFIER:
    case AT:{
entries = new LinkedList<EnumConstantDeclaration>();
      entry = EnumConstantDeclaration();
entries.add(entry);
      label_8:
      while (true) {
        if (jj_2_3(2)) {
          ;
        } else {
          break label_8;
        }
        jj_consume_token(COMMA);
        entry = EnumConstantDeclaration();
entries.add(entry);
      }
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ABSTRACT:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case CLASS:
        case _DEFAULT:
        case DOUBLE:
        case ENUM:
        case FINAL:
        case FLOAT:
        case INT:
        case INTERFACE:
        case LONG:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case SHORT:
        case STATIC:
        case STRICTFP:
        case SYNCHRONIZED:
        case TRANSIENT:
        case VOID:
        case VOLATILE:
        case IDENTIFIER:
        case LBRACE:
        case SEMICOLON:
        case AT:
        case LT:{
          ;
          break;
          }
        default:
          jj_la1[20] = jj_gen;
          break label_9;
        }
        member = ClassOrInterfaceBodyDeclaration(false);
members = add(members, member);
      }
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
EnumDeclaration tmp = new EnumDeclaration(range(begin, tokenEnd()), modifier.modifiers, modifier.annotations, null, impList, entries, members);
      tmp.setNameExpr(name);
      return tmp;
  }

  final public EnumConstantDeclaration EnumConstantDeclaration() throws ParseException {List<AnnotationExpr> annotations = null;
        AnnotationExpr ann;
        String name;
        List<Expression> args = null;
        List<BodyDeclaration<?>> classBody = null;
        Position begin = INVALID;

    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        break label_10;
      }
      ann = Annotation();
annotations = add(annotations, ann); begin = begin.orIfInvalid(ann.getBegin());
    }
    jj_consume_token(IDENTIFIER);
name = token.image; begin = begin.orIfInvalid(tokenBegin());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      args = Arguments();
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACE:{
      classBody = ClassOrInterfaceBody(false);
      break;
      }
    default:
      jj_la1[24] = jj_gen;
      ;
    }
return new EnumConstantDeclaration(range(begin, tokenEnd()), annotations, name, args, classBody);
  }

/**
 * If the list inside the returned RangedList is null, there are no brackets.
 * If it is empty, there are brackets, but nothing is in them <>.
 * The normal case is that it contains TypeParameters, like <A, B, C>.
 */
  final public RangedList<TypeParameter> TypeParameters() throws ParseException {RangedList<TypeParameter> ret = new RangedList<TypeParameter>(new LinkedList<TypeParameter>());
        TypeParameter tp;
        List<AnnotationExpr> annotations = null;
        AnnotationExpr ann;
    jj_consume_token(LT);
ret.beginAt(tokenBegin());
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        break label_11;
      }
      ann = Annotation();
annotations = add(annotations, ann);
    }
    tp = TypeParameter();
ret.add(tp); tp.setAnnotations(annotations); annotations = null;
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        break label_12;
      }
      jj_consume_token(COMMA);
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AT:{
          ;
          break;
          }
        default:
          jj_la1[27] = jj_gen;
          break label_13;
        }
        ann = Annotation();
annotations = add(annotations, ann);
      }
      tp = TypeParameter();
ret.add(tp); tp.setAnnotations(annotations); annotations = null;
    }
    jj_consume_token(GT);
ret.endAt(tokenEnd());
return ret;
  }

  final public TypeParameter TypeParameter() throws ParseException {String name;
        List<ClassOrInterfaceType> typeBound = null;
        Position begin;
    jj_consume_token(IDENTIFIER);
name = token.image; begin=tokenBegin();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EXTENDS:{
      typeBound = TypeBound();
      break;
      }
    default:
      jj_la1[28] = jj_gen;
      ;
    }
return new TypeParameter(range(begin, tokenEnd()),name, typeBound);
  }

  final public List<ClassOrInterfaceType> TypeBound() throws ParseException {List<ClassOrInterfaceType> ret = new LinkedList<ClassOrInterfaceType>();
        ClassOrInterfaceType cit;
        AnnotationExpr ann;
        List<AnnotationExpr> annotations = null;
    jj_consume_token(EXTENDS);
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        break label_14;
      }
      ann = Annotation();
annotations = add(annotations, ann);
    }
    cit = ClassOrInterfaceType();
cit.setAnnotations(annotations); ret.add(cit); annotations=null;
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BIT_AND:{
        ;
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        break label_15;
      }
      jj_consume_token(BIT_AND);
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AT:{
          ;
          break;
          }
        default:
          jj_la1[31] = jj_gen;
          break label_16;
        }
        ann = Annotation();
annotations = add(annotations, ann);
      }
      cit = ClassOrInterfaceType();
cit.setAnnotations(annotations); ret.add(cit); annotations=null;
    }
return ret;
  }

  final public List<BodyDeclaration<?>> ClassOrInterfaceBody(boolean isInterface) throws ParseException {List<BodyDeclaration<?>> ret = new LinkedList<BodyDeclaration<?>>();
        BodyDeclaration member;
    jj_consume_token(LBRACE);
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case _DEFAULT:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case STRICTFP:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOID:
      case VOLATILE:
      case IDENTIFIER:
      case LBRACE:
      case SEMICOLON:
      case AT:
      case LT:{
        ;
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        break label_17;
      }
      member = ClassOrInterfaceBodyDeclaration(isInterface);
ret.add(member);
    }
    jj_consume_token(RBRACE);
return ret;
  }

  final public BodyDeclaration<?> ClassOrInterfaceBodyDeclaration(boolean isInterface) throws ParseException {ModifierHolder modifier;
   ModifierHolder modifier2 = null;
   EnumSet<Modifier> aux = null;
   BodyDeclaration<?> ret;
   boolean isDefault = false;

    if (jj_2_6(2)) {
      ret = InitializerDeclaration();
if (isInterface)
                throwParseException("An interface cannot have initializers");
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case _DEFAULT:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case STRICTFP:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOID:
      case VOLATILE:
      case IDENTIFIER:
      case AT:
      case LT:{
        modifier = Modifiers();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case _DEFAULT:{
          jj_consume_token(_DEFAULT);
          modifier2 = Modifiers();
if(!isInterface)
            {
              throwParseException("A class cannot have default members");
            }
            isDefault = true;
          break;
          }
        default:
          jj_la1[33] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CLASS:
        case INTERFACE:{
          ret = ClassOrInterfaceDeclaration(modifier);
          break;
          }
        case ENUM:{
          ret = EnumDeclaration(modifier);
          break;
          }
        case AT:{
          ret = AnnotationTypeDeclaration(modifier);
          break;
          }
        default:
          jj_la1[34] = jj_gen;
          if (jj_2_4(2147483647)) {
            ret = ConstructorDeclaration(modifier);
          } else if (jj_2_5(2147483647)) {
            ret = FieldDeclaration(modifier);
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case BOOLEAN:
            case BYTE:
            case CHAR:
            case DOUBLE:
            case FLOAT:
            case INT:
            case LONG:
            case SHORT:
            case VOID:
            case IDENTIFIER:
            case LT:{
              ret = MethodDeclaration(modifier);
if(isDefault && ret!= null && ((MethodDeclaration)ret).getBody() == null)
                {
                  throwParseException("\"default\" methods must have a body");
                }
                ((MethodDeclaration)ret).setDefault(isDefault);
                if(modifier2!= null)
                {
                  aux = modifier2.modifiers;
                }
                addMultipleModifier(modifier.modifiers, aux, token);
                ((MethodDeclaration)ret).setModifiers(modifier.modifiers);
              break;
              }
            default:
              jj_la1[35] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
if(isDefault && ! (ret instanceof MethodDeclaration))
            {
              throwParseException("Only methods can have the keyword \"default\".");
            }
        break;
        }
      case SEMICOLON:{
        jj_consume_token(SEMICOLON);
ret = new EmptyMemberDeclaration(tokenRange());
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return ret;
  }

  final public FieldDeclaration FieldDeclaration(ModifierHolder modifier) throws ParseException {Type type;
        List<VariableDeclarator> variables = new LinkedList<VariableDeclarator>();
        VariableDeclarator val;
    // Modifiers are already matched in the caller
      type = Type();
    val = VariableDeclarator();
variables.add(val);
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        break label_18;
      }
      jj_consume_token(COMMA);
      val = VariableDeclarator();
variables.add(val);
    }
    jj_consume_token(SEMICOLON);
Position begin = modifier.begin.orIfInvalid(type.getBegin());
        return new FieldDeclaration(range(begin, tokenEnd()), modifier.modifiers, modifier.annotations, type, variables);
  }

  final public VariableDeclarator VariableDeclarator() throws ParseException {VariableDeclaratorId id;
        Expression init = null;
    id = VariableDeclaratorId();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASSIGN:{
      jj_consume_token(ASSIGN);
      init = VariableInitializer();
      break;
      }
    default:
      jj_la1[38] = jj_gen;
      ;
    }
return new  VariableDeclarator(range(id.getBegin(), tokenEnd()), id, init);
  }

  final public VariableDeclaratorId VariableDeclaratorId() throws ParseException {String name;
        int arrayCount = 0;
        Position begin;
    jj_consume_token(IDENTIFIER);
name = token.image; begin=tokenBegin();
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:{
        ;
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        break label_19;
      }
      jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
arrayCount++;
    }
return new VariableDeclaratorId(range(begin, tokenEnd()),name, arrayCount);
  }

  final public Expression VariableInitializer() throws ParseException {Expression ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACE:{
      ret = ArrayInitializer();
      break;
      }
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case LONG_LITERAL:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:{
      ret = Expression();
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
  }

  final public ArrayInitializerExpr ArrayInitializer() throws ParseException {List<Expression> values = null;
        Expression val;
        Position begin;
    jj_consume_token(LBRACE);
begin=tokenBegin();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case LONG_LITERAL:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case LBRACE:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:{
      val = VariableInitializer();
values = add(values, val);
      label_20:
      while (true) {
        if (jj_2_7(2)) {
          ;
        } else {
          break label_20;
        }
        jj_consume_token(COMMA);
        val = VariableInitializer();
values = add(values, val);
      }
      break;
      }
    default:
      jj_la1[41] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
return new ArrayInitializerExpr(range(begin, tokenEnd()), values);
  }

  final public MethodDeclaration MethodDeclaration(ModifierHolder modifier) throws ParseException {RangedList<TypeParameter> typeParameters = new RangedList<TypeParameter>(null);
        Type type;
        NameExpr name;
        List<Parameter> parameters;
        int arrayCount = 0;
        List<ReferenceType> throws_ = null;
        BlockStmt block = null;
        Position beginPos = modifier.begin;
        ReferenceType throwType;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LT:{
      typeParameters = TypeParameters();
if(beginPos.line==-1){ beginPos=typeParameters.range.begin;}
      break;
      }
    default:
      jj_la1[43] = jj_gen;
      ;
    }
    type = ResultType();
if(beginPos.line==-1){beginPos=type.getBegin();}
    name = Name();
    parameters = FormalParameters();
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:{
        ;
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        break label_21;
      }
      jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
arrayCount++;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case THROWS:{
      jj_consume_token(THROWS);
      throwType = ReferenceTypeWithAnnotations();
throws_ = add(throws_, throwType);
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[45] = jj_gen;
          break label_22;
        }
        jj_consume_token(COMMA);
        throwType = ReferenceTypeWithAnnotations();
throws_ = add(throws_, throwType);
      }
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACE:{
      block = Block();
      break;
      }
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      break;
      }
    default:
      jj_la1[47] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
MethodDeclaration tmp = new MethodDeclaration(range(beginPos, pos(token.endLine, token.endColumn)), modifier.modifiers, modifier.annotations, typeParameters.list, type, null, parameters, arrayCount, throws_, block);
      tmp.setNameExpr(name);
      return tmp;
  }

  final public ReferenceType ReferenceTypeWithAnnotations() throws ParseException {List<AnnotationExpr> annotations = new ArrayList<AnnotationExpr>();
        AnnotationExpr annotation = null;
        ReferenceType type;
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[48] = jj_gen;
        break label_23;
      }
      annotation = Annotation();
annotations = add(annotations, annotation);
    }
    type = ReferenceType();
if (type.getAnnotations() != null) {
            type.getAnnotations().addAll(annotations);
        } else {
            type.setAnnotations(annotations);
        }
        return type;
  }

  final public List<Parameter> FormalParameters() throws ParseException {List<Parameter> ret = null;
        Parameter par;
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ABSTRACT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FINAL:
    case FLOAT:
    case INT:
    case LONG:
    case NATIVE:
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
    case SHORT:
    case STATIC:
    case STRICTFP:
    case SYNCHRONIZED:
    case TRANSIENT:
    case VOLATILE:
    case IDENTIFIER:
    case AT:{
      par = FormalParameter();
ret = add(ret, par);
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[49] = jj_gen;
          break label_24;
        }
        jj_consume_token(COMMA);
        par = FormalParameter();
ret = add(ret, par);
      }
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
return ret;
  }

  final public List<Parameter> FormalLambdaParameters() throws ParseException {List<Parameter> ret = null;
  Parameter par;
    jj_consume_token(COMMA);
    par = FormalParameter();
ret = add(ret, par);
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[51] = jj_gen;
        break label_25;
      }
      jj_consume_token(COMMA);
      par = FormalParameter();
ret = add(ret, par);
    }
return ret;
  }

  final public List<Parameter> InferredLambdaParameters() throws ParseException {List<Parameter> ret = null;
  VariableDeclaratorId id;
    jj_consume_token(COMMA);
    id = VariableDeclaratorId();
ret = add(ret, new Parameter(range(id.getBegin(), id.getEnd()), EnumSet.noneOf(Modifier.class), null, new UnknownType(), false, id));
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[52] = jj_gen;
        break label_26;
      }
      jj_consume_token(COMMA);
      id = VariableDeclaratorId();
ret = add(ret, new Parameter(range(id.getBegin(), id.getEnd()), EnumSet.noneOf(Modifier.class), null, new UnknownType(), false, id));
    }
return ret;
  }

  final public Parameter FormalParameter() throws ParseException {ModifierHolder modifier;
        Type type;
        boolean isVarArg = false;
        VariableDeclaratorId id;
    modifier = Modifiers();
    type = Type();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ELLIPSIS:{
      jj_consume_token(ELLIPSIS);
isVarArg = true;
      break;
      }
    default:
      jj_la1[53] = jj_gen;
      ;
    }
    id = VariableDeclaratorId();
Position begin = modifier.begin.orIfInvalid(type.getBegin());
    return new Parameter(range(begin, tokenEnd()), modifier.modifiers, modifier.annotations, type, isVarArg, id);
  }

  final public ConstructorDeclaration ConstructorDeclaration(ModifierHolder modifier) throws ParseException {RangedList<TypeParameter> typeParameters = new RangedList<TypeParameter>(null);
        NameExpr name;
        List<Parameter> parameters;
        List<ReferenceType> throws_ = null;
        ExplicitConstructorInvocationStmt exConsInv = null;
        List<Statement> stmts;
    Position begin = modifier.begin;
        Position blockBegin = INVALID;
        ReferenceType throwType;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LT:{
      typeParameters = TypeParameters();
begin = begin.orIfInvalid(typeParameters.range.begin);
      break;
      }
    default:
      jj_la1[54] = jj_gen;
      ;
    }
    // Modifiers matched in the caller
      name = SimpleName();
begin = begin.orIfInvalid(typeParameters.range.begin);
    parameters = FormalParameters();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case THROWS:{
      jj_consume_token(THROWS);
      throwType = ReferenceTypeWithAnnotations();
throws_ = add(throws_, throwType);
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[55] = jj_gen;
          break label_27;
        }
        jj_consume_token(COMMA);
        throwType = ReferenceTypeWithAnnotations();
throws_ = add(throws_, throwType);
      }
      break;
      }
    default:
      jj_la1[56] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
blockBegin=tokenBegin();
    if (jj_2_8(2147483647)) {
      exConsInv = ExplicitConstructorInvocation();
    } else {
      ;
    }
    stmts = Statements();
    jj_consume_token(RBRACE);
if (exConsInv != null) {
                stmts = add(0, stmts, exConsInv);
        }
        ConstructorDeclaration tmp = new ConstructorDeclaration(range(begin, pos(token.endLine, token.endColumn)), modifier.modifiers, modifier.annotations, typeParameters.list, null, parameters, throws_, new BlockStmt(range(blockBegin, tokenEnd()), stmts));
    tmp.setNameExpr(name);
    return tmp;
  }

  final public ExplicitConstructorInvocationStmt ExplicitConstructorInvocation() throws ParseException {boolean isThis = false;
        List<Expression> args;
        Expression expr = null;
        RangedList<Type> typeArgs = new RangedList<Type>(null);
        Position begin = INVALID;
    if (jj_2_10(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LT:{
        typeArgs = TypeArguments();
begin=typeArgs.range.begin;
        break;
        }
      default:
        jj_la1[57] = jj_gen;
        ;
      }
      jj_consume_token(THIS);
begin = begin.orIfInvalid(tokenBegin()); isThis = true;
      args = Arguments();
      jj_consume_token(SEMICOLON);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case LT:{
        if (jj_2_9(2147483647)) {
          expr = PrimaryExpressionWithoutSuperSuffix();
          jj_consume_token(DOT);
begin=expr.getBegin();
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LT:{
          typeArgs = TypeArguments();
begin = begin.orIfInvalid(typeArgs.range.begin);
          break;
          }
        default:
          jj_la1[58] = jj_gen;
          ;
        }
        jj_consume_token(SUPER);
begin = begin.orIfInvalid(tokenBegin());
        args = Arguments();
        jj_consume_token(SEMICOLON);
        break;
        }
      default:
        jj_la1[59] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return new ExplicitConstructorInvocationStmt(range(begin, tokenEnd()),typeArgs.list, isThis, expr, args);
  }

  final public List<Statement> Statements() throws ParseException {List<Statement> ret = null;
        Statement stmt;
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ABSTRACT:
      case ASSERT:
      case BOOLEAN:
      case BREAK:
      case BYTE:
      case CHAR:
      case CLASS:
      case CONTINUE:
      case DO:
      case DOUBLE:
      case FALSE:
      case FINAL:
      case FLOAT:
      case FOR:
      case IF:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case NEW:
      case NULL:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case RETURN:
      case SHORT:
      case STATIC:
      case STRICTFP:
      case SUPER:
      case SWITCH:
      case SYNCHRONIZED:
      case THIS:
      case THROW:
      case TRANSIENT:
      case TRUE:
      case TRY:
      case VOID:
      case VOLATILE:
      case WHILE:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case LBRACE:
      case SEMICOLON:
      case AT:
      case INCR:
      case DECR:{
        ;
        break;
        }
      default:
        jj_la1[60] = jj_gen;
        break label_28;
      }
      stmt = BlockStatement();
ret = add(ret, stmt);
    }
return ret;
  }

  final public InitializerDeclaration InitializerDeclaration() throws ParseException {BlockStmt block;
        Position begin = INVALID;
        boolean isStatic = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STATIC:{
      jj_consume_token(STATIC);
isStatic = true; begin=tokenBegin();
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      ;
    }
    block = Block();
begin = begin.orIfInvalid(block.getBegin());
return new InitializerDeclaration(range(begin, tokenEnd()), isStatic, block);
  }

/*
 * Type, name and expression syntax follows.
 */
  final public 
Type Type() throws ParseException {Type ret;
    if (jj_2_11(2)) {
      ret = ReferenceType();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:{
        ret = PrimitiveType();
        break;
        }
      default:
        jj_la1[62] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return ret;
  }

  final public ReferenceType ReferenceType() throws ParseException {Type type;
        int arrayCount = 0;
        List<AnnotationExpr> annotations = null;
        List<List<AnnotationExpr>> accum= null;
        AnnotationExpr ann;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:{
      type = PrimitiveType();
      label_29:
      while (true) {
        label_30:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case AT:{
            ;
            break;
            }
          default:
            jj_la1[63] = jj_gen;
            break label_30;
          }
          ann = Annotation();
annotations = add(annotations, ann);
        }
        jj_consume_token(LBRACKET);
        jj_consume_token(RBRACKET);
arrayCount++; accum = add(accum, annotations); annotations= null;
        if (jj_2_12(2)) {
          ;
        } else {
          break label_29;
        }
      }
      break;
      }
    case IDENTIFIER:{
      type = ClassOrInterfaceType();
      label_31:
      while (true) {
        if (jj_2_13(2)) {
          ;
        } else {
          break label_31;
        }
        label_32:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case AT:{
            ;
            break;
            }
          default:
            jj_la1[64] = jj_gen;
            break label_32;
          }
          ann = Annotation();
annotations = add(annotations, ann);
        }
        jj_consume_token(LBRACKET);
        jj_consume_token(RBRACKET);
arrayCount++; accum = add(accum, annotations); annotations= null;
      }
      break;
      }
    default:
      jj_la1[65] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return new ReferenceType(range(type.getBegin(), tokenEnd()), type, arrayCount, null, accum);
  }

  final public IntersectionType IntersectionType() throws ParseException {Position begin;
        ReferenceType elementType;
        List<ReferenceType> elements = null;
    elementType = ReferenceType();
begin=elementType.getBegin(); elements = add(elements, elementType);
    jj_consume_token(BIT_AND);
    label_33:
    while (true) {
      elementType = ReferenceType();
elements = add(elements, elementType);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case IDENTIFIER:{
        ;
        break;
        }
      default:
        jj_la1[66] = jj_gen;
        break label_33;
      }
    }
return new IntersectionType(range(begin, tokenEnd()), elements);
  }

  final public ClassOrInterfaceType ClassOrInterfaceType() throws ParseException {ClassOrInterfaceType ret;
        String name;
        RangedList<Type> typeArgs = new RangedList<Type>(null);
        Position begin;
        List<AnnotationExpr> annotations = null;
        AnnotationExpr ann;
    jj_consume_token(IDENTIFIER);
begin=tokenBegin();
name = token.image;
    if (jj_2_14(2)) {
      typeArgs = TypeArguments();
    } else {
      ;
    }
ret = new ClassOrInterfaceType(range(begin, tokenEnd()),null, name, createTypeArguments(typeArgs.list));
    label_34:
    while (true) {
      if (jj_2_15(2)) {
        ;
      } else {
        break label_34;
      }
      jj_consume_token(DOT);
      label_35:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AT:{
          ;
          break;
          }
        default:
          jj_la1[67] = jj_gen;
          break label_35;
        }
        ann = Annotation();
annotations = add(annotations, ann);
      }
      jj_consume_token(IDENTIFIER);
name = token.image;
      if (jj_2_16(2)) {
        typeArgs = TypeArguments();
      } else {
        ;
      }
ret = new ClassOrInterfaceType(range(begin, tokenEnd()),ret, name, createTypeArguments(typeArgs.list));
            ret.setAnnotations(annotations);
            annotations = null;
    }
return ret;
  }

  final public ClassOrInterfaceType ClassOrInterfaceTypeWithAnnotations() throws ParseException {List<AnnotationExpr> annotations = new ArrayList<AnnotationExpr>();
        AnnotationExpr annotation = null;
        ClassOrInterfaceType type;
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[68] = jj_gen;
        break label_36;
      }
      annotation = Annotation();
annotations = add(annotations, annotation);
    }
    type = ClassOrInterfaceType();
if (type.getAnnotations() != null) {
            type.getAnnotations().addAll(annotations);
        } else {
            type.setAnnotations(annotations);
        }
        return type;
  }

  final public RangedList<Type> TypeArguments() throws ParseException {RangedList<Type> ret = new RangedList<Type>(new LinkedList<Type>());
        Type type;
    jj_consume_token(LT);
ret.beginAt(tokenBegin());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case IDENTIFIER:
    case AT:
    case HOOK:{
      type = TypeArgument();
ret.add(type);
      label_37:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[69] = jj_gen;
          break label_37;
        }
        jj_consume_token(COMMA);
        type = TypeArgument();
ret.add(type);
      }
      break;
      }
    default:
      jj_la1[70] = jj_gen;
      ;
    }
    jj_consume_token(GT);
ret.endAt(tokenEnd());
return ret;
  }

  final public Type TypeArgument() throws ParseException {Type ret;
        List<AnnotationExpr> annotations = null;
        AnnotationExpr ann;
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[71] = jj_gen;
        break label_38;
      }
      ann = Annotation();
annotations = add(annotations, ann);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case IDENTIFIER:{
      ret = ReferenceType();
      break;
      }
    case HOOK:{
      ret = Wildcard();
      break;
      }
    default:
      jj_la1[72] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
ret.setAnnotations(annotations); return ret;
  }

  final public WildcardType Wildcard() throws ParseException {ReferenceType ext = null;
        ReferenceType sup = null;
        Position begin;
        AnnotationExpr ann;
        List<AnnotationExpr> annotations = null;
    jj_consume_token(HOOK);
begin=tokenBegin();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EXTENDS:
    case SUPER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EXTENDS:{
        jj_consume_token(EXTENDS);
        label_39:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case AT:{
            ;
            break;
            }
          default:
            jj_la1[73] = jj_gen;
            break label_39;
          }
          ann = Annotation();
annotations = add(annotations, ann);
        }
        ext = ReferenceType();
ext.setAnnotations(annotations);
        break;
        }
      case SUPER:{
        jj_consume_token(SUPER);
        label_40:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case AT:{
            ;
            break;
            }
          default:
            jj_la1[74] = jj_gen;
            break label_40;
          }
          ann = Annotation();
annotations = add(annotations, ann);
        }
        sup = ReferenceType();
sup.setAnnotations(annotations);
        break;
        }
      default:
        jj_la1[75] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[76] = jj_gen;
      ;
    }
return new WildcardType(range(begin, tokenEnd()),ext, sup);
  }

  final public PrimitiveType PrimitiveType() throws ParseException {PrimitiveType ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:{
      jj_consume_token(BOOLEAN);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.Boolean);
      break;
      }
    case CHAR:{
      jj_consume_token(CHAR);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.Char);
      break;
      }
    case BYTE:{
      jj_consume_token(BYTE);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.Byte);
      break;
      }
    case SHORT:{
      jj_consume_token(SHORT);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.Short);
      break;
      }
    case INT:{
      jj_consume_token(INT);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.Int);
      break;
      }
    case LONG:{
      jj_consume_token(LONG);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.Long);
      break;
      }
    case FLOAT:{
      jj_consume_token(FLOAT);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.Float);
      break;
      }
    case DOUBLE:{
      jj_consume_token(DOUBLE);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.Double);
      break;
      }
    default:
      jj_la1[77] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
  }

  final public Type ResultType() throws ParseException {Type ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case VOID:{
      jj_consume_token(VOID);
ret = new VoidType(tokenRange());
      break;
      }
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case IDENTIFIER:{
      ret = Type();
      break;
      }
    default:
      jj_la1[78] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
  }

  final public NameExpr Name() throws ParseException {NameExpr ret;
    jj_consume_token(IDENTIFIER);
ret = new NameExpr(tokenRange(), token.image);
    label_41:
    while (true) {
      if (jj_2_17(2)) {
        ;
      } else {
        break label_41;
      }
      jj_consume_token(DOT);
      jj_consume_token(IDENTIFIER);
ret = new QualifiedNameExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, token.image);
    }
return ret;
  }

  final public NameExpr SimpleName() throws ParseException {NameExpr ret;
    jj_consume_token(IDENTIFIER);
ret = new NameExpr(tokenRange(), token.image);
return ret;
  }

/*
 * Expression syntax follows.
 */
  final public 
Expression Expression() throws ParseException {Expression ret;
        AssignExpr.Operator op;
        Expression value;
        Statement lambdaBody = null;
        RangedList<Type> typeArgs = new RangedList<Type>(null);
    ret = ConditionalExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASSIGN:
    case PLUSASSIGN:
    case MINUSASSIGN:
    case STARASSIGN:
    case SLASHASSIGN:
    case ANDASSIGN:
    case ORASSIGN:
    case XORASSIGN:
    case REMASSIGN:
    case LSHIFTASSIGN:
    case RSIGNEDSHIFTASSIGN:
    case RUNSIGNEDSHIFTASSIGN:
    case ARROW:
    case DOUBLECOLON:{
      if (jj_2_18(2)) {
        op = AssignmentOperator();
        value = Expression();
ret = new AssignExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, value, op);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ARROW:{
          jj_consume_token(ARROW);
          lambdaBody = LambdaBody();
if (ret instanceof CastExpr)
     {
       ret = generateLambda(ret, lambdaBody);
     }
     else if (ret instanceof ConditionalExpr){
         ConditionalExpr ce = (ConditionalExpr) ret;
         if(ce.getElseExpr() != null){
            ce.setElseExpr(generateLambda(ce.getElseExpr(), lambdaBody));
         }
     }
     else
     {
       ret = generateLambda(ret, lambdaBody);
     }
          break;
          }
        case DOUBLECOLON:{
          jj_consume_token(DOUBLECOLON);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LT:{
            typeArgs = TypeArguments();
            break;
            }
          default:
            jj_la1[79] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case IDENTIFIER:{
            jj_consume_token(IDENTIFIER);
            break;
            }
          case NEW:{
            jj_consume_token(NEW);
            break;
            }
          default:
            jj_la1[80] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
ret = new MethodReferenceExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, createTypeArguments(typeArgs.list), token.image);
          break;
          }
        default:
          jj_la1[81] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[82] = jj_gen;
      ;
    }
return ret;
  }

  final public AssignExpr.Operator AssignmentOperator() throws ParseException {AssignExpr.Operator ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASSIGN:{
      jj_consume_token(ASSIGN);
ret = AssignExpr.Operator.assign;
      break;
      }
    case STARASSIGN:{
      jj_consume_token(STARASSIGN);
ret = AssignExpr.Operator.star;
      break;
      }
    case SLASHASSIGN:{
      jj_consume_token(SLASHASSIGN);
ret = AssignExpr.Operator.slash;
      break;
      }
    case REMASSIGN:{
      jj_consume_token(REMASSIGN);
ret = AssignExpr.Operator.rem;
      break;
      }
    case PLUSASSIGN:{
      jj_consume_token(PLUSASSIGN);
ret = AssignExpr.Operator.plus;
      break;
      }
    case MINUSASSIGN:{
      jj_consume_token(MINUSASSIGN);
ret = AssignExpr.Operator.minus;
      break;
      }
    case LSHIFTASSIGN:{
      jj_consume_token(LSHIFTASSIGN);
ret = AssignExpr.Operator.lShift;
      break;
      }
    case RSIGNEDSHIFTASSIGN:{
      jj_consume_token(RSIGNEDSHIFTASSIGN);
ret = AssignExpr.Operator.rSignedShift;
      break;
      }
    case RUNSIGNEDSHIFTASSIGN:{
      jj_consume_token(RUNSIGNEDSHIFTASSIGN);
ret = AssignExpr.Operator.rUnsignedShift;
      break;
      }
    case ANDASSIGN:{
      jj_consume_token(ANDASSIGN);
ret = AssignExpr.Operator.and;
      break;
      }
    case XORASSIGN:{
      jj_consume_token(XORASSIGN);
ret = AssignExpr.Operator.xor;
      break;
      }
    case ORASSIGN:{
      jj_consume_token(ORASSIGN);
ret = AssignExpr.Operator.or;
      break;
      }
    default:
      jj_la1[83] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
  }

  final public Expression ConditionalExpression() throws ParseException {Expression ret;
        Expression left;
        Expression right;
    ret = ConditionalOrExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case HOOK:{
      jj_consume_token(HOOK);
      left = Expression();
      jj_consume_token(COLON);
      right = ConditionalExpression();
ret = new ConditionalExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, left, right);
      break;
      }
    default:
      jj_la1[84] = jj_gen;
      ;
    }
return ret;
  }

  final public Expression ConditionalOrExpression() throws ParseException {Expression ret;
        Expression right;
    ret = ConditionalAndExpression();
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SC_OR:{
        ;
        break;
        }
      default:
        jj_la1[85] = jj_gen;
        break label_42;
      }
      jj_consume_token(SC_OR);
      right = ConditionalAndExpression();
ret = new BinaryExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, right, BinaryExpr.Operator.or);
    }
return ret;
  }

  final public Expression ConditionalAndExpression() throws ParseException {Expression ret;
        Expression right;
    ret = InclusiveOrExpression();
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SC_AND:{
        ;
        break;
        }
      default:
        jj_la1[86] = jj_gen;
        break label_43;
      }
      jj_consume_token(SC_AND);
      right = InclusiveOrExpression();
ret = new BinaryExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, right, BinaryExpr.Operator.and);
    }
return ret;
  }

  final public Expression InclusiveOrExpression() throws ParseException {Expression ret;
        Expression right;
    ret = ExclusiveOrExpression();
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BIT_OR:{
        ;
        break;
        }
      default:
        jj_la1[87] = jj_gen;
        break label_44;
      }
      jj_consume_token(BIT_OR);
      right = ExclusiveOrExpression();
ret = new BinaryExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, right, BinaryExpr.Operator.binOr);
    }
return ret;
  }

  final public Expression ExclusiveOrExpression() throws ParseException {Expression ret;
        Expression right;
    ret = AndExpression();
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case XOR:{
        ;
        break;
        }
      default:
        jj_la1[88] = jj_gen;
        break label_45;
      }
      jj_consume_token(XOR);
      right = AndExpression();
ret = new BinaryExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, right, BinaryExpr.Operator.xor);
    }
return ret;
  }

  final public Expression AndExpression() throws ParseException {Expression ret;
        Expression right;
    ret = EqualityExpression();
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BIT_AND:{
        ;
        break;
        }
      default:
        jj_la1[89] = jj_gen;
        break label_46;
      }
      jj_consume_token(BIT_AND);
      right = EqualityExpression();
ret = new BinaryExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, right, BinaryExpr.Operator.binAnd);
    }
return ret;
  }

  final public Expression EqualityExpression() throws ParseException {Expression ret;
        Expression right;
        BinaryExpr.Operator op;
    ret = InstanceOfExpression();
    label_47:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQ:
      case NE:{
        ;
        break;
        }
      default:
        jj_la1[90] = jj_gen;
        break label_47;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQ:{
        jj_consume_token(EQ);
op = BinaryExpr.Operator.equals;
        break;
        }
      case NE:{
        jj_consume_token(NE);
op = BinaryExpr.Operator.notEquals;
        break;
        }
      default:
        jj_la1[91] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = InstanceOfExpression();
ret = new BinaryExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, right, op);
    }
return ret;
  }

  final public Expression InstanceOfExpression() throws ParseException {Expression ret;
        Type type;
    ret = RelationalExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INSTANCEOF:{
      jj_consume_token(INSTANCEOF);
      type = Type();
ret = new InstanceOfExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, type);
      break;
      }
    default:
      jj_la1[92] = jj_gen;
      ;
    }
return ret;
  }

  final public Expression RelationalExpression() throws ParseException {Expression ret;
        Expression right;
        BinaryExpr.Operator op;
    ret = ShiftExpression();
    label_48:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LT:
      case LE:
      case GE:
      case GT:{
        ;
        break;
        }
      default:
        jj_la1[93] = jj_gen;
        break label_48;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LT:{
        jj_consume_token(LT);
op = BinaryExpr.Operator.less;
        break;
        }
      case GT:{
        jj_consume_token(GT);
op = BinaryExpr.Operator.greater;
        break;
        }
      case LE:{
        jj_consume_token(LE);
op = BinaryExpr.Operator.lessEquals;
        break;
        }
      case GE:{
        jj_consume_token(GE);
op = BinaryExpr.Operator.greaterEquals;
        break;
        }
      default:
        jj_la1[94] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = ShiftExpression();
ret = new BinaryExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, right, op);
    }
return ret;
  }

  final public Expression ShiftExpression() throws ParseException {Expression ret;
        Expression right;
        BinaryExpr.Operator op;
    ret = AdditiveExpression();
    label_49:
    while (true) {
      if (jj_2_19(1)) {
        ;
      } else {
        break label_49;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LSHIFT:{
        jj_consume_token(LSHIFT);
op = BinaryExpr.Operator.lShift;
        break;
        }
      default:
        jj_la1[95] = jj_gen;
        if (jj_2_20(1)) {
          RSIGNEDSHIFT();
op = BinaryExpr.Operator.rSignedShift;
        } else if (jj_2_21(1)) {
          RUNSIGNEDSHIFT();
op = BinaryExpr.Operator.rUnsignedShift;
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      right = AdditiveExpression();
ret = new BinaryExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, right, op);
    }
return ret;
  }

  final public Expression AdditiveExpression() throws ParseException {Expression ret;
        Expression right;
        BinaryExpr.Operator op;
    ret = MultiplicativeExpression();
    label_50:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[96] = jj_gen;
        break label_50;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
op = BinaryExpr.Operator.plus;
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
op = BinaryExpr.Operator.minus;
        break;
        }
      default:
        jj_la1[97] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = MultiplicativeExpression();
ret = new BinaryExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, right, op);
    }
return ret;
  }

  final public Expression MultiplicativeExpression() throws ParseException {Expression ret;
        Expression right;
        BinaryExpr.Operator op;
    ret = UnaryExpression();
    label_51:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STAR:
      case SLASH:
      case REM:{
        ;
        break;
        }
      default:
        jj_la1[98] = jj_gen;
        break label_51;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STAR:{
        jj_consume_token(STAR);
op = BinaryExpr.Operator.times;
        break;
        }
      case SLASH:{
        jj_consume_token(SLASH);
op = BinaryExpr.Operator.divide;
        break;
        }
      case REM:{
        jj_consume_token(REM);
op = BinaryExpr.Operator.remainder;
        break;
        }
      default:
        jj_la1[99] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = UnaryExpression();
ret = new BinaryExpr(range(ret.getBegin(), tokenEnd()), ret, right, op);
    }
return ret;
  }

  final public Expression UnaryExpression() throws ParseException {Expression ret;
        UnaryExpr.Operator op;
        Position begin = INVALID;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INCR:{
      ret = PreIncrementExpression();
      break;
      }
    case DECR:{
      ret = PreDecrementExpression();
      break;
      }
    case PLUS:
    case MINUS:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
op = UnaryExpr.Operator.positive; begin=tokenBegin();
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
op = UnaryExpr.Operator.negative; begin=tokenBegin();
        break;
        }
      default:
        jj_la1[100] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      ret = UnaryExpression();
if(op == UnaryExpr.Operator.negative) {
                        if (ret instanceof IntegerLiteralExpr && ((IntegerLiteralExpr)ret).isMinValue()) {
                                ret = new IntegerLiteralMinValueExpr(range(begin, tokenEnd()));
                        } else if (ret instanceof LongLiteralExpr && ((LongLiteralExpr)ret).isMinValue()) {
                                ret = new LongLiteralMinValueExpr(range(begin, tokenEnd()));
                        } else {
                                ret = new UnaryExpr(range(begin, tokenEnd()), ret, op);
                        }
                 } else {
                        ret = new UnaryExpr(range(begin, tokenEnd()), ret, op);
                 }
      break;
      }
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case LONG_LITERAL:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case BANG:
    case TILDE:{
      ret = UnaryExpressionNotPlusMinus();
      break;
      }
    default:
      jj_la1[101] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
  }

  final public Expression PreIncrementExpression() throws ParseException {Expression ret;
        Position begin = INVALID;
    jj_consume_token(INCR);
begin=tokenBegin();
    ret = UnaryExpression();
ret = new UnaryExpr(range(begin, tokenEnd()), ret, UnaryExpr.Operator.preIncrement);
return ret;
  }

  final public Expression PreDecrementExpression() throws ParseException {Expression ret;
        Position begin;
    jj_consume_token(DECR);
begin=tokenBegin();
    ret = UnaryExpression();
ret = new UnaryExpr(range(begin, tokenEnd()), ret, UnaryExpr.Operator.preDecrement);
return ret;
  }

  final public Expression UnaryExpressionNotPlusMinus() throws ParseException {Expression ret;
        UnaryExpr.Operator op;
        Position begin = INVALID;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BANG:
    case TILDE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TILDE:{
        jj_consume_token(TILDE);
op = UnaryExpr.Operator.inverse; begin=tokenBegin();
        break;
        }
      case BANG:{
        jj_consume_token(BANG);
op = UnaryExpr.Operator.not;     begin=tokenBegin();
        break;
        }
      default:
        jj_la1[102] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      ret = UnaryExpression();
ret = new UnaryExpr(range(begin, tokenEnd()), ret, op);
      break;
      }
    default:
      jj_la1[103] = jj_gen;
      if (jj_2_22(2147483647)) {
        ret = CastExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FALSE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case SHORT:
        case SUPER:
        case THIS:
        case TRUE:
        case VOID:
        case LONG_LITERAL:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:{
          ret = PostfixExpression();
          break;
          }
        default:
          jj_la1[104] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return ret;
  }

  final public Expression PostfixExpression() throws ParseException {Expression ret;
        UnaryExpr.Operator op;
    ret = PrimaryExpression();
    if (jj_2_23(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case INCR:{
        jj_consume_token(INCR);
op = UnaryExpr.Operator.posIncrement;
        break;
        }
      case DECR:{
        jj_consume_token(DECR);
op = UnaryExpr.Operator.posDecrement;
        break;
        }
      default:
        jj_la1[105] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
ret = new UnaryExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, op);
    } else {
      ;
    }
return ret;
  }

  final public Expression CastExpression() throws ParseException {Expression ret;
        ReferenceType referenceType;
        PrimitiveType primitiveType;
        Position begin = INVALID;
        AnnotationExpr ann;
        List<AnnotationExpr> annotations = null;
        List<ReferenceType> typesOfMultiCast = null;
    jj_consume_token(LPAREN);
begin=tokenBegin();
    label_52:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[106] = jj_gen;
        break label_52;
      }
      ann = Annotation();
annotations = add(annotations, ann);
    }
    if (jj_2_24(2)) {
      primitiveType = PrimitiveType();
      jj_consume_token(RPAREN);
      ret = UnaryExpression();
primitiveType.setAnnotations(annotations); ret = new CastExpr(range(begin, tokenEnd()), primitiveType, ret);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case IDENTIFIER:{
        referenceType = ReferenceType();
typesOfMultiCast = add(typesOfMultiCast, referenceType); referenceType.setAnnotations(annotations);
        label_53:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case BIT_AND:{
            ;
            break;
            }
          default:
            jj_la1[107] = jj_gen;
            break label_53;
          }
          jj_consume_token(BIT_AND);
          referenceType = ReferenceType();
typesOfMultiCast = add(typesOfMultiCast, referenceType);
        }
        jj_consume_token(RPAREN);
        ret = UnaryExpressionNotPlusMinus();
if (typesOfMultiCast.size() > 1) {
                ret = new CastExpr(range(begin, tokenEnd()), new IntersectionType(range(begin, tokenEnd()), typesOfMultiCast), ret);
            }
            ret = new CastExpr(range(begin, tokenEnd()), referenceType, ret);
        break;
        }
      default:
        jj_la1[108] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return ret;
  }

  final public Expression PrimaryExpression() throws ParseException {Expression ret;
    ret = PrimaryPrefix();
    label_54:
    while (true) {
      if (jj_2_25(2)) {
        ;
      } else {
        break label_54;
      }
      ret = PrimarySuffix(ret);
    }
return ret;
  }

  final public Expression PrimaryExpressionWithoutSuperSuffix() throws ParseException {Expression ret;
    ret = PrimaryPrefix();
    label_55:
    while (true) {
      if (jj_2_26(2147483647)) {
        ;
      } else {
        break label_55;
      }
      ret = PrimarySuffixWithoutSuper(ret);
    }
return ret;
  }

  final public Expression PrimaryPrefix() throws ParseException {Expression ret = null;
        NameExpr name;
        RangedList<Type> typeArgs = new RangedList<Type>(null);
        List<Expression> args = null;
        List<Parameter> params = null;
        boolean hasArgs = false;
        boolean isLambda = false;
        Type type;
        Position begin;
        Parameter p = null;
        VariableDeclaratorId id = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FALSE:
    case NULL:
    case TRUE:
    case LONG_LITERAL:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:{
      ret = Literal();
      break;
      }
    case THIS:{
      jj_consume_token(THIS);
ret = new ThisExpr(tokenRange(), null);
      break;
      }
    case SUPER:{
      jj_consume_token(SUPER);
ret = new SuperExpr(tokenRange(), null);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        jj_consume_token(DOT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LT:{
          typeArgs = TypeArguments();
          break;
          }
        default:
          jj_la1[109] = jj_gen;
          ;
        }
        name = SimpleName();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LPAREN:{
          args = Arguments();
hasArgs=true;
          break;
          }
        default:
          jj_la1[110] = jj_gen;
          ;
        }
if (hasArgs) {
                                MethodCallExpr m = new MethodCallExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, typeArgs.list, null, args);
                                m.setNameExpr(name);
                                ret = m;
                        } else {
                                FieldAccessExpr f = new FieldAccessExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, null, null);
                                f.setFieldExpr(name);
                                ret = f;
                        }
        break;
        }
      case DOUBLECOLON:{
        jj_consume_token(DOUBLECOLON);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LT:{
          typeArgs = TypeArguments();
          break;
          }
        default:
          jj_la1[111] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IDENTIFIER:{
          jj_consume_token(IDENTIFIER);
          break;
          }
        case NEW:{
          jj_consume_token(NEW);
          break;
          }
        default:
          jj_la1[112] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
ret = new MethodReferenceExpr(range(ret.getBegin(), pos(token.endLine, token.endColumn)), ret, createTypeArguments(typeArgs.list), token.image);
        break;
        }
      default:
        jj_la1[113] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
begin=tokenBegin();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FALSE:
      case FINAL:
      case FLOAT:
      case INT:
      case LONG:
      case NATIVE:
      case NEW:
      case NULL:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case STRICTFP:
      case SUPER:
      case SYNCHRONIZED:
      case THIS:
      case TRANSIENT:
      case TRUE:
      case VOID:
      case VOLATILE:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case AT:
      case BANG:
      case TILDE:
      case INCR:
      case DECR:
      case PLUS:
      case MINUS:{
        if (jj_2_27(2147483647)) {
          p = FormalParameter();
isLambda = true;
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            params = FormalLambdaParameters();
            break;
            }
          default:
            jj_la1[114] = jj_gen;
            ;
          }
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case BOOLEAN:
          case BYTE:
          case CHAR:
          case DOUBLE:
          case FALSE:
          case FLOAT:
          case INT:
          case LONG:
          case NEW:
          case NULL:
          case SHORT:
          case SUPER:
          case THIS:
          case TRUE:
          case VOID:
          case LONG_LITERAL:
          case INTEGER_LITERAL:
          case FLOATING_POINT_LITERAL:
          case CHARACTER_LITERAL:
          case STRING_LITERAL:
          case IDENTIFIER:
          case LPAREN:
          case BANG:
          case TILDE:
          case INCR:
          case DECR:
          case PLUS:
          case MINUS:{
            ret = Expression();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case COMMA:{
              params = InferredLambdaParameters();
isLambda = true;
              break;
              }
            default:
              jj_la1[115] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[116] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[117] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
if(!isLambda) { ret = new EnclosedExpr(range(begin, tokenEnd()), ret);}
                           else{
                                  if(ret != null){
                                          if(ret instanceof NameExpr)
                                          {
                                            id = new VariableDeclaratorId(range(ret.getBegin(), ret.getEnd()), ((NameExpr)ret).getName(), 0);
                                            p = new Parameter(range(ret.getBegin(), ret.getEnd()), EnumSet.noneOf(Modifier.class), null, new UnknownType(), false, id);
                                          }

                                        }
                                        params = add(0, params, p);
                                        // TODO p may be null here
                                        ret = new LambdaExpr(range(p.getBegin(), tokenEnd()), params, null, true);
                                }
      break;
      }
    case NEW:{
      ret = AllocationExpression(null);
      break;
      }
    default:
      jj_la1[121] = jj_gen;
      if (jj_2_28(2147483647)) {
        type = ResultType();
        jj_consume_token(DOT);
        jj_consume_token(CLASS);
ret = new ClassExpr(range(type.getBegin(), tokenEnd()), type);
      } else if (jj_2_29(2147483647)) {
        type = ResultType();
        jj_consume_token(DOUBLECOLON);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LT:{
          typeArgs = TypeArguments();
          break;
          }
        default:
          jj_la1[118] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IDENTIFIER:{
          jj_consume_token(IDENTIFIER);
          break;
          }
        case NEW:{
          jj_consume_token(NEW);
          break;
          }
        default:
          jj_la1[119] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
ret = new TypeExpr(type.getRange(), type);
                  ret = new MethodReferenceExpr(ret.getRange(), ret, createTypeArguments(typeArgs.list), token.image);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IDENTIFIER:{
          name = SimpleName();
begin=tokenBegin();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LPAREN:{
            args = Arguments();
hasArgs=true;
            break;
            }
          default:
            jj_la1[120] = jj_gen;
            ;
          }
if (hasArgs) {
                                MethodCallExpr m = new MethodCallExpr(range(begin, tokenEnd()), null, null, null, args);
                                m.setNameExpr(name);
                                ret = m;
                        } else {
                                ret = name;
                        }
          break;
          }
        default:
          jj_la1[122] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return ret;
  }

  final public Expression PrimarySuffix(Expression scope) throws ParseException {Expression ret;
    if (jj_2_30(2)) {
      ret = PrimarySuffixWithoutSuper(scope);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        jj_consume_token(DOT);
        jj_consume_token(SUPER);
ret = new SuperExpr(range(scope.getBegin(), tokenEnd()), scope);
        break;
        }
      default:
        jj_la1[123] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return ret;
  }

  final public Expression PrimarySuffixWithoutSuper(Expression scope) throws ParseException {Expression ret;
        RangedList<Type> typeArgs = new RangedList<Type>(null);
        List<Expression> args = null;
        boolean hasArgs = false;
        NameExpr name;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOT:{
      jj_consume_token(DOT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case THIS:{
        jj_consume_token(THIS);
ret = new ThisExpr(range(scope.getBegin(), tokenEnd()), scope);
        break;
        }
      case NEW:{
        ret = AllocationExpression(scope);
        break;
        }
      default:
        jj_la1[126] = jj_gen;
        if (jj_2_31(2147483647)) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LT:{
            typeArgs = TypeArguments();
            break;
            }
          default:
            jj_la1[124] = jj_gen;
            ;
          }
          name = SimpleName();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LPAREN:{
            args = Arguments();
hasArgs=true;
            break;
            }
          default:
            jj_la1[125] = jj_gen;
            ;
          }
if (hasArgs) {
                                MethodCallExpr m = new MethodCallExpr(range(scope.getBegin(), tokenEnd()), scope, typeArgs.list, null, args);
                                m.setNameExpr(name);
                                ret = m;
                        } else {
                                FieldAccessExpr f =  new FieldAccessExpr(range(scope.getBegin(), tokenEnd()), scope, typeArgs.list, null);
                                f.setFieldExpr(name);
                                ret = f;
                        }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case LBRACKET:{
      jj_consume_token(LBRACKET);
      ret = Expression();
      jj_consume_token(RBRACKET);
ret = new ArrayAccessExpr(range(scope.getBegin(), tokenEnd()), scope, ret);
      break;
      }
    default:
      jj_la1[127] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
  }

  final public Expression Literal() throws ParseException {Expression ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTEGER_LITERAL:{
      jj_consume_token(INTEGER_LITERAL);
ret = new IntegerLiteralExpr(tokenRange(), token.image);
      break;
      }
    case LONG_LITERAL:{
      jj_consume_token(LONG_LITERAL);
ret = new LongLiteralExpr(tokenRange(), token.image);
      break;
      }
    case FLOATING_POINT_LITERAL:{
      jj_consume_token(FLOATING_POINT_LITERAL);
ret = new DoubleLiteralExpr(tokenRange(), token.image);
      break;
      }
    case CHARACTER_LITERAL:{
      jj_consume_token(CHARACTER_LITERAL);
ret = new CharLiteralExpr(tokenRange(), token.image.substring(1, token.image.length()-1));
      break;
      }
    case STRING_LITERAL:{
      jj_consume_token(STRING_LITERAL);
ret = new StringLiteralExpr(tokenRange(), token.image.substring(1, token.image.length()-1));
      break;
      }
    case FALSE:
    case TRUE:{
      ret = BooleanLiteral();
      break;
      }
    case NULL:{
      ret = NullLiteral();
      break;
      }
    default:
      jj_la1[128] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
  }

  final public Expression BooleanLiteral() throws ParseException {Expression ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TRUE:{
      jj_consume_token(TRUE);
ret = new BooleanLiteralExpr(tokenRange(), true);
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
ret = new BooleanLiteralExpr(tokenRange(), false);
      break;
      }
    default:
      jj_la1[129] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
  }

  final public Expression NullLiteral() throws ParseException {
    jj_consume_token(NULL);
return new NullLiteralExpr(tokenRange());
  }

  final public List<Expression> Arguments() throws ParseException {List<Expression> ret = null;
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case LONG_LITERAL:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:{
      ret = ArgumentList();
      break;
      }
    default:
      jj_la1[130] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
return ret;
  }

  final public List<Expression> ArgumentList() throws ParseException {List<Expression> ret = new LinkedList<Expression>();
        Expression expr;
    expr = Expression();
ret.add(expr);
    label_56:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[131] = jj_gen;
        break label_56;
      }
      jj_consume_token(COMMA);
      expr = Expression();
ret.add(expr);
    }
return ret;
  }

  final public Expression AllocationExpression(Expression scope) throws ParseException {Expression ret;
        ArrayCreationExpr arrayExpr;
        Type type;
        Object[] arr;
        RangedList<Type> typeArgs = new RangedList<Type>(null);
        List<BodyDeclaration<?>> anonymousBody = null;
        List<Expression> args;
        Position begin;
        List<AnnotationExpr> annotations = null;
        AnnotationExpr ann;
    jj_consume_token(NEW);
if(scope==null) {begin=tokenBegin();} else {begin=scope.getBegin();}
    label_57:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[132] = jj_gen;
        break label_57;
      }
      ann = Annotation();
annotations = add(annotations, ann);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:{
      type = PrimitiveType();
type.setAnnotations(annotations);
      arr = ArrayDimsAndInits();
arrayExpr = new ArrayCreationExpr(range(begin, tokenEnd()), type, null, 0);
            arrayExpr.setArraysAnnotations((List)arr[2]);
                if (arr[0] instanceof Integer) {
                    arrayExpr.setArrayCount(((Integer)arr[0]).intValue());
                    arrayExpr.setInitializer((ArrayInitializerExpr)arr[1]);
                } else {
                    arrayExpr.setArrayCount(((Integer)arr[1]).intValue());
                    arrayExpr.setDimensions((List)arr[0]);
                }
                ret = arrayExpr;
      break;
      }
    case IDENTIFIER:
    case LT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LT:{
        typeArgs = TypeArguments();
        label_58:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case AT:{
            ;
            break;
            }
          default:
            jj_la1[133] = jj_gen;
            break label_58;
          }
          ann = Annotation();
annotations = add(annotations, ann);
        }
        break;
        }
      default:
        jj_la1[134] = jj_gen;
        ;
      }
      type = ClassOrInterfaceType();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:
      case AT:{
        arr = ArrayDimsAndInits();
type.setAnnotations(annotations); arrayExpr = new ArrayCreationExpr(range(begin, tokenEnd()), type, null, 0);
arrayExpr.setArraysAnnotations((List)arr[2]);
                        if (arr[0] instanceof Integer) {
                                arrayExpr.setArrayCount(((Integer)arr[0]).intValue());
                            arrayExpr.setInitializer((ArrayInitializerExpr)arr[1]);
                        } else {
                                arrayExpr.setArrayCount(((Integer)arr[1]).intValue());
                            arrayExpr.setDimensions((List)arr[0]);
                        }
                        ret = arrayExpr;
        break;
        }
      case LPAREN:{
        args = Arguments();
        if (jj_2_32(2)) {
          anonymousBody = ClassOrInterfaceBody(false);
        } else {
          ;
        }
type.setAnnotations(annotations); ret = new ObjectCreationExpr(range(begin, tokenEnd()), scope, (ClassOrInterfaceType) type, typeArgs.list, args, anonymousBody);
        break;
        }
      default:
        jj_la1[135] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[136] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
  }

/*
 * The third LOOKAHEAD specification below is to parse to PrimarySuffix
 * if there is an expression between the "[...]".
 */
// TODO fix the horrible return type.
  final public Object[] ArrayDimsAndInits() throws ParseException {Object[] ret = new Object[3];
        Expression expr;
        List<Expression> inits = null;
        int i = 0;
        List<List<AnnotationExpr>> accum = null;
        List<AnnotationExpr> annotations = null;
        AnnotationExpr ann;
    label_59:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[137] = jj_gen;
        break label_59;
      }
      ann = Annotation();
annotations = add(annotations, ann);
    }
    if (jj_2_35(2)) {
      label_60:
      while (true) {
        jj_consume_token(LBRACKET);
        expr = Expression();
accum = add(accum, annotations); inits = add(inits, expr);
        jj_consume_token(RBRACKET);
        if (jj_2_33(2)) {
          ;
        } else {
          break label_60;
        }
      }
      label_61:
      while (true) {
        if (jj_2_34(2)) {
          ;
        } else {
          break label_61;
        }
        label_62:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case AT:{
            ;
            break;
            }
          default:
            jj_la1[138] = jj_gen;
            break label_62;
          }
          ann = Annotation();
annotations = add(annotations, ann);
        }
        jj_consume_token(LBRACKET);
        jj_consume_token(RBRACKET);
i++;
      }
accum = add(accum, annotations); annotations=null; ret[0] = inits; ret[1] = i;
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:{
        label_63:
        while (true) {
          jj_consume_token(LBRACKET);
          jj_consume_token(RBRACKET);
i++;
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LBRACKET:{
            ;
            break;
            }
          default:
            jj_la1[139] = jj_gen;
            break label_63;
          }
        }
        expr = ArrayInitializer();
accum = add(accum, annotations);ret[0] = i; ret[1] = expr;
        break;
        }
      default:
        jj_la1[140] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
ret[2]=accum; return ret;
  }

/*
 * Statement syntax follows.
 */
  final public 
Statement Statement() throws ParseException {Statement ret;
    if (jj_2_36(2)) {
      ret = LabeledStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASSERT:{
        ret = AssertStatement();
        break;
        }
      case LBRACE:{
        ret = Block();
        break;
        }
      case SEMICOLON:{
        ret = EmptyStatement();
        break;
        }
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case INCR:
      case DECR:{
        ret = StatementExpression();
        break;
        }
      case SWITCH:{
        ret = SwitchStatement();
        break;
        }
      case IF:{
        ret = IfStatement();
        break;
        }
      case WHILE:{
        ret = WhileStatement();
        break;
        }
      case DO:{
        ret = DoStatement();
        break;
        }
      case FOR:{
        ret = ForStatement();
        break;
        }
      case BREAK:{
        ret = BreakStatement();
        break;
        }
      case CONTINUE:{
        ret = ContinueStatement();
        break;
        }
      case RETURN:{
        ret = ReturnStatement();
        break;
        }
      case THROW:{
        ret = ThrowStatement();
        break;
        }
      case SYNCHRONIZED:{
        ret = SynchronizedStatement();
        break;
        }
      case TRY:{
        ret = TryStatement();
        break;
        }
      default:
        jj_la1[141] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return ret;
  }

  final public AssertStmt AssertStatement() throws ParseException {Expression check;
        Expression msg = null;
        Position begin;
    jj_consume_token(ASSERT);
begin=tokenBegin();
    check = Expression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      msg = Expression();
      break;
      }
    default:
      jj_la1[142] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
return new AssertStmt(range(begin, tokenEnd()),check, msg);
  }

  final public LabeledStmt LabeledStatement() throws ParseException {String label;
        Statement stmt;
        Position begin;
    jj_consume_token(IDENTIFIER);
begin=tokenBegin();
label = token.image;
    jj_consume_token(COLON);
    stmt = Statement();
return new LabeledStmt(range(begin, tokenEnd()),label, stmt);
  }

  final public BlockStmt Block() throws ParseException {List<Statement> stmts;
        Position begin;
    jj_consume_token(LBRACE);
begin=tokenBegin();
    stmts = Statements();
    jj_consume_token(RBRACE);
return new BlockStmt(range(begin, tokenEnd()), stmts);
  }

/*
 * Classes inside block stametents can only be abstract or final. The semantic must check it.
 */
  final public Statement BlockStatement() throws ParseException {Statement ret;
        Expression expr;
        ClassOrInterfaceDeclaration typeDecl;
        ModifierHolder modifier;
    if (jj_2_37(2147483647)) {

      modifier = Modifiers();
      typeDecl = ClassOrInterfaceDeclaration(modifier);
ret = new TypeDeclarationStmt(range(typeDecl.getBegin().line, typeDecl.getBegin().column, token.endLine, token.endColumn), typeDecl);
    } else if (jj_2_38(2147483647)) {
      expr = VariableDeclarationExpression();
      jj_consume_token(SEMICOLON);
ret = new ExpressionStmt(range(expr.getBegin().line, expr.getBegin().column, token.endLine, token.endColumn), expr);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASSERT:
      case BOOLEAN:
      case BREAK:
      case BYTE:
      case CHAR:
      case CONTINUE:
      case DO:
      case DOUBLE:
      case FALSE:
      case FLOAT:
      case FOR:
      case IF:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case RETURN:
      case SHORT:
      case SUPER:
      case SWITCH:
      case SYNCHRONIZED:
      case THIS:
      case THROW:
      case TRUE:
      case TRY:
      case VOID:
      case WHILE:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case LBRACE:
      case SEMICOLON:
      case INCR:
      case DECR:{
        ret = Statement();
        break;
        }
      default:
        jj_la1[143] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return ret;
  }

  final public VariableDeclarationExpr VariableDeclarationExpression() throws ParseException {ModifierHolder modifier;
        Type type;
        List<VariableDeclarator> vars = new LinkedList<VariableDeclarator>();
        VariableDeclarator var;
    modifier = Modifiers();
    type = Type();
    var = VariableDeclarator();
vars.add(var);
    label_64:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[144] = jj_gen;
        break label_64;
      }
      jj_consume_token(COMMA);
      var = VariableDeclarator();
vars.add(var);
    }
Position begin=modifier.begin.orIfInvalid(type.getBegin());
    return new VariableDeclarationExpr(range(begin, tokenEnd()), modifier.modifiers, modifier.annotations, type, vars);
  }

  final public EmptyStmt EmptyStatement() throws ParseException {
    jj_consume_token(SEMICOLON);
return new EmptyStmt(tokenRange());
  }

  final public Statement LambdaBody() throws ParseException {Expression expr;
  Statement n = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case LONG_LITERAL:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:{
      expr = Expression();
n = new ExpressionStmt(range(expr.getBegin(), tokenEnd()), expr);
      break;
      }
    case LBRACE:{
      n = Block();
      break;
      }
    default:
      jj_la1[145] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return n;
  }

  final public ExpressionStmt StatementExpression() throws ParseException {Expression expr;
        AssignExpr.Operator op;
        Expression value;
        RangedList<Type> typeArgs = new RangedList<Type>(null);
        Statement lambdaBody;
    if (jj_2_39(2)) {
      expr = PreIncrementExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DECR:{
        expr = PreDecrementExpression();
        break;
        }
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:{
        expr = PrimaryExpression();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ASSIGN:
        case INCR:
        case DECR:
        case PLUSASSIGN:
        case MINUSASSIGN:
        case STARASSIGN:
        case SLASHASSIGN:
        case ANDASSIGN:
        case ORASSIGN:
        case XORASSIGN:
        case REMASSIGN:
        case LSHIFTASSIGN:
        case RSIGNEDSHIFTASSIGN:
        case RUNSIGNEDSHIFTASSIGN:
        case ARROW:
        case DOUBLECOLON:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case INCR:{
            jj_consume_token(INCR);
expr = new UnaryExpr(range(expr.getBegin(), tokenEnd()), expr, UnaryExpr.Operator.posIncrement);
            break;
            }
          case DECR:{
            jj_consume_token(DECR);
expr = new UnaryExpr(range(expr.getBegin(), tokenEnd()), expr, UnaryExpr.Operator.posDecrement);
            break;
            }
          case ASSIGN:
          case PLUSASSIGN:
          case MINUSASSIGN:
          case STARASSIGN:
          case SLASHASSIGN:
          case ANDASSIGN:
          case ORASSIGN:
          case XORASSIGN:
          case REMASSIGN:
          case LSHIFTASSIGN:
          case RSIGNEDSHIFTASSIGN:
          case RUNSIGNEDSHIFTASSIGN:{
            op = AssignmentOperator();
            value = Expression();
expr = new AssignExpr(range(expr.getBegin(), tokenEnd()), expr, value, op);
            break;
            }
          case DOUBLECOLON:{
            jj_consume_token(DOUBLECOLON);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case LT:{
              typeArgs = TypeArguments();
              break;
              }
            default:
              jj_la1[146] = jj_gen;
              ;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case IDENTIFIER:{
              jj_consume_token(IDENTIFIER);
              break;
              }
            case NEW:{
              jj_consume_token(NEW);
              break;
              }
            default:
              jj_la1[147] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
expr = new MethodReferenceExpr(range(expr.getBegin(), tokenEnd()), expr, createTypeArguments(typeArgs.list), token.image);
            break;
            }
          case ARROW:{
            jj_consume_token(ARROW);
            lambdaBody = LambdaBody();
expr = generateLambda(expr, lambdaBody);
            break;
            }
          default:
            jj_la1[148] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[149] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[150] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(SEMICOLON);
return new ExpressionStmt(range(expr.getBegin(), tokenEnd()), expr);
  }

  final public SwitchStmt SwitchStatement() throws ParseException {Expression selector;
        SwitchEntryStmt entry;
        List<SwitchEntryStmt> entries = null;
        Position begin;
    jj_consume_token(SWITCH);
begin=tokenBegin();
    jj_consume_token(LPAREN);
    selector = Expression();
    jj_consume_token(RPAREN);
    jj_consume_token(LBRACE);
    label_65:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CASE:
      case _DEFAULT:{
        ;
        break;
        }
      default:
        jj_la1[151] = jj_gen;
        break label_65;
      }
      entry = SwitchEntry();
entries = add(entries, entry);
    }
    jj_consume_token(RBRACE);
return new SwitchStmt(range(begin, tokenEnd()), selector, entries);
  }

  final public SwitchEntryStmt SwitchEntry() throws ParseException {Expression label = null;
        List<Statement> stmts;
        Position begin;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CASE:{
      jj_consume_token(CASE);
begin=tokenBegin();
      label = Expression();
      break;
      }
    case _DEFAULT:{
      jj_consume_token(_DEFAULT);
begin=tokenBegin();
      break;
      }
    default:
      jj_la1[152] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(COLON);
    stmts = Statements();
return new SwitchEntryStmt(range(begin, tokenEnd()),label, stmts);
  }

  final public IfStmt IfStatement() throws ParseException {Expression condition;
        Statement thenStmt;
        Statement elseStmt = null;
        Position begin;
    Comment thenCmmt = null;
    Comment elseCmmt = null;
    jj_consume_token(IF);
begin=tokenBegin();
    jj_consume_token(LPAREN);
    condition = Expression();
    jj_consume_token(RPAREN);

    thenStmt = Statement();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ELSE:{
      jj_consume_token(ELSE);

      elseStmt = Statement();
      break;
      }
    default:
      jj_la1[153] = jj_gen;
      ;
    }
IfStmt tmp = new IfStmt(range(begin, tokenEnd()),condition, thenStmt, elseStmt);

      // TODO comment is always null
      thenStmt.setComment(thenCmmt);
      if (elseStmt != null)
          // TODO comment is always null
          elseStmt.setComment(elseCmmt);
      return tmp;
  }

  final public WhileStmt WhileStatement() throws ParseException {Expression condition;
        Statement body;
        Position begin;
    jj_consume_token(WHILE);
begin=tokenBegin();
    jj_consume_token(LPAREN);
    condition = Expression();
    jj_consume_token(RPAREN);
    body = Statement();
return new WhileStmt(range(begin, tokenEnd()),condition, body);
  }

  final public DoStmt DoStatement() throws ParseException {Expression condition;
        Statement body;
        Position begin;
    jj_consume_token(DO);
begin=tokenBegin();
    body = Statement();
    jj_consume_token(WHILE);
    jj_consume_token(LPAREN);
    condition = Expression();
    jj_consume_token(RPAREN);
    jj_consume_token(SEMICOLON);
return new DoStmt(range(begin, tokenEnd()),body, condition);
  }

  final public Statement ForStatement() throws ParseException {VariableDeclarationExpr varExpr = null;
        Expression expr = null;
        List<Expression> init = null;
        List<Expression> update = null;
        Statement body;
        Position begin;
    jj_consume_token(FOR);
begin=tokenBegin();
    jj_consume_token(LPAREN);
    if (jj_2_40(2147483647)) {
      varExpr = VariableDeclarationExpression();
      jj_consume_token(COLON);
      expr = Expression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FALSE:
      case FINAL:
      case FLOAT:
      case INT:
      case LONG:
      case NATIVE:
      case NEW:
      case NULL:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case STRICTFP:
      case SUPER:
      case SYNCHRONIZED:
      case THIS:
      case TRANSIENT:
      case TRUE:
      case VOID:
      case VOLATILE:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case SEMICOLON:
      case AT:
      case BANG:
      case TILDE:
      case INCR:
      case DECR:
      case PLUS:
      case MINUS:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ABSTRACT:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FALSE:
        case FINAL:
        case FLOAT:
        case INT:
        case LONG:
        case NATIVE:
        case NEW:
        case NULL:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case SHORT:
        case STATIC:
        case STRICTFP:
        case SUPER:
        case SYNCHRONIZED:
        case THIS:
        case TRANSIENT:
        case TRUE:
        case VOID:
        case VOLATILE:
        case LONG_LITERAL:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
        case AT:
        case BANG:
        case TILDE:
        case INCR:
        case DECR:
        case PLUS:
        case MINUS:{
          init = ForInit();
          break;
          }
        default:
          jj_la1[154] = jj_gen;
          ;
        }
        jj_consume_token(SEMICOLON);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FALSE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case SHORT:
        case SUPER:
        case THIS:
        case TRUE:
        case VOID:
        case LONG_LITERAL:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
        case BANG:
        case TILDE:
        case INCR:
        case DECR:
        case PLUS:
        case MINUS:{
          expr = Expression();
          break;
          }
        default:
          jj_la1[155] = jj_gen;
          ;
        }
        jj_consume_token(SEMICOLON);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FALSE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case SHORT:
        case SUPER:
        case THIS:
        case TRUE:
        case VOID:
        case LONG_LITERAL:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
        case BANG:
        case TILDE:
        case INCR:
        case DECR:
        case PLUS:
        case MINUS:{
          update = ForUpdate();
          break;
          }
        default:
          jj_la1[156] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[157] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RPAREN);
    body = Statement();
if (varExpr != null) {
                return new ForeachStmt(range(begin, tokenEnd()),varExpr, expr, body);
        }
        return new ForStmt(range(begin, tokenEnd()),init, expr, update, body);
  }

  final public List<Expression> ForInit() throws ParseException {List<Expression> ret;
        Expression expr;
    if (jj_2_41(2147483647)) {
      expr = VariableDeclarationExpression();
ret = new LinkedList<Expression>(); ret.add(expr);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case BANG:
      case TILDE:
      case INCR:
      case DECR:
      case PLUS:
      case MINUS:{
        ret = ExpressionList();
        break;
        }
      default:
        jj_la1[158] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return ret;
  }

  final public List<Expression> ExpressionList() throws ParseException {List<Expression> ret = new LinkedList<Expression>();
        Expression expr;
    expr = Expression();
ret.add(expr);
    label_66:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[159] = jj_gen;
        break label_66;
      }
      jj_consume_token(COMMA);
      expr = Expression();
ret.add(expr);
    }
return ret;
  }

  final public List<Expression> ForUpdate() throws ParseException {List<Expression> ret;
    ret = ExpressionList();
return ret;
  }

  final public BreakStmt BreakStatement() throws ParseException {String id = null;
        Position begin;
    jj_consume_token(BREAK);
begin=tokenBegin();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENTIFIER:{
      jj_consume_token(IDENTIFIER);
id = token.image;
      break;
      }
    default:
      jj_la1[160] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
return new BreakStmt(range(begin, tokenEnd()),id);
  }

  final public ContinueStmt ContinueStatement() throws ParseException {String id = null;
        Position begin;
    jj_consume_token(CONTINUE);
begin=tokenBegin();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENTIFIER:{
      jj_consume_token(IDENTIFIER);
id = token.image;
      break;
      }
    default:
      jj_la1[161] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
return new ContinueStmt(range(begin, tokenEnd()),id);
  }

  final public ReturnStmt ReturnStatement() throws ParseException {Expression expr = null;
        Position begin;
    jj_consume_token(RETURN);
begin=tokenBegin();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case LONG_LITERAL:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:{
      expr = Expression();
      break;
      }
    default:
      jj_la1[162] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
return new ReturnStmt(range(begin, tokenEnd()),expr);
  }

  final public ThrowStmt ThrowStatement() throws ParseException {Expression expr;
        Position begin;
    jj_consume_token(THROW);
begin=tokenBegin();
    expr = Expression();
    jj_consume_token(SEMICOLON);
return new ThrowStmt(range(begin, tokenEnd()),expr);
  }

  final public SynchronizedStmt SynchronizedStatement() throws ParseException {Expression expr;
        BlockStmt block;
        Position begin;
    jj_consume_token(SYNCHRONIZED);
begin=tokenBegin();
    jj_consume_token(LPAREN);
    expr = Expression();
    jj_consume_token(RPAREN);
    block = Block();
return new SynchronizedStmt(range(begin, tokenEnd()),expr, block);
  }

  final public TryStmt TryStatement() throws ParseException {List<VariableDeclarationExpr> resources = new LinkedList<VariableDeclarationExpr>();
        BlockStmt tryBlock;
        BlockStmt finallyBlock = null;
        List<CatchClause> catchs = null;
        BlockStmt catchBlock;
        ModifierHolder exceptModifier;
        ReferenceType exceptionType;
        List<ReferenceType> exceptionTypes = new LinkedList<ReferenceType>();
        VariableDeclaratorId exceptId;
        Position begin;
        Position catchBegin;
        Type type;
    jj_consume_token(TRY);
begin=tokenBegin();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      resources = ResourceSpecification();
      break;
      }
    default:
      jj_la1[163] = jj_gen;
      ;
    }
    tryBlock = Block();
    label_67:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CATCH:{
        ;
        break;
        }
      default:
        jj_la1[164] = jj_gen;
        break label_67;
      }
      jj_consume_token(CATCH);
catchBegin=tokenBegin();
      jj_consume_token(LPAREN);
      exceptModifier = Modifiers();
      exceptionType = ReferenceType();
exceptionTypes.add(exceptionType);
      label_68:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case BIT_OR:{
          ;
          break;
          }
        default:
          jj_la1[165] = jj_gen;
          break label_68;
        }
        jj_consume_token(BIT_OR);
        exceptionType = ReferenceType();
exceptionTypes.add(exceptionType);
      }
      exceptId = VariableDeclaratorId();
      jj_consume_token(RPAREN);
      catchBlock = Block();
if (exceptionTypes.size() > 1) {
                                type = new UnionType(exceptionTypes);
                           } else {
                                type = (Type)exceptionTypes.get(0);
                           }
                           catchs = add(catchs, new CatchClause(range(catchBegin, tokenEnd()), exceptModifier.modifiers, exceptModifier.annotations, type, exceptId, catchBlock));
                           exceptionTypes = new LinkedList<ReferenceType>();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FINALLY:{
      jj_consume_token(FINALLY);
      finallyBlock = Block();
      break;
      }
    default:
      jj_la1[166] = jj_gen;
      ;
    }
return new TryStmt(range(begin, tokenEnd()), resources, tryBlock, catchs, finallyBlock);
  }

  final public List<VariableDeclarationExpr> ResourceSpecification() throws ParseException {List<VariableDeclarationExpr> vars;
    jj_consume_token(LPAREN);
    vars = Resources();
    if (jj_2_42(2)) {
      jj_consume_token(SEMICOLON);
    } else {
      ;
    }
    jj_consume_token(RPAREN);
return vars;
  }

  final public List<VariableDeclarationExpr> Resources() throws ParseException {List<VariableDeclarationExpr> vars = new LinkedList<VariableDeclarationExpr>();
        VariableDeclarationExpr var;
    /*this is a bit more lenient than we need to be, eg allowing access modifiers like private*/
      var = VariableDeclarationExpression();
vars.add(var);
    label_69:
    while (true) {
      if (jj_2_43(2)) {
        ;
      } else {
        break label_69;
      }
      jj_consume_token(SEMICOLON);
      var = VariableDeclarationExpression();
vars.add(var);
    }
return vars;
  }

/* We use productions to match >>>, >> and > so that we can keep the
 * type declaration syntax with generics clean
 */
  final public 
void RUNSIGNEDSHIFT() throws ParseException {
    if (getToken(1).kind == GT &&
                    ((GTToken)getToken(1)).realKind == RUNSIGNEDSHIFT) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(GT);
    jj_consume_token(GT);
    jj_consume_token(GT);
  }

  final public void RSIGNEDSHIFT() throws ParseException {
    if (getToken(1).kind == GT &&
                    ((GTToken)getToken(1)).realKind == RSIGNEDSHIFT) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(GT);
    jj_consume_token(GT);
  }

/* Annotation syntax follows. */
  final public 
AnnotationExpr Annotation() throws ParseException {AnnotationExpr ret;
    if (jj_2_44(2147483647)) {
      ret = NormalAnnotation();
    } else if (jj_2_45(2147483647)) {
      ret = SingleMemberAnnotation();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ret = MarkerAnnotation();
        break;
        }
      default:
        jj_la1[167] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return ret;
  }

  final public NormalAnnotationExpr NormalAnnotation() throws ParseException {NameExpr name;
        List<MemberValuePair> pairs = null;
        Position begin;
    jj_consume_token(AT);
begin=tokenBegin();
    name = Name();
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENTIFIER:{
      pairs = MemberValuePairs();
      break;
      }
    default:
      jj_la1[168] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
return new NormalAnnotationExpr(range(begin, tokenEnd()),name, pairs);
  }

  final public MarkerAnnotationExpr MarkerAnnotation() throws ParseException {NameExpr name;
        Position begin;
    jj_consume_token(AT);
begin=tokenBegin();
    name = Name();
return new MarkerAnnotationExpr(range(begin, tokenEnd()),name);
  }

  final public SingleMemberAnnotationExpr SingleMemberAnnotation() throws ParseException {NameExpr name;
        Expression memberVal;
        Position begin;
    jj_consume_token(AT);
begin=tokenBegin();
    name = Name();
    jj_consume_token(LPAREN);
    memberVal = MemberValue();
    jj_consume_token(RPAREN);
return new SingleMemberAnnotationExpr(range(begin, tokenEnd()),name, memberVal);
  }

  final public List<MemberValuePair> MemberValuePairs() throws ParseException {List<MemberValuePair> ret = new LinkedList<MemberValuePair>();
        MemberValuePair pair;
    pair = MemberValuePair();
ret.add(pair);
    label_70:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[169] = jj_gen;
        break label_70;
      }
      jj_consume_token(COMMA);
      pair = MemberValuePair();
ret.add(pair);
    }
return ret;
  }

  final public MemberValuePair MemberValuePair() throws ParseException {String name;
        Expression value;
        Position begin;
    jj_consume_token(IDENTIFIER);
name = token.image; begin=tokenBegin();
    jj_consume_token(ASSIGN);
    value = MemberValue();
return new MemberValuePair(range(begin, tokenEnd()),name, value);
  }

  final public Expression MemberValue() throws ParseException {Expression ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AT:{
      ret = Annotation();
      break;
      }
    case LBRACE:{
      ret = MemberValueArrayInitializer();
      break;
      }
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case LONG_LITERAL:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:{
      ret = ConditionalExpression();
      break;
      }
    default:
      jj_la1[170] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
  }

  final public Expression MemberValueArrayInitializer() throws ParseException {List<Expression> ret = new LinkedList<Expression>();
        Expression member;
        Position begin;
    jj_consume_token(LBRACE);
begin=tokenBegin();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case LONG_LITERAL:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case LBRACE:
    case AT:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:{
      member = MemberValue();
ret.add(member);
      label_71:
      while (true) {
        if (jj_2_46(2)) {
          ;
        } else {
          break label_71;
        }
        jj_consume_token(COMMA);
        member = MemberValue();
ret.add(member);
      }
      break;
      }
    default:
      jj_la1[171] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[172] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
return new ArrayInitializerExpr(range(begin, tokenEnd()),ret);
  }

/* Annotation Types. */
  final public 
AnnotationDeclaration AnnotationTypeDeclaration(ModifierHolder modifier) throws ParseException {NameExpr name;
        List<BodyDeclaration<?>> members;
        Position begin = modifier.begin;
    jj_consume_token(AT);
begin=begin.orIfInvalid(tokenBegin());
    jj_consume_token(INTERFACE);
    name = Name();
    members = AnnotationTypeBody();
AnnotationDeclaration tmp = new AnnotationDeclaration(range(begin, tokenEnd()), modifier.modifiers, modifier.annotations, null, members);
      tmp.setNameExpr(name);
      return tmp;
  }

  final public List<BodyDeclaration<?>> AnnotationTypeBody() throws ParseException {List<BodyDeclaration<?>> ret = null;
        BodyDeclaration member;
    jj_consume_token(LBRACE);
    label_72:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case STRICTFP:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOLATILE:
      case IDENTIFIER:
      case SEMICOLON:
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[173] = jj_gen;
        break label_72;
      }
      member = AnnotationBodyDeclaration();
ret = add(ret, member);
    }
    jj_consume_token(RBRACE);
return ret;
  }

  final public BodyDeclaration<?> AnnotationBodyDeclaration() throws ParseException {ModifierHolder modifier;
   BodyDeclaration ret;

    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
ret = new EmptyTypeDeclaration(tokenRange());
      break;
      }
    case ABSTRACT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case CLASS:
    case DOUBLE:
    case ENUM:
    case FINAL:
    case FLOAT:
    case INT:
    case INTERFACE:
    case LONG:
    case NATIVE:
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
    case SHORT:
    case STATIC:
    case STRICTFP:
    case SYNCHRONIZED:
    case TRANSIENT:
    case VOLATILE:
    case IDENTIFIER:
    case AT:{
      modifier = Modifiers();
      if (jj_2_47(2147483647)) {
        ret = AnnotationTypeMemberDeclaration(modifier);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CLASS:
        case INTERFACE:{
          ret = ClassOrInterfaceDeclaration(modifier);
          break;
          }
        case ENUM:{
          ret = EnumDeclaration(modifier);
          break;
          }
        case AT:{
          ret = AnnotationTypeDeclaration(modifier);
          break;
          }
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FLOAT:
        case INT:
        case LONG:
        case SHORT:
        case IDENTIFIER:{
          ret = FieldDeclaration(modifier);
          break;
          }
        default:
          jj_la1[174] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[175] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
  }

  final public AnnotationMemberDeclaration AnnotationTypeMemberDeclaration(ModifierHolder modifier) throws ParseException {Type type;
        String name;
        Expression defaultVal = null;
    type = Type();
    jj_consume_token(IDENTIFIER);
name = token.image;
    jj_consume_token(LPAREN);
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case _DEFAULT:{
      defaultVal = DefaultValue();
      break;
      }
    default:
      jj_la1[176] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
Position begin = modifier.begin.orIfInvalid(tokenBegin());
    return new AnnotationMemberDeclaration(range(begin, tokenEnd()), modifier.modifiers, modifier.annotations, type, name, defaultVal);
  }

  final public Expression DefaultValue() throws ParseException {Expression ret;
    jj_consume_token(_DEFAULT);
    ret = MemberValue();
return ret;
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_3R_356()
 {
    if (jj_scan_token(BREAK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_422()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_171()
 {
    if (jj_3R_207()) return true;
    return false;
  }

  private boolean jj_3R_210()
 {
    if (jj_3R_242()) return true;
    return false;
  }

  private boolean jj_3R_209()
 {
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_279()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_114()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_171()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_305()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_455()
 {
    if (jj_3R_462()) return true;
    return false;
  }

  private boolean jj_3R_174()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_209()) {
    jj_scanpos = xsp;
    if (jj_3R_210()) {
    jj_scanpos = xsp;
    if (jj_3R_211()) {
    jj_scanpos = xsp;
    if (jj_3R_212()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_280()
 {
    if (jj_scan_token(BIT_AND)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_305()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_198()) return true;
    return false;
  }

  private boolean jj_3R_433()
 {
    if (jj_scan_token(REM)) return true;
    return false;
  }

  private boolean jj_3R_245()
 {
    if (jj_scan_token(EXTENDS)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_279()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_198()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_280()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_41()
 {
    if (jj_3R_117()) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_432()
 {
    if (jj_scan_token(SLASH)) return true;
    return false;
  }

  private boolean jj_3R_431()
 {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_419()
 {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_306()) return true;
    return false;
  }

  private boolean jj_3R_414()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_431()) {
    jj_scanpos = xsp;
    if (jj_3R_432()) {
    jj_scanpos = xsp;
    if (jj_3R_433()) return true;
    }
    }
    if (jj_3R_174()) return true;
    return false;
  }

  private boolean jj_3R_462()
 {
    if (jj_3R_101()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_464()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_461()
 {
    if (jj_3R_462()) return true;
    return false;
  }

  private boolean jj_3R_437()
 {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_460()
 {
    if (jj_3R_118()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_376()
 {
    if (jj_3R_174()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_414()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_182()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_217()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_416()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_218()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_415()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_454()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_460()) {
    jj_scanpos = xsp;
    if (jj_3R_461()) return true;
    }
    return false;
  }

  private boolean jj_3R_404()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_415()) {
    jj_scanpos = xsp;
    if (jj_3R_416()) return true;
    }
    if (jj_3R_376()) return true;
    return false;
  }

  private boolean jj_3R_183()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_218()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_410()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_181()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_372()
 {
    if (jj_3R_376()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_404()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_126()
 {
    if (jj_scan_token(LT)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_181()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_182()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_183()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3_40()
 {
    if (jj_3R_118()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3R_436()
 {
    if (jj_3R_454()) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_102()
 {
    if (jj_scan_token(LSHIFT)) return true;
    return false;
  }

  private boolean jj_3R_421()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_436()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3R_437()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3R_438()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_19()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3_21()) return true;
    }
    }
    if (jj_3R_372()) return true;
    return false;
  }

  private boolean jj_3R_420()
 {
    if (jj_3R_118()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_373()
 {
    if (jj_scan_token(INSTANCEOF)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_370()
 {
    if (jj_3R_372()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_19()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_355()
 {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_420()) {
    jj_scanpos = xsp;
    if (jj_3R_421()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_306()) return true;
    return false;
  }

  private boolean jj_3R_409()
 {
    if (jj_3R_187()) return true;
    return false;
  }

  private boolean jj_3R_125()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_395()
 {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  private boolean jj_3R_398()
 {
    if (jj_3R_207()) return true;
    return false;
  }

  private boolean jj_3R_394()
 {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  private boolean jj_3R_86()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_125()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(IDENTIFIER)) return true;
    xsp = jj_scanpos;
    if (jj_3R_409()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_410()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_393()
 {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_392()
 {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  private boolean jj_3R_377()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_392()) {
    jj_scanpos = xsp;
    if (jj_3R_393()) {
    jj_scanpos = xsp;
    if (jj_3R_394()) {
    jj_scanpos = xsp;
    if (jj_3R_395()) return true;
    }
    }
    }
    if (jj_3R_370()) return true;
    return false;
  }

  private boolean jj_3R_383()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_398()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_354()
 {
    if (jj_scan_token(DO)) return true;
    if (jj_3R_306()) return true;
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_101()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_368()
 {
    if (jj_3R_370()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_377()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_353()
 {
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_101()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_306()) return true;
    return false;
  }

  private boolean jj_3R_369()
 {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_345()) return true;
    return false;
  }

  private boolean jj_3R_382()
 {
    if (jj_3R_86()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_3()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_364()
 {
    if (jj_3R_368()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_373()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_381()
 {
    if (jj_3R_397()) return true;
    return false;
  }

  private boolean jj_3R_375()
 {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  private boolean jj_3R_374()
 {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_299()
 {
    if (jj_scan_token(ENUM)) return true;
    if (jj_3R_120()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_381()) jj_scanpos = xsp;
    if (jj_scan_token(LBRACE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_382()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(113)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_383()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_371()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_374()) {
    jj_scanpos = xsp;
    if (jj_3R_375()) return true;
    }
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_365()
 {
    if (jj_scan_token(XOR)) return true;
    if (jj_3R_315()) return true;
    return false;
  }

  private boolean jj_3R_346()
 {
    if (jj_scan_token(BIT_OR)) return true;
    if (jj_3R_293()) return true;
    return false;
  }

  private boolean jj_3R_345()
 {
    if (jj_3R_364()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_371()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_352()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_101()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_306()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_419()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_316()
 {
    if (jj_scan_token(SC_AND)) return true;
    if (jj_3R_264()) return true;
    return false;
  }

  private boolean jj_3R_408()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_407()) return true;
    return false;
  }

  private boolean jj_3R_315()
 {
    if (jj_3R_345()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_369()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_397()
 {
    if (jj_scan_token(IMPLEMENTS)) return true;
    if (jj_3R_407()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_408()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_453()
 {
    if (jj_scan_token(_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_295()
 {
    if (jj_scan_token(SC_OR)) return true;
    if (jj_3R_233()) return true;
    return false;
  }

  private boolean jj_3R_452()
 {
    if (jj_scan_token(CASE)) return true;
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_405()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_293()
 {
    if (jj_3R_315()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_365()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_406()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_198()) return true;
    return false;
  }

  private boolean jj_3R_435()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_452()) {
    jj_scanpos = xsp;
    if (jj_3R_453()) return true;
    }
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_396()
 {
    if (jj_scan_token(EXTENDS)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_405()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_198()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_406()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_264()
 {
    if (jj_3R_293()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_346()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_418()
 {
    if (jj_3R_435()) return true;
    return false;
  }

  private boolean jj_3R_173()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_172()) return true;
    return false;
  }

  private boolean jj_3R_319()
 {
    if (jj_scan_token(INTERFACE)) return true;
    return false;
  }

  private boolean jj_3R_351()
 {
    if (jj_scan_token(SWITCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_101()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_418()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_233()
 {
    if (jj_3R_264()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_316()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_459()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_380()
 {
    if (jj_3R_397()) return true;
    return false;
  }

  private boolean jj_3R_379()
 {
    if (jj_3R_396()) return true;
    return false;
  }

  private boolean jj_3R_378()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_451()
 {
    if (jj_scan_token(ARROW)) return true;
    if (jj_3R_296()) return true;
    return false;
  }

  private boolean jj_3R_450()
 {
    if (jj_scan_token(DOUBLECOLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_459()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) return true;
    }
    return false;
  }

  private boolean jj_3R_298()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_3R_319()) return true;
    }
    if (jj_3R_120()) return true;
    xsp = jj_scanpos;
    if (jj_3R_378()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_379()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_380()) jj_scanpos = xsp;
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_200()
 {
    if (jj_3R_233()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_295()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_449()
 {
    if (jj_3R_100()) return true;
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_448()
 {
    if (jj_scan_token(DECR)) return true;
    return false;
  }

  private boolean jj_3R_447()
 {
    if (jj_scan_token(INCR)) return true;
    return false;
  }

  private boolean jj_3R_434()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_447()) {
    jj_scanpos = xsp;
    if (jj_3R_448()) {
    jj_scanpos = xsp;
    if (jj_3R_449()) {
    jj_scanpos = xsp;
    if (jj_3R_450()) {
    jj_scanpos = xsp;
    if (jj_3R_451()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_268()
 {
    if (jj_scan_token(HOOK)) return true;
    if (jj_3R_101()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3R_367()
 {
    if (jj_3R_294()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_434()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_366()
 {
    if (jj_3R_242()) return true;
    return false;
  }

  private boolean jj_3R_151()
 {
    if (jj_3R_200()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_268()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_150()
 {
    if (jj_scan_token(ORASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_149()
 {
    if (jj_scan_token(XORASSIGN)) return true;
    return false;
  }

  private boolean jj_3_39()
 {
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_148()
 {
    if (jj_scan_token(ANDASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_350()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_39()) {
    jj_scanpos = xsp;
    if (jj_3R_366()) {
    jj_scanpos = xsp;
    if (jj_3R_367()) return true;
    }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_147()
 {
    if (jj_scan_token(RUNSIGNEDSHIFTASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_146()
 {
    if (jj_scan_token(RSIGNEDSHIFTASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_145()
 {
    if (jj_scan_token(LSHIFTASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_144()
 {
    if (jj_scan_token(MINUSASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_143()
 {
    if (jj_scan_token(PLUSASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_142()
 {
    if (jj_scan_token(REMASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_141()
 {
    if (jj_scan_token(SLASHASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_140()
 {
    if (jj_scan_token(STARASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_139()
 {
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_318()
 {
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_100()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_139()) {
    jj_scanpos = xsp;
    if (jj_3R_140()) {
    jj_scanpos = xsp;
    if (jj_3R_141()) {
    jj_scanpos = xsp;
    if (jj_3R_142()) {
    jj_scanpos = xsp;
    if (jj_3R_143()) {
    jj_scanpos = xsp;
    if (jj_3R_144()) {
    jj_scanpos = xsp;
    if (jj_3R_145()) {
    jj_scanpos = xsp;
    if (jj_3R_146()) {
    jj_scanpos = xsp;
    if (jj_3R_147()) {
    jj_scanpos = xsp;
    if (jj_3R_148()) {
    jj_scanpos = xsp;
    if (jj_3R_149()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_297()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_317()
 {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_85()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_84()
 {
    if (jj_scan_token(STRICTFP)) return true;
    return false;
  }

  private boolean jj_3R_270()
 {
    if (jj_scan_token(DOUBLECOLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_297()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) return true;
    }
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_scan_token(VOLATILE)) return true;
    return false;
  }

  private boolean jj_3R_296()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_317()) {
    jj_scanpos = xsp;
    if (jj_3R_318()) return true;
    }
    return false;
  }

  private boolean jj_3R_82()
 {
    if (jj_scan_token(TRANSIENT)) return true;
    return false;
  }

  private boolean jj_3R_81()
 {
    if (jj_scan_token(NATIVE)) return true;
    return false;
  }

  private boolean jj_3R_80()
 {
    if (jj_scan_token(SYNCHRONIZED)) return true;
    return false;
  }

  private boolean jj_3R_79()
 {
    if (jj_scan_token(ABSTRACT)) return true;
    return false;
  }

  private boolean jj_3R_115()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_349()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    if (jj_scan_token(FINAL)) return true;
    return false;
  }

  private boolean jj_3R_77()
 {
    if (jj_scan_token(PRIVATE)) return true;
    return false;
  }

  private boolean jj_3R_76()
 {
    if (jj_scan_token(PROTECTED)) return true;
    return false;
  }

  private boolean jj_3R_75()
 {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_3R_100()) return true;
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_269()
 {
    if (jj_scan_token(ARROW)) return true;
    if (jj_3R_296()) return true;
    return false;
  }

  private boolean jj_3R_74()
 {
    if (jj_scan_token(PUBLIC)) return true;
    return false;
  }

  private boolean jj_3_38()
 {
    if (jj_3R_118()) return true;
    return false;
  }

  private boolean jj_3R_239()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_18()) {
    jj_scanpos = xsp;
    if (jj_3R_269()) {
    jj_scanpos = xsp;
    if (jj_3R_270()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_118()
 {
    if (jj_3R_117()) return true;
    if (jj_3R_88()) return true;
    if (jj_3R_172()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_173()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_2()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_117()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_2()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_34()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_115()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_37()
 {
    if (jj_3R_117()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) return true;
    }
    return false;
  }

  private boolean jj_3R_101()
 {
    if (jj_3R_151()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_239()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_283()
 {
    if (jj_3R_306()) return true;
    return false;
  }

  private boolean jj_3R_417()
 {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_282()
 {
    if (jj_3R_118()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_281()
 {
    if (jj_3R_117()) return true;
    if (jj_3R_298()) return true;
    return false;
  }

  private boolean jj_3R_246()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_281()) {
    jj_scanpos = xsp;
    if (jj_3R_282()) {
    jj_scanpos = xsp;
    if (jj_3R_283()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_227()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_123()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_73()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_123()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(PACKAGE)) return true;
    if (jj_3R_120()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_120()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_17()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_129()
 {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_184()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_170()
 {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_169()
 {
    if (jj_scan_token(VOID)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_116()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_306()) return true;
    return false;
  }

  private boolean jj_3R_112()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_169()) {
    jj_scanpos = xsp;
    if (jj_3R_170()) return true;
    }
    return false;
  }

  private boolean jj_3R_348()
 {
    if (jj_scan_token(ASSERT)) return true;
    if (jj_3R_101()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_417()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_339()
 {
    if (jj_3R_361()) return true;
    return false;
  }

  private boolean jj_3R_338()
 {
    if (jj_3R_360()) return true;
    return false;
  }

  private boolean jj_3R_163()
 {
    if (jj_scan_token(DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_337()
 {
    if (jj_3R_359()) return true;
    return false;
  }

  private boolean jj_3R_162()
 {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_336()
 {
    if (jj_3R_358()) return true;
    return false;
  }

  private boolean jj_3R_161()
 {
    if (jj_scan_token(LONG)) return true;
    return false;
  }

  private boolean jj_3R_335()
 {
    if (jj_3R_357()) return true;
    return false;
  }

  private boolean jj_3R_160()
 {
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_363()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_334()
 {
    if (jj_3R_356()) return true;
    return false;
  }

  private boolean jj_3R_159()
 {
    if (jj_scan_token(SHORT)) return true;
    return false;
  }

  private boolean jj_3R_362()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_333()
 {
    if (jj_3R_355()) return true;
    return false;
  }

  private boolean jj_3R_158()
 {
    if (jj_scan_token(BYTE)) return true;
    return false;
  }

  private boolean jj_3R_332()
 {
    if (jj_3R_354()) return true;
    return false;
  }

  private boolean jj_3R_157()
 {
    if (jj_scan_token(CHAR)) return true;
    return false;
  }

  private boolean jj_3R_331()
 {
    if (jj_3R_353()) return true;
    return false;
  }

  private boolean jj_3R_156()
 {
    if (jj_scan_token(BOOLEAN)) return true;
    return false;
  }

  private boolean jj_3R_344()
 {
    if (jj_scan_token(SUPER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_363()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_330()
 {
    if (jj_3R_352()) return true;
    return false;
  }

  private boolean jj_3R_108()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_156()) {
    jj_scanpos = xsp;
    if (jj_3R_157()) {
    jj_scanpos = xsp;
    if (jj_3R_158()) {
    jj_scanpos = xsp;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_329()
 {
    if (jj_3R_351()) return true;
    return false;
  }

  private boolean jj_3R_328()
 {
    if (jj_3R_350()) return true;
    return false;
  }

  private boolean jj_3R_343()
 {
    if (jj_scan_token(EXTENDS)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_362()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_314()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_343()) {
    jj_scanpos = xsp;
    if (jj_3R_344()) return true;
    }
    return false;
  }

  private boolean jj_3R_229()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_199()) return true;
    return false;
  }

  private boolean jj_3R_327()
 {
    if (jj_3R_349()) return true;
    return false;
  }

  private boolean jj_3R_326()
 {
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_325()
 {
    if (jj_3R_348()) return true;
    return false;
  }

  private boolean jj_3_36()
 {
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_263()
 {
    if (jj_scan_token(HOOK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_314()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_306()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_36()) {
    jj_scanpos = xsp;
    if (jj_3R_325()) {
    jj_scanpos = xsp;
    if (jj_3R_326()) {
    jj_scanpos = xsp;
    if (jj_3R_327()) {
    jj_scanpos = xsp;
    if (jj_3R_328()) {
    jj_scanpos = xsp;
    if (jj_3R_329()) {
    jj_scanpos = xsp;
    if (jj_3R_330()) {
    jj_scanpos = xsp;
    if (jj_3R_331()) {
    jj_scanpos = xsp;
    if (jj_3R_332()) {
    jj_scanpos = xsp;
    if (jj_3R_333()) {
    jj_scanpos = xsp;
    if (jj_3R_334()) {
    jj_scanpos = xsp;
    if (jj_3R_335()) {
    jj_scanpos = xsp;
    if (jj_3R_336()) {
    jj_scanpos = xsp;
    if (jj_3R_337()) {
    jj_scanpos = xsp;
    if (jj_3R_338()) {
    jj_scanpos = xsp;
    if (jj_3R_339()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_342()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_33()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_101()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_312()
 {
    Token xsp;
    if (jj_3R_342()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_342()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_185()) return true;
    return false;
  }

  private boolean jj_3_35()
 {
    Token xsp;
    if (jj_3_33()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_33()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_34()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_32()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_232()
 {
    if (jj_3R_263()) return true;
    return false;
  }

  private boolean jj_3R_231()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_230()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_199()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_230()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_3R_232()) return true;
    }
    return false;
  }

  private boolean jj_3R_311()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_289()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_311()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_35()) {
    jj_scanpos = xsp;
    if (jj_3R_312()) return true;
    }
    return false;
  }

  private boolean jj_3R_313()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_138()
 {
    if (jj_3R_199()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_229()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_98()
 {
    if (jj_scan_token(LT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_138()) jj_scanpos = xsp;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_292()
 {
    if (jj_3R_187()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_32()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_99()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_291()
 {
    if (jj_3R_289()) return true;
    return false;
  }

  private boolean jj_3R_428()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_407()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_428()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_198()) return true;
    return false;
  }

  private boolean jj_3R_290()
 {
    if (jj_3R_98()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_313()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_97()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_262()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_290()) jj_scanpos = xsp;
    if (jj_3R_198()) return true;
    xsp = jj_scanpos;
    if (jj_3R_291()) {
    jj_scanpos = xsp;
    if (jj_3R_292()) return true;
    }
    return false;
  }

  private boolean jj_3R_284()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_99()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(IDENTIFIER)) return true;
    xsp = jj_scanpos;
    if (jj_3_16()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_96()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_97()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_261()
 {
    if (jj_3R_108()) return true;
    if (jj_3R_289()) return true;
    return false;
  }

  private boolean jj_3R_463()
 {
    if (jj_3R_465()) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_198()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_14()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_15()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_260()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_96()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_225()
 {
    if (jj_scan_token(NEW)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_260()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) return true;
    }
    return false;
  }

  private boolean jj_3R_386()
 {
    if (jj_scan_token(THROWS)) return true;
    if (jj_3R_401()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_402()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_247()
 {
    if (jj_3R_101()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_284()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_137()
 {
    if (jj_3R_198()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_13()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_220()
 {
    if (jj_3R_247()) return true;
    return false;
  }

  private boolean jj_3R_136()
 {
    if (jj_3R_108()) return true;
    Token xsp;
    if (jj_3_12()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_12()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_95()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3R_137()) return true;
    }
    return false;
  }

  private boolean jj_3R_187()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_220()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_286()
 {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_308()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_465()
 {
    if (jj_scan_token(_DEFAULT)) return true;
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3R_127()
 {
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_307()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_88()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3R_127()) return true;
    }
    return false;
  }

  private boolean jj_3R_285()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_307()) {
    jj_scanpos = xsp;
    if (jj_3R_308()) return true;
    }
    return false;
  }

  private boolean jj_3R_254()
 {
    if (jj_3R_286()) return true;
    return false;
  }

  private boolean jj_3R_458()
 {
    if (jj_3R_88()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_463()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_253()
 {
    if (jj_3R_285()) return true;
    return false;
  }

  private boolean jj_3_47()
 {
    if (jj_3R_88()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_446()
 {
    if (jj_3R_302()) return true;
    return false;
  }

  private boolean jj_3R_128()
 {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3R_252()
 {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_445()
 {
    if (jj_3R_300()) return true;
    return false;
  }

  private boolean jj_3R_90()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_128()) jj_scanpos = xsp;
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_444()
 {
    if (jj_3R_299()) return true;
    return false;
  }

  private boolean jj_3R_219()
 {
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_251()
 {
    if (jj_scan_token(CHARACTER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_443()
 {
    if (jj_3R_298()) return true;
    return false;
  }

  private boolean jj_3R_184()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_219()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_442()
 {
    if (jj_3R_458()) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_3R_93()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_250()
 {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_249()
 {
    if (jj_scan_token(LONG_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_46()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3R_429()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_94()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_189()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_248()
 {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_430()
 {
    if (jj_3R_117()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_442()) {
    jj_scanpos = xsp;
    if (jj_3R_443()) {
    jj_scanpos = xsp;
    if (jj_3R_444()) {
    jj_scanpos = xsp;
    if (jj_3R_445()) {
    jj_scanpos = xsp;
    if (jj_3R_446()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_10()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_94()) jj_scanpos = xsp;
    if (jj_scan_token(THIS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_188()
 {
    if (jj_3R_93()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_133()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_188()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_189()) jj_scanpos = xsp;
    if (jj_scan_token(SUPER)) return true;
    if (jj_3R_187()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_411()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_429()) {
    jj_scanpos = xsp;
    if (jj_3R_430()) return true;
    }
    return false;
  }

  private boolean jj_3R_186()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_113()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_221()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_248()) {
    jj_scanpos = xsp;
    if (jj_3R_249()) {
    jj_scanpos = xsp;
    if (jj_3R_250()) {
    jj_scanpos = xsp;
    if (jj_3R_251()) {
    jj_scanpos = xsp;
    if (jj_3R_252()) {
    jj_scanpos = xsp;
    if (jj_3R_253()) {
    jj_scanpos = xsp;
    if (jj_3R_254()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_132()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_186()) jj_scanpos = xsp;
    if (jj_scan_token(THIS)) return true;
    if (jj_3R_187()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_166()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_101()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_31()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_113()) jj_scanpos = xsp;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_399()
 {
    if (jj_3R_411()) return true;
    return false;
  }

  private boolean jj_3R_238()
 {
    if (jj_3R_187()) return true;
    return false;
  }

  private boolean jj_3R_384()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_399()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_237()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_92()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) return true;
    }
    return false;
  }

  private boolean jj_3R_205()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_237()) jj_scanpos = xsp;
    if (jj_3R_227()) return true;
    xsp = jj_scanpos;
    if (jj_3R_238()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_204()
 {
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_203()
 {
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_92()) return true;
    return false;
  }

  private boolean jj_3R_287()
 {
    if (jj_3R_309()) return true;
    return false;
  }

  private boolean jj_3R_167()
 {
    if (jj_scan_token(ELLIPSIS)) return true;
    return false;
  }

  private boolean jj_3R_300()
 {
    if (jj_scan_token(AT)) return true;
    if (jj_scan_token(INTERFACE)) return true;
    if (jj_3R_120()) return true;
    if (jj_3R_384()) return true;
    return false;
  }

  private boolean jj_3R_340()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_165()
 {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_203()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) {
    jj_scanpos = xsp;
    if (jj_3R_205()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_387()
 {
    if (jj_3R_92()) return true;
    return false;
  }

  private boolean jj_3R_324()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_323()) return true;
    return false;
  }

  private boolean jj_3R_347()
 {
    if (jj_3R_122()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_46()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_110()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_3R_166()) return true;
    }
    return false;
  }

  private boolean jj_3R_402()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_401()) return true;
    return false;
  }

  private boolean jj_3R_320()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_301()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_320()) jj_scanpos = xsp;
    if (jj_3R_227()) return true;
    if (jj_3R_385()) return true;
    xsp = jj_scanpos;
    if (jj_3R_386()) jj_scanpos = xsp;
    if (jj_scan_token(LBRACE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_387()) jj_scanpos = xsp;
    if (jj_3R_184()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_412()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_213()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_347()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(113)) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_164()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(SUPER)) return true;
    return false;
  }

  private boolean jj_3R_177()
 {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3_30()
 {
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3R_226()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_176()
 {
    if (jj_3R_213()) return true;
    return false;
  }

  private boolean jj_3R_175()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_109()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) return true;
    }
    return false;
  }

  private boolean jj_3R_228()
 {
    if (jj_3R_187()) return true;
    return false;
  }

  private boolean jj_3R_197()
 {
    if (jj_3R_227()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_228()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_122()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) {
    jj_scanpos = xsp;
    if (jj_3R_177()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_111()
 {
    if (jj_3R_117()) return true;
    if (jj_3R_88()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_167()) jj_scanpos = xsp;
    if (jj_3R_168()) return true;
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_3R_112()) return true;
    if (jj_scan_token(DOUBLECOLON)) return true;
    return false;
  }

  private boolean jj_3R_278()
 {
    if (jj_3R_304()) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_91()) return true;
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_3R_112()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_323()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3R_341()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_168()) return true;
    return false;
  }

  private boolean jj_3R_288()
 {
    if (jj_3R_310()) return true;
    return false;
  }

  private boolean jj_3R_196()
 {
    if (jj_3R_112()) return true;
    if (jj_scan_token(DOUBLECOLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_226()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) return true;
    }
    return false;
  }

  private boolean jj_3R_310()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_168()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_341()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_195()
 {
    if (jj_3R_112()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_194()
 {
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_304()
 {
    if (jj_3R_323()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_324()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_27()
 {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_389()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_309()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_111()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_340()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_215()
 {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_120()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_122()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_121()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_259()
 {
    if (jj_3R_101()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_288()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_400()
 {
    if (jj_3R_111()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_412()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_258()
 {
    if (jj_3R_111()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_287()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_224()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_258()) {
    jj_scanpos = xsp;
    if (jj_3R_259()) return true;
    }
    return false;
  }

  private boolean jj_3R_257()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_385()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_400()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_216()
 {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_120()) return true;
    return false;
  }

  private boolean jj_3R_193()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_224()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_223()
 {
    if (jj_scan_token(DOUBLECOLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_257()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) return true;
    }
    return false;
  }

  private boolean jj_3_45()
 {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_120()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_43()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_118()) return true;
    return false;
  }

  private boolean jj_3_44()
 {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_120()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) return true;
    }
    return false;
  }

  private boolean jj_3R_214()
 {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_120()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_278()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_413()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_401()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_413()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_180()
 {
    if (jj_3R_216()) return true;
    return false;
  }

  private boolean jj_3R_179()
 {
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3R_206()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_178()
 {
    if (jj_3R_214()) return true;
    return false;
  }

  private boolean jj_3R_256()
 {
    if (jj_3R_187()) return true;
    return false;
  }

  private boolean jj_3R_222()
 {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_255()) jj_scanpos = xsp;
    if (jj_3R_227()) return true;
    xsp = jj_scanpos;
    if (jj_3R_256()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_255()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3R_322()
 {
    if (jj_3R_91()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_7()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_192()
 {
    if (jj_scan_token(SUPER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_222()) {
    jj_scanpos = xsp;
    if (jj_3R_223()) return true;
    }
    return false;
  }

  private boolean jj_3R_403()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_401()) return true;
    return false;
  }

  private boolean jj_3R_391()
 {
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_191()
 {
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3R_124()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_178()) {
    jj_scanpos = xsp;
    if (jj_3R_179()) {
    jj_scanpos = xsp;
    if (jj_3R_180()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_390()
 {
    if (jj_scan_token(THROWS)) return true;
    if (jj_3R_401()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_403()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_152()
 {
    return false;
  }

  private boolean jj_3R_190()
 {
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_321()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_303()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_321()) jj_scanpos = xsp;
    if (jj_3R_112()) return true;
    if (jj_3R_120()) return true;
    if (jj_3R_385()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_389()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_390()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_391()) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) return true;
    }
    return false;
  }

  private boolean jj_3R_135()
 {
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3R_153()
 {
    return false;
  }

  private boolean jj_3R_134()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_190()) {
    jj_scanpos = xsp;
    if (jj_3R_191()) {
    jj_scanpos = xsp;
    if (jj_3R_192()) {
    jj_scanpos = xsp;
    if (jj_3R_193()) {
    jj_scanpos = xsp;
    if (jj_3R_194()) {
    jj_scanpos = xsp;
    if (jj_3R_195()) {
    jj_scanpos = xsp;
    if (jj_3R_196()) {
    jj_scanpos = xsp;
    if (jj_3R_197()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_103()
 {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == GT &&
                ((GTToken)getToken(1)).realKind == RSIGNEDSHIFT;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_152()) return true;
    if (jj_scan_token(GT)) return true;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_104()
 {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == GT &&
                ((GTToken)getToken(1)).realKind == RUNSIGNEDSHIFT;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_153()) return true;
    if (jj_scan_token(GT)) return true;
    if (jj_scan_token(GT)) return true;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_185()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_322()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(113)) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_131()
 {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_208()
 {
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_91()) return true;
    return false;
  }

  private boolean jj_3R_130()
 {
    if (jj_3R_185()) return true;
    return false;
  }

  private boolean jj_3R_93()
 {
    if (jj_3R_134()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_135()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_456()
 {
    if (jj_3R_118()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_43()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_91()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_130()) {
    jj_scanpos = xsp;
    if (jj_3R_131()) return true;
    }
    return false;
  }

  private boolean jj_3R_294()
 {
    if (jj_3R_134()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_25()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_441()
 {
    if (jj_scan_token(FINALLY)) return true;
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_427()
 {
    if (jj_scan_token(FINALLY)) return true;
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3_42()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_168()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_206()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_439()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_456()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_42()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_201()
 {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_457()
 {
    if (jj_scan_token(BIT_OR)) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_155()
 {
    if (jj_3R_95()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_201()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_202()) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_3R_108()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_174()) return true;
    return false;
  }

  private boolean jj_3R_440()
 {
    if (jj_scan_token(CATCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_117()) return true;
    if (jj_3R_95()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_457()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_168()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_172()
 {
    if (jj_3R_168()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_208()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_154()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_105()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_154()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    if (jj_3R_155()) return true;
    }
    return false;
  }

  private boolean jj_3R_89()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_388()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_172()) return true;
    return false;
  }

  private boolean jj_3R_426()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_440()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_441()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_302()
 {
    if (jj_3R_88()) return true;
    if (jj_3R_172()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_388()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_241()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_107()
 {
    if (jj_scan_token(DECR)) return true;
    return false;
  }

  private boolean jj_3_23()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_106()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) return true;
    }
    return false;
  }

  private boolean jj_3R_106()
 {
    if (jj_scan_token(INCR)) return true;
    return false;
  }

  private boolean jj_3R_425()
 {
    if (jj_3R_439()) return true;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_361()
 {
    if (jj_scan_token(TRY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_425()) jj_scanpos = xsp;
    if (jj_3R_129()) return true;
    xsp = jj_scanpos;
    if (jj_3R_426()) {
    jj_scanpos = xsp;
    if (jj_3R_427()) return true;
    }
    return false;
  }

  private boolean jj_3R_267()
 {
    if (jj_3R_294()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_23()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_88()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_89()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(113)) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_87()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_87()) jj_scanpos = xsp;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_235()
 {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_236()
 {
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_266()
 {
    if (jj_scan_token(BANG)) return true;
    return false;
  }

  private boolean jj_3R_265()
 {
    if (jj_scan_token(TILDE)) return true;
    return false;
  }

  private boolean jj_3R_424()
 {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_277()
 {
    if (jj_3R_303()) return true;
    return false;
  }

  private boolean jj_3R_234()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_265()) {
    jj_scanpos = xsp;
    if (jj_3R_266()) return true;
    }
    if (jj_3R_174()) return true;
    return false;
  }

  private boolean jj_3R_271()
 {
    if (jj_scan_token(_DEFAULT)) return true;
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_276()
 {
    if (jj_3R_302()) return true;
    return false;
  }

  private boolean jj_3R_275()
 {
    if (jj_3R_301()) return true;
    return false;
  }

  private boolean jj_3R_423()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_274()
 {
    if (jj_3R_300()) return true;
    return false;
  }

  private boolean jj_3R_202()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_234()) {
    jj_scanpos = xsp;
    if (jj_3R_235()) {
    jj_scanpos = xsp;
    if (jj_3R_236()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_273()
 {
    if (jj_3R_299()) return true;
    return false;
  }

  private boolean jj_3R_360()
 {
    if (jj_scan_token(SYNCHRONIZED)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_101()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_272()
 {
    if (jj_3R_298()) return true;
    return false;
  }

  private boolean jj_3R_422()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_242()
 {
    if (jj_scan_token(DECR)) return true;
    if (jj_3R_174()) return true;
    return false;
  }

  private boolean jj_3R_217()
 {
    if (jj_3R_245()) return true;
    return false;
  }

  private boolean jj_3R_359()
 {
    if (jj_scan_token(THROW)) return true;
    if (jj_3R_101()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_240()
 {
    if (jj_3R_117()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_271()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_272()) {
    jj_scanpos = xsp;
    if (jj_3R_273()) {
    jj_scanpos = xsp;
    if (jj_3R_274()) {
    jj_scanpos = xsp;
    if (jj_3R_275()) {
    jj_scanpos = xsp;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_3R_277()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_119()
 {
    if (jj_scan_token(INCR)) return true;
    if (jj_3R_174()) return true;
    return false;
  }

  private boolean jj_3R_464()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_358()
 {
    if (jj_scan_token(RETURN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_424()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_212()
 {
    if (jj_3R_202()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_357()
 {
    if (jj_scan_token(CONTINUE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_423()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_207()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3R_240()) {
    jj_scanpos = xsp;
    if (jj_3R_241()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_244()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_243()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_438()
 {
    if (jj_3R_455()) return true;
    return false;
  }

  private boolean jj_3R_211()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_243()) {
    jj_scanpos = xsp;
    if (jj_3R_244()) return true;
    }
    if (jj_3R_174()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ASTParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[177];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x40000000,0x40000000,0x902020,0x0,0x0,0x0,0x0,0x800020,0x102000,0x902020,0x2000,0x0,0x200000,0x20000000,0x0,0x0,0x0,0x20000000,0x0,0x0,0x29532a0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x29532a0,0x10000,0x102000,0x2041280,0x29532a0,0x0,0x0,0x0,0x2441280,0x2441280,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x28412a0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2441280,0x16c6b3e0,0x0,0x2041280,0x0,0x0,0x2041280,0x2041280,0x0,0x0,0x0,0x2041280,0x0,0x2041280,0x0,0x0,0x200000,0x200000,0x2041280,0x2041280,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2441280,0x0,0x0,0x2441280,0x0,0x0,0x0,0x2041280,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2441280,0x2c412a0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x400000,0x2441280,0x0,0x0,0x0,0x0,0x0,0x2041280,0x0,0x0,0x0,0x0,0x164693c0,0x0,0x164693c0,0x0,0x2441280,0x0,0x0,0x0,0x0,0x2441280,0x10400,0x10400,0x80000,0x2c412a0,0x2441280,0x2441280,0x2c412a0,0x2441280,0x0,0x0,0x0,0x2441280,0x0,0x800,0x0,0x1000000,0x0,0x0,0x0,0x2441280,0x2441280,0x0,0x29432a0,0x2143280,0x29432a0,0x10000,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x111338a,0x0,0x0,0x1000,0x0,0x1113388,0x2,0x111338a,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1913b8f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1913b8f,0x0,0x2,0x800805,0x1913b8f,0x0,0x0,0x0,0xca24835,0xca24835,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x1113b8d,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0xca24835,0xff7ffbf,0x1000,0x805,0x0,0x0,0x805,0x805,0x0,0x0,0x0,0x805,0x0,0x805,0x0,0x0,0x4000,0x4000,0x805,0x800805,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xca24835,0x0,0x0,0xca24835,0x0,0x0,0x0,0x805,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0xca24835,0xdb37bbd,0x0,0x10,0x0,0xc224030,0x0,0x0,0x0,0x0,0x20010,0x0,0xc200020,0x200000,0xca24835,0x0,0x0,0x0,0x0,0x0,0x805,0x0,0x0,0x0,0x0,0xee7cc35,0x0,0xee7cc35,0x0,0xca24835,0x0,0x10,0x0,0x0,0xca24835,0x0,0x0,0x0,0xdb37bbd,0xca24835,0xca24835,0xdb37bbd,0xca24835,0x0,0x0,0x0,0xca24835,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xca24835,0xca24835,0x0,0x1113b8f,0x807,0x1113b8f,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x10000,0x10000,0x90000,0x0,0x80000,0x0,0x40000,0x80000,0x80000,0x90000,0x0,0x200000,0x0,0x0,0x80000,0x20000,0x20000,0x0,0x80080,0x20000,0x291080,0x10000,0x80000,0x400,0x1000,0x80000,0x20000,0x80000,0x0,0x80000,0x0,0x80000,0x291080,0x0,0x80000,0x200080,0x290080,0x20000,0x100000,0x4000,0xc014e1,0xc014e1,0x20000,0x200000,0x4000,0x20000,0x0,0x11000,0x80000,0x20000,0x80080,0x20000,0x20000,0x0,0x200000,0x20000,0x0,0x200000,0x200000,0x2004e1,0x914e1,0x0,0x0,0x80000,0x80000,0x80,0x80,0x80000,0x80000,0x20000,0x1080080,0x80000,0x1000080,0x80000,0x80000,0x0,0x0,0x0,0x80,0x200000,0x80,0x0,0x100000,0x100000,0x1000000,0x40000000,0x80000000,0x0,0x0,0x0,0x24000000,0x24000000,0x0,0x18200000,0x18200000,0x0,0x0,0x0,0x0,0x0,0x0,0xc004e1,0xc00000,0xc00000,0x4e1,0x0,0x80000,0x0,0x80,0x200000,0x400,0x200000,0x80,0x40000,0x20000,0x20000,0xc004e1,0xc804e1,0x200000,0x80,0x400,0x461,0x80,0x40000,0x200000,0x400,0x0,0x44000,0x61,0x0,0xc004e1,0x20000,0x80000,0x80000,0x200000,0x84400,0x200080,0x80000,0x80000,0x4000,0x4000,0x114e1,0x2000000,0x114e1,0x20000,0xc014e1,0x200000,0x80,0x100000,0x100000,0x4e1,0x0,0x0,0x0,0xc804e1,0xc004e1,0xc004e1,0xc904e1,0xc004e1,0x20000,0x80,0x80,0xc004e1,0x400,0x0,0x0,0x0,0x80000,0x80,0x20000,0xc814e1,0xc814e1,0x20000,0x90080,0x80080,0x90080,0x0,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1800000,0x1bff800,0x3ff800,0x0,0x0,0x0,0x80,0x100,0x40,0x0,0x0,0x0,0x8000000,0x8000000,0x400,0xc,0xc,0x230,0x230,0xc,0xf,0x0,0x0,0x0,0x3,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0xf,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x3,0x0,0xf,0x0,0x0,0x1bff803,0x1bff803,0x2,0x0,0x0,0x0,0xf,0xf,0xf,0xf,0xf,0x0,0x0,0x0,0xf,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0xf,0xf,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[47];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public ASTParser(Provider stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new ASTParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 177; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public ASTParser(String dsl) throws ParseException, TokenMgrException {
      this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
     ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
      jj_input_stream = new JavaCharStream(stream, 1, 1);
   } else {
      jj_input_stream.ReInit(stream, 1, 1);
   }
   if (token_source == null) {
      token_source = new ASTParserTokenManager(jj_input_stream);
   }

    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 177; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public ASTParser(ASTParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 177; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ASTParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 177; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) {
       return;
    }

    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];

      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }

      for (int[] oldentry : jj_expentries) {
        if (oldentry.length == jj_expentry.length) {
          boolean isMatched = true;

          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              isMatched = false;
              break;
            }

          }
          if (isMatched) {
            jj_expentries.add(jj_expentry);
            break;
          }
        }
      }

      if (pos != 0) {
        jj_lasttokens[(jj_endpos = pos) - 1] = kind;
      }
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[157];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 177; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 157; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : ASTParserTokenManager.lexStateNames[token_source.curLexState]);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 47; i++) {
      try {
        JJCalls p = jj_2_rtns[i];

        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
              case 7: jj_3_8(); break;
              case 8: jj_3_9(); break;
              case 9: jj_3_10(); break;
              case 10: jj_3_11(); break;
              case 11: jj_3_12(); break;
              case 12: jj_3_13(); break;
              case 13: jj_3_14(); break;
              case 14: jj_3_15(); break;
              case 15: jj_3_16(); break;
              case 16: jj_3_17(); break;
              case 17: jj_3_18(); break;
              case 18: jj_3_19(); break;
              case 19: jj_3_20(); break;
              case 20: jj_3_21(); break;
              case 21: jj_3_22(); break;
              case 22: jj_3_23(); break;
              case 23: jj_3_24(); break;
              case 24: jj_3_25(); break;
              case 25: jj_3_26(); break;
              case 26: jj_3_27(); break;
              case 27: jj_3_28(); break;
              case 28: jj_3_29(); break;
              case 29: jj_3_30(); break;
              case 30: jj_3_31(); break;
              case 31: jj_3_32(); break;
              case 32: jj_3_33(); break;
              case 33: jj_3_34(); break;
              case 34: jj_3_35(); break;
              case 35: jj_3_36(); break;
              case 36: jj_3_37(); break;
              case 37: jj_3_38(); break;
              case 38: jj_3_39(); break;
              case 39: jj_3_40(); break;
              case 40: jj_3_41(); break;
              case 41: jj_3_42(); break;
              case 42: jj_3_43(); break;
              case 43: jj_3_44(); break;
              case 44: jj_3_45(); break;
              case 45: jj_3_46(); break;
              case 46: jj_3_47(); break;
            }
          }
          p = p.next;
        } while (p != null);

        } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }

    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
