/*
 * Decompiled with CFR 0.152.
 */
package com.sourcetrail.name;

import com.sourcetrail.name.DeclName;
import com.sourcetrail.name.NameElement;
import com.sourcetrail.name.NameHierarchy;
import com.sourcetrail.name.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FunctionDeclName
extends DeclName {
    private TypeName m_returnTypeName = null;
    private List<TypeName> m_parameterTypeNames = new ArrayList<TypeName>();
    private boolean m_isStatic = false;

    public FunctionDeclName(String name, TypeName returnTypeName, List<TypeName> parameterTypeNames, boolean isStatic) {
        super(name);
        this.m_returnTypeName = returnTypeName;
        if (parameterTypeNames != null) {
            this.m_parameterTypeNames = parameterTypeNames;
        }
        this.m_isStatic = isStatic;
    }

    public FunctionDeclName(String name, List<String> typeParameterNames, TypeName returnTypeName, List<TypeName> parameterTypeNames, boolean isStatic) {
        super(name, typeParameterNames);
        this.m_returnTypeName = returnTypeName;
        if (parameterTypeNames != null) {
            this.m_parameterTypeNames = parameterTypeNames;
        }
        this.m_isStatic = isStatic;
    }

    @Override
    public NameHierarchy toNameHierarchy() {
        Object prefix = "";
        if (this.m_isStatic) {
            prefix = (String)prefix + "static ";
        }
        if (this.m_returnTypeName != null) {
            prefix = (String)prefix + this.m_returnTypeName.toString();
        }
        String postfix = this.getParameterString();
        NameHierarchy nameHierarchy = super.toNameHierarchy();
        Optional<NameElement> nameElement = nameHierarchy.peek();
        if (nameElement.isPresent()) {
            String name = nameElement.get().getName();
            nameHierarchy.pop();
            nameHierarchy.push(new NameElement(name, (String)prefix, postfix));
        }
        return nameHierarchy;
    }

    private String getParameterString() {
        Object string = "(";
        if (this.m_parameterTypeNames != null) {
            for (int i = 0; i < this.m_parameterTypeNames.size(); ++i) {
                if (i != 0) {
                    string = (String)string + ", ";
                }
                string = (String)string + this.m_parameterTypeNames.get(i).toString();
            }
        }
        string = (String)string + ")";
        return string;
    }
}

