/*
 * Decompiled with CFR 0.152.
 */
package com.sourcetrail.name;

import com.sourcetrail.Position;
import com.sourcetrail.name.NameElement;
import com.sourcetrail.name.NameHierarchy;
import com.sourcetrail.name.SymbolName;
import java.io.File;
import java.util.List;

public class DeclName
implements SymbolName {
    private DeclName m_parent = null;
    private String m_name = "";
    private List<String> m_typeParameterNames = null;
    private boolean m_isUnsolved = false;
    private boolean m_isAnonymous = false;
    private boolean m_isLocal = false;
    private boolean m_isGlobal = false;

    public static DeclName unsolved() {
        DeclName declName = new DeclName("unsolved-symbol");
        declName.m_isUnsolved = true;
        return declName;
    }

    public static DeclName anonymousClass(File filePath, int line, int col) {
        DeclName declName = new DeclName("anonymous class (" + filePath.getName() + "<" + line + ":" + col + ">)");
        declName.m_isAnonymous = true;
        return declName;
    }

    public static DeclName localSymbol(DeclName methodContextName, int id) {
        DeclName declName = new DeclName(String.valueOf(methodContextName) + "<" + id + ">");
        declName.m_isLocal = true;
        return declName;
    }

    public static DeclName globalSymbol(File fileContext, int id) {
        DeclName declName = new DeclName(fileContext.getName() + "<" + id + ">");
        declName.m_isGlobal = true;
        return declName;
    }

    public static DeclName scope(File fileContext, Position begin) {
        DeclName declName = new DeclName(fileContext.getName() + "<" + begin.line() + ":" + begin.column() + ">");
        return declName;
    }

    public static DeclName fromDotSeparatedString(String s) {
        DeclName declName = null;
        int separatorIndex = s.lastIndexOf(46);
        if (separatorIndex != -1) {
            declName = new DeclName(s.substring(separatorIndex + 1));
            declName.setParent(DeclName.fromDotSeparatedString(s.substring(0, separatorIndex)));
        } else {
            declName = new DeclName(s, null);
        }
        return declName;
    }

    public DeclName(String name) {
        this.m_name = name;
    }

    public DeclName(String name, List<String> typeParameterNames) {
        this.m_name = name;
        this.m_typeParameterNames = typeParameterNames;
    }

    public void setParent(DeclName parent) {
        this.m_parent = parent;
    }

    public DeclName getParent() {
        return this.m_parent;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean getIsUnsolved() {
        return this.m_isUnsolved;
    }

    public boolean getIsAnonymous() {
        return this.m_isAnonymous;
    }

    public boolean getIsLocal() {
        return this.m_isLocal;
    }

    public boolean getIsGlobal() {
        return this.m_isGlobal;
    }

    @Override
    public NameHierarchy toNameHierarchy() {
        NameHierarchy nameHierarchy = this.m_parent != null ? this.m_parent.toNameHierarchy() : new NameHierarchy();
        nameHierarchy.push(new NameElement(this.m_name + this.getTypeParameterString()));
        return nameHierarchy;
    }

    public String toString() {
        Object string = "";
        if (this.m_parent != null) {
            string = this.m_parent.toString();
            string = (String)string + ".";
        }
        string = (String)string + this.m_name;
        string = (String)string + this.getTypeParameterString();
        return string;
    }

    public String getTypeParameterString() {
        Object string = "";
        if (this.m_typeParameterNames != null && !this.m_typeParameterNames.isEmpty()) {
            string = (String)string + "<";
            for (int i = 0; i < this.m_typeParameterNames.size(); ++i) {
                if (i != 0) {
                    string = (String)string + ", ";
                }
                string = (String)string + this.m_typeParameterNames.get(i);
            }
            string = (String)string + ">";
        }
        return string;
    }

    public List<String> getTypeParameterNames() {
        return this.m_typeParameterNames;
    }
}

