/*
 * Decompiled with CFR 0.152.
 */
package com.sourcetrail;

import com.sourcetrail.AstVisitor;
import com.sourcetrail.AstVisitorClient;
import com.sourcetrail.ReferenceKind;
import java.io.File;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class ContextAwareAstVisitor
extends AstVisitor {
    private Stack<ReferenceKind> m_typeRefKind = new Stack();

    public ContextAwareAstVisitor(AstVisitorClient client, File filePath, String fileContent, CompilationUnit compilationUnit) {
        super(client, filePath, fileContent, compilationUnit);
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        boolean visitChildren = super.visit(node);
        if (visitChildren) {
            this.m_typeRefKind.push(ReferenceKind.TYPE_USAGE);
            this.acceptChild((ASTNode)node.getJavadoc());
            this.acceptChildren(node.modifiers());
            this.acceptChild((ASTNode)node.getName());
            this.acceptChildren(node.typeParameters());
            this.m_typeRefKind.push(ReferenceKind.INHERITANCE);
            this.acceptChild((ASTNode)node.getSuperclassType());
            this.acceptChildren(node.superInterfaceTypes());
            this.m_typeRefKind.pop();
            this.acceptChildren(node.bodyDeclarations());
            this.m_typeRefKind.pop();
        }
        return false;
    }

    @Override
    public boolean visit(EnumDeclaration node) {
        boolean visitChildren = super.visit(node);
        if (visitChildren) {
            this.m_typeRefKind.push(ReferenceKind.TYPE_USAGE);
            this.acceptChild((ASTNode)node.getJavadoc());
            this.acceptChildren(node.modifiers());
            this.acceptChild((ASTNode)node.getName());
            this.m_typeRefKind.push(ReferenceKind.INHERITANCE);
            this.acceptChildren(node.superInterfaceTypes());
            this.m_typeRefKind.pop();
            this.acceptChildren(node.enumConstants());
            this.acceptChildren(node.bodyDeclarations());
            this.m_typeRefKind.pop();
        }
        return false;
    }

    @Override
    public boolean visit(EnumConstantDeclaration node) {
        boolean visitChildren = super.visit(node);
        if (visitChildren) {
            this.m_typeRefKind.push(ReferenceKind.TYPE_USAGE);
            this.acceptChild((ASTNode)node.getJavadoc());
            this.acceptChildren(node.modifiers());
            this.acceptChildren(node.arguments());
            this.acceptChild((ASTNode)node.getAnonymousClassDeclaration());
            this.m_typeRefKind.pop();
        }
        return false;
    }

    public boolean visit(VariableDeclarationFragment node) {
        boolean visitChildren = super.visit(node);
        if (visitChildren) {
            this.m_typeRefKind.push(ReferenceKind.TYPE_USAGE);
            if (!(node.getParent() instanceof FieldDeclaration)) {
                this.acceptChild((ASTNode)node.getName());
            }
            this.acceptChildren(node.extraDimensions());
            this.acceptChild((ASTNode)node.getInitializer());
            this.m_typeRefKind.pop();
        }
        return false;
    }

    @Override
    public boolean visit(ImportDeclaration node) {
        super.visit(node);
        return false;
    }

    @Override
    public boolean visit(ParameterizedType node) {
        boolean visitChildren = super.visit(node);
        if (visitChildren) {
            this.acceptChild((ASTNode)node.getType());
            this.m_typeRefKind.push(ReferenceKind.TYPE_USAGE);
            this.acceptChildren(node.typeArguments());
            this.m_typeRefKind.pop();
        }
        return false;
    }

    @Override
    public boolean visit(QualifiedType node) {
        boolean visitChildren = super.visit(node);
        if (visitChildren) {
            this.m_typeRefKind.push(ReferenceKind.TYPE_USAGE);
            this.acceptChildren(node.annotations());
            this.acceptChild((ASTNode)node.getName());
            this.m_typeRefKind.pop();
        }
        return false;
    }

    @Override
    public boolean visit(NameQualifiedType node) {
        boolean visitChildren = super.visit(node);
        if (visitChildren) {
            this.m_typeRefKind.push(ReferenceKind.TYPE_USAGE);
            this.acceptChildren(node.annotations());
            this.acceptChild((ASTNode)node.getName());
            this.m_typeRefKind.pop();
        }
        return false;
    }

    @Override
    public boolean visit(MethodInvocation node) {
        boolean visitChildren = super.visit(node);
        if (visitChildren) {
            this.m_typeRefKind.push(ReferenceKind.TYPE_USAGE);
            this.acceptChild((ASTNode)node.getExpression());
            this.acceptChildren(node.typeArguments());
            this.acceptChild((ASTNode)node.getName());
            this.acceptChildren(node.arguments());
            this.m_typeRefKind.pop();
        }
        return false;
    }

    @Override
    public boolean visit(SuperMethodInvocation node) {
        boolean visitChildren = super.visit(node);
        if (visitChildren) {
            this.m_typeRefKind.push(ReferenceKind.TYPE_USAGE);
            this.acceptChildren(node.typeArguments());
            this.acceptChild((ASTNode)node.getName());
            this.acceptChildren(node.arguments());
            this.m_typeRefKind.pop();
        }
        return false;
    }

    @Override
    public boolean visit(ConstructorInvocation node) {
        boolean visitChildren = super.visit(node);
        if (visitChildren) {
            this.m_typeRefKind.push(ReferenceKind.TYPE_USAGE);
            this.acceptChildren(node.typeArguments());
            this.acceptChildren(node.arguments());
            this.m_typeRefKind.pop();
        }
        return false;
    }

    @Override
    public boolean visit(SuperConstructorInvocation node) {
        boolean visitChildren = super.visit(node);
        if (visitChildren) {
            this.m_typeRefKind.push(ReferenceKind.TYPE_USAGE);
            this.acceptChild((ASTNode)node.getExpression());
            this.acceptChildren(node.typeArguments());
            this.acceptChildren(node.arguments());
            this.m_typeRefKind.pop();
        }
        return false;
    }

    @Override
    public boolean visit(CreationReference node) {
        boolean visitChildren = super.visit(node);
        if (visitChildren) {
            this.m_typeRefKind.push(ReferenceKind.TYPE_USAGE);
            this.acceptChildren(node.typeArguments());
            this.m_typeRefKind.pop();
        }
        return false;
    }

    @Override
    public boolean visit(ExpressionMethodReference node) {
        boolean visitChildren = super.visit(node);
        if (visitChildren) {
            this.m_typeRefKind.push(ReferenceKind.TYPE_USAGE);
            this.acceptChild((ASTNode)node.getExpression());
            this.acceptChildren(node.typeArguments());
            this.acceptChild((ASTNode)node.getName());
            this.m_typeRefKind.pop();
        }
        return false;
    }

    @Override
    public boolean visit(SuperMethodReference node) {
        boolean visitChildren = super.visit(node);
        if (visitChildren) {
            this.m_typeRefKind.push(ReferenceKind.TYPE_USAGE);
            this.acceptChildren(node.typeArguments());
            this.acceptChild((ASTNode)node.getName());
            this.m_typeRefKind.pop();
        }
        return false;
    }

    @Override
    public boolean visit(TypeMethodReference node) {
        boolean visitChildren = super.visit(node);
        if (visitChildren) {
            this.m_typeRefKind.push(ReferenceKind.TYPE_USAGE);
            this.acceptChildren(node.typeArguments());
            this.acceptChild((ASTNode)node.getName());
            this.m_typeRefKind.pop();
        }
        return false;
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        boolean visitChildren = super.visit(node);
        if (visitChildren) {
            this.m_typeRefKind.push(ReferenceKind.TYPE_USAGE);
            this.acceptChild((ASTNode)node.getExpression());
            this.acceptChildren(node.typeArguments());
            if (node.getAnonymousClassDeclaration() != null) {
                this.m_typeRefKind.push(ReferenceKind.INHERITANCE);
                this.acceptChild((ASTNode)node.getType());
                this.m_typeRefKind.pop();
            } else {
                this.acceptChild((ASTNode)node.getType());
            }
            this.acceptChildren(node.arguments());
            this.acceptChild((ASTNode)node.getAnonymousClassDeclaration());
            this.m_typeRefKind.pop();
        }
        return false;
    }

    @Override
    public boolean visit(Javadoc node) {
        super.visit(node);
        return false;
    }

    @Override
    protected ReferenceKind getTypeReferenceKind() {
        if (!this.m_typeRefKind.isEmpty()) {
            return this.m_typeRefKind.peek();
        }
        return ReferenceKind.TYPE_USAGE;
    }

    private void acceptChild(ASTNode node) {
        if (node != null) {
            node.accept((ASTVisitor)this);
        }
    }

    private void acceptChildren(List<?> nodes) {
        if (nodes != null) {
            for (Object node : nodes) {
                if (!(node instanceof ASTNode)) continue;
                this.acceptChild((ASTNode)node);
            }
        }
    }
}

