/*
 * Decompiled with CFR 0.152.
 */
package com.sourcetrail;

import com.sourcetrail.AccessKind;
import com.sourcetrail.AstVisitorClient;
import com.sourcetrail.DefinitionKind;
import com.sourcetrail.FileContent;
import com.sourcetrail.QualifierVisitor;
import com.sourcetrail.Range;
import com.sourcetrail.ReferenceKind;
import com.sourcetrail.SymbolKind;
import com.sourcetrail.Utility;
import com.sourcetrail.name.DeclName;
import com.sourcetrail.name.FileName;
import com.sourcetrail.name.NameHierarchy;
import com.sourcetrail.name.SymbolName;
import com.sourcetrail.name.TypeName;
import com.sourcetrail.name.resolver.BindingNameResolver;
import com.sourcetrail.name.resolver.DeclNameResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public abstract class AstVisitor
extends ASTVisitor {
    protected AstVisitorClient m_client = null;
    private File m_filePath;
    private FileContent m_fileContent = null;
    private CompilationUnit m_compilationUnit;
    private Stack<List<SymbolName>> m_contextStack = new Stack();

    public AstVisitor(AstVisitorClient client, File filePath, String fileContent, CompilationUnit compilationUnit) {
        this.m_client = client;
        this.m_filePath = filePath;
        this.m_fileContent = new FileContent(fileContent);
        this.m_compilationUnit = compilationUnit;
        this.m_contextStack.push(Arrays.asList(new FileName(filePath)));
    }

    protected abstract ReferenceKind getTypeReferenceKind();

    public boolean visit(PackageDeclaration node) {
        Name name = node.getName();
        Range range = this.getRange((ASTNode)name);
        if (name instanceof QualifiedName) {
            range = this.getRange((ASTNode)((QualifiedName)name).getName());
        }
        this.m_client.recordSymbolWithLocation(DeclNameResolver.getQualifiedName(name).toNameHierarchy(), SymbolKind.PACKAGE, range, AccessKind.NONE, DefinitionKind.EXPLICIT);
        while (name instanceof QualifiedName) {
            name = ((QualifiedName)name).getQualifier();
            this.m_client.recordSymbol(DeclNameResolver.getQualifiedName(name).toNameHierarchy(), SymbolKind.PACKAGE, AccessKind.NONE, DefinitionKind.EXPLICIT);
        }
        return true;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        this.recordAbstractTypeDeclaration((AbstractTypeDeclaration)node, SymbolKind.ANNOTATION);
        return true;
    }

    public void endVisit(AnnotationTypeDeclaration node) {
        this.m_contextStack.pop();
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        DeclName symbolName = BindingNameResolver.getQualifiedName(node.resolveBinding(), this.m_filePath, this.m_compilationUnit).orElse(DeclName.unsolved());
        this.m_client.recordSymbolWithLocation(symbolName.toNameHierarchy(), SymbolKind.FIELD, this.getRange((ASTNode)node.getName()), AccessKind.fromModifiers(node.getModifiers()), DefinitionKind.EXPLICIT);
        this.m_contextStack.push(Arrays.asList(symbolName));
        return true;
    }

    public void endVisit(AnnotationTypeMemberDeclaration node) {
        this.m_contextStack.pop();
    }

    public boolean visit(TypeDeclaration node) {
        this.recordAbstractTypeDeclaration((AbstractTypeDeclaration)node, node.isInterface() ? SymbolKind.INTERFACE : SymbolKind.CLASS);
        return true;
    }

    public void endVisit(TypeDeclaration node) {
        this.m_contextStack.pop();
    }

    public boolean visit(RecordDeclaration node) {
        this.recordAbstractTypeDeclaration((AbstractTypeDeclaration)node, SymbolKind.RECORD);
        return true;
    }

    public void endVisit(RecordDeclaration node) {
        this.m_contextStack.pop();
    }

    public boolean visit(TypeParameter node) {
        DeclName symbolName = BindingNameResolver.getQualifiedName(node.resolveBinding(), this.m_filePath, this.m_compilationUnit).map(tn -> tn.toDeclName()).orElse(DeclName.unsolved());
        this.m_client.recordSymbolWithLocation(symbolName.toNameHierarchy(), SymbolKind.TYPE_PARAMETER, this.getRange((ASTNode)node.getName()), AccessKind.TYPE_PARAMETER, DefinitionKind.EXPLICIT);
        this.m_contextStack.push(Arrays.asList(symbolName));
        return true;
    }

    public void endVisit(TypeParameter node) {
        this.m_contextStack.pop();
    }

    public boolean visit(EnumDeclaration node) {
        this.recordAbstractTypeDeclaration((AbstractTypeDeclaration)node, SymbolKind.ENUM);
        return true;
    }

    public void endVisit(EnumDeclaration node) {
        this.m_contextStack.pop();
    }

    public boolean visit(EnumConstantDeclaration node) {
        DeclName symbolName = DeclNameResolver.getQualifiedDeclName((BodyDeclaration)node, this.m_filePath, this.m_compilationUnit);
        this.m_client.recordSymbolWithLocation(symbolName.toNameHierarchy(), SymbolKind.ENUM_CONSTANT, this.getRange((ASTNode)node.getName()), AccessKind.NONE, DefinitionKind.EXPLICIT);
        this.m_contextStack.push(Arrays.asList(symbolName));
        return true;
    }

    public void endVisit(EnumConstantDeclaration node) {
        this.m_contextStack.pop();
    }

    public boolean visit(MethodDeclaration node) {
        if (this.m_client.getInterrupted()) {
            this.m_contextStack.push(new ArrayList());
            return false;
        }
        DeclName symbolName = DeclNameResolver.getQualifiedDeclName((BodyDeclaration)node, this.m_filePath, this.m_compilationUnit);
        Range signatureRange = this.getRange((ASTNode)node);
        if (!node.thrownExceptionTypes().isEmpty()) {
            Object lastExceptionType = node.thrownExceptionTypes().get(node.thrownExceptionTypes().size() - 1);
            if (lastExceptionType instanceof ASTNode) {
                signatureRange.end = this.getRange((ASTNode)((ASTNode)lastExceptionType)).end;
            }
        } else {
            Object lastParametersType;
            signatureRange.end = this.getRange((ASTNode)node.getName()).end;
            if (!node.parameters().isEmpty() && (lastParametersType = node.parameters().get(node.parameters().size() - 1)) instanceof ASTNode) {
                signatureRange.end = this.getRange((ASTNode)((ASTNode)lastParametersType)).end;
            }
            signatureRange.end = this.m_fileContent.findStartPosition(")", signatureRange.end);
        }
        this.m_client.recordSymbolWithLocationAndScopeAndSignature(symbolName.toNameHierarchy(), SymbolKind.METHOD, this.getRange((ASTNode)node.getName()), this.getRange((ASTNode)node), signatureRange, AccessKind.fromModifiers(node.getModifiers()), DefinitionKind.EXPLICIT);
        Optional<IMethodBinding> overriddenMethod = this.getOverriddenMethod(node.resolveBinding());
        if (overriddenMethod.isPresent()) {
            IMethodBinding overriddenMethodDeclaration = overriddenMethod.get().getMethodDeclaration();
            DeclName overriddenMethodName = BindingNameResolver.getQualifiedName(overriddenMethodDeclaration, this.m_filePath, this.m_compilationUnit).orElse(DeclName.unsolved());
            if (!overriddenMethodName.getIsUnsolved()) {
                this.m_client.recordSymbol(overriddenMethodName.toNameHierarchy(), SymbolKind.METHOD, AccessKind.NONE, DefinitionKind.NONE);
            }
            this.m_client.recordReference(ReferenceKind.OVERRIDE, overriddenMethodName.toNameHierarchy(), symbolName.toNameHierarchy(), this.getRange((ASTNode)node.getName()));
        }
        this.m_contextStack.push(Arrays.asList(symbolName));
        return true;
    }

    public void endVisit(MethodDeclaration node) {
        this.m_contextStack.pop();
    }

    public boolean visit(FieldDeclaration node) {
        ArrayList<DeclName> childContext = new ArrayList<DeclName>();
        for (Object declarator : node.fragments()) {
            if (!(declarator instanceof VariableDeclarationFragment)) continue;
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)declarator;
            DeclName symbolName = DeclNameResolver.getQualifiedDeclName(fragment, this.m_filePath, this.m_compilationUnit);
            this.m_client.recordSymbolWithLocation(symbolName.toNameHierarchy(), SymbolKind.FIELD, this.getRange((ASTNode)fragment.getName()), AccessKind.fromModifiers(node.getModifiers()), DefinitionKind.EXPLICIT);
            childContext.add(symbolName);
        }
        this.m_contextStack.push(childContext);
        return true;
    }

    public void endVisit(FieldDeclaration node) {
        this.m_contextStack.pop();
    }

    public boolean visit(ImportDeclaration node) {
        Optional<DeclName> packageName;
        DeclName symbolName = DeclName.unsolved();
        IBinding binding = node.resolveBinding();
        if (binding != null && !binding.isRecovered()) {
            if (binding instanceof IPackageBinding) {
                symbolName = BindingNameResolver.getQualifiedName((IPackageBinding)binding, this.m_filePath, this.m_compilationUnit).orElse(DeclName.unsolved());
            } else if (binding instanceof ITypeBinding) {
                symbolName = BindingNameResolver.getQualifiedName((ITypeBinding)binding, this.m_filePath, this.m_compilationUnit).map(tn -> tn.toDeclName()).orElse(DeclName.unsolved());
            } else if (binding instanceof IMethodBinding) {
                symbolName = BindingNameResolver.getQualifiedName((IMethodBinding)binding, this.m_filePath, this.m_compilationUnit).orElse(DeclName.unsolved());
            } else if (binding instanceof IVariableBinding) {
                symbolName = BindingNameResolver.getQualifiedName((IVariableBinding)binding, this.m_filePath, this.m_compilationUnit);
            }
        }
        for (SymbolName context : this.m_contextStack.peek()) {
            Range range = this.getRange((ASTNode)node.getName());
            if (node.getName() instanceof QualifiedName) {
                range = this.getRange((ASTNode)((QualifiedName)node.getName()).getName());
            }
            this.m_client.recordReference(ReferenceKind.IMPORT, symbolName.toNameHierarchy(), context.toNameHierarchy(), range);
        }
        if (binding instanceof IPackageBinding && (packageName = BindingNameResolver.getQualifiedName((IPackageBinding)binding, this.m_filePath, this.m_compilationUnit)).isPresent()) {
            this.m_client.recordSymbol(packageName.get().toNameHierarchy(), SymbolKind.PACKAGE, AccessKind.NONE, DefinitionKind.NONE);
        }
        new QualifierVisitor(this.m_client, this.m_filePath, this.m_compilationUnit, true).recordQualifierOfNode(node);
        return true;
    }

    public boolean visit(SingleMemberAnnotation node) {
        return this.recordAnnotation((Annotation)node);
    }

    public boolean visit(NormalAnnotation node) {
        for (Object value : node.values()) {
            SimpleName name;
            IBinding binding;
            if (!(value instanceof MemberValuePair) || !((binding = (name = ((MemberValuePair)value).getName()).resolveBinding()) instanceof IMethodBinding)) continue;
            DeclName symbolName = BindingNameResolver.getQualifiedName((IMethodBinding)binding, this.m_filePath, this.m_compilationUnit).orElse(DeclName.unsolved());
            for (SymbolName context : this.m_contextStack.peek()) {
                this.m_client.recordReference(ReferenceKind.USAGE, symbolName.toNameHierarchy(), context.toNameHierarchy(), this.getRange((ASTNode)name));
            }
        }
        return this.recordAnnotation((Annotation)node);
    }

    public boolean visit(MarkerAnnotation node) {
        return this.recordAnnotation((Annotation)node);
    }

    private boolean recordAnnotation(Annotation node) {
        for (SymbolName context : this.m_contextStack.peek()) {
            IAnnotationBinding annotationBinding = node.resolveAnnotationBinding();
            ITypeBinding typeBinding = null;
            if (annotationBinding != null) {
                typeBinding = annotationBinding.getAnnotationType();
            }
            Range range = this.getRange((ASTNode)node.getTypeName());
            if (node.getTypeName() instanceof QualifiedName) {
                range = this.getRange((ASTNode)((QualifiedName)node.getTypeName()).getName());
            }
            this.m_client.recordReference(ReferenceKind.ANNOTATION_USAGE, BindingNameResolver.getQualifiedName(typeBinding, this.m_filePath, this.m_compilationUnit).orElse(TypeName.unsolved()).toDeclName().toNameHierarchy(), context.toNameHierarchy(), range);
        }
        return true;
    }

    public boolean visit(SimpleType node) {
        for (SymbolName context : this.m_contextStack.peek()) {
            ITypeBinding binding = node.resolveBinding();
            if (binding != null) {
                binding = binding.getTypeDeclaration();
            }
            Range range = this.getRange((ASTNode)node.getName());
            if (node.getName() instanceof QualifiedName) {
                range = this.getRange((ASTNode)((QualifiedName)node.getName()).getName());
            }
            this.m_client.recordReference(this.getTypeReferenceKind(), BindingNameResolver.getQualifiedName(binding, this.m_filePath, this.m_compilationUnit).orElse(TypeName.unsolved()).toDeclName().toNameHierarchy(), context.toNameHierarchy(), range);
        }
        new QualifierVisitor(this.m_client, this.m_filePath, this.m_compilationUnit, false).recordQualifierOfNode(node);
        return true;
    }

    public boolean visit(QualifiedType node) {
        for (SymbolName context : this.m_contextStack.peek()) {
            ITypeBinding binding = node.resolveBinding();
            if (binding != null) {
                binding = binding.getTypeDeclaration();
            }
            this.m_client.recordReference(this.getTypeReferenceKind(), BindingNameResolver.getQualifiedName(binding, this.m_filePath, this.m_compilationUnit).orElse(TypeName.unsolved()).toDeclName().toNameHierarchy(), context.toNameHierarchy(), this.getRange((ASTNode)node.getName()));
        }
        new QualifierVisitor(this.m_client, this.m_filePath, this.m_compilationUnit, false).recordQualifierOfNode(node);
        return true;
    }

    public boolean visit(NameQualifiedType node) {
        for (SymbolName context : this.m_contextStack.peek()) {
            ITypeBinding binding = node.resolveBinding();
            if (binding != null) {
                binding = binding.getTypeDeclaration();
            }
            this.m_client.recordReference(this.getTypeReferenceKind(), BindingNameResolver.getQualifiedName(binding, this.m_filePath, this.m_compilationUnit).orElse(TypeName.unsolved()).toDeclName().toNameHierarchy(), context.toNameHierarchy(), this.getRange((ASTNode)node.getName()));
        }
        new QualifierVisitor(this.m_client, this.m_filePath, this.m_compilationUnit, false).recordQualifierOfNode(node);
        return true;
    }

    public boolean visit(PrimitiveType node) {
        NameHierarchy referencedName = TypeName.fromDotSeparatedString(node.getPrimitiveTypeCode().toString()).toDeclName().toNameHierarchy();
        this.m_client.recordSymbol(referencedName, SymbolKind.BUILTIN_TYPE, AccessKind.NONE, DefinitionKind.EXPLICIT);
        for (SymbolName context : this.m_contextStack.peek()) {
            this.m_client.recordReference(this.getTypeReferenceKind(), referencedName, context.toNameHierarchy(), this.getRange((ASTNode)node));
        }
        return true;
    }

    public boolean visit(SimpleName node) {
        IVariableBinding variableBinding;
        DeclName declName;
        IBinding binding = node.resolveBinding();
        if (!(!(binding instanceof IVariableBinding) || (declName = BindingNameResolver.getQualifiedName(variableBinding = ((IVariableBinding)binding).getVariableDeclaration(), this.m_filePath, this.m_compilationUnit)).getIsUnsolved() && variableBinding.getDeclaringClass() == null && variableBinding.getName().equals("length"))) {
            if (declName.getIsLocal() || declName.getIsGlobal()) {
                this.m_client.recordLocalSymbol(declName.toNameHierarchy(), this.getRange((ASTNode)node));
            } else {
                this.m_client.recordSymbol(declName.toNameHierarchy(), SymbolKind.FIELD, AccessKind.NONE, DefinitionKind.NONE);
                for (SymbolName context : this.m_contextStack.peek()) {
                    this.m_client.recordReference(ReferenceKind.USAGE, declName.toNameHierarchy(), context.toNameHierarchy(), this.getRange((ASTNode)node));
                }
            }
        }
        return true;
    }

    public boolean visit(ParameterizedType node) {
        ITypeBinding binding = node.resolveBinding();
        if (binding != null) {
            binding = binding.getTypeDeclaration();
        }
        for (Object o : node.typeArguments()) {
            if (!(o instanceof Type)) continue;
            Type type = (Type)o;
            ITypeBinding typeBinding = type.resolveBinding();
            this.m_client.recordReference(ReferenceKind.TYPE_ARGUMENT, BindingNameResolver.getQualifiedName(typeBinding, this.m_filePath, this.m_compilationUnit).orElse(TypeName.unsolved()).toDeclName().toNameHierarchy(), BindingNameResolver.getQualifiedName(binding, this.m_filePath, this.m_compilationUnit).orElse(TypeName.unsolved()).toDeclName().toNameHierarchy(), this.getRange((ASTNode)type));
        }
        return true;
    }

    public boolean visit(QualifiedName node) {
        new QualifierVisitor(this.m_client, this.m_filePath, this.m_compilationUnit, false).recordQualifierOfNode(node);
        return true;
    }

    public boolean visit(FieldAccess node) {
        new QualifierVisitor(this.m_client, this.m_filePath, this.m_compilationUnit, false).recordQualifierOfNode(node, this.m_fileContent);
        return true;
    }

    public boolean visit(SuperFieldAccess node) {
        new QualifierVisitor(this.m_client, this.m_filePath, this.m_compilationUnit, false).recordQualifierOfNode(node, this.m_fileContent);
        return true;
    }

    public boolean visit(ThisExpression node) {
        new QualifierVisitor(this.m_client, this.m_filePath, this.m_compilationUnit, false).recordQualifierOfNode(node, this.m_fileContent);
        return true;
    }

    public boolean visit(MethodInvocation node) {
        IMethodBinding methodBinding = node.resolveMethodBinding();
        this.recordReferenceToMethodDeclaration(methodBinding, this.getRange((ASTNode)node.getName()), ReferenceKind.CALL, this.m_contextStack.peek());
        this.recordReferenceToTypeArguments(methodBinding, node.typeArguments());
        new QualifierVisitor(this.m_client, this.m_filePath, this.m_compilationUnit, false).recordQualifierOfNode(node, this.m_fileContent);
        return true;
    }

    public boolean visit(SuperMethodInvocation node) {
        IMethodBinding methodBinding = node.resolveMethodBinding();
        this.recordReferenceToMethodDeclaration(methodBinding, this.getRange((ASTNode)node.getName()), ReferenceKind.CALL, this.m_contextStack.peek());
        this.recordReferenceToTypeArguments(methodBinding, node.typeArguments());
        new QualifierVisitor(this.m_client, this.m_filePath, this.m_compilationUnit, false).recordQualifierOfNode(node, this.m_fileContent);
        return true;
    }

    public boolean visit(ConstructorInvocation node) {
        IMethodBinding methodBinding = node.resolveConstructorBinding();
        this.recordReferenceToMethodDeclaration(methodBinding, this.m_fileContent.findRange("this", this.getRange((ASTNode)node).begin), ReferenceKind.CALL, this.m_contextStack.peek());
        this.recordReferenceToTypeArguments(methodBinding, node.typeArguments());
        return true;
    }

    public boolean visit(SuperConstructorInvocation node) {
        IMethodBinding methodBinding = node.resolveConstructorBinding();
        this.recordReferenceToMethodDeclaration(methodBinding, this.m_fileContent.findRange("super", this.getRange((ASTNode)node).begin), ReferenceKind.CALL, this.m_contextStack.peek());
        this.recordReferenceToTypeArguments(methodBinding, node.typeArguments());
        return true;
    }

    public boolean visit(CreationReference node) {
        IMethodBinding methodBinding = node.resolveMethodBinding();
        this.recordReferenceToMethodDeclaration(methodBinding, this.m_fileContent.findRange("new", this.getRange((ASTNode)node).begin), ReferenceKind.USAGE, this.m_contextStack.peek());
        this.recordReferenceToTypeArguments(methodBinding, node.typeArguments());
        new QualifierVisitor(this.m_client, this.m_filePath, this.m_compilationUnit, false).recordQualifierOfNode(node);
        return true;
    }

    public boolean visit(ExpressionMethodReference node) {
        IMethodBinding methodBinding = node.resolveMethodBinding();
        this.recordReferenceToMethodDeclaration(methodBinding, this.getRange((ASTNode)node.getName()), ReferenceKind.USAGE, this.m_contextStack.peek());
        this.recordReferenceToTypeArguments(methodBinding, node.typeArguments());
        new QualifierVisitor(this.m_client, this.m_filePath, this.m_compilationUnit, false).recordQualifierOfNode(node, this.m_fileContent);
        return true;
    }

    public boolean visit(SuperMethodReference node) {
        IMethodBinding methodBinding = node.resolveMethodBinding();
        this.recordReferenceToMethodDeclaration(methodBinding, this.getRange((ASTNode)node.getName()), ReferenceKind.USAGE, this.m_contextStack.peek());
        this.recordReferenceToTypeArguments(methodBinding, node.typeArguments());
        new QualifierVisitor(this.m_client, this.m_filePath, this.m_compilationUnit, false).recordQualifierOfNode(node, this.m_fileContent);
        return true;
    }

    public boolean visit(TypeMethodReference node) {
        IMethodBinding methodBinding = node.resolveMethodBinding();
        if (methodBinding != null || node.getType() == null || !node.getType().isArrayType()) {
            this.recordReferenceToMethodDeclaration(methodBinding, this.getRange((ASTNode)node.getName()), ReferenceKind.USAGE, this.m_contextStack.peek());
            this.recordReferenceToTypeArguments(methodBinding, node.typeArguments());
            new QualifierVisitor(this.m_client, this.m_filePath, this.m_compilationUnit, false).recordQualifierOfNode(node);
        }
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (node.getAnonymousClassDeclaration() != null) {
            AnonymousClassDeclaration anonymousClassDeclaration = node.getAnonymousClassDeclaration();
            DeclName symbolName = DeclNameResolver.getQualifiedDeclName(anonymousClassDeclaration, this.m_filePath, this.m_compilationUnit);
            Range anonymousClassScope = this.getRange((ASTNode)anonymousClassDeclaration);
            this.m_client.recordSymbolWithLocationAndScope(symbolName.toNameHierarchy(), SymbolKind.CLASS, new Range(anonymousClassScope.begin, anonymousClassScope.begin), anonymousClassScope, AccessKind.NONE, DefinitionKind.EXPLICIT);
            this.recordScope(anonymousClassScope);
            this.m_contextStack.push(Arrays.asList(symbolName));
        } else {
            DeclName referencedDeclName;
            IMethodBinding constructorBinding = node.resolveConstructorBinding();
            if (constructorBinding != null) {
                constructorBinding = constructorBinding.getMethodDeclaration();
            }
            if (!(referencedDeclName = BindingNameResolver.getQualifiedName(constructorBinding, this.m_filePath, this.m_compilationUnit).orElse(DeclName.unsolved())).getIsUnsolved()) {
                this.m_client.recordSymbol(referencedDeclName.toNameHierarchy(), SymbolKind.METHOD, AccessKind.NONE, DefinitionKind.NONE);
            }
            for (SymbolName context : this.m_contextStack.peek()) {
                this.m_client.recordReference(ReferenceKind.CALL, referencedDeclName.toNameHierarchy(), context.toNameHierarchy(), this.getRange((ASTNode)node.getType()));
            }
            this.recordReferenceToTypeArguments(constructorBinding, node.typeArguments());
        }
        return true;
    }

    public void endVisit(ClassInstanceCreation node) {
        if (node.getAnonymousClassDeclaration() != null) {
            this.m_contextStack.pop();
        }
    }

    public boolean visit(Block node) {
        this.recordScope(this.getRange((ASTNode)node));
        return true;
    }

    public boolean visit(ArrayInitializer node) {
        this.recordScope(this.getRange((ASTNode)node));
        return true;
    }

    public boolean visit(SwitchStatement node) {
        Range scopeRange = this.getRange((ASTNode)node);
        scopeRange.begin = this.m_fileContent.findStartPosition("{", scopeRange.begin);
        this.recordScope(scopeRange);
        return true;
    }

    public boolean visit(LineComment node) {
        this.m_client.recordComment(this.getRange((ASTNode)node));
        return true;
    }

    public boolean visit(BlockComment node) {
        this.m_client.recordComment(this.getRange((ASTNode)node));
        return true;
    }

    public boolean visit(Javadoc node) {
        this.m_client.recordComment(this.getRange((ASTNode)node));
        return true;
    }

    private void recordAbstractTypeDeclaration(AbstractTypeDeclaration node, SymbolKind symbolKind) {
        DeclName symbolName = DeclNameResolver.getQualifiedDeclName((BodyDeclaration)node, this.m_filePath, this.m_compilationUnit);
        Range scopeRange = this.getRange((ASTNode)node);
        this.m_client.recordSymbolWithLocationAndScope(symbolName.toNameHierarchy(), symbolKind, this.getRange((ASTNode)node.getName()), scopeRange, AccessKind.fromModifiers(node.getModifiers()), DefinitionKind.EXPLICIT);
        scopeRange.begin = this.m_fileContent.findStartPosition("{", scopeRange.begin);
        this.recordScope(scopeRange);
        this.m_contextStack.push(Arrays.asList(symbolName));
    }

    private void recordReferenceToMethodDeclaration(IMethodBinding methodBinding, Range range, ReferenceKind referenceKind, List<SymbolName> contexts) {
        DeclName referencedDeclName;
        if (methodBinding != null) {
            methodBinding = methodBinding.getMethodDeclaration();
        }
        if (!(referencedDeclName = BindingNameResolver.getQualifiedName(methodBinding, this.m_filePath, this.m_compilationUnit).orElse(DeclName.unsolved())).getIsUnsolved()) {
            this.m_client.recordSymbol(referencedDeclName.toNameHierarchy(), SymbolKind.METHOD, AccessKind.NONE, DefinitionKind.NONE);
        }
        for (SymbolName context : this.m_contextStack.peek()) {
            this.m_client.recordReference(referenceKind, referencedDeclName.toNameHierarchy(), context.toNameHierarchy(), range);
        }
    }

    private void recordReferenceToTypeArguments(IMethodBinding methodBinding, List<Object> typeArguments) {
        if (!typeArguments.isEmpty()) {
            if (methodBinding != null) {
                methodBinding = methodBinding.getMethodDeclaration();
            }
            for (Object o : typeArguments) {
                if (!(o instanceof Type)) continue;
                Type type = (Type)o;
                ITypeBinding typeBinding = type.resolveBinding();
                this.m_client.recordReference(ReferenceKind.TYPE_ARGUMENT, BindingNameResolver.getQualifiedName(typeBinding, this.m_filePath, this.m_compilationUnit).orElse(TypeName.unsolved()).toDeclName().toNameHierarchy(), BindingNameResolver.getQualifiedName(methodBinding, this.m_filePath, this.m_compilationUnit).orElse(DeclName.unsolved()).toNameHierarchy(), this.getRange((ASTNode)type));
            }
        }
    }

    private void recordScope(Range range) {
        NameHierarchy nameHierarchy = DeclName.scope(this.m_filePath, range.begin).toNameHierarchy();
        this.m_client.recordLocalSymbol(nameHierarchy, new Range(range.begin, range.begin));
        this.m_client.recordLocalSymbol(nameHierarchy, new Range(range.end, range.end));
    }

    protected Range getRange(ASTNode node) {
        return Utility.getRange(node, this.m_compilationUnit);
    }

    private IPackageBinding getDeclaringPackage(IBinding binding) {
        if (binding != null) {
            IBinding parentBinding = BindingNameResolver.getParentBinding(binding);
            if (parentBinding instanceof IPackageBinding) {
                return (IPackageBinding)parentBinding;
            }
            return this.getDeclaringPackage(parentBinding);
        }
        return null;
    }

    private Optional<IMethodBinding> getOverriddenMethod(IMethodBinding method) {
        if (method != null) {
            for (ITypeBinding declaringClassAncestor : this.getAllAncestorTypes(method.getDeclaringClass())) {
                for (IMethodBinding potentiallyOverridden : declaringClassAncestor.getDeclaredMethods()) {
                    if (!method.overrides(potentiallyOverridden)) continue;
                    return Optional.of(potentiallyOverridden);
                }
            }
        }
        return Optional.empty();
    }

    private List<ITypeBinding> getAllAncestorTypes(ITypeBinding type) {
        ArrayList<ITypeBinding> allAncestorTypes = new ArrayList<ITypeBinding>();
        List<ITypeBinding> directAncestorTypes = AstVisitor.getDirectAncestorTypes(type);
        allAncestorTypes.addAll(directAncestorTypes);
        for (ITypeBinding directAncestorType : directAncestorTypes) {
            allAncestorTypes.addAll(this.getAllAncestorTypes(directAncestorType));
        }
        return allAncestorTypes;
    }

    private static List<ITypeBinding> getDirectAncestorTypes(ITypeBinding type) {
        ArrayList<ITypeBinding> ancestorTypes = new ArrayList<ITypeBinding>();
        if (type != null) {
            ITypeBinding superclass = type.getSuperclass();
            if (superclass != null) {
                ancestorTypes.add(superclass);
            }
            ancestorTypes.addAll(Arrays.asList(type.getInterfaces()));
        }
        return ancestorTypes;
    }
}

