/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery.predicates;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.jupiter.api.ClassTemplate;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.engine.discovery.predicates.IsTestFactoryMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestTemplateMethod;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;

@API(status=API.Status.INTERNAL, since="5.13")
public class TestClassPredicates {
    public final Predicate<Class<?>> isAnnotatedWithNested = testClass -> AnnotationSupport.isAnnotated((AnnotatedElement)testClass, Nested.class);
    public final Predicate<Class<?>> isAnnotatedWithClassTemplate = testClass -> AnnotationSupport.isAnnotated((AnnotatedElement)testClass, ClassTemplate.class);
    public final Predicate<Class<?>> isAnnotatedWithNestedAndValid = candidate -> this.isAnnotatedWithNested.test((Class<?>)candidate) && this.isValidNestedTestClass((Class<?>)candidate);
    public final Predicate<Class<?>> looksLikeNestedOrStandaloneTestClass = candidate -> this.isAnnotatedWithNested.test((Class<?>)candidate) || this.looksLikeIntendedTestClass((Class<?>)candidate);
    public final Predicate<Method> isTestOrTestFactoryOrTestTemplateMethod;
    private final DiscoveryIssueReporter.Condition<Class<?>> isValidNestedTestClass;
    private final DiscoveryIssueReporter.Condition<Class<?>> isValidStandaloneTestClass;

    public TestClassPredicates(DiscoveryIssueReporter issueReporter) {
        this.isTestOrTestFactoryOrTestTemplateMethod = new IsTestMethod(issueReporter).or(new IsTestFactoryMethod(issueReporter)).or(new IsTestTemplateMethod(issueReporter));
        this.isValidNestedTestClass = TestClassPredicates.isNotPrivateUnlessAbstract("@Nested", issueReporter).and(TestClassPredicates.isInner(issueReporter));
        this.isValidStandaloneTestClass = TestClassPredicates.isNotPrivateUnlessAbstract("Test", issueReporter).and(TestClassPredicates.isNotLocal(issueReporter)).and(TestClassPredicates.isNotInnerUnlessAbstract(issueReporter)).and(TestClassPredicates.isNotAnonymous(issueReporter));
    }

    public boolean looksLikeIntendedTestClass(Class<?> candidate) {
        return this.looksLikeIntendedTestClass(candidate, new HashSet());
    }

    private boolean looksLikeIntendedTestClass(Class<?> candidate, Set<Class<?>> seen) {
        if (seen.add(candidate)) {
            return this.isAnnotatedWithClassTemplate.test(candidate) || this.hasTestOrTestFactoryOrTestTemplateMethods(candidate) || this.hasNestedTests(candidate, seen);
        }
        return false;
    }

    public boolean isValidNestedTestClass(Class<?> candidate) {
        return this.isValidNestedTestClass.check(candidate) && ModifierSupport.isNotAbstract(candidate);
    }

    public boolean isValidStandaloneTestClass(Class<?> candidate) {
        return this.isValidStandaloneTestClass.check(candidate) && ModifierSupport.isNotAbstract(candidate);
    }

    private boolean hasTestOrTestFactoryOrTestTemplateMethods(Class<?> candidate) {
        return ReflectionUtils.isMethodPresent(candidate, this.isTestOrTestFactoryOrTestTemplateMethod);
    }

    private boolean hasNestedTests(Class<?> candidate, Set<Class<?>> seen) {
        boolean hasAnnotatedClass = ReflectionUtils.isNestedClassPresent(candidate, this.isAnnotatedWithNested, (ReflectionUtils.CycleErrorHandling)ReflectionUtils.CycleErrorHandling.THROW_EXCEPTION);
        if (hasAnnotatedClass) {
            return true;
        }
        return ReflectionUtils.isNestedClassPresent(candidate, it -> ReflectionUtils.isInnerClass((Class)it) && this.looksLikeIntendedTestClass((Class<?>)it, seen), (ReflectionUtils.CycleErrorHandling)ReflectionUtils.CycleErrorHandling.ABORT_VISIT);
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isNotPrivateUnlessAbstract(String prefix, DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(testClass -> ModifierSupport.isNotPrivate((Class)testClass) || ModifierSupport.isAbstract((Class)testClass), testClass -> TestClassPredicates.createIssue(prefix, testClass, "must not be private"));
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isNotLocal(DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(testClass -> !testClass.isLocalClass(), testClass -> TestClassPredicates.createIssue("Test", testClass, "must not be a local class"));
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isInner(DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(ReflectionUtils::isInnerClass, testClass -> {
            if (testClass.getEnclosingClass() == null) {
                return TestClassPredicates.createIssue("@Nested", testClass, "must not be a top-level class");
            }
            return TestClassPredicates.createIssue("@Nested", testClass, "must not be static");
        });
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isNotInnerUnlessAbstract(DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(testClass -> !ReflectionUtils.isInnerClass((Class)testClass) || ModifierSupport.isAbstract((Class)testClass), testClass -> TestClassPredicates.createIssue("Test", testClass, "must not be an inner class unless annotated with @Nested"));
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isNotAnonymous(DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(testClass -> !testClass.isAnonymousClass(), testClass -> TestClassPredicates.createIssue("Test", testClass, "must not be anonymous"));
    }

    private static DiscoveryIssue createIssue(String prefix, Class<?> testClass, String detailMessage) {
        String message = String.format("%s class '%s' %s. It will not be executed.", prefix, testClass.getName(), detailMessage);
        return DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.WARNING, (String)message).source((TestSource)ClassSource.from(testClass)).build();
    }
}

