/*
 * Decompiled with CFR 0.152.
 */
package com.sourcetrail;

import com.sourcetrail.Position;
import com.sourcetrail.Range;
import java.util.Arrays;
import java.util.List;

public class FileContent {
    private List<String> m_lines;

    public FileContent(String text) {
        this.m_lines = Arrays.asList(text.split("\\r?\\n"));
    }

    public Position findStartPosition(String s) {
        return this.findStartPosition(s, new Position(1, 1));
    }

    public Position findStartPosition(String s, Position from) {
        int startColumn = from.column() - 1;
        int column = -1;
        for (int lineIndex = from.line() - 1; lineIndex < this.m_lines.size(); ++lineIndex) {
            column = this.m_lines.get(lineIndex).indexOf(s, startColumn);
            if (column != -1) {
                return new Position(lineIndex + 1, column + 1);
            }
            startColumn = 0;
        }
        return new Position(0, 0);
    }

    public Range findRange(String s) {
        return this.findRange(s, new Position(1, 1));
    }

    public Range findRange(String s, Position from) {
        Position startPosition = this.findStartPosition(s, from);
        return new Range(startPosition, new Position(startPosition.line(), startPosition.column() + s.length() - 1));
    }
}

