/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gradle.util.internal.ArgumentsSplitter;

public class PropertiesFileHandler {
    private static final String SYSTEM_PROP_PREFIX = "systemProp.";
    private static final String JVMARGS_PROP_KEY = "org.gradle.jvmargs";
    private static final String DEBUG_PROP_KEY = "org.gradle.debug";
    private static final String DEBUG_PROP_VALUE = "true";

    public static Map<String, String> getSystemProperties(File propertiesFile) {
        if (!propertiesFile.isFile()) {
            return Collections.emptyMap();
        }
        Properties properties = PropertiesFileHandler.loadProperties(propertiesFile);
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        for (Object argument : properties.keySet()) {
            String key;
            if (!argument.toString().startsWith(SYSTEM_PROP_PREFIX) || (key = argument.toString().substring(SYSTEM_PROP_PREFIX.length())).length() <= 0) continue;
            systemProperties.put(key, properties.get(argument).toString());
        }
        return Collections.unmodifiableMap(systemProperties);
    }

    public static List<String> getJvmArgs(File propertiesFile) {
        if (!propertiesFile.isFile()) {
            return Collections.emptyList();
        }
        Properties properties = PropertiesFileHandler.loadProperties(propertiesFile);
        ArrayList<String> jvmArgs = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (JVMARGS_PROP_KEY.equals(entry.getKey())) {
                Object jvmArgsPropValue = entry.getValue();
                if (!(jvmArgsPropValue instanceof String)) continue;
                jvmArgs.addAll(ArgumentsSplitter.split((String)jvmArgsPropValue));
                continue;
            }
            if (!DEBUG_PROP_KEY.equals(entry.getKey()) || !DEBUG_PROP_VALUE.equals(entry.getValue())) continue;
            jvmArgs.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005");
        }
        return Collections.unmodifiableList(jvmArgs);
    }

    private static Properties loadProperties(File propertiesFile) {
        Properties properties = new Properties();
        try {
            FileInputStream inStream = new FileInputStream(propertiesFile);
            try {
                properties.load(inStream);
            }
            finally {
                inStream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error when loading properties file=" + propertiesFile, e);
        }
        return properties;
    }
}

