import numpy as np
import matplotlib.pyplot as plt
import astropy.units as u

from dust_extinction.averages import I05_MWAvg

fig, ax = plt.subplots()

# define the extinction model
ext_model = I05_MWAvg()

# generate the curves and plot them
x = np.arange(1.0/ext_model.x_range[1], 1.0/ext_model.x_range[0], 0.1) * u.micron

ax.plot(x,ext_model(x),label='I05_MWAvg')
ax.plot(1.0/ext_model.obsdata_x, ext_model.obsdata_axav, 'ko',
        label='obsdata')

ax.set_xlabel(r'$\lambda$ [$\mu m$]')
ax.set_ylabel(r'$A(x)/A(V)$')

ax.legend(loc='best')
plt.show()