from collections import namedtuple

__all__ = ["colors"]

ColorProp = namedtuple(
	"ColorProp",
	(
		"code",  # int
		"rgb",  # Tuple[float, float, float]
		"hsl",  # Tuple[Number, Number, Number]
		"hex",  # str
		"names",  # List[str]
	),
)


colors = [
	ColorProp(
		code=0,
		rgb=(0, 0, 0),
		hsl=(0, 0, 0),
		hex="#000000",
		names=["black", "css:black"],
	),
	ColorProp(
		code=1,
		rgb=(170, 0, 0),
		hsl=(0, 1, 0.3333333333333333),
		hex="#aa0000",
		names=["dark red 1", "Heartbeat"],
	),
	ColorProp(
		code=2,
		rgb=(0, 170, 0),
		hsl=(120, 1, 0.3333333333333333),
		hex="#00aa00",
		names=["mixed green 1", "Phosphor Green"],
	),
	ColorProp(
		code=3,
		rgb=(170, 85, 0),
		hsl=(30, 1, 0.3333333333333333),
		hex="#aa5500",
		names=["mixed orange 1", "Tijolo"],
	),
	ColorProp(
		code=4,
		rgb=(0, 0, 170),
		hsl=(240, 1, 0.3333333333333333),
		hex="#0000aa",
		names=["mixed blue 1", "Bohemian Blue"],
	),
	ColorProp(
		code=5,
		rgb=(170, 0, 170),
		hsl=(300, 1, 0.3333333333333333),
		hex="#aa00aa",
		names=["purple 1", "Purple Potion"],
	),
	ColorProp(
		code=6,
		rgb=(0, 170, 170),
		hsl=(180, 1, 0.3333333333333333),
		hex="#00aaaa",
		names=["cyan 1", "Jade Orchid"],
	),
	ColorProp(
		code=7,
		rgb=(185, 185, 185),
		hsl=(0, 0, 0.7254901960784313),
		hex="#b9b9b9",
		names=["light gray", "Covered in Platinum"],
	),
	ColorProp(
		code=8,
		rgb=(85, 85, 85),
		hsl=(0, 0, 0.3333333333333333),
		hex="#555555",
		names=["dark gray", "Stone Cold Gray"],
	),
	ColorProp(
		code=9,
		rgb=(255, 85, 85),
		hsl=(0, 1, 0.6666666666666666),
		hex="#ff5555",
		names=["light red", "Fluorescent Red"],
	),
	ColorProp(
		code=10,
		rgb=(85, 255, 85),
		hsl=(120, 1, 0.6666666666666666),
		hex="#55ff55",
		names=["light green", "Puyo Blob Green"],
	),
	ColorProp(
		code=11,
		rgb=(255, 255, 85),
		hsl=(60, 1, 0.6666666666666666),
		hex="#ffff55",
		names=["yellow", "Pīlā Yellow"],
	),
	ColorProp(
		code=12,
		rgb=(85, 85, 255),
		hsl=(240, 1, 0.6666666666666666),
		hex="#5555ff",
		names=["light blue", "Shady Neon Blue"],
	),
	ColorProp(
		code=13,
		rgb=(255, 85, 255),
		hsl=(300, 1, 0.6666666666666666),
		hex="#ff55ff",
		names=["light purple", "Ultimate Pink"],
	),
	ColorProp(
		code=14,
		rgb=(85, 255, 255),
		hsl=(180, 1, 0.6666666666666666),
		hex="#55ffff",
		names=["light cyan", "Electric Sheep"],
	),
	ColorProp(
		code=15,
		rgb=(255, 255, 255),
		hsl=(0, 0, 1),
		hex="#ffffff",
		names=["white", "css:white"],
	),
	ColorProp(
		code=16,
		rgb=(0, 0, 0),
		hsl=(0, 0, 0),
		hex="#000000",
		names=["black", "css:black"],
	),
	ColorProp(
		code=17,
		rgb=(0, 0, 95),
		hsl=(240, 1, 0.18627450980392157),
		hex="#00005f",
		names=["blue 4"],
	),
	ColorProp(
		code=18,
		rgb=(0, 0, 135),
		hsl=(240, 1, 0.2647058823529412),
		hex="#000087",
		names=["blue 3", "css:darkblue", "Midnight in Tokyo"],
	),
	ColorProp(
		code=19,
		rgb=(0, 0, 175),
		hsl=(240, 1, 0.3431372549019608),
		hex="#0000af",
		names=["blue 2"],
	),
	ColorProp(
		code=20,
		rgb=(0, 0, 215),
		hsl=(240, 1, 0.4215686274509804),
		hex="#0000d7",
		names=["blue 1", "css:mediumblue", "Bluealicious"],
	),
	ColorProp(
		code=21,
		rgb=(0, 0, 255),
		hsl=(240, 1, 0.5),
		hex="#0000ff",
		names=["blue", "css:blue"],
	),
	ColorProp(
		code=22,
		rgb=(0, 95, 0),
		hsl=(120, 1, 0.18627450980392157),
		hex="#005f00",
		names=["green 4", "css:darkgreen", "Cucumber", "Pakistan Green"],
	),
	ColorProp(
		code=23,
		rgb=(0, 95, 95),
		hsl=(180, 1, 0.18627450980392157),
		hex="#005f5f",
		names=["blue stone"],
	),
	ColorProp(
		code=24,
		rgb=(0, 95, 135),
		hsl=(197.77777777777777, 1, 0.2647058823529412),
		hex="#005f87",
		names=["orient"],
	),
	ColorProp(
		code=25,
		rgb=(0, 95, 175),
		hsl=(207.42857142857144, 1, 0.3431372549019608),
		hex="#005faf",
		names=[],
	),
	ColorProp(
		code=26,
		rgb=(0, 95, 215),
		hsl=(213.48837209302326, 1, 0.4215686274509804),
		hex="#005fd7",
		names=[],
	),
	ColorProp(
		code=27,
		rgb=(0, 95, 255),
		hsl=(217.64705882352942, 1, 0.5),
		hex="#005fff",
		names=[],
	),
	ColorProp(
		code=28,
		rgb=(0, 135, 0),
		hsl=(120, 1, 0.2647058823529412),
		hex="#008700",
		names=["green 3", "css:green", "Fine Pine"],
	),
	ColorProp(
		code=29,
		rgb=(0, 135, 95),
		hsl=(162.22222222222223, 1, 0.2647058823529412),
		hex="#00875f",
		names=["Absinthe Turquoise", "Golf Green", "Chagall Green"],
	),
	ColorProp(
		code=30,
		rgb=(0, 135, 135),
		hsl=(180, 1, 0.2647058823529412),
		hex="#008787",
		names=["css:darkcyan", "Green Moblin"],
	),
	ColorProp(
		code=31,
		rgb=(0, 135, 175),
		hsl=(193.71428571428572, 1, 0.3431372549019608),
		hex="#0087af",
		names=["Stomy Shower"],
	),
	ColorProp(
		code=32,
		rgb=(0, 135, 215),
		hsl=(202.32558139534882, 1, 0.4215686274509804),
		hex="#0087d7",
		names=[],
	),
	ColorProp(
		code=33,
		rgb=(0, 135, 255),
		hsl=(208.23529411764707, 1, 0.5),
		hex="#0087ff",
		names=["Too Blue to be True"],
	),
	ColorProp(
		code=34,
		rgb=(0, 175, 0),
		hsl=(120, 1, 0.3431372549019608),
		hex="#00af00",
		names=["green 2"],
	),
	ColorProp(
		code=35,
		rgb=(0, 175, 95),
		hsl=(152.57142857142856, 1, 0.3431372549019608),
		hex="#00af5f",
		names=[],
	),
	ColorProp(
		code=36,
		rgb=(0, 175, 135),
		hsl=(166.28571428571428, 1, 0.3431372549019608),
		hex="#00af87",
		names=[],
	),
	ColorProp(
		code=37,
		rgb=(0, 175, 175),
		hsl=(180, 1, 0.3431372549019608),
		hex="#00afaf",
		names=[],
	),
	ColorProp(
		code=38,
		rgb=(0, 175, 215),
		hsl=(191.1627906976744, 1, 0.4215686274509804),
		hex="#00afd7",
		names=[],
	),
	ColorProp(
		code=39,
		rgb=(0, 175, 255),
		hsl=(198.8235294117647, 1, 0.5),
		hex="#00afff",
		names=[],
	),
	ColorProp(
		code=40,
		rgb=(0, 215, 0),
		hsl=(120, 1, 0.4215686274509804),
		hex="#00d700",
		names=["green 1"],
	),
	ColorProp(
		code=41,
		rgb=(0, 215, 95),
		hsl=(146.51162790697674, 1, 0.4215686274509804),
		hex="#00d75f",
		names=[],
	),
	ColorProp(
		code=42,
		rgb=(0, 215, 135),
		hsl=(157.67441860465118, 1, 0.4215686274509804),
		hex="#00d787",
		names=[],
	),
	ColorProp(
		code=43,
		rgb=(0, 215, 175),
		hsl=(168.8372093023256, 1, 0.4215686274509804),
		hex="#00d7af",
		names=[],
	),
	ColorProp(
		code=44,
		rgb=(0, 215, 215),
		hsl=(180, 1, 0.4215686274509804),
		hex="#00d7d7",
		names=[],
	),
	ColorProp(
		code=45,
		rgb=(0, 215, 255),
		hsl=(189.41176470588235, 1, 0.5),
		hex="#00d7ff",
		names=[],
	),
	ColorProp(
		code=46,
		rgb=(0, 255, 0),
		hsl=(120, 1, 0.5),
		hex="#00ff00",
		names=["green", "css:lime"],
	),
	ColorProp(
		code=47,
		rgb=(0, 255, 95),
		hsl=(142.35294117647058, 1, 0.5),
		hex="#00ff5f",
		names=[],
	),
	ColorProp(
		code=48,
		rgb=(0, 255, 135),
		hsl=(151.76470588235293, 1, 0.5),
		hex="#00ff87",
		names=["css:springgreen"],
	),
	ColorProp(
		code=49,
		rgb=(0, 255, 175),
		hsl=(161.1764705882353, 1, 0.5),
		hex="#00ffaf",
		names=[],
	),
	ColorProp(
		code=50,
		rgb=(0, 255, 215),
		hsl=(170.58823529411765, 1, 0.5),
		hex="#00ffd7",
		names=[],
	),
	ColorProp(
		code=51,
		rgb=(0, 255, 255),
		hsl=(180, 1, 0.5),
		hex="#00ffff",
		names=["cyan", "css:cyan", "css:aqua"],
	),
	ColorProp(
		code=52,
		rgb=(95, 0, 0),
		hsl=(0, 1, 0.18627450980392157),
		hex="#5f0000",
		names=["red 5", "Spikey Red"],
	),
	ColorProp(
		code=53,
		rgb=(95, 0, 95),
		hsl=(300, 1, 0.18627450980392157),
		hex="#5f005f",
		names=[],
	),
	ColorProp(
		code=54,
		rgb=(95, 0, 135),
		hsl=(282.22222222222223, 1, 0.2647058823529412),
		hex="#5f0087",
		names=[],
	),
	ColorProp(
		code=55,
		rgb=(95, 0, 175),
		hsl=(272.57142857142856, 1, 0.3431372549019608),
		hex="#5f00af",
		names=[],
	),
	ColorProp(
		code=56,
		rgb=(95, 0, 215),
		hsl=(266.51162790697674, 1, 0.4215686274509804),
		hex="#5f00d7",
		names=[],
	),
	ColorProp(
		code=57,
		rgb=(95, 0, 255),
		hsl=(262.3529411764706, 1, 0.5),
		hex="#5f00ff",
		names=[],
	),
	ColorProp(
		code=58,
		rgb=(95, 95, 0),
		hsl=(60, 1, 0.18627450980392157),
		hex="#5f5f00",
		names=[],
	),
	ColorProp(
		code=59,
		rgb=(95, 95, 95),
		hsl=(0, 0, 0.37254901960784315),
		hex="#5f5f5f",
		names=["Rhine Castle", "Shades On"],
	),
	ColorProp(
		code=60,
		rgb=(95, 95, 135),
		hsl=(240, 0.17391304347826086, 0.45098039215686275),
		hex="#5f5f87",
		names=[],
	),
	ColorProp(
		code=61,
		rgb=(95, 95, 175),
		hsl=(240, 0.3333333333333333, 0.5294117647058824),
		hex="#5f5faf",
		names=[],
	),
	ColorProp(
		code=62,
		rgb=(95, 95, 215),
		hsl=(240, 0.6000000000000001, 0.607843137254902),
		hex="#5f5fd7",
		names=[],
	),
	ColorProp(
		code=63,
		rgb=(95, 95, 255),
		hsl=(240, 1, 0.6862745098039216),
		hex="#5f5fff",
		names=[],
	),
	ColorProp(
		code=64,
		rgb=(95, 135, 0),
		hsl=(77.77777777777777, 1, 0.2647058823529412),
		hex="#5f8700",
		names=[],
	),
	ColorProp(
		code=65,
		rgb=(95, 135, 95),
		hsl=(120, 0.17391304347826086, 0.45098039215686275),
		hex="#5f875f",
		names=["glade green"],
	),
	ColorProp(
		code=66,
		rgb=(95, 135, 135),
		hsl=(180, 0.17391304347826086, 0.45098039215686275),
		hex="#5f8787",
		names=[],
	),
	ColorProp(
		code=67,
		rgb=(95, 135, 175),
		hsl=(210, 0.3333333333333333, 0.5294117647058824),
		hex="#5f87af",
		names=[],
	),
	ColorProp(
		code=68,
		rgb=(95, 135, 215),
		hsl=(220, 0.6000000000000001, 0.607843137254902),
		hex="#5f87d7",
		names=[],
	),
	ColorProp(
		code=69,
		rgb=(95, 135, 255),
		hsl=(225, 1, 0.6862745098039216),
		hex="#5f87ff",
		names=[],
	),
	ColorProp(
		code=70,
		rgb=(95, 175, 0),
		hsl=(87.42857142857144, 1, 0.3431372549019608),
		hex="#5faf00",
		names=[],
	),
	ColorProp(
		code=71,
		rgb=(95, 175, 95),
		hsl=(120, 0.3333333333333333, 0.5294117647058824),
		hex="#5faf5f",
		names=[],
	),
	ColorProp(
		code=72,
		rgb=(95, 175, 135),
		hsl=(150, 0.3333333333333333, 0.5294117647058824),
		hex="#5faf87",
		names=["Verdigris Green"],
	),
	ColorProp(
		code=73,
		rgb=(95, 175, 175),
		hsl=(180, 0.3333333333333333, 0.5294117647058824),
		hex="#5fafaf",
		names=[],
	),
	ColorProp(
		code=74,
		rgb=(95, 175, 215),
		hsl=(200, 0.6000000000000001, 0.607843137254902),
		hex="#5fafd7",
		names=["tradewind"],
	),
	ColorProp(
		code=75,
		rgb=(95, 175, 255),
		hsl=(210, 1, 0.6862745098039216),
		hex="#5fafff",
		names=[],
	),
	ColorProp(
		code=76,
		rgb=(95, 215, 0),
		hsl=(93.48837209302326, 1, 0.4215686274509804),
		hex="#5fd700",
		names=[],
	),
	ColorProp(
		code=77,
		rgb=(95, 215, 95),
		hsl=(120, 0.6000000000000001, 0.607843137254902),
		hex="#5fd75f",
		names=[],
	),
	ColorProp(
		code=78,
		rgb=(95, 215, 135),
		hsl=(140, 0.6000000000000001, 0.607843137254902),
		hex="#5fd787",
		names=[],
	),
	ColorProp(
		code=79,
		rgb=(95, 215, 175),
		hsl=(160, 0.6000000000000001, 0.607843137254902),
		hex="#5fd7af",
		names=[],
	),
	ColorProp(
		code=80,
		rgb=(95, 215, 215),
		hsl=(180, 0.6000000000000001, 0.607843137254902),
		hex="#5fd7d7",
		names=[],
	),
	ColorProp(
		code=81,
		rgb=(95, 215, 255),
		hsl=(195, 1, 0.6862745098039216),
		hex="#5fd7ff",
		names=[],
	),
	ColorProp(
		code=82,
		rgb=(95, 255, 0),
		hsl=(97.6470588235294, 1, 0.5),
		hex="#5fff00",
		names=[],
	),
	ColorProp(
		code=83,
		rgb=(95, 255, 95),
		hsl=(120, 1, 0.6862745098039216),
		hex="#5fff5f",
		names=[],
	),
	ColorProp(
		code=84,
		rgb=(95, 255, 135),
		hsl=(135, 1, 0.6862745098039216),
		hex="#5fff87",
		names=[],
	),
	ColorProp(
		code=85,
		rgb=(95, 255, 175),
		hsl=(150, 1, 0.6862745098039216),
		hex="#5fffaf",
		names=[],
	),
	ColorProp(
		code=86,
		rgb=(95, 255, 215),
		hsl=(165, 1, 0.6862745098039216),
		hex="#5fffd7",
		names=[],
	),
	ColorProp(
		code=87,
		rgb=(95, 255, 255),
		hsl=(180, 1, 0.6862745098039216),
		hex="#5fffff",
		names=[],
	),
	ColorProp(
		code=88,
		rgb=(135, 0, 0),
		hsl=(0, 1, 0.2647058823529412),
		hex="#870000",
		names=["red 4", "css:darkred", "Chanticleer"],
	),
	ColorProp(
		code=89,
		rgb=(135, 0, 95),
		hsl=(317.77777777777777, 1, 0.2647058823529412),
		hex="#87005f",
		names=[],
	),
	ColorProp(
		code=90,
		rgb=(135, 0, 135),
		hsl=(300, 1, 0.2647058823529412),
		hex="#870087",
		names=["css:darkmagenta", "Mardi Gras"],
	),
	ColorProp(
		code=91,
		rgb=(135, 0, 175),
		hsl=(286.2857142857143, 1, 0.3431372549019608),
		hex="#8700af",
		names=["Shade of Violet"],
	),
	ColorProp(
		code=92,
		rgb=(135, 0, 215),
		hsl=(277.6744186046512, 1, 0.4215686274509804),
		hex="#8700d7",
		names=[],
	),
	ColorProp(
		code=93,
		rgb=(135, 0, 255),
		hsl=(271.7647058823529, 1, 0.5),
		hex="#8700ff",
		names=["electric violet"],
	),
	ColorProp(
		code=94,
		rgb=(135, 95, 0),
		hsl=(42.22222222222222, 1, 0.2647058823529412),
		hex="#875f00",
		names=["Rat Brown"],
	),
	ColorProp(
		code=95,
		rgb=(135, 95, 95),
		hsl=(0, 0.17391304347826086, 0.45098039215686275),
		hex="#875f5f",
		names=["Rabbit Paws"],
	),
	ColorProp(
		code=96,
		rgb=(135, 95, 135),
		hsl=(300, 0.17391304347826086, 0.45098039215686275),
		hex="#875f87",
		names=[],
	),
	ColorProp(
		code=97,
		rgb=(135, 95, 175),
		hsl=(270, 0.3333333333333333, 0.5294117647058824),
		hex="#875faf",
		names=[],
	),
	ColorProp(
		code=98,
		rgb=(135, 95, 215),
		hsl=(260, 0.6000000000000001, 0.607843137254902),
		hex="#875fd7",
		names=[],
	),
	ColorProp(
		code=99,
		rgb=(135, 95, 255),
		hsl=(255, 1, 0.6862745098039216),
		hex="#875fff",
		names=[],
	),
	ColorProp(
		code=100,
		rgb=(135, 135, 0),
		hsl=(60, 1, 0.2647058823529412),
		hex="#878700",
		names=["css:olive"],
	),
	ColorProp(
		code=101,
		rgb=(135, 135, 95),
		hsl=(60, 0.17391304347826086, 0.45098039215686275),
		hex="#87875f",
		names=["clay creek"],
	),
	ColorProp(
		code=102,
		rgb=(135, 135, 135),
		hsl=(0, 0, 0.5294117647058824),
		hex="#878787",
		names=[],
	),
	ColorProp(
		code=103,
		rgb=(135, 135, 175),
		hsl=(240, 0.2, 0.607843137254902),
		hex="#8787af",
		names=[],
	),
	ColorProp(
		code=104,
		rgb=(135, 135, 215),
		hsl=(240, 0.5000000000000001, 0.6862745098039216),
		hex="#8787d7",
		names=[],
	),
	ColorProp(
		code=105,
		rgb=(135, 135, 255),
		hsl=(240, 1, 0.7647058823529411),
		hex="#8787ff",
		names=[],
	),
	ColorProp(
		code=106,
		rgb=(135, 175, 0),
		hsl=(73.71428571428572, 1, 0.3431372549019608),
		hex="#87af00",
		names=[],
	),
	ColorProp(
		code=107,
		rgb=(135, 175, 95),
		hsl=(90, 0.3333333333333333, 0.5294117647058824),
		hex="#87af5f",
		names=[],
	),
	ColorProp(
		code=108,
		rgb=(135, 175, 135),
		hsl=(120, 0.2, 0.607843137254902),
		hex="#87af87",
		names=[],
	),
	ColorProp(
		code=109,
		rgb=(135, 175, 175),
		hsl=(180, 0.2, 0.607843137254902),
		hex="#87afaf",
		names=[],
	),
	ColorProp(
		code=110,
		rgb=(135, 175, 215),
		hsl=(210, 0.5000000000000001, 0.6862745098039216),
		hex="#87afd7",
		names=[],
	),
	ColorProp(
		code=111,
		rgb=(135, 175, 255),
		hsl=(220, 1, 0.7647058823529411),
		hex="#87afff",
		names=[],
	),
	ColorProp(
		code=112,
		rgb=(135, 215, 0),
		hsl=(82.32558139534883, 1, 0.4215686274509804),
		hex="#87d700",
		names=[],
	),
	ColorProp(
		code=113,
		rgb=(135, 215, 95),
		hsl=(100, 0.6000000000000001, 0.607843137254902),
		hex="#87d75f",
		names=[],
	),
	ColorProp(
		code=114,
		rgb=(135, 215, 135),
		hsl=(120, 0.5000000000000001, 0.6862745098039216),
		hex="#87d787",
		names=[],
	),
	ColorProp(
		code=115,
		rgb=(135, 215, 175),
		hsl=(150, 0.5000000000000001, 0.6862745098039216),
		hex="#87d7af",
		names=[],
	),
	ColorProp(
		code=116,
		rgb=(135, 215, 215),
		hsl=(180, 0.5000000000000001, 0.6862745098039216),
		hex="#87d7d7",
		names=["Island Oasis"],
	),
	ColorProp(
		code=117,
		rgb=(135, 215, 255),
		hsl=(200, 1, 0.7647058823529411),
		hex="#87d7ff",
		names=["css:lightskyblue"],
	),
	ColorProp(
		code=118,
		rgb=(135, 255, 0),
		hsl=(88.23529411764707, 1, 0.5),
		hex="#87ff00",
		names=["css:chartreuse", "Lasting Lime"],
	),
	ColorProp(
		code=119,
		rgb=(135, 255, 95),
		hsl=(105, 1, 0.6862745098039216),
		hex="#87ff5f",
		names=[],
	),
	ColorProp(
		code=120,
		rgb=(135, 255, 135),
		hsl=(120, 1, 0.7647058823529411),
		hex="#87ff87",
		names=[],
	),
	ColorProp(
		code=121,
		rgb=(135, 255, 175),
		hsl=(140, 1, 0.7647058823529411),
		hex="#87ffaf",
		names=[],
	),
	ColorProp(
		code=122,
		rgb=(135, 255, 215),
		hsl=(160, 1, 0.7647058823529411),
		hex="#87ffd7",
		names=["css:aquamarine"],
	),
	ColorProp(
		code=123,
		rgb=(135, 255, 255),
		hsl=(180, 1, 0.7647058823529411),
		hex="#87ffff",
		names=["Glitter Shower"],
	),
	ColorProp(
		code=124,
		rgb=(175, 0, 0),
		hsl=(0, 1, 0.3431372549019608),
		hex="#af0000",
		names=["red 3", "bright red"],
	),
	ColorProp(
		code=125,
		rgb=(175, 0, 95),
		hsl=(327.42857142857144, 1, 0.3431372549019608),
		hex="#af005f",
		names=[],
	),
	ColorProp(
		code=126,
		rgb=(175, 0, 135),
		hsl=(313.7142857142857, 1, 0.3431372549019608),
		hex="#af0087",
		names=[],
	),
	ColorProp(
		code=127,
		rgb=(175, 0, 175),
		hsl=(300, 1, 0.3431372549019608),
		hex="#af00af",
		names=[],
	),
	ColorProp(
		code=128,
		rgb=(175, 0, 215),
		hsl=(288.83720930232556, 1, 0.4215686274509804),
		hex="#af00d7",
		names=[],
	),
	ColorProp(
		code=129,
		rgb=(175, 0, 255),
		hsl=(281.1764705882353, 1, 0.5),
		hex="#af00ff",
		names=[],
	),
	ColorProp(
		code=130,
		rgb=(175, 95, 0),
		hsl=(32.57142857142857, 1, 0.3431372549019608),
		hex="#af5f00",
		names=["Orange Brown"],
	),
	ColorProp(
		code=131,
		rgb=(175, 95, 95),
		hsl=(0, 0.3333333333333333, 0.5294117647058824),
		hex="#af5f5f",
		names=["Italian Villa", "Poppy Prose", "Sienna Red"],
	),
	ColorProp(
		code=132,
		rgb=(175, 95, 135),
		hsl=(330, 0.3333333333333333, 0.5294117647058824),
		hex="#af5f87",
		names=[],
	),
	ColorProp(
		code=133,
		rgb=(175, 95, 175),
		hsl=(300, 0.3333333333333333, 0.5294117647058824),
		hex="#af5faf",
		names=[],
	),
	ColorProp(
		code=134,
		rgb=(175, 95, 215),
		hsl=(280, 0.6000000000000001, 0.607843137254902),
		hex="#af5fd7",
		names=[],
	),
	ColorProp(
		code=135,
		rgb=(175, 95, 255),
		hsl=(270, 1, 0.6862745098039216),
		hex="#af5fff",
		names=[],
	),
	ColorProp(
		code=136,
		rgb=(175, 135, 0),
		hsl=(46.285714285714285, 1, 0.3431372549019608),
		hex="#af8700",
		names=[],
	),
	ColorProp(
		code=137,
		rgb=(175, 135, 95),
		hsl=(30, 0.3333333333333333, 0.5294117647058824),
		hex="#af875f",
		names=["Clay Ochre", "Roman Coin", "Light Oak Brown"],
	),
	ColorProp(
		code=138,
		rgb=(175, 135, 135),
		hsl=(0, 0.2, 0.607843137254902),
		hex="#af8787",
		names=[],
	),
	ColorProp(
		code=139,
		rgb=(175, 135, 175),
		hsl=(300, 0.2, 0.607843137254902),
		hex="#af87af",
		names=[],
	),
	ColorProp(
		code=140,
		rgb=(175, 135, 215),
		hsl=(270, 0.5000000000000001, 0.6862745098039216),
		hex="#af87d7",
		names=[],
	),
	ColorProp(
		code=141,
		rgb=(175, 135, 255),
		hsl=(260, 1, 0.7647058823529411),
		hex="#af87ff",
		names=[],
	),
	ColorProp(
		code=142,
		rgb=(175, 175, 0),
		hsl=(60, 1, 0.3431372549019608),
		hex="#afaf00",
		names=[],
	),
	ColorProp(
		code=143,
		rgb=(175, 175, 95),
		hsl=(60, 0.3333333333333333, 0.5294117647058824),
		hex="#afaf5f",
		names=["Palm"],
	),
	ColorProp(
		code=144,
		rgb=(175, 175, 135),
		hsl=(60, 0.2, 0.607843137254902),
		hex="#afaf87",
		names=["Lively Ivy", "Wall Green"],
	),
	ColorProp(
		code=145,
		rgb=(175, 175, 175),
		hsl=(0, 0, 0.6862745098039216),
		hex="#afafaf",
		names=["silver chalice", "Smoke Screen"],
	),
	ColorProp(
		code=146,
		rgb=(175, 175, 215),
		hsl=(240, 0.3333333333333334, 0.7647058823529411),
		hex="#afafd7",
		names=[],
	),
	ColorProp(
		code=147,
		rgb=(175, 175, 255),
		hsl=(240, 1, 0.8431372549019608),
		hex="#afafff",
		names=[],
	),
	ColorProp(
		code=148,
		rgb=(175, 215, 0),
		hsl=(71.16279069767441, 1, 0.4215686274509804),
		hex="#afd700",
		names=["King Lime"],
	),
	ColorProp(
		code=149,
		rgb=(175, 215, 95),
		hsl=(80.00000000000001, 0.6000000000000001, 0.607843137254902),
		hex="#afd75f",
		names=[],
	),
	ColorProp(
		code=150,
		rgb=(175, 215, 135),
		hsl=(90, 0.5000000000000001, 0.6862745098039216),
		hex="#afd787",
		names=[],
	),
	ColorProp(
		code=151,
		rgb=(175, 215, 175),
		hsl=(120, 0.3333333333333334, 0.7647058823529411),
		hex="#afd7af",
		names=[],
	),
	ColorProp(
		code=152,
		rgb=(175, 215, 215),
		hsl=(180, 0.3333333333333334, 0.7647058823529411),
		hex="#afd7d7",
		names=["Rivers Edge"],
	),
	ColorProp(
		code=153,
		rgb=(175, 215, 255),
		hsl=(210, 1, 0.8431372549019608),
		hex="#afd7ff",
		names=[],
	),
	ColorProp(
		code=154,
		rgb=(175, 255, 0),
		hsl=(78.82352941176471, 1, 0.5),
		hex="#afff00",
		names=["Lime Acid"],
	),
	ColorProp(
		code=155,
		rgb=(175, 255, 95),
		hsl=(90, 1, 0.6862745098039216),
		hex="#afff5f",
		names=[],
	),
	ColorProp(
		code=156,
		rgb=(175, 255, 135),
		hsl=(100, 1, 0.7647058823529411),
		hex="#afff87",
		names=[],
	),
	ColorProp(
		code=157,
		rgb=(175, 255, 175),
		hsl=(120, 1, 0.8431372549019608),
		hex="#afffaf",
		names=[],
	),
	ColorProp(
		code=158,
		rgb=(175, 255, 215),
		hsl=(150, 1, 0.8431372549019608),
		hex="#afffd7",
		names=["Mintastic"],
	),
	ColorProp(
		code=159,
		rgb=(175, 255, 255),
		hsl=(180, 1, 0.8431372549019608),
		hex="#afffff",
		names=["Celeste", "Frostbite", "Italian Sky Blue"],
	),
	ColorProp(
		code=160,
		rgb=(215, 0, 0),
		hsl=(0, 1, 0.4215686274509804),
		hex="#d70000",
		names=["red 2", "Rosso Corsa", "Hot Fever"],
	),
	ColorProp(
		code=161,
		rgb=(215, 0, 95),
		hsl=(333.48837209302326, 1, 0.4215686274509804),
		hex="#d7005f",
		names=[],
	),
	ColorProp(
		code=162,
		rgb=(215, 0, 135),
		hsl=(322.3255813953488, 1, 0.4215686274509804),
		hex="#d70087",
		names=[],
	),
	ColorProp(
		code=163,
		rgb=(215, 0, 175),
		hsl=(311.16279069767444, 1, 0.4215686274509804),
		hex="#d700af",
		names=[],
	),
	ColorProp(
		code=164,
		rgb=(215, 0, 215),
		hsl=(300, 1, 0.4215686274509804),
		hex="#d700d7",
		names=[],
	),
	ColorProp(
		code=165,
		rgb=(215, 0, 255),
		hsl=(290.5882352941176, 1, 0.5),
		hex="#d700ff",
		names=[],
	),
	ColorProp(
		code=166,
		rgb=(215, 95, 0),
		hsl=(26.511627906976745, 1, 0.4215686274509804),
		hex="#d75f00",
		names=[],
	),
	ColorProp(
		code=167,
		rgb=(215, 95, 95),
		hsl=(0, 0.6000000000000001, 0.607843137254902),
		hex="#d75f5f",
		names=["Spiced Coral", "Deep Sea Coral", "Roman"],
	),
	ColorProp(
		code=168,
		rgb=(215, 95, 135),
		hsl=(340, 0.6000000000000001, 0.607843137254902),
		hex="#d75f87",
		names=[],
	),
	ColorProp(
		code=169,
		rgb=(215, 95, 175),
		hsl=(320, 0.6000000000000001, 0.607843137254902),
		hex="#d75faf",
		names=[],
	),
	ColorProp(
		code=170,
		rgb=(215, 95, 215),
		hsl=(300, 0.6000000000000001, 0.607843137254902),
		hex="#d75fd7",
		names=[],
	),
	ColorProp(
		code=171,
		rgb=(215, 95, 255),
		hsl=(285, 1, 0.6862745098039216),
		hex="#d75fff",
		names=[],
	),
	ColorProp(
		code=172,
		rgb=(215, 135, 0),
		hsl=(37.674418604651166, 1, 0.4215686274509804),
		hex="#d78700",
		names=[],
	),
	ColorProp(
		code=173,
		rgb=(215, 135, 95),
		hsl=(20, 0.6000000000000001, 0.607843137254902),
		hex="#d7875f",
		names=[],
	),
	ColorProp(
		code=174,
		rgb=(215, 135, 135),
		hsl=(0, 0.5000000000000001, 0.6862745098039216),
		hex="#d78787",
		names=["Peaches of Immortality", "Copperfield"],
	),
	ColorProp(
		code=175,
		rgb=(215, 135, 175),
		hsl=(330, 0.5000000000000001, 0.6862745098039216),
		hex="#d787af",
		names=[],
	),
	ColorProp(
		code=176,
		rgb=(215, 135, 215),
		hsl=(300, 0.5000000000000001, 0.6862745098039216),
		hex="#d787d7",
		names=[],
	),
	ColorProp(
		code=177,
		rgb=(215, 135, 255),
		hsl=(280, 1, 0.7647058823529411),
		hex="#d787ff",
		names=[],
	),
	ColorProp(
		code=178,
		rgb=(215, 175, 0),
		hsl=(48.83720930232558, 1, 0.4215686274509804),
		hex="#d7af00",
		names=["Palomino Gold"],
	),
	ColorProp(
		code=179,
		rgb=(215, 175, 95),
		hsl=(40, 0.6000000000000001, 0.607843137254902),
		hex="#d7af5f",
		names=["Sell Gold", "Butterscotch Bliss", "Equator"],
	),
	ColorProp(
		code=180,
		rgb=(215, 175, 135),
		hsl=(30, 0.5000000000000001, 0.6862745098039216),
		hex="#d7af87",
		names=["css:tan", "Santa Fe Tan", "Calico", "Caramel Cloud"],
	),
	ColorProp(
		code=181,
		rgb=(215, 175, 175),
		hsl=(0, 0.3333333333333334, 0.7647058823529411),
		hex="#d7afaf",
		names=["Mary Rose"],
	),
	ColorProp(
		code=182,
		rgb=(215, 175, 215),
		hsl=(300, 0.3333333333333334, 0.7647058823529411),
		hex="#d7afd7",
		names=[],
	),
	ColorProp(
		code=183,
		rgb=(215, 175, 255),
		hsl=(270, 1, 0.8431372549019608),
		hex="#d7afff",
		names=[],
	),
	ColorProp(
		code=184,
		rgb=(215, 215, 0),
		hsl=(60, 1, 0.4215686274509804),
		hex="#d7d700",
		names=[],
	),
	ColorProp(
		code=185,
		rgb=(215, 215, 95),
		hsl=(60, 0.6000000000000001, 0.607843137254902),
		hex="#d7d75f",
		names=[],
	),
	ColorProp(
		code=186,
		rgb=(215, 215, 135),
		hsl=(60, 0.5000000000000001, 0.6862745098039216),
		hex="#d7d787",
		names=[],
	),
	ColorProp(
		code=187,
		rgb=(215, 215, 175),
		hsl=(60, 0.3333333333333334, 0.7647058823529411),
		hex="#d7d7af",
		names=["Green Mesh"],
	),
	ColorProp(
		code=188,
		rgb=(215, 215, 215),
		hsl=(0, 0, 0.8431372549019608),
		hex="#d7d7d7",
		names=["gray 3"],
	),
	ColorProp(
		code=189,
		rgb=(215, 215, 255),
		hsl=(240, 1, 0.9215686274509804),
		hex="#d7d7ff",
		names=[],
	),
	ColorProp(
		code=190,
		rgb=(215, 255, 0),
		hsl=(69.41176470588235, 1, 0.5),
		hex="#d7ff00",
		names=[],
	),
	ColorProp(
		code=191,
		rgb=(215, 255, 95),
		hsl=(75, 1, 0.6862745098039216),
		hex="#d7ff5f",
		names=[],
	),
	ColorProp(
		code=192,
		rgb=(215, 255, 135),
		hsl=(80.00000000000001, 1, 0.7647058823529411),
		hex="#d7ff87",
		names=[],
	),
	ColorProp(
		code=193,
		rgb=(215, 255, 175),
		hsl=(90, 1, 0.8431372549019608),
		hex="#d7ffaf",
		names=[],
	),
	ColorProp(
		code=194,
		rgb=(215, 255, 215),
		hsl=(120, 1, 0.9215686274509804),
		hex="#d7ffd7",
		names=["snowy mint"],
	),
	ColorProp(
		code=195,
		rgb=(215, 255, 255),
		hsl=(180, 1, 0.9215686274509804),
		hex="#d7ffff",
		names=["css:lightcyan", "Refreshing Primer"],
	),
	ColorProp(
		code=196,
		rgb=(255, 0, 0),
		hsl=(0, 1, 0.5),
		hex="#ff0000",
		names=["red", "css:red"],
	),
	ColorProp(
		code=197,
		rgb=(255, 0, 95),
		hsl=(337.6470588235294, 1, 0.5),
		hex="#ff005f",
		names=["Flaming Hot Flamingoes"],
	),
	ColorProp(
		code=198,
		rgb=(255, 0, 135),
		hsl=(328.2352941176471, 1, 0.5),
		hex="#ff0087",
		names=["Fancy Fuchsia"],
	),
	ColorProp(
		code=199,
		rgb=(255, 0, 175),
		hsl=(318.8235294117647, 1, 0.5),
		hex="#ff00af",
		names=["Mean Girls Lipstick"],
	),
	ColorProp(
		code=200,
		rgb=(255, 0, 215),
		hsl=(309.4117647058824, 1, 0.5),
		hex="#ff00d7",
		names=[],
	),
	ColorProp(
		code=201,
		rgb=(255, 0, 255),
		hsl=(300, 1, 0.5),
		hex="#ff00ff",
		names=["css:fuchsia", "css:magenta"],
	),
	ColorProp(
		code=202,
		rgb=(255, 95, 0),
		hsl=(22.352941176470587, 1, 0.5),
		hex="#ff5f00",
		names=["Vivid Orange"],
	),
	ColorProp(
		code=203,
		rgb=(255, 95, 95),
		hsl=(0, 1, 0.6862745098039216),
		hex="#ff5f5f",
		names=[],
	),
	ColorProp(
		code=204,
		rgb=(255, 95, 135),
		hsl=(345, 1, 0.6862745098039216),
		hex="#ff5f87",
		names=[],
	),
	ColorProp(
		code=205,
		rgb=(255, 95, 175),
		hsl=(330, 1, 0.6862745098039216),
		hex="#ff5faf",
		names=[],
	),
	ColorProp(
		code=206,
		rgb=(255, 95, 215),
		hsl=(315, 1, 0.6862745098039216),
		hex="#ff5fd7",
		names=[],
	),
	ColorProp(
		code=207,
		rgb=(255, 95, 255),
		hsl=(300, 1, 0.6862745098039216),
		hex="#ff5fff",
		names=[],
	),
	ColorProp(
		code=208,
		rgb=(255, 135, 0),
		hsl=(31.764705882352942, 1, 0.5),
		hex="#ff8700",
		names=["css:darkorange", "Mandarin Jelly"],
	),
	ColorProp(
		code=209,
		rgb=(255, 135, 95),
		hsl=(15, 1, 0.6862745098039216),
		hex="#ff875f",
		names=[],
	),
	ColorProp(
		code=210,
		rgb=(255, 135, 135),
		hsl=(0, 1, 0.7647058823529411),
		hex="#ff8787",
		names=["geraldine"],
	),
	ColorProp(
		code=211,
		rgb=(255, 135, 175),
		hsl=(340, 1, 0.7647058823529411),
		hex="#ff87af",
		names=[],
	),
	ColorProp(
		code=212,
		rgb=(255, 135, 215),
		hsl=(320, 1, 0.7647058823529411),
		hex="#ff87d7",
		names=["Pink Delight"],
	),
	ColorProp(
		code=213,
		rgb=(255, 135, 255),
		hsl=(300, 1, 0.7647058823529411),
		hex="#ff87ff",
		names=["Darling Bud"],
	),
	ColorProp(
		code=214,
		rgb=(255, 175, 0),
		hsl=(41.1764705882353, 1, 0.5),
		hex="#ffaf00",
		names=["css:orange", "Gold Fusion"],
	),
	ColorProp(
		code=215,
		rgb=(255, 175, 95),
		hsl=(30, 1, 0.6862745098039216),
		hex="#ffaf5f",
		names=["Vintage Orange"],
	),
	ColorProp(
		code=216,
		rgb=(255, 175, 135),
		hsl=(20, 1, 0.7647058823529411),
		hex="#ffaf87",
		names=["Spice Pink"],
	),
	ColorProp(
		code=217,
		rgb=(255, 175, 175),
		hsl=(0, 1, 0.8431372549019608),
		hex="#ffafaf",
		names=["cornflower lilac"],
	),
	ColorProp(
		code=218,
		rgb=(255, 175, 215),
		hsl=(330, 1, 0.8431372549019608),
		hex="#ffafd7",
		names=[],
	),
	ColorProp(
		code=219,
		rgb=(255, 175, 255),
		hsl=(300, 1, 0.8431372549019608),
		hex="#ffafff",
		names=[],
	),
	ColorProp(
		code=220,
		rgb=(255, 215, 0),
		hsl=(50.588235294117645, 1, 0.5),
		hex="#ffd700",
		names=["css:gold"],
	),
	ColorProp(
		code=221,
		rgb=(255, 215, 95),
		hsl=(45, 1, 0.6862745098039216),
		hex="#ffd75f",
		names=["dandelion"],
	),
	ColorProp(
		code=222,
		rgb=(255, 215, 135),
		hsl=(40, 1, 0.7647058823529411),
		hex="#ffd787",
		names=["Workout Routine"],
	),
	ColorProp(
		code=223,
		rgb=(255, 215, 175),
		hsl=(30, 1, 0.8431372549019608),
		hex="#ffd7af",
		names=["css:navajowhite", "light apricot"],
	),
	ColorProp(
		code=224,
		rgb=(255, 215, 215),
		hsl=(0, 1, 0.9215686274509804),
		hex="#ffd7d7",
		names=["cosmos"],
	),
	ColorProp(
		code=225,
		rgb=(255, 215, 255),
		hsl=(300, 1, 0.9215686274509804),
		hex="#ffd7ff",
		names=[],
	),
	ColorProp(
		code=226,
		rgb=(255, 255, 0),
		hsl=(60, 1, 0.5),
		hex="#ffff00",
		names=["css:yellow"],
	),
	ColorProp(
		code=227,
		rgb=(255, 255, 95),
		hsl=(60, 1, 0.6862745098039216),
		hex="#ffff5f",
		names=[],
	),
	ColorProp(
		code=228,
		rgb=(255, 255, 135),
		hsl=(60, 1, 0.7647058823529411),
		hex="#ffff87",
		names=["Cinque Foil"],
	),
	ColorProp(
		code=229,
		rgb=(255, 255, 175),
		hsl=(60, 1, 0.8431372549019608),
		hex="#ffffaf",
		names=["portafino"],
	),
	ColorProp(
		code=230,
		rgb=(255, 255, 215),
		hsl=(60, 1, 0.9215686274509804),
		hex="#ffffd7",
		names=["css:cornsilk", "cumulus"],
	),
	ColorProp(
		code=231,
		rgb=(255, 255, 255),
		hsl=(0, 0, 1),
		hex="#ffffff",
		names=["white", "css:white"],
	),
	ColorProp(
		code=232,
		rgb=(8, 8, 8),
		hsl=(0, 0, 0.03137254901960784),
		hex="#080808",
		names=["gray 24", "cod gray", "Reversed Grey"],
	),
	ColorProp(
		code=233,
		rgb=(18, 18, 18),
		hsl=(0, 0, 0.07058823529411765),
		hex="#121212",
		names=["gray 23", "Dark Tone Ink"],
	),
	ColorProp(
		code=234,
		rgb=(28, 28, 28),
		hsl=(0, 0, 0.10980392156862745),
		hex="#1c1c1c",
		names=["gray 22", "Eerie Black"],
	),
	ColorProp(
		code=235,
		rgb=(38, 38, 38),
		hsl=(0, 0, 0.14901960784313725),
		hex="#262626",
		names=["gray 21", "Nero"],
	),
	ColorProp(
		code=236,
		rgb=(48, 48, 48),
		hsl=(0, 0, 0.18823529411764706),
		hex="#303030",
		names=["gray 20", "mine shaft"],
	),
	ColorProp(
		code=237,
		rgb=(58, 58, 58),
		hsl=(0, 0, 0.22745098039215686),
		hex="#3a3a3a",
		names=["gray 19", "Dead Pixel"],
	),
	ColorProp(
		code=238,
		rgb=(68, 68, 68),
		hsl=(0, 0, 0.26666666666666666),
		hex="#444444",
		names=["gray 18", "Goshawk Grey"],
	),
	ColorProp(
		code=239,
		rgb=(78, 78, 78),
		hsl=(0, 0, 0.3058823529411765),
		hex="#4e4e4e",
		names=["gray 17", "Black Oak"],
	),
	ColorProp(
		code=240,
		rgb=(88, 88, 88),
		hsl=(0, 0, 0.34509803921568627),
		hex="#585858",
		names=["gray 16", "Shadow Mountain"],
	),
	ColorProp(
		code=241,
		rgb=(98, 98, 98),
		hsl=(0, 0, 0.3843137254901961),
		hex="#626262",
		names=["gray 15"],
	),
	ColorProp(
		code=242,
		rgb=(108, 108, 108),
		hsl=(0, 0, 0.4235294117647059),
		hex="#6c6c6c",
		names=["gray 14", "css:dimgray", "dove gray"],
	),
	ColorProp(
		code=243,
		rgb=(118, 118, 118),
		hsl=(0, 0, 0.4627450980392157),
		hex="#767676",
		names=["gray 13", "Steel Wool", "Sonic Silver"],
	),
	ColorProp(
		code=244,
		rgb=(128, 128, 128),
		hsl=(0, 0, 0.5019607843137255),
		hex="#808080",
		names=["gray 12", "css:gray", "css:grey"],
	),
	ColorProp(
		code=245,
		rgb=(138, 138, 138),
		hsl=(0, 0, 0.5411764705882353),
		hex="#8a8a8a",
		names=["gray 11"],
	),
	ColorProp(
		code=246,
		rgb=(148, 148, 148),
		hsl=(0, 0, 0.5803921568627451),
		hex="#949494",
		names=["gray 10"],
	),
	ColorProp(
		code=247,
		rgb=(158, 158, 158),
		hsl=(0, 0, 0.6196078431372549),
		hex="#9e9e9e",
		names=["gray 9"],
	),
	ColorProp(
		code=248,
		rgb=(168, 168, 168),
		hsl=(0, 0, 0.6588235294117647),
		hex="#a8a8a8",
		names=["gray 8", "css:darkgrey"],
	),
	ColorProp(
		code=249,
		rgb=(178, 178, 178),
		hsl=(0, 0, 0.6980392156862745),
		hex="#b2b2b2",
		names=["gray 7"],
	),
	ColorProp(
		code=250,
		rgb=(188, 188, 188),
		hsl=(0, 0, 0.7372549019607844),
		hex="#bcbcbc",
		names=["gray 6", "css:silver", "Dust to Dust"],
	),
	ColorProp(
		code=251,
		rgb=(198, 198, 198),
		hsl=(0, 0, 0.7764705882352941),
		hex="#c6c6c6",
		names=["gray 5", "Silver Polish"],
	),
	ColorProp(
		code=252,
		rgb=(208, 208, 208),
		hsl=(0, 0, 0.8156862745098039),
		hex="#d0d0d0",
		names=["gray 4", "css:lightgray", "Ancestral Water"],
	),
	ColorProp(
		code=253,
		rgb=(218, 218, 218),
		hsl=(0, 0, 0.8549019607843137),
		hex="#dadada",
		names=["gray 2", "css:gainsboro", "alto"],
	),
	ColorProp(
		code=254,
		rgb=(228, 228, 228),
		hsl=(0, 0, 0.8941176470588236),
		hex="#e4e4e4",
		names=["gray 1", "mercury"],
	),
	ColorProp(
		code=255,
		rgb=(238, 238, 238),
		hsl=(0, 0, 0.9333333333333333),
		hex="#eeeeee",
		names=["gray 0", "gallery"],
	),
]
