#!/usr/bin/bash
# Test suite for java examples.
#
# Copyright (C) 2004-2017 Alan W. Irwin
# Copyright (C) 2004 Andrew Ross
#
# This file is part of PLplot.
#
# PLplot is free software; you can redistribute it and/or modify
# it under the terms of the GNU Library General Public License as published
# by the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# PLplot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public License
# along with PLplot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

# This is called from plplot-test.sh with $javadir, $device, $dsuffix,
# $options, and possibly $verbose_test defined.

# N.B. $PLPLOT_CLASSPATH must be defined properly so it includes a
# reference to plplot.jar. If not we assume in installation location.
# The path must point to the java command for this to work.

# To build the java examples before running this script do the following:
# pushd $javadir; make; popd

# Do the standard non-interactive examples.
#
# Set up option to point to java bindings jar file and wrapper if needed.
lang="j"
if [ -n "$PLPLOT_JAVA_WRAP_DIR" ]; then
    JAVA_TEST_OPTS="-Dplplot.libdir=$PLPLOT_JAVA_WRAP_DIR"
fi
if [ -z "$PLPLOT_CLASSPATH" ] ; then
    PLPLOT_CLASSPATH="/usr/share/java"/plplot.jar
fi
if [ "" != "1" ]; then
    PLPLOT_CLASSPATH="${javadir}:${PLPLOT_CLASSPATH}"
fi

for index in 00 01 02 03 04 05 06 07 08 09 10 11 12 13 15 16 18 19 20 21 22 23 24 25 26 27 28 30 31 33 ${critical_examples} ; do
    if [ "$verbose_test" ] ; then
	echo "x${index}"
    fi
    if [ "$index" = "14" ] ; then
	echo "${OUTPUT_DIR}"/x${index}a${lang}%n.$dsuffix | \
	java -classpath "${PLPLOT_CLASSPATH}" "${JAVA_TEST_OPTS}" plplot.examples.x${index} -dev $device -o "${OUTPUT_DIR}"/x${index}${lang}%n.$dsuffix \
	     $options 2> java_${device}_test.error >| "${OUTPUT_DIR}"/x${index}${lang}_${dsuffix}.txt
	status_code=$?
    else
	java -classpath "${PLPLOT_CLASSPATH}" "${JAVA_TEST_OPTS}" plplot.examples.x${index} -dev $device -o "${OUTPUT_DIR}"/x${index}${lang}%n.$dsuffix \
	     $options 2> java_${device}_test.error >| "${OUTPUT_DIR}"/x${index}${lang}_${dsuffix}.txt
	status_code=$?
    fi
    cat java_${device}_test.error
    if [ "$status_code" -ne 0 ] ; then
	exit $status_code
    fi
  # Look for any PLPLOT ERROR messages from plwarn that do not result in an
  # exit code.
    is_error=`grep -l 'PLPLOT ERROR' java_${device}_test.error`
    if [ -n "$is_error" ] ; then
	exit 1
    fi
done
