/*
 * Decompiled with CFR 0.152.
 */
package net.schmunk.ui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.FilteredImageSource;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.schmunk.gfx.filter.DarkFilter;

public class PlusMinus
extends JPanel {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int PLUS = 2000;
    public static final int MINUS = 2001;
    private static final Insets NO_MARGIN = new Insets(0, 0, 0, 0);
    private static final Color FW_COLOR = new Color(173, 173, 173);
    private static final Color UFW_COLOR = new Color(204, 204, 204);
    private final BasicStroke BORDER_STROKE = new BasicStroke(1.0f, 2, 0);
    private static ImageIcon plusIcon_ = new ImageIcon(PlusMinus.class.getResource("resources/plusbutton.png"));
    private static ImageIcon minusIcon_ = new ImageIcon(PlusMinus.class.getResource("resources/minusbutton.png"));
    private final Object lock_ = new Object();
    private final int axis_;
    private WidgetButton plusButton_;
    private WidgetButton minusButton_;
    private Action plusAction_;
    private Action minusAction_;
    private boolean plusEnabled_;
    private boolean minusEnabled_;

    public PlusMinus() {
        this(0, null);
    }

    public PlusMinus(int axis, String name) {
        this.axis_ = axis;
        this.setLayout(new BoxLayout(this, axis));
        this.setOpaque(false);
        this.setName(name);
        super.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.plusAction_ = new WidgetAction("Add", 2000);
        this.minusAction_ = new WidgetAction("Delete", 2001);
        this.plusButton_ = new WidgetButton(this.plusAction_, plusIcon_);
        this.minusButton_ = new WidgetButton(this.minusAction_, minusIcon_);
        if (axis == 0) {
            this.add(this.plusButton_);
            this.add(Box.createHorizontalStrut(1));
            this.add(this.minusButton_);
        } else {
            this.add(this.plusButton_);
            this.add(Box.createVerticalStrut(1));
            this.add(this.minusButton_);
        }
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.plusAction_.setEnabled(this.plusEnabled_);
            this.plusAction_.setEnabled(this.minusEnabled_);
        } else {
            this.plusAction_.setEnabled(false);
            this.plusAction_.setEnabled(false);
        }
    }

    @Override
    public final void setBorder(Border b) {
    }

    public boolean isButtonEnabled(int buttonID) {
        switch (buttonID) {
            case 2000: {
                return this.plusEnabled_;
            }
            case 2001: {
                return this.minusEnabled_;
            }
        }
        throw new IllegalArgumentException("Invalid icon ID.");
    }

    public void setPlusEnabled(boolean enabled) {
        this.setButtonEnabled(2000, enabled);
    }

    public void setMinusEnabled(boolean enabled) {
        this.setButtonEnabled(2001, enabled);
    }

    public void setButtonEnabled(int buttonID, boolean enabled) {
        switch (buttonID) {
            case 2000: {
                this.plusEnabled_ = enabled;
                this.plusAction_.setEnabled(this.plusEnabled_);
                break;
            }
            case 2001: {
                this.minusEnabled_ = enabled;
                this.minusAction_.setEnabled(this.minusEnabled_);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid icon ID.");
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle r1 = this.getBounds();
        Rectangle r2 = this.minusButton_.getBounds();
        Window window = SwingUtilities.getWindowAncestor(this);
        boolean windowHasFocus = window != null && window.isFocused();
        Color scolor = windowHasFocus ? FW_COLOR : UFW_COLOR;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(scolor);
        g2d.setStroke(this.BORDER_STROKE);
        Rectangle2D.Double r3 = new Rectangle2D.Double(0.5, 0.5, r1.width - 1, r1.height - 1);
        g2d.draw(r3);
        Path2D.Double path = new Path2D.Double();
        if (this.axis_ == 0) {
            path.moveTo((double)r2.x - 0.5, 0.0);
            path.lineTo((double)r2.x - 0.5, r1.height + 1);
        } else {
            path.moveTo(0.0, (double)r2.y - 0.5);
            path.lineTo(r2.width + 1, (double)r2.y - 0.5);
        }
        g2d.draw(path);
        g2d.dispose();
        super.paintComponent(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList.add(ActionListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList.remove(ActionListener.class, l);
        }
    }

    private void fireAction(int iconID) {
        ActionEvent e;
        switch (iconID) {
            case 2000: {
                e = new ActionEvent(this, 2000, "plus");
                break;
            }
            case 2001: {
                e = new ActionEvent(this, 2001, "minus");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid icon ID.");
            }
        }
        ActionListener[] listeners = (ActionListener[])this.listenerList.getListeners(ActionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].actionPerformed(e);
        }
    }

    private class WidgetButton
    extends JButton {
        private final ImageIcon icon_;
        private final ImageIcon armedIcon_;

        WidgetButton(Action action, ImageIcon icon) {
            this.icon_ = icon;
            this.setAction(action);
            this.setText(null);
            this.setOpaque(false);
            this.setMargin(NO_MARGIN);
            this.setContentAreaFilled(false);
            this.setRolloverEnabled(true);
            this.setBorderPainted(false);
            Toolkit tk = Toolkit.getDefaultToolkit();
            Image armedImage = tk.createImage(new FilteredImageSource(icon.getImage().getSource(), new DarkFilter(67)));
            this.armedIcon_ = new ImageIcon(armedImage);
            Dimension d = new Dimension(icon.getIconWidth() / 2, icon.getIconHeight() / 2);
            this.setPreferredSize(d);
            this.setMinimumSize(d);
            this.setMaximumSize(d);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            ImageIcon icon = this.icon_;
            if (this.getModel().isArmed()) {
                icon = this.armedIcon_;
            } else if (!this.isEnabled()) {
                g2d.setComposite(AlphaComposite.getInstance(3, 0.2f));
            }
            g2d.scale(0.5, 0.5);
            icon.paintIcon(PlusMinus.this, g2d, 0, 0);
            g2d.dispose();
        }
    }

    class WidgetAction
    extends AbstractAction {
        private final int actionID_;

        WidgetAction(String name, int id) {
            super(name);
            this.actionID_ = id;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlusMinus.this.fireAction(this.actionID_);
        }
    }
}

