/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.treetable;

import gov.nasa.giss.ui.event.TreeTableEvent;
import gov.nasa.giss.ui.event.TreeTableListener;
import gov.nasa.giss.ui.treetable.TreeTable;
import gov.nasa.giss.ui.treetable.TreeTableCellRenderer;
import gov.nasa.giss.ui.treetable.TreeTableModel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import java.lang.invoke.MethodHandles;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeTablePanel
extends JScrollPane
implements TreeTableListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final BasicStroke DSTROKE = new BasicStroke(1.75f, 2, 0);
    private final Object lock_ = new Object();
    private static Color dragColor_;
    private static Border activeBorder_;
    private final TreeTable ttable_;
    private final TreeTableModel ttModel_;
    private boolean activeBorderEnabled_;
    private int dragOverRow_ = -1;
    private DragMode dragOverMode_ = DragMode.BEFORE;

    public TreeTablePanel(TreeTableModel model) {
        if (PlatformUtils.isMacintosh()) {
            this.setOpaque(true);
        }
        this.ttModel_ = model;
        this.ttable_ = new TreeTable(model);
        this.setViewportView(this.ttable_);
        if (activeBorder_ == null) {
            dragColor_ = UIManager.getColor("Table.focusCellForeground");
            activeBorder_ = BorderFactory.createMatteBorder(2, 2, 2, 2, dragColor_);
        }
        this.ttable_.addTreeTableListener(this);
    }

    public TreeTable getTreeTable() {
        return this.ttable_;
    }

    public TreeTableModel getModel() {
        return this.ttModel_;
    }

    public void toggleBorderActive(boolean active) {
        this.activeBorderEnabled_ = active;
        this.repaint();
    }

    public void setDragHighlight(int row, DragMode mode) {
        this.dragOverRow_ = row;
        this.dragOverMode_ = mode;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        JViewport jv;
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.dragOverRow_ > -1 && this.dragOverMode_ != DragMode.NONE) {
            jv = this.getViewport();
            Point p1 = jv.getLocation();
            Rectangle r1 = this.ttable_.getCellRect(this.dragOverRow_, 0, false);
            int x = p1.x + r1.x;
            int y1 = p1.y + r1.y;
            int y2 = p1.y + r1.y + r1.height;
            int w = r1.width;
            g2d.setColor(dragColor_);
            g2d.setStroke(DSTROKE);
            if (this.dragOverMode_ == DragMode.BEFORE || this.dragOverMode_ == DragMode.AFTER) {
                TreeTableCellRenderer ttcr = (TreeTableCellRenderer)this.ttable_.getColumnModel().getColumn(0).getCellRenderer();
                TreeTableNode node = this.ttModel_.getNodeForRow(this.dragOverRow_);
                int dx = ttcr.getDisclosureX(this.ttable_, node, null);
                int ix = ttcr.getIconX(this.ttable_, node, null);
                int xx = (dx + ix) / 2;
                if (this.dragOverMode_ == DragMode.BEFORE) {
                    g2d.drawLine(x + xx, y1, w, y1);
                } else {
                    g2d.drawLine(x + xx, y2, w, y2);
                }
            } else if (this.dragOverMode_ == DragMode.ONTO) {
                RoundRectangle2D.Float r2d = new RoundRectangle2D.Float(x, y1, r1.width - 1, r1.height, 0.3f * (float)r1.height, 0.3f * (float)r1.height);
                g2d.draw(r2d);
            } else if (this.dragOverMode_ == DragMode.END) {
                g2d.drawLine(x, y2, w, y2);
            }
        }
        if (this.activeBorderEnabled_) {
            jv = this.getViewport();
            activeBorder_.paintBorder(jv, g2d, jv.getX(), jv.getY(), jv.getWidth(), jv.getHeight());
        }
    }

    @Override
    public void itemAdded(TreeTableEvent e) {
        this.fireItemAdded(e.getNode());
    }

    @Override
    public void itemRemoved(TreeTableEvent e) {
        this.fireItemRemoved(e.getNode());
    }

    @Override
    public void selectionMade(TreeTableEvent e) {
        Point p = e.getPoint();
        if (p != null) {
            Point vp = this.getViewport().getLocation();
            p.x = p.x - this.getTreeTable().getVisibleRect().x + vp.x;
            p.y = p.y - this.getTreeTable().getVisibleRect().y + vp.y;
        }
        this.fireSelectionMade(e.getNode(), e.getID(), p);
    }

    @Override
    public void removalRequested(TreeTableEvent e) {
        this.fireRemovalRequested(e.getNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTreeTableListener(TreeTableListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList.add(TreeTableListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTreeTableListener(TreeTableListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList.remove(TreeTableListener.class, l);
        }
    }

    protected void fireSelectionMade(TreeTableNode node, int selectionID, Point p) {
        TreeTableListener[] listeners;
        TreeTableEvent e = new TreeTableEvent(this, node, selectionID, p);
        for (TreeTableListener l : listeners = (TreeTableListener[])this.getListeners(TreeTableListener.class)) {
            l.selectionMade(e);
        }
    }

    protected void fireRemovalRequested(TreeTableNode node) {
        TreeTableListener[] listeners;
        TreeTableEvent e = new TreeTableEvent(this, node, 131, null);
        for (TreeTableListener l : listeners = (TreeTableListener[])this.getListeners(TreeTableListener.class)) {
            l.removalRequested(e);
        }
    }

    protected void fireItemAdded(TreeTableNode node) {
        TreeTableListener[] listeners;
        TreeTableEvent e = new TreeTableEvent(this, node, 111);
        for (TreeTableListener l : listeners = (TreeTableListener[])this.getListeners(TreeTableListener.class)) {
            l.itemAdded(e);
        }
    }

    protected void fireItemRemoved(TreeTableNode node) {
        TreeTableListener[] listeners;
        TreeTableEvent e = new TreeTableEvent(this, node, 112);
        for (TreeTableListener l : listeners = (TreeTableListener[])this.getListeners(TreeTableListener.class)) {
            l.itemRemoved(e);
        }
    }

    public static enum DragMode {
        NONE,
        BEFORE,
        ONTO,
        AFTER,
        END;

    }
}

