/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ColorCellRenderer
extends JComponent
implements TableCellRenderer {
    private Color sampleColor_ = Color.GRAY;

    public ColorCellRenderer() {
        this.setOpaque(false);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size = this.getSize();
        Insets ins = this.getInsets();
        int useWidth = size.width - ins.left - ins.right;
        int useHeight = size.height - ins.top - ins.bottom;
        int boxSize = Math.min(useWidth, useHeight) - 4;
        int x = (size.width - boxSize) / 2;
        int y = (size.height - boxSize) / 2;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(this.sampleColor_);
        g.fillRect(x, y, boxSize, boxSize);
        g.setColor(this.getForeground());
        g.drawRect(x, y, boxSize, boxSize);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(value instanceof Color)) {
            throw new IllegalArgumentException("Passed value is not a Color");
        }
        this.sampleColor_ = (Color)value;
        return this;
    }
}

