/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color.chooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.colorchooser.ColorSelectionModel;

class ColorChooserPreview
extends JComponent {
    private static final Color SHADOW = new Color(51, 51, 51);
    private static final Color HIGHLIGHT = new Color(153, 153, 153);
    private static final int DESIRE_SIZE = 34;
    private final ColorSelectionModel csmodel_;

    ColorChooserPreview(ColorSelectionModel csmodel) {
        this.csmodel_ = csmodel;
        Dimension size = new Dimension(34, 34);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
    }

    @Override
    public void paintComponent(Graphics g) {
        int h = this.getHeight();
        int w = this.getWidth();
        int actualSize = Math.min(Math.min(34, w), h);
        int l = w > 34 ? (w - 34) / 2 : 0;
        int t = h > 34 ? (h - 34) / 2 : 0;
        g.setColor(this.csmodel_.getSelectedColor());
        g.fillRect(l, t, actualSize, actualSize);
        g.setColor(SHADOW);
        g.drawLine(l, t, l + actualSize, t);
        g.drawLine(l, t, l, t + actualSize);
        g.setColor(HIGHLIGHT);
        g.drawLine(l + 1, t + actualSize, l + 1 + actualSize - 2, t + actualSize);
        g.drawLine(l + actualSize, t + 1, l + actualSize, t + actualSize);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }
}

