/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import gov.nasa.giss.ui.SizeVariant;
import gov.nasa.giss.ui.label.MultiLineLabel;
import gov.nasa.giss.ui.label.VerticalLabel;
import gov.nasa.giss.ui.menu.GissMenuBar;
import gov.nasa.giss.ui.plaf.EmphasizedLabelUI;
import gov.nasa.giss.ui.plaf.EmphasizedMultiLineLabelUI;
import gov.nasa.giss.ui.plaf.GissComboBoxUI;
import gov.nasa.giss.ui.tabbedpane.FolderTabbedPane;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GuiUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Font hudFont_;

    public static void attachAction(JComponent jc, AbstractAction action, String keyStroke) {
        Objects.requireNonNull(jc, "Component cannot be null.");
        InputMap im = jc.getInputMap(2);
        ActionMap am = jc.getActionMap();
        im.put(KeyStroke.getKeyStroke(keyStroke), action.getValue("Name"));
        am.put(action.getValue("Name"), action);
    }

    public static JFrame getActiveFrame() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (kfm == null) {
            return null;
        }
        Window front = kfm.getActiveWindow();
        if (front instanceof JFrame) {
            return (JFrame)front;
        }
        return null;
    }

    public static Component getPermanentFocusOwner() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (kfm == null) {
            return null;
        }
        return kfm.getPermanentFocusOwner();
    }

    public static Window getFocusedWindow() {
        Container tla;
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (kfm == null) {
            return null;
        }
        Component kfo = kfm.getPermanentFocusOwner();
        if (kfo == null) {
            kfo = kfm.getFocusOwner();
        }
        if (kfo == null) {
            return null;
        }
        if (kfo instanceof Window) {
            return (Window)kfo;
        }
        if (kfo instanceof JComponent && (tla = ((JComponent)kfo).getTopLevelAncestor()) instanceof Window) {
            return (Window)tla;
        }
        return null;
    }

    public static JFrame getParentFrame(JComponent jc) {
        Container tla = jc.getTopLevelAncestor();
        if (tla == null) {
            Component c2;
            Container c1 = jc.getParent();
            if (c1 == null) {
                return null;
            }
            if (c1 instanceof JPopupMenu && (c2 = ((JPopupMenu)c1).getInvoker()) != null && c1 instanceof JComponent) {
                tla = ((JComponent)c2).getTopLevelAncestor();
            }
        }
        if (!(tla instanceof JFrame)) {
            return null;
        }
        return (JFrame)tla;
    }

    public static Window getParentWindow(JComponent jc) {
        Container tla = jc.getTopLevelAncestor();
        if (tla == null) {
            Component c2;
            Container c1 = jc.getParent();
            if (c1 == null) {
                return null;
            }
            if (c1 instanceof JPopupMenu && (c2 = ((JPopupMenu)c1).getInvoker()) != null && c1 instanceof JComponent) {
                tla = ((JComponent)c2).getTopLevelAncestor();
            }
        }
        if (tla instanceof Window) {
            return (Window)tla;
        }
        return null;
    }

    public static boolean isParentWindowFocused(Component c) {
        Window window = SwingUtilities.getWindowAncestor(c);
        return window != null && window.isFocused();
    }

    public static void refreshFrontFrameMenuBar() {
        final JFrame front = GuiUtils.getActiveFrame();
        if (front == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JMenuBar mbar = front.getJMenuBar();
                if (mbar instanceof GissMenuBar) {
                    ((GissMenuBar)mbar).refresh();
                }
            }
        });
    }

    public static GraphicsDevice[] getScreens() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = env.getScreenDevices();
        return devices;
    }

    public static Rectangle getMainScreenBounds() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        if (gc == null) {
            return null;
        }
        return gc.getBounds();
    }

    public static Insets getMainScreenInsets() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        if (gc == null) {
            return null;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Insets ins = tk.getScreenInsets(gc);
        return ins;
    }

    public static Rectangle getActiveScreenBounds() {
        JFrame jf = GuiUtils.getActiveFrame();
        if (jf == null) {
            return GuiUtils.getMainScreenBounds();
        }
        GraphicsConfiguration gc = jf.getGraphicsConfiguration();
        return gc.getBounds();
    }

    public static Insets getActiveScreenInsets() {
        JFrame jf = GuiUtils.getActiveFrame();
        if (jf == null) {
            return GuiUtils.getMainScreenInsets();
        }
        GraphicsConfiguration gc = jf.getGraphicsConfiguration();
        if (gc == null) {
            return null;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Insets ins = tk.getScreenInsets(gc);
        return ins;
    }

    public static Rectangle getFrameScreenBounds(JFrame jf) {
        GraphicsConfiguration gc = GuiUtils.getFrameGraphicsConfiguration(jf);
        if (gc != null) {
            return gc.getBounds();
        }
        return GuiUtils.getMainScreenBounds();
    }

    public static Insets getFrameScreenInsets(JFrame jf) {
        GraphicsConfiguration gc = GuiUtils.getFrameGraphicsConfiguration(jf);
        if (gc != null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            return tk.getScreenInsets(gc);
        }
        return GuiUtils.getMainScreenInsets();
    }

    public static GraphicsConfiguration getFrameGraphicsConfiguration(JFrame jf) {
        GraphicsDevice[] devices;
        Point pp = jf.getLocation();
        if (pp == null) {
            return null;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : devices = ge.getScreenDevices()) {
            GraphicsConfiguration gc = device.getDefaultConfiguration();
            Rectangle rr = gc.getBounds();
            if (!rr.contains(pp)) continue;
            return gc;
        }
        return null;
    }

    public static int matchLabelWidths(JLabel ... labels) {
        Dimension ddx;
        int i;
        int www = 0;
        for (i = 0; i < labels.length; ++i) {
            if (labels[i] == null) continue;
            labels[i].setPreferredSize(null);
            ddx = labels[i].getPreferredSize();
            www = Math.max(www, ddx.width);
        }
        for (i = 0; i < labels.length; ++i) {
            if (labels[i] == null) continue;
            ddx = labels[i].getPreferredSize();
            ddx.width = www;
            labels[i].setPreferredSize(ddx);
            labels[i].setMinimumSize(ddx);
        }
        return www;
    }

    public static int matchComponentWidths(JComponent ... cc) {
        Dimension ddx;
        int i;
        int www = 0;
        for (i = 0; i < cc.length; ++i) {
            if (cc[i] == null) continue;
            cc[i].setPreferredSize(null);
            ddx = cc[i].getPreferredSize();
            www = Math.max(www, ddx.width);
        }
        for (i = 0; i < cc.length; ++i) {
            if (cc[i] == null) continue;
            ddx = cc[i].getPreferredSize();
            ddx.width = www;
            cc[i].setPreferredSize(ddx);
            cc[i].setMinimumSize(ddx);
        }
        return www;
    }

    public static int matchComponentWidths(Collection<? extends JComponent> cc) {
        Dimension ddx;
        int www = 0;
        for (JComponent jComponent : cc) {
            if (jComponent == null) continue;
            ddx = jComponent.getPreferredSize();
            www = Math.max(www, ddx.width);
        }
        for (JComponent jComponent : cc) {
            if (jComponent == null) continue;
            ddx = jComponent.getPreferredSize();
            ddx.width = www;
            jComponent.setPreferredSize(ddx);
            jComponent.setMinimumSize(ddx);
        }
        return www;
    }

    public static boolean applyBrushMetalLook(JFrame frame) {
        if (PlatformUtils.isMacintosh()) {
            frame.getRootPane().putClientProperty("apple.awt.brushMetalLook", Boolean.TRUE);
            frame.getRootPane().setOpaque(false);
            return true;
        }
        return false;
    }

    public static void applyHudUI(JComponent jc) {
        if (hudFont_ == null) {
            hudFont_ = UIManager.getFont("Button.font").deriveFont(1, 11.0f);
        }
        jc.setOpaque(false);
        if (jc instanceof JLabel || jc instanceof MultiLineLabel) {
            jc.setFont(hudFont_);
            jc.setForeground(Color.WHITE);
            jc.setOpaque(false);
        }
        if (jc instanceof Container) {
            for (Component c : jc.getComponents()) {
                if (!(c instanceof JComponent)) continue;
                GuiUtils.applyHudUI((JComponent)c);
            }
        }
    }

    public static void applyEmphasizedUI(JComponent jc) {
        if (jc instanceof JLabel) {
            ((JLabel)jc).setUI(new EmphasizedLabelUI());
        } else if (jc instanceof MultiLineLabel) {
            ((MultiLineLabel)jc).setUI(new EmphasizedMultiLineLabelUI());
        }
        if (jc instanceof Container) {
            for (Component c : jc.getComponents()) {
                if (!(c instanceof JComponent)) continue;
                GuiUtils.applyEmphasizedUI((JComponent)c);
            }
        }
    }

    public static void setSizeRegular(JComponent jc) {
        GuiUtils.setSizeVariant(jc, SizeVariant.REGULAR);
    }

    public static void setSizeRegular(Border border) {
        GuiUtils.setSizeVariant(border, SizeVariant.REGULAR);
    }

    public static void setSizeSmall(JComponent jc) {
        GuiUtils.setSizeVariant(jc, SizeVariant.SMALL);
    }

    public static void setSizeSmall(Border border) {
        GuiUtils.setSizeVariant(border, SizeVariant.SMALL);
    }

    public static void setSizeMini(JComponent jc) {
        GuiUtils.setSizeVariant(jc, SizeVariant.MINI);
    }

    public static void setSizeMini(Border border) {
        GuiUtils.setSizeVariant(border, SizeVariant.MINI);
    }

    public static void setSizeVariant(JComponent jc, SizeVariant size) {
        if (jc == null) {
            return;
        }
        for (Component c : jc.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            GuiUtils.setSizeVariant((JComponent)c, size);
        }
        if (PlatformUtils.isMacintosh()) {
            if (jc instanceof JSpinner) {
                JComponent jce = ((JSpinner)jc).getEditor();
                if (jce instanceof JSpinner.DefaultEditor) {
                    JFormattedTextField jtf = ((JSpinner.DefaultEditor)jce).getTextField();
                    GuiUtils.setSizeVariant(jtf, size);
                } else {
                    GuiUtils.setSizeVariant(jce, size);
                }
            } else if (jc instanceof JTable || jc instanceof JTabbedPane && !(jc instanceof FolderTabbedPane)) {
                Font f = jc.getFont();
                if (f != null) {
                    float scaling = size.getFontScaling();
                    float fsize = (float)Math.floor(scaling * (float)f.getSize());
                    jc.setFont(f.deriveFont(fsize));
                }
            } else if (jc instanceof JSeparator) {
                // empty if block
            }
            jc.putClientProperty("JComponent.sizeVariant", size.getDescription());
        }
        if (jc instanceof JComboBox || jc instanceof JTextField) {
            GuiUtils.restrictSize(jc);
        } else if (!(jc instanceof JButton)) {
            if (jc instanceof JLabel) {
                GuiUtils.restrictSize(jc);
            } else if (jc instanceof JCheckBox || jc instanceof JLabel || jc instanceof JRadioButton || jc instanceof JSpinner || jc instanceof JToggleButton || jc instanceof VerticalLabel) {
                GuiUtils.restrictSize(jc);
            }
        }
    }

    private static void setSizeVariant(Border border, SizeVariant size) {
        if (border == null) {
            return;
        }
        if (!PlatformUtils.isMacintosh()) {
            return;
        }
        if (border instanceof TitledBorder) {
            TitledBorder tb = (TitledBorder)border;
            Font f = tb.getTitleFont();
            if (f != null) {
                tb.setTitleFont(f.deriveFont((float)(f.getSize() - 2)));
            }
        } else if (border instanceof CompoundBorder) {
            CompoundBorder cb = (CompoundBorder)border;
            GuiUtils.setSizeVariant(cb.getOutsideBorder(), size);
            GuiUtils.setSizeVariant(cb.getInsideBorder(), size);
        }
    }

    public static void applyComboBoxUI(JComboBox<?> jcb, SizeVariant size) {
        jcb.setPreferredSize(null);
        GuiUtils.setSizeVariant(jcb, size);
        jcb.setUI(new GissComboBoxUI());
    }

    public static void restrictSize(JComponent jc) {
        jc.setPreferredSize(null);
        Dimension dd = jc.getPreferredSize();
        jc.setMinimumSize(dd);
        if (jc instanceof JLabel) {
            dd.width += 5;
        }
        jc.setMaximumSize(dd);
    }

    public static void reduceComponentFont(Component component, int reduction) {
        Font f;
        if (PlatformUtils.isMacintosh() && (f = component.getFont()) != null) {
            component.setFont(f.deriveFont((float)(f.getSize() - reduction)));
        }
    }

    public static void padBorder(JComponent jc, int top, int left, int bottom, int right) {
        Border innerBorder = jc.getBorder();
        Border outerBorder = BorderFactory.createEmptyBorder(top, left, bottom, right);
        jc.setBorder(new CompoundBorder(outerBorder, innerBorder));
    }

    public static CompoundBorder createPaddedTitleBorder(String s) {
        TitledBorder outerBorder = BorderFactory.createTitledBorder(s);
        Border innerBorder = BorderFactory.createEmptyBorder(8, 6, 4, 6);
        return new CompoundBorder(outerBorder, innerBorder);
    }

    public static void updateGraphicsIfDisabled(Graphics2D g2d, Component component) {
        if (!component.isEnabled()) {
            g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
    }

    public static void makeRecursiveDropTarget(Component component, DropTargetListener listener) {
        new DropTarget(component, listener);
        if (component instanceof Container) {
            for (Component c : ((Container)component).getComponents()) {
                GuiUtils.makeRecursiveDropTarget(c, listener);
            }
        }
    }

    public static Object getCutKey(ActionMap amap) {
        Action cut = TransferHandler.getCutAction();
        for (Object key : amap.allKeys()) {
            Action a = amap.get(key);
            if (a != cut) continue;
            return key;
        }
        return null;
    }

    private GuiUtils() {
    }
}

