/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time.mission;

import gov.nasa.giss.time.TimeEvent;
import gov.nasa.giss.time.TimeListener;
import gov.nasa.giss.time.mission.MissionStatus;
import gov.nasa.giss.time.planet.AbstractPlanetTime;

public abstract class MissionTime
implements TimeListener {
    protected String name_ = "";
    protected MissionStatus status_ = MissionStatus.NOT_LAUNCHED;
    protected long sol_ = Long.MIN_VALUE;
    protected double fraction_;
    protected boolean needsUpdate_ = true;

    public MissionTime() {
        this("No Name");
    }

    public MissionTime(String name) {
        this.name_ = name;
    }

    public MissionStatus getStatus() {
        if (this.needsUpdate_) {
            this.update();
        }
        return this.status_;
    }

    public long getSol() {
        if (this.needsUpdate_) {
            this.update();
        }
        return this.sol_;
    }

    public double getSolFraction() {
        if (this.needsUpdate_) {
            this.update();
        }
        return this.fraction_;
    }

    public double getSolHour() {
        if (this.needsUpdate_) {
            this.update();
        }
        return this.fraction_ * 24.0;
    }

    public abstract void setMillis(long var1);

    public abstract void setPlanetTime(AbstractPlanetTime var1);

    protected abstract void update();

    @Override
    public void timeChanged(TimeEvent e) {
        this.needsUpdate_ = true;
    }
}

