/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.JulianType;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class JDCalendar
extends GregorianCalendar {
    public static final double MJD = 2400000.5;
    public static final double JD_UNIX = 2440587.5;
    public static final double JD2000 = 2451545.0;

    public JDCalendar() {
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        gmt.setRawOffset(0);
        super.setTimeZone(gmt);
    }

    @Override
    public final void setTimeZone(TimeZone tz) {
        throw new IllegalArgumentException("Specification of time zone not permitted");
    }

    public void setJulianDate(JulianType jdType, double value) {
        double jd = value;
        switch (jdType) {
            case SIMPLE: {
                break;
            }
            case MODIFIED: 
            case MJD: {
                jd += 2400000.5;
                break;
            }
            case J2000: 
            case MJD2K: {
                jd += 2451545.0;
                break;
            }
            case UNIX: {
                jd += 2440587.5;
                break;
            }
            default: {
                throw new IllegalArgumentException("No switch case for JulianType " + jdType);
            }
        }
        double j = Math.floor(jd);
        double f = jd - j;
        f += 0.5;
        if (f >= 1.0) {
            f -= 1.0;
            j += 1.0;
        }
        double a1 = Math.floor(j / 36524.25 - 51.12264);
        double a = j + 1.0 + a1 - Math.floor(a1 / 4.0);
        double b = a + 1524.0;
        double c = Math.floor(b / 365.25 - 0.3343);
        double d = Math.floor(365.25 * c);
        double e = Math.floor((b - d) / 30.61);
        d = b - d - Math.floor(30.61 * e) + f;
        double mon = e - 1.0;
        int yr = (int)(c - 4716.0);
        if (e > 13.5) {
            mon -= 12.0;
        }
        if (mon < 2.5) {
            ++yr;
        }
        int dd = (int)d;
        d = (d - (double)dd) * 24.0;
        int hh = (int)Math.floor(d);
        d = (d - (double)hh) * 60.0;
        int mm = (int)Math.floor(d);
        d = (d - (double)mm) * 60.0;
        int ss = (int)Math.floor(d);
        this.set(yr, (int)(mon - 1.0), dd, hh, mm, ss);
        this.set(14, 0);
    }
}

