/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.text;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ConstrainedIntegerDocument
extends PlainDocument {
    private final int minimum_;
    private final int maximum_;

    public ConstrainedIntegerDocument(int min, int max) {
        this.minimum_ = min;
        this.maximum_ = max;
    }

    @Override
    public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
        if (string == null) {
            return;
        }
        String currentContent = this.getText(0, this.getLength());
        StringBuilder currentBuffer = new StringBuilder(currentContent);
        currentBuffer.insert(offset, string);
        String newContent = currentBuffer.toString();
        try {
            int newvalue = Integer.parseInt(newContent);
            if (newvalue >= this.minimum_ && newvalue <= this.maximum_) {
                super.insertString(offset, string, attributes);
                return;
            }
            Toolkit.getDefaultToolkit().beep();
        }
        catch (NumberFormatException exc) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (Exception exc) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public int getValue() {
        try {
            return Integer.parseInt(this.getText(0, this.getLength()));
        }
        catch (Exception exc) {
            return 0;
        }
    }
}

