/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.graphics.ColorTableResourceList;
import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.map.OverlayFactory;
import gov.nasa.giss.map.kml.KMLData;
import gov.nasa.giss.map.kml.KMLDataResourceList;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.panoply.Panoply;
import gov.nasa.giss.panoply.overlay.PanMaskOverlay;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanStringUtils;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanResourceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Object LOCK = new Object();
    private static final String DEFAULT_CLUT = "panoply.act";
    private static final String DEFAULT_OVERLAY = "Earth.cno";
    private static ColorTableResourceList clutSet_;
    private static OverlayResourceList overlaySet_;
    private static KMLDataResourceList kmlSet_;

    public static String getDefaultColorTableName() {
        return DEFAULT_CLUT;
    }

    public static AbstractColorTable getDefaultColorTable() {
        return PanResourceUtils.getColorTable(PanResourceUtils.getDefaultColorTableName());
    }

    public static AbstractColorTable getPreferredColorTable() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        String clutName = prefs.getString("plot:colorbar.name");
        AbstractColorTable clut = PanResourceUtils.getColorTable(clutName);
        if (clut == null) {
            return PanResourceUtils.getDefaultColorTable();
        }
        return clut;
    }

    public static AbstractColorTable getColorTable(int idx) {
        return (AbstractColorTable)PanResourceUtils.getColorTableList().getBackingObject(idx);
    }

    public static AbstractColorTable getColorTable(String name) {
        return (AbstractColorTable)PanResourceUtils.getColorTableList().getBackingObject(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorTableResourceList getColorTableList() {
        Object object = LOCK;
        synchronized (object) {
            if (clutSet_ == null) {
                LOGGER.trace("Initializing color table resource set");
                clutSet_ = new ColorTableResourceList();
                LOGGER.trace("Scanning jar");
                clutSet_.scanJarDirectory(Panoply.class, "resources/colorbars");
            }
            return clutSet_;
        }
    }

    public static String getDefaultOverlayName() {
        return DEFAULT_OVERLAY;
    }

    public static MapOverlay getDefaultOverlay() {
        return PanResourceUtils.getOverlay(PanResourceUtils.getDefaultOverlayName());
    }

    public static MapOverlay getPreferredOverlay() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        String oname = prefs.getString(PanParamKeys.P_OVERLAY_NAME[0]);
        MapOverlay overlay = PanResourceUtils.getOverlay(oname);
        if (overlay == null) {
            return PanResourceUtils.getDefaultOverlay();
        }
        return overlay;
    }

    public static MapOverlay getOverlay(int idx) {
        return (MapOverlay)PanResourceUtils.getOverlayList().getBackingObject(idx);
    }

    public static MapOverlay getOverlay(String name) {
        if (name == null || PanStringUtils.isNoneString(name)) {
            return null;
        }
        return (MapOverlay)PanResourceUtils.getOverlayList().getBackingObject(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OverlayResourceList getOverlayList() {
        Object object = LOCK;
        synchronized (object) {
            if (overlaySet_ == null) {
                OverlayFactory.registerOverlayExt("gif", PanMaskOverlay.class);
                OverlayFactory.registerOverlayExt("png", PanMaskOverlay.class);
                overlaySet_ = new OverlayResourceList();
                overlaySet_.scanJarDirectory(Panoply.class, "resources/overlays");
            }
            return overlaySet_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KMLDataResourceList getUnderlayList() {
        Object object = LOCK;
        synchronized (object) {
            if (kmlSet_ == null) {
                kmlSet_ = new KMLDataResourceList();
                kmlSet_.scanJarDirectory(Panoply.class, "resources/underlays");
            }
            return kmlSet_;
        }
    }

    public static KMLData getUnderlay(int idx) {
        return (KMLData)PanResourceUtils.getUnderlayList().getBackingObject(idx);
    }

    public static KMLData getUnderlay(String name) {
        if (name == null || PanStringUtils.isNoneString(name)) {
            return null;
        }
        if (kmlSet_ == null) {
            PanResourceUtils.getUnderlayList();
        }
        return (KMLData)kmlSet_.getBackingObject(name);
    }

    private PanResourceUtils() {
    }
}

