/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanAxisMethod implements DescribedItem
{
    SCALAR("Scalar"),
    LOG10("Log\u2081\u2080"),
    INDEX("Grid Point Index");

    private final String description_;

    private PanAxisMethod(String description) {
        this.description_ = description;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    public static PanAxisMethod matching(String str) {
        for (PanAxisMethod item : PanAxisMethod.values()) {
            if (!item.matches(str)) continue;
            return item;
        }
        return null;
    }
}

