/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.action.PanCloseAllWindowsAction;
import gov.nasa.giss.panoply.action.PanShowLoggingFrameAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanWindowAdapter;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.StatusBar;
import gov.nasa.giss.ui.menu.GissMenu;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.task.Task;
import gov.nasa.giss.util.task.TaskQueue;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanFrame
extends JFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static PanFrame dummyFrame_;
    protected StatusBar statusBar_;

    public PanFrame() {
        this((String)null);
    }

    public PanFrame(String title) {
        super(title);
        if (PlatformUtils.isMacintosh()) {
            GuiUtils.applyBrushMetalLook(this);
        }
        this.statusBar_ = new StatusBar();
        this.getContentPane().setBackground(PanGuiUtils.LIGHT_GRAY);
        PanWindowAdapter windowAdapter = PanWindowAdapter.getSharedInstance();
        this.addWindowListener(windowAdapter);
        this.addWindowFocusListener(windowAdapter);
        this.addComponentListener(windowAdapter);
        this.attachAltActions();
    }

    private void attachAltActions() {
        InputMap im = this.getRootPane().getInputMap(1);
        ActionMap am = this.getRootPane().getActionMap();
        AbstractAction a = PanCloseAllWindowsAction.getSharedInstance();
        PanGuiUtils.attachKeyStrokeAction(a, "close-all-windows", im, am);
        if (!PanUtils.isBeta()) {
            a = PanShowLoggingFrameAction.getSharedInstance();
            PanGuiUtils.attachKeyStrokeAction(a, "develop-frame", im, am);
        }
    }

    protected void placeOnScreen() {
        Rectangle rr = GuiUtils.getActiveScreenBounds();
        if (rr == null) {
            this.setLocation(25, 25);
        } else {
            Dimension psize = this.getContentPane().getPreferredSize();
            int x = (rr.width - psize.width) / 2;
            int y = (rr.height - psize.height) * 4 / 10;
            this.setLocation(rr.x + x, rr.y + y);
        }
    }

    public PanMenuBar getPanMenuBar() {
        return (PanMenuBar)this.getJMenuBar();
    }

    public void setPanMenuBar(PanMenuBar mbar) {
        super.setJMenuBar(mbar);
    }

    @Override
    public void setJMenuBar(JMenuBar mbar) {
        throw new UnsupportedOperationException("Use setPanMenuBar(PanMenuBar) instead");
    }

    public void reveal() {
        this.setState(0);
        this.toFront();
        this.setVisible(true);
    }

    protected boolean needsResizeToFitDisplay() {
        Rectangle rr = this.isVisible() ? GuiUtils.getFrameScreenBounds(this) : GuiUtils.getMainScreenBounds();
        Insets ins = this.isVisible() ? GuiUtils.getFrameScreenInsets(this) : GuiUtils.getMainScreenInsets();
        Dimension dd = this.getSize();
        int insW = Math.max(24, ins.left + ins.right);
        int insH = Math.max(24, ins.top + ins.bottom);
        int availW = rr.width - insW;
        int availH = rr.height - insH;
        int excessW = Math.max(0, dd.width - availW);
        int excessH = Math.max(0, dd.height - availH);
        return excessW > 0 || excessH > 0;
    }

    public void resizeToFitDisplay() {
    }

    public void refresh() {
        this.refreshMenuBar();
    }

    public void refreshMenuBar() {
        EventQueue.invokeLater(() -> {
            PanMenuBar mbar = this.getPanMenuBar();
            if (mbar != null) {
                mbar.refresh();
            }
        });
    }

    public void refreshMenu(String menuName) {
        EventQueue.invokeLater(() -> {
            PanMenuBar mbar = this.getPanMenuBar();
            if (mbar != null) {
                GissMenu menu = mbar.getMenuForName(menuName);
                if (menu == null) {
                    LOGGER.warn("No menu named {}", (Object)menuName);
                } else {
                    menu.refresh();
                }
            }
        });
    }

    public void close() {
    }

    public static PanFrame getActivePanFrame() {
        JFrame jf = GuiUtils.getActiveFrame();
        if (jf instanceof PanFrame) {
            return (PanFrame)jf;
        }
        return PanFrame.getDummyFrame();
    }

    private static PanFrame getDummyFrame() {
        if (dummyFrame_ == null) {
            dummyFrame_ = new PanFrame();
        }
        return dummyFrame_;
    }

    public void addTask(Task task) {
        TaskQueue.getSharedInstance().add(task);
    }

    public boolean isBusy() {
        return TaskQueue.getSharedInstance().size() > 0;
    }
}

