/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Component;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanBetaPrefsPanel
extends PanAbstractPrefsPanel {
    private PanCheckBox underlaysCB_;
    private PanCheckBox numberlaysCB_;
    private boolean refreshing_;

    public PanBetaPrefsPanel() {
        this.createLayout();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Beta Features"));
        JLabel topText = new JLabel("What beta features should be enabled?");
        JLabel restartText = new JLabel("Changing beta settings may require restart.");
        GuiUtils.setSizeSmall(restartText);
        this.underlaysCB_ = PanCheckBox.create("Enable lon-lat map plot alpha levels and underlays");
        this.numberlaysCB_ = PanCheckBox.create("Enable lon-lat map plot number layers (numberlays)");
        FlexingGridLayout fgl = new FlexingGridLayout(1, 4, 0, 2);
        this.setLayout(fgl);
        fgl.setRigidHeight(true);
        this.add((Component)topText, new FGConstraint(0, 0));
        this.add((Component)this.underlaysCB_, new FGConstraint(0, 1));
        this.add((Component)this.numberlaysCB_, new FGConstraint(0, 2));
        this.add((Component)restartText, new FGConstraint(0, 3));
        this.refreshPrivate();
    }

    private void attachListeners() {
        this.underlaysCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("beta:underlays", this.underlaysCB_.isSelected());
        });
        this.numberlaysCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("beta:numberlays", this.numberlaysCB_.isSelected());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.underlaysCB_.setSelected(prefs_.getBoolean("beta:underlays"));
        this.numberlaysCB_.setSelected(prefs_.getBoolean("beta:numberlays"));
        this.refreshing_ = false;
    }
}

