/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.panoply.data.PanDataEvent;
import gov.nasa.giss.panoply.data.PanDataListener;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanControlsPanel;
import gov.nasa.giss.panoply.ui.PanCaptionListener;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.GTextField;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorComboBox;
import gov.nasa.giss.ui.panel.PanelSection;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanStrokeControls1D
extends PanControlsPanel
implements PanDataListener,
PlotPropertyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanelSection[] section_ = new PanelSection[2];
    private JPanel[] sectionContent_ = new JPanel[2];
    private ColorComboBox[] sColorCombo_ = new ColorComboBox[2];
    private DescribedEnumComboBox[] sStyleCombo_ = new DescribedEnumComboBox[2];
    private PanIntSpinner[] sWeightSpinner_ = new PanIntSpinner[2];
    private JRadioButton[] dfltCapBtn_ = new JRadioButton[2];
    private JRadioButton[] userCapBtn_ = new JRadioButton[2];
    private GTextField[] captionTF_ = new GTextField[2];
    private FloatComboBox captionSizeCombo_;
    private boolean refreshing_;

    public PanStrokeControls1D(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("stroke-controls", pmeta, mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
        this.pmeta_.addPlotPropertyListener(this);
        this.data_.addDataListener(this);
    }

    private void createLayout() {
        this.setLayout(new BoxLayout(this, 1));
        for (int i = 0; i < 2; ++i) {
            String title = "Stroke " + (i + 1);
            this.sectionContent_[i] = this.createSection(i);
            if (i == 0) {
                this.section_[i] = new PanelSection(title, this.sectionContent_[i]);
            } else {
                this.section_[i] = new PanelSection(title, null);
                this.section_[i].setExpanded(false);
            }
            this.add(this.section_[i]);
        }
    }

    private JPanel createSection(int idx) {
        JLabel styleLabel = new JLabel("Style:\u2009");
        this.sStyleCombo_[idx] = new DescribedEnumComboBox(PanStrokePattern.class);
        this.sStyleCombo_[idx].setName(PanParamKeys.STROKE_STYLE[idx]);
        this.sStyleCombo_[idx].removeItem(PanStrokePattern.NONE);
        QuickBox row1 = QuickBox.createLeftBox(styleLabel, this.sStyleCombo_[idx]);
        JLabel colorLabel = new JLabel("Color:\u2009");
        this.sColorCombo_[idx] = new ColorComboBox();
        this.sColorCombo_[idx].setName(PanParamKeys.STROKE_COLOR[idx]);
        JLabel weightLabel = new JLabel("\u2014 Weight:\u2009");
        this.sWeightSpinner_[idx] = PanIntSpinner.smallWeightX5(PanParamKeys.STROKE_WGT[idx], this.pmeta_.getInt(PanParamKeys.STROKE_WGT[idx]), 0, 500);
        JLabel pctLabel = new JLabel("%");
        QuickBox row2 = QuickBox.createLeftBox(colorLabel, this.sColorCombo_[idx], weightLabel, this.sWeightSpinner_[idx], pctLabel);
        JLabel capLabel = new JLabel("Caption:\u2009");
        this.dfltCapBtn_[idx] = new JRadioButton("Default", !this.pmeta_.getBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[idx]));
        this.userCapBtn_[idx] = new JRadioButton("Custom:", this.pmeta_.getBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[idx]));
        this.dfltCapBtn_[idx].setName(PanParamKeys.STROKE_LABEL_CUSTOM[idx]);
        this.userCapBtn_[idx].setName(PanParamKeys.STROKE_LABEL_CUSTOM[idx]);
        ButtonGroup capChoices = new ButtonGroup();
        capChoices.add(this.dfltCapBtn_[idx]);
        capChoices.add(this.userCapBtn_[idx]);
        this.captionTF_[idx] = GTextField.create(this.pmeta_.getString(PanParamKeys.STROKE_LABEL_TEXT[idx]), 20);
        this.captionTF_[idx].setName(PanParamKeys.STROKE_LABEL_TEXT[idx]);
        QuickBox row3 = QuickBox.createLeftBox(capLabel, this.dfltCapBtn_[idx], this.userCapBtn_[idx], this.captionTF_[idx]);
        QuickBox row4 = null;
        if (idx == 0) {
            JLabel blankLabel = new JLabel(" ");
            GuiUtils.matchLabelWidths(styleLabel, colorLabel, capLabel, blankLabel);
            this.captionSizeCombo_ = FloatComboBox.create(5.0f, 24.0f);
            this.captionSizeCombo_.setName("stroke.label.size");
            this.captionSizeCombo_.setValue(this.pmeta_.getFloat("stroke.label.size"));
            row4 = QuickBox.createLeftBox(blankLabel, new JLabel("Size:\u2009"), this.captionSizeCombo_);
        } else {
            GuiUtils.matchLabelWidths(styleLabel, colorLabel, capLabel);
        }
        JPanel jp = new JPanel();
        jp.setLayout(new BoxLayout(jp, 1));
        jp.setBorder(PanGuiUtils.WINDOID_SECT_BORDER);
        jp.setOpaque(false);
        jp.add(row1);
        jp.add(Box.createVerticalStrut(1));
        jp.add(row2);
        jp.add(Box.createVerticalStrut(1));
        jp.add(row3);
        if (row4 != null) {
            jp.add(Box.createVerticalStrut(1));
            jp.add(row4);
        }
        GuiUtils.setSizeSmall(jp);
        int tfh = this.captionTF_[idx].getPreferredSize().height;
        this.captionTF_[idx].setMinimumSize(new Dimension(150, tfh));
        this.captionTF_[idx].setPreferredSize(new Dimension(225, tfh));
        this.captionTF_[idx].setMaximumSize(new Dimension(1000, tfh));
        return jp;
    }

    private void attachListeners() {
        int ii = 0;
        while (ii < 2) {
            final int i = ii++;
            this.sColorCombo_[i].addItemListener(e -> {
                Color cold;
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                int index = this.sColorCombo_[i].getSelectedIndex();
                if (index < 0 || index >= this.sColorCombo_[i].getItemCount()) {
                    return;
                }
                Color cnew = this.sColorCombo_[i].getSelectedColor();
                if (!cnew.equals(cold = this.pmeta_.getColor(PanParamKeys.STROKE_COLOR[i]))) {
                    this.pmeta_.setColor(PanParamKeys.STROKE_COLOR[i], cnew);
                }
            });
            this.sStyleCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.set(PanParamKeys.STROKE_STYLE[i], this.sStyleCombo_[i].getEnumName());
            });
            this.sWeightSpinner_[i].addChangeListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setInt(PanParamKeys.STROKE_WGT[i], this.sWeightSpinner_[i].getIntValue());
            });
            this.dfltCapBtn_[i].addActionListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[i], this.userCapBtn_[i].isSelected());
            });
            this.userCapBtn_[i].addActionListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[i], this.userCapBtn_[i].isSelected());
            });
            this.captionTF_[i].addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (PanStrokeControls1D.this.refreshing_) {
                        return;
                    }
                    if (PanStrokeControls1D.this.captionTF_[i] == null || PanStrokeControls1D.this.pmeta_ == null) {
                        return;
                    }
                    PanStrokeControls1D.this.pmeta_.setString(PanParamKeys.STROKE_LABEL_TEXT[i], PanStrokeControls1D.this.captionTF_[i].getText());
                }
            });
            this.captionTF_[i].addActionListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setString(PanParamKeys.STROKE_LABEL_TEXT[i], this.captionTF_[i].getText());
            });
            this.captionTF_[i].getDocument().addDocumentListener(new PanCaptionListener(this.captionTF_[i], this.pmeta_, PanParamKeys.STROKE_LABEL_TEXT[i]));
        }
        this.captionSizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.set("stroke.label.size", Float.valueOf(this.captionSizeCombo_.getValue()));
        });
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        PanCombinationType ctype = PanCombinationType.matching(this.pmeta_.getString("combination"));
        boolean[] enable = new boolean[]{true, false};
        if (ctype == PanCombinationType.COMPARE) {
            enable[1] = true;
        } else if (ctype == PanCombinationType.A2_ONLY) {
            enable[0] = false;
            enable[1] = true;
        }
        for (int i = 0; i < 2; ++i) {
            this.sColorCombo_[i].setEnabled(enable[i]);
            this.sStyleCombo_[i].setEnabled(enable[i]);
            this.sWeightSpinner_[i].setEnabled(enable[i]);
            this.dfltCapBtn_[i].setEnabled(enable[i]);
            this.userCapBtn_[i].setEnabled(enable[i]);
            this.captionTF_[i].setEnabled(enable[i]);
            this.sStyleCombo_[i].setSelItemMatching(this.pmeta_.getString(PanParamKeys.STROKE_STYLE[i]));
            this.sColorCombo_[i].setSelectedColor(this.pmeta_.getColor(PanParamKeys.STROKE_COLOR[i]));
            this.sWeightSpinner_[i].setValue(this.pmeta_.getInt(PanParamKeys.STROKE_WGT[i]));
            this.dfltCapBtn_[i].setSelected(!this.pmeta_.getBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[i]));
            this.userCapBtn_[i].setSelected(this.pmeta_.getBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[i]));
            this.refreshTextField(this.captionTF_[i], PanParamKeys.STROKE_LABEL_TEXT[i]);
        }
        this.refreshing_ = false;
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        boolean changeAll;
        if (e == null) {
            return;
        }
        String pname = e.getMessage();
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("combination")) {
            this.refreshPrivate();
        }
        this.repaint();
    }

    @Override
    public void dataChanged(PanDataEvent e) {
        if (e == null) {
            return;
        }
        LOGGER.trace("{}", (Object)e);
        if (e.getID() == PanDataEvent.EType.VARIABLE_CHANGED && !this.section_[1].hasContent()) {
            this.section_[1].setContent(this.sectionContent_[1]);
            this.section_[1].setExpanded(true);
            this.validate();
        }
        LOGGER.trace("done");
    }
}

