/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.panoply.action.PanInterpolateAction;
import gov.nasa.giss.panoply.action.PanLinkDimensionsAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanArraySlicePanel;
import gov.nasa.giss.panoply.plotui.PanArraySlicer;
import gov.nasa.giss.panoply.plotui.PanControlsPanel;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanLinkButton;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.menu.GissMenu;
import gov.nasa.giss.ui.panel.PanelSection;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanArrayControls
extends PanControlsPanel
implements PlotPropertyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Box topBox_;
    private PanelSection[] sboxes_ = new PanelSection[2];
    private PanArraySlicePanel[] spanels_ = new PanArraySlicePanel[2];
    private DescribedEnumComboBox combinationCombo_;
    private PanCheckBox interpolateCB_;
    private PanLinkButton linkBtn_;
    private boolean linked_;
    private boolean refreshing_;

    public PanArrayControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("array-controls", pmeta, mbar);
        this.createActions(mbar);
        this.createLayout();
        this.attachAltActions();
        this.pmeta_.addPlotPropertyListener(this);
    }

    private void createActions(PanMenuBar mbar) {
        AbstractAction a;
        GissMenu plotMenu = mbar.getMenuForName("plot-menu");
        if (this.ptype_.isColorContour()) {
            a = new PanInterpolateAction(this.pmeta_);
            this.pmeta_.putAction("interpolate", a);
            plotMenu.getItemForName("interpolate").setAction(a);
        }
        a = new PanLinkDimensionsAction(this);
        this.pmeta_.putAction("link-dimensions", a);
        plotMenu.getItemForName("link-dimensions").setAction(a);
        a.setEnabled(false);
    }

    private void attachAltActions() {
        AbstractAction a;
        String aname;
        InputMap im = this.getInputMap(2);
        ActionMap am = this.getActionMap();
        if (this.ptype_.isLinePlot() || this.ptype_.isLonLatTrajectory()) {
            aname = PanProperties.MENU_PROPS.getString("combine-compare");
            a = new AbstractAction(aname){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.trace("Combined!");
                    PanArrayControls.this.combinationCombo_.setSelectedItem(PanCombinationType.COMPARE);
                }
            };
            PanGuiUtils.attachKeyStrokeAction(a, "combine-compare", im, am);
        }
        if (this.ptype_.isColorContour()) {
            aname = PanProperties.MENU_PROPS.getString("combine-diff-12");
            a = new AbstractAction(aname){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.trace("Combined!");
                    PanArrayControls.this.combinationCombo_.setSelectedItem(PanCombinationType.A1_MINUS_A2);
                }
            };
            PanGuiUtils.attachKeyStrokeAction(a, "combine-diff-12", im, am);
        }
        if (this.ptype_.isColorContour()) {
            aname = PanProperties.MENU_PROPS.getString("combine-average");
            a = new AbstractAction(aname){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.trace("Combined!");
                    PanArrayControls.this.combinationCombo_.setSelectedItem(PanCombinationType.AVERAGE);
                }
            };
            PanGuiUtils.attachKeyStrokeAction(a, "combine-average", im, am);
        }
        if (this.ptype_.isColorContour()) {
            aname = PanProperties.MENU_PROPS.getString("combine-vectormag");
            a = new AbstractAction(aname){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.trace("Combined!");
                    PanArrayControls.this.combinationCombo_.setSelectedItem(PanCombinationType.VECTOR);
                }
            };
            PanGuiUtils.attachKeyStrokeAction(a, "combine-vectormag", im, am);
        }
    }

    private void createLayout() {
        this.topBox_ = this.createTopBox();
        this.sboxes_[0] = new PanelSection("Array 1", null);
        this.sboxes_[1] = new PanelSection("Array 2", null);
        this.addSlicePanel(0);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.topBox_);
        this.add(this.sboxes_[0]);
        this.add(this.sboxes_[1]);
    }

    private Box createTopBox() {
        Action a;
        JLabel plotLabel = new JLabel("Plot ");
        JLabel emdash1 = new JLabel(" \u2014 ");
        JLabel emdash2 = new JLabel(" \u2014 ");
        this.combinationCombo_ = new DescribedEnumComboBox(PanCombinationType.class);
        this.combinationCombo_.setName("combination");
        this.combinationCombo_.removeAllItems();
        this.combinationCombo_.addItem(PanCombinationType.A1_ONLY);
        this.combinationCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            PanCombinationType ctype = (PanCombinationType)this.combinationCombo_.getSelectedItem();
            this.pmeta_.setDataCombination(ctype.name(), null);
        });
        if (this.ptype_.isColorContour()) {
            a = this.pmeta_.getAction("interpolate");
            this.interpolateCB_ = PanCheckBox.small("interpolate", "Interpolate", a);
            this.interpolateCB_.setSelected(this.pmeta_.getBoolean("interpolate"));
            this.interpolateCB_.setToolTipText("Enable/disable interpolation");
        }
        a = this.pmeta_.getAction("link-dimensions");
        this.linkBtn_ = new PanLinkButton(a);
        QuickBox box = null;
        box = this.ptype_.isColorContour() ? QuickBox.createLeftBox(plotLabel, this.combinationCombo_, emdash1, this.interpolateCB_, emdash2, this.linkBtn_) : QuickBox.createLeftBox(plotLabel, this.combinationCombo_, emdash2, this.linkBtn_);
        box.setBorder(PanGuiUtils.WINDOID_SECT_BORDER);
        GuiUtils.setSizeSmall(box);
        plotLabel.setMinimumSize(plotLabel.getPreferredSize());
        return box;
    }

    private void addSlicePanel(int vnum) {
        LOGGER.trace("vnum {}", (Object)vnum);
        NcArray ncarray = this.data_.getArray(vnum);
        if (this.spanels_[vnum] != null) {
            this.spanels_[vnum].flush();
        }
        this.spanels_[vnum] = new PanArraySlicePanel(this.pmeta_, this.mbar_, ncarray, vnum);
        this.sboxes_[vnum].setContent(this.spanels_[vnum]);
        this.sboxes_[vnum].setExpanded(true);
        this.sboxes_[vnum].setTitle(this.spanels_[vnum].getName());
        this.validate();
        PanPlotFrame pf = this.pmeta_.getFrame();
        if (pf == null) {
            return;
        }
        PanMenuBar mbar = pf.getPanMenuBar();
        if (mbar == null) {
            return;
        }
        JMenuItem jmi = mbar.getItemForName("plot-menu", "link-dimensions");
        Action a = jmi.getAction();
        if (a != null) {
            a.setEnabled(this.canLinkDimensions());
        }
    }

    public void updateSlicePanel(int vnum) {
        LOGGER.trace("vnum {}", (Object)vnum);
        this.addSlicePanel(vnum);
        this.resetLinkedDimensions();
        int ocount = this.combinationCombo_.getItemCount();
        LOGGER.trace("count {}", (Object)ocount);
        if (ocount > 1) {
            for (int i = 1; i < ocount; ++i) {
                this.combinationCombo_.removeItemAt(1);
            }
        }
        if (this.ptype_.isLinePlot()) {
            for (PanCombinationType ct : PanCombinationType.values()) {
                NcArray ncarray1;
                NcArray ncarray0;
                if (ct == PanCombinationType.A1_ONLY || ct == PanCombinationType.VECTOR && !(ncarray0 = this.data_.getArray(0)).isCompatibleUnits(ncarray1 = this.data_.getArray(1))) continue;
                this.combinationCombo_.addItem(ct);
            }
        } else if (this.ptype_.isLonLatTrajectory()) {
            this.combinationCombo_.addItem(PanCombinationType.A2_ONLY);
            this.combinationCombo_.addItem(PanCombinationType.COMPARE);
        } else {
            for (PanCombinationType ct : PanCombinationType.values()) {
                if (ct == PanCombinationType.A1_ONLY || ct == PanCombinationType.COMPARE) continue;
                this.combinationCombo_.addItem(ct);
            }
        }
        this.combinationCombo_.setMaximumSize(this.combinationCombo_.getPreferredSize());
        if (this.ptype_.isLinePlot() || this.ptype_.isLonLatTrajectory()) {
            this.combinationCombo_.setSelectedItem(PanCombinationType.COMPARE);
        } else {
            this.combinationCombo_.setSelectedItem(PanCombinationType.A1_MINUS_A2);
        }
        this.invalidate();
        this.validate();
    }

    public void setCombinationType(PanCombinationType ctype) {
        try {
            this.combinationCombo_.setSelectedItem(ctype);
        }
        catch (Exception exc) {
            LOGGER.warn("Combination failed - {}", (Object)exc.toString());
        }
    }

    public PanArraySlicePanel getSlicePanel(int index) {
        return this.spanels_[index];
    }

    public void resetLinkedDimensions() {
        for (int vnum = 0; vnum < 2; ++vnum) {
            if (this.spanels_[vnum] == null) continue;
            for (int i = 0; i < this.spanels_[vnum].getItemCount(); ++i) {
                PanArraySlicer slicer = this.spanels_[vnum].getSlicer(i);
                if (slicer == null) continue;
                slicer.setCompanion(null);
            }
        }
        this.linkBtn_.setLinked(false);
        this.linked_ = false;
        PanPlotFrame pf = this.pmeta_.getFrame();
        if (pf == null) {
            return;
        }
        PanMenuBar mbar = pf.getPanMenuBar();
        mbar.getItemForName("plot-menu", "link-dimensions").setText(PanProperties.MENU_PROPS.getString("link-dimensions"));
    }

    public void linkDimensions() {
        if (this.spanels_[0] == null || this.spanels_[1] == null) {
            LOGGER.debug("No matching pair of dimensions because a slicer is null.");
            return;
        }
        int size0 = this.spanels_[0].getItemCount();
        int size1 = this.spanels_[1].getItemCount();
        for (int i = 0; i < size0; ++i) {
            PanArraySlicer slicer0 = this.spanels_[0].getSlicer(i);
            if (slicer0 == null || slicer0.getLength() < 2) continue;
            for (int j = 0; j < size1; ++j) {
                PanArraySlicer slicer1 = this.spanels_[1].getSlicer(j);
                if (slicer1 == null || slicer1.getLength() <= 1 || !slicer0.isSameLength(slicer1)) continue;
                this.linkDimensions(slicer0, slicer1);
                return;
            }
        }
    }

    public void linkDimensions(PanArraySlicer slicer0, PanArraySlicer slicer1) {
        this.resetLinkedDimensions();
        if (slicer0 == null || slicer1 == null) {
            return;
        }
        slicer0.setCompanion(slicer1);
        slicer1.setCompanion(slicer0);
        slicer1.setSelectedIndex(slicer0.getSelectedIndex());
        this.linkBtn_.setLinked(true);
        this.linked_ = true;
        PanPlotFrame pf = this.pmeta_.getFrame();
        if (pf == null) {
            return;
        }
        PanMenuBar mbar = pf.getPanMenuBar();
        mbar.getItemForName("plot-menu", "link-dimensions").setText(PanProperties.MENU_PROPS.getString("unlink-dimensions"));
    }

    public boolean isLinked() {
        return this.linked_;
    }

    public final boolean canLinkDimensions() {
        boolean canLink = this.getPossibleLinkCount() > 0;
        this.linkBtn_.setEnabled(canLink);
        return canLink;
    }

    public final int getPossibleLinkCount() {
        if (this.spanels_[0] == null || this.spanels_[1] == null) {
            return 0;
        }
        int size0 = this.spanels_[0].getItemCount();
        int size1 = this.spanels_[1].getItemCount();
        int count = 0;
        for (int i = 0; i < size0; ++i) {
            PanArraySlicer slicer0 = this.spanels_[0].getSlicer(i);
            if (slicer0 == null || slicer0.getLength() < 2) continue;
            for (int j = 0; j < size1; ++j) {
                PanArraySlicer slicer1 = this.spanels_[1].getSlicer(j);
                if (slicer1 == null || slicer1.getLength() <= 1 || !slicer0.isSameLength(slicer1)) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        if (this.interpolateCB_ != null) {
            boolean isInterpolated = this.pmeta_.getBoolean("interpolate");
            this.interpolateCB_.setSelected(isInterpolated);
        }
        if (this.combinationCombo_ != null) {
            // empty if block
        }
        this.refreshing_ = false;
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        if (e == null) {
            return;
        }
        String pname = e.getMessage();
        boolean changeAll = false;
        if (pname.contains("interpolate")) {
            boolean oldval = this.interpolateCB_.isSelected();
            boolean newval = this.pmeta_.getBoolean("interpolate");
            if (newval ^ oldval) {
                this.interpolateCB_.setSelected(newval);
            }
        }
    }

    @Override
    public void setSize(Dimension d) {
        LOGGER.trace("{}", (Object)d);
        super.setSize(d);
    }
}

