/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.panoply.plot.PanColorContourPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;

public class PanLatVertPlot
extends PanColorContourPlot {
    public PanLatVertPlot(PanPlotMeta pmeta) {
        super(pmeta);
    }

    @Override
    protected String getXAxisLabelStr() {
        if (this.xAxisLabelText_ != null) {
            return this.xAxisLabelText_;
        }
        return "Latitude (\u00b0N)";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object[] getXYVectorBaseAngle() {
        boolean counterclockwise;
        double baseAngleRad;
        double rBound;
        double lBound = this.pmeta_.getDouble("xaxis.begin");
        boolean northAtLeft = lBound > (rBound = this.pmeta_.getDouble("xaxis.end"));
        String dir1 = this.pmeta_.getString("vector.dir1");
        String dir2 = this.pmeta_.getString("vector.dir2");
        if (northAtLeft) {
            if (dir1.equalsIgnoreCase("North")) {
                dir1 = "Left";
            } else if (dir1.equalsIgnoreCase("South")) {
                dir1 = "Right";
            } else if (dir2.equalsIgnoreCase("North")) {
                dir2 = "Left";
            } else if (dir1.equalsIgnoreCase("South")) {
                dir2 = "Right";
            }
        } else if (dir1.equalsIgnoreCase("North")) {
            dir1 = "Right";
        } else if (dir1.equalsIgnoreCase("South")) {
            dir1 = "Left";
        } else if (dir2.equalsIgnoreCase("North")) {
            dir2 = "Right";
        } else if (dir1.equalsIgnoreCase("South")) {
            dir2 = "Left";
        }
        if (dir2.equalsIgnoreCase("Up")) {
            baseAngleRad = 0.0;
            if (dir1.equalsIgnoreCase("Right")) {
                counterclockwise = false;
                return new Object[]{baseAngleRad, counterclockwise};
            } else {
                if (!dir1.equalsIgnoreCase("Left")) return null;
                counterclockwise = true;
            }
            return new Object[]{baseAngleRad, counterclockwise};
        } else if (dir2.equalsIgnoreCase("Right")) {
            baseAngleRad = 1.5707963705062866;
            if (dir1.equalsIgnoreCase("Up")) {
                counterclockwise = true;
                return new Object[]{baseAngleRad, counterclockwise};
            } else {
                if (!dir1.equalsIgnoreCase("Down")) return null;
                counterclockwise = false;
            }
            return new Object[]{baseAngleRad, counterclockwise};
        } else if (dir2.equalsIgnoreCase("Down")) {
            baseAngleRad = 3.1415927410125732;
            if (dir1.equalsIgnoreCase("Left")) {
                counterclockwise = false;
                return new Object[]{baseAngleRad, counterclockwise};
            } else {
                if (!dir1.equalsIgnoreCase("Right")) return null;
                counterclockwise = true;
            }
            return new Object[]{baseAngleRad, counterclockwise};
        } else {
            if (!dir2.equalsIgnoreCase("Left")) return null;
            baseAngleRad = 4.71238899230957;
            if (dir1.equalsIgnoreCase("Up")) {
                counterclockwise = false;
                return new Object[]{baseAngleRad, counterclockwise};
            } else {
                if (!dir1.equalsIgnoreCase("Down")) return null;
                counterclockwise = true;
            }
        }
        return new Object[]{baseAngleRad, counterclockwise};
    }
}

