/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.dialog;

import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanExportGridOption;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportGridDialog
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPlotFrame pframe_;
    private JTextField varTF_;
    private JTextField standardTF_;
    private JTextField longTF_;
    private JTextField unitsTF_;
    private JButton cancelBtn_;
    private JButton makeBtn_;
    private boolean success_;

    public PanExportGridDialog(PanPlotFrame pframe) {
        super(pframe, "Data Grid Export Options", true);
        this.pframe_ = pframe;
        this.setResizable(false);
        this.createLayout();
        this.attachListeners();
    }

    private void createLayout() {
        PanData data = this.pframe_.getData();
        JLabel message = new JLabel("What name and attributes should I use the export?");
        this.varTF_ = new JTextField("some_data", 24);
        this.standardTF_ = new JTextField("", 32);
        this.longTF_ = new JTextField("", 32);
        this.unitsTF_ = new JTextField(data.getUnits(), 16);
        JLabel standardNote = new JLabel(" (per CF conventions, optional)");
        JLabel longNote = new JLabel(" (descriptive, optional)");
        JLabel unitsNote = new JLabel(" (per UDUNITS-1)");
        GuiUtils.setSizeSmall(standardNote);
        GuiUtils.setSizeSmall(longNote);
        GuiUtils.setSizeSmall(unitsNote);
        QuickBox varBox = QuickBox.createLeftBox(this.varTF_);
        QuickBox standardBox = QuickBox.createLeftBox(this.standardTF_, standardNote);
        QuickBox longBox = QuickBox.createLeftBox(this.longTF_, longNote);
        QuickBox unitsBox = QuickBox.createLeftBox(this.unitsTF_, unitsNote);
        this.makeBtn_ = new JButton("Okay");
        this.cancelBtn_ = new JButton("Cancel");
        QuickBox buttonBox = PlatformUtils.isMacintosh() ? QuickBox.createRightBox(this.cancelBtn_, this.makeBtn_) : QuickBox.createRightBox(this.makeBtn_, this.cancelBtn_);
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(3, 6, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(PanGuiUtils.STD_BORDER);
        contentPanel.add((Component)message, new FGConstraint(0, 0, 2, 1));
        contentPanel.add((Component)new JLabel("Var name:\u2009"), new FGConstraint(0, 1));
        contentPanel.add((Component)varBox, new FGConstraint(1, 1));
        contentPanel.add((Component)new JLabel("Standard name:\u2009"), new FGConstraint(0, 2));
        contentPanel.add((Component)standardBox, new FGConstraint(1, 2));
        contentPanel.add((Component)new JLabel("Long name:\u2009"), new FGConstraint(0, 3));
        contentPanel.add((Component)longBox, new FGConstraint(1, 3));
        contentPanel.add((Component)new JLabel("Units:\u2009"), new FGConstraint(0, 4));
        contentPanel.add((Component)unitsBox, new FGConstraint(1, 4));
        contentPanel.add((Component)buttonBox, new FGConstraint(0, 5, 3, 1, 1.0, 0.5));
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(this.makeBtn_);
        this.pack();
        Rectangle rr = this.pframe_.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
    }

    private void attachListeners() {
        this.makeBtn_.addActionListener(e -> {
            this.success_ = true;
            this.setVisible(false);
        });
        this.cancelBtn_.addActionListener(e -> this.setVisible(false));
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public Hashtable<PanExportGridOption, String> getOptions() {
        String varname = this.varTF_.getText().replaceAll("[^\\w-]", "");
        if (varname.length() == 0) {
            varname = "some_data";
        }
        String standardName = this.standardTF_.getText();
        String longName = this.longTF_.getText();
        String unitsStr = this.unitsTF_.getText();
        standardName = standardName.replaceFirst("^\\s*", "").replaceFirst("\\s*$", "").replaceAll("\\s+", "_");
        longName = longName.replaceFirst("^\\s*", "").replaceFirst("\\s*$", "").replaceAll("\\s+", " ");
        unitsStr = unitsStr.replaceFirst("^\\s*", "").replaceFirst("\\s*$", "").replaceAll("\\ss+", " ");
        Hashtable<PanExportGridOption, String> opts = new Hashtable<PanExportGridOption, String>(4);
        opts.put(PanExportGridOption.VARNAME, varname);
        if (standardName != null && standardName.length() > 0) {
            opts.put(PanExportGridOption.STANDARD_NAME, standardName);
        }
        if (longName != null && longName.length() > 0) {
            opts.put(PanExportGridOption.LONG_NAME, longName);
        }
        if (unitsStr != null && unitsStr.length() > 0) {
            opts.put(PanExportGridOption.UNITS, unitsStr);
        }
        if (LOGGER.isTraceEnabled()) {
            for (PanExportGridOption key : opts.keySet()) {
                LOGGER.trace("{}, '{}'", (Object)key, (Object)opts.get((Object)key));
            }
        }
        return opts;
    }
}

