/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.plotui.PanPlotControlsMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotUnifiedPseudoPalette;
import gov.nasa.giss.panoply.plotui.PanPlotWindoid;
import gov.nasa.giss.panoply.util.PanPlotControlsID;
import gov.nasa.giss.panoply.util.PanProperties;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanCenterPlotControlsAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPlotFrame parent_;

    public PanCenterPlotControlsAction(PanPlotFrame parent) {
        super(PanProperties.MENU_PROPS.getString("center-plot-controls"));
        this.parent_ = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (PanPlotControlsMeta.isFloating()) {
            for (PanPlotControlsID wid : PanPlotControlsID.values()) {
                PanPlotWindoid ww = this.parent_.getControlsWindoid(wid);
                if (ww == null) continue;
                this.centerWindoid(ww);
            }
        } else {
            PanPlotUnifiedPseudoPalette upp = this.parent_.getPseudoPalette();
            if (upp == null) {
                LOGGER.debug("Pseudo controls palette is null.");
                return;
            }
            Rectangle prr = this.parent_.getContentPane().getBounds();
            Rectangle crr = upp.getBounds();
            int xnew = (prr.width - crr.width) / 2;
            int ynew = (prr.height - crr.height) / 2;
            upp.setLocation(xnew, ynew);
            this.parent_.repaint();
        }
    }

    private void centerWindoid(PanPlotWindoid ww) {
        Point testPt;
        Rectangle prr = this.parent_.getBounds();
        Rectangle crr = ww.getBounds();
        int xnew = prr.x + (prr.width - crr.width) / 2;
        int ynew = prr.y + (prr.height - crr.height) / 2;
        GraphicsDevice pdevice = this.parent_.getGraphicsConfiguration().getDevice();
        GraphicsConfiguration gc = pdevice.getDefaultConfiguration();
        Rectangle srec = gc.getBounds();
        boolean goodPt = srec.contains(testPt = new Point(xnew + crr.width / 2, ynew + crr.height / 2));
        if (!goodPt) {
            int minx = srec.x;
            int maxx = srec.x + srec.width;
            int miny = srec.y;
            int maxy = srec.y + srec.height;
            if (xnew + crr.width < minx + 20) {
                xnew = minx + 20;
            } else if (xnew + crr.width > maxx - 20) {
                xnew = maxx - 20 - crr.width;
            }
            if (ynew + crr.height < miny + 20) {
                ynew = miny + 20;
            } else if (ynew + crr.height > maxy - 20) {
                ynew = maxy - 20 - crr.height;
            }
        }
        ww.setLocation(xnew, ynew);
    }
}

