/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanBiggerPlotAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("show-bigger");
    private final PanPlotMeta pmeta_;

    public PanBiggerPlotAction(PanPlotMeta pmeta) {
        super(ACTION_NAME);
        this.pmeta_ = pmeta;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int oldval = this.pmeta_.getInt("size.factor");
        int newval = oldval >= 120 ? oldval + 10 : oldval + 5;
        this.pmeta_.setInt("size.factor", newval);
        PanPlotFrame pframe = this.pmeta_.getFrame();
        EventQueue.invokeLater(() -> pframe.refreshMenu("plot-size-menu"));
        this.setEnabled(newval < 300);
    }
}

