/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class QuarticAuthalic
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "Quartic Authalic";
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.4142135623730951;

    public QuarticAuthalic(int width, int height) {
        this(width, height, 0, 0);
    }

    public QuarticAuthalic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x1000008, width, height, xmargin, ymargin, Math.PI, 1.4142135623730951);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        if (lat == 0.0 && !this.isInterrupted()) {
            double x2 = this.lonToLambdaRad(lon);
            double y = 0.0;
            x2 = (double)this.outCenterX_ + x2 * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x2, y);
        }
        double phiRad = Math.toRadians(lat);
        double halfPhiRad = 0.5 * phiRad;
        double phiFactor = Math.cos(phiRad) / Math.cos(halfPhiRad);
        double y = 2.0 * Math.sin(halfPhiRad);
        if (this.isInterrupted()) {
            double[] gore = this.getGore(lon, lat);
            double nlon = MapUtils.normalizeMP180(lon);
            double dlon = nlon - gore[1];
            double dx = Math.toRadians(dlon) * phiFactor;
            double cx = this.lonToLambdaRad(gore[1]);
            x = cx + dx;
        } else {
            x = this.lonToLambdaRad(lon) * phiFactor;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double xFactor;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (y == 0.0) {
            phiRad = 0.0;
            xFactor = this.invRS_;
        } else {
            double yOverRS = y * this.invRS_;
            double sinHalfPhi = 0.5 * yOverRS;
            double halfPhiRad = Math.asin(sinHalfPhi);
            phiRad = 2.0 * halfPhiRad;
            xFactor = this.invRS_ * Math.cos(halfPhiRad) / Math.cos(phiRad);
        }
        double lon = this.getLongitudeForX(x, xFactor, this.invRS_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        QuarticAuthalic quarticAuthalic = this;
        synchronized (quarticAuthalic) {
            double y;
            double sinHalfPhi;
            double halfPhiRad;
            double phiRad;
            for (int iy = -this.dyMax_; iy < this.dyMax_ && !((phiRad = 2.0 * (halfPhiRad = Math.asin(sinHalfPhi = 0.5 * (y = (double)iy + 0.5) * this.invRS_))) > 1.5707963267948966); ++iy) {
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ * Math.cos(halfPhiRad) / Math.cos(phiRad);
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lon = this.getLongitudeForX(x, xFactor, this.invRS_, phi > 0.0);
                    if (Double.isNaN(lon)) continue;
                    this.setInvPoint(ix, iy, lon, phi);
                }
            }
        }
    }
}

