/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.QuadEllipseProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class PseudoStereographic
extends QuadEllipseProjection {
    public static final String PROJECTION_NAME = "Pseudo-Stereographic";
    public static final int PROPERTIES = 32;
    private static final double MAX_X_OVER_RS = 4.0;
    private static final double MAX_Y_OVER_RS = 2.0;
    private double inv2RS_;
    private double inv4RS_;

    public PseudoStereographic(int width, int height) {
        this(width, height, 0, 0);
    }

    public PseudoStereographic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 32, width, height, xmargin, ymargin, 4.0, 2.0);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.inv2RS_ = 0.5 * this.invRS_;
        this.inv4RS_ = 0.25 * this.invRS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double halfLambdaRad = 0.5 * lambdaRad;
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cosBeta = cosPhi * Math.cos(halfLambdaRad);
        double onePlusCosBeta = 1.0 + cosBeta;
        double x = 4.0 * cosPhi * Math.sin(halfLambdaRad) / onePlusCosBeta;
        double y = 2.0 * sinPhi / onePlusCosBeta;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return new PointLL(this.lambdaC_, 0.0);
        }
        double rhoFac = Math.hypot(0.5 * x, y) * this.invRS_;
        if (rhoFac > 2.0) {
            return null;
        }
        double tanHalfBeta = 0.5 * rhoFac;
        double betaRad = 2.0 * Math.atan(tanHalfBeta);
        double cosBeta = Math.cos(betaRad);
        double onePlusCosBeta = 1.0 + cosBeta;
        double sinPhi = y * this.inv2RS_ * onePlusCosBeta;
        double phiRad = Math.asin(sinPhi);
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double cosPhi = Math.cos(phiRad);
        if (phiRad == 1.5707963267948966) {
            lambdaRad = 0.0;
        } else {
            double sinHalfLambda = x * this.inv4RS_ * onePlusCosBeta / cosPhi;
            lambdaRad = 2.0 * Math.asin(sinHalfLambda);
        }
        if (Double.isNaN(lambdaRad) || lambdaRad > Math.PI) {
            return null;
        }
        if (x < 0.0) {
            lambdaRad = -lambdaRad;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        PseudoStereographic pseudoStereographic = this;
        synchronized (pseudoStereographic) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double rhoFac;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                for (int ix = 0; ix < this.dxMax_ && !((rhoFac = Math.hypot(0.5 * (x = (double)ix + 0.5), y) * this.invRS_) > 2.0); ++ix) {
                    double lambdaRad;
                    double phiRad;
                    double tanHalfBeta = 0.5 * rhoFac;
                    double betaRad = 2.0 * Math.atan(tanHalfBeta);
                    double cosBeta = Math.cos(betaRad);
                    double onePlusCosBeta = 1.0 + cosBeta;
                    if (betaRad > 1.0E-5) {
                        double sinPhi = 0.5 * yOverRS * onePlusCosBeta;
                        phiRad = Math.asin(sinPhi);
                        if (phiRad > 1.5707963267948966) {
                            return;
                        }
                        if (phiRad == 1.5707963267948966) {
                            lambdaRad = 0.0;
                        } else {
                            double cosPhi = Math.cos(phiRad);
                            double sinHalfLambda = x * this.inv4RS_ * onePlusCosBeta / cosPhi;
                            lambdaRad = 2.0 * Math.asin(sinHalfLambda);
                        }
                        if (lambdaRad > Math.PI) {
                            continue block3;
                        }
                    } else {
                        phiRad = 0.0;
                        lambdaRad = 0.0;
                    }
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }
}

