/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjParameterListener;
import java.util.Objects;
import javax.swing.event.EventListenerList;

public abstract class ProjExtraParameter {
    protected String description_;
    protected String label_;
    protected String units_;
    private final EventListenerList listenerList_ = new EventListenerList();

    public ProjExtraParameter(String description, String label, String units) {
        Objects.requireNonNull(description, "Description cannot be null.");
        Objects.requireNonNull(label, "Label cannot be null.");
        this.description_ = description;
        this.label_ = label;
        this.units_ = units;
    }

    public String getDescription() {
        return this.description_;
    }

    public String getLabel() {
        return this.label_;
    }

    public String getUnits() {
        return this.units_;
    }

    public abstract Object getDefaultObject();

    public abstract Object getValueObject();

    public abstract void setValue(Object var1) throws IllegalArgumentException;

    public abstract void setValue(String var1) throws IllegalArgumentException;

    public void setUnits(String units) {
        this.units_ = units;
    }

    public abstract void reset();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameterListener(ProjParameterListener l) {
        EventListenerList eventListenerList = this.listenerList_;
        synchronized (eventListenerList) {
            this.listenerList_.add(ProjParameterListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParameterListener(ProjParameterListener l) {
        EventListenerList eventListenerList = this.listenerList_;
        synchronized (eventListenerList) {
            this.listenerList_.remove(ProjParameterListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjParameterListener[] getParameterListeners() {
        ProjParameterListener[] listeners;
        EventListenerList eventListenerList = this.listenerList_;
        synchronized (eventListenerList) {
            listeners = (ProjParameterListener[])this.listenerList_.getListeners(ProjParameterListener.class);
        }
        return listeners;
    }

    public void fireChange() {
        ProjParameterListener[] listeners;
        ProjParameterEvent e = new ProjParameterEvent(this);
        for (ProjParameterListener l : listeners = this.getParameterListeners()) {
            l.parameterChanged(e);
        }
    }
}

