/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GeneralEquidistantConic;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Kavraisky2
extends GeneralEquidistantConic {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Kavraisky II";

    public Kavraisky2(int width, int height) {
        this(width, height, 0, 0);
    }

    public Kavraisky2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200010, width, height, xmargin, ymargin);
        this.finishConstruction();
    }

    @Override
    protected void calculateParams() {
        if (this.phi1_ == this.phi2_ && this.phi1_ == 0.0) {
            this.phi1_ += 1.0E-5;
        }
        double phi0Rad = 0.5 * Math.toRadians(this.phi1_ + this.phi2_);
        double deltaRad = 0.5 * Math.toRadians(Math.abs(this.phi1_ - this.phi2_));
        this.termF_ = this.phi1_ == this.phi2_ ? 1.0 / Math.tan(phi0Rad) + phi0Rad : deltaRad / (Math.tan(deltaRad) * Math.tan(phi0Rad)) + phi0Rad;
        double gammaRad = 1.0;
        for (int iter = 0; iter < 33; ++iter) {
            double cotGamma = 1.0 / Math.tan(gammaRad);
            double cscGamma = 1.0 / Math.sin(gammaRad);
            double func = gammaRad + cotGamma - this.termF_;
            double dfunc = -cscGamma * cscGamma + 1.0;
            double dgammaRad = -func / dfunc;
            gammaRad += dgammaRad;
            if (Math.abs(dgammaRad) < 1.0E-5) break;
        }
        if (this.phi1_ == this.phi2_) {
            double nSq = Math.sin(phi0Rad) * Math.sin(gammaRad);
            this.termN_ = Math.sqrt(nSq);
        } else {
            double nSq = Math.sin(phi0Rad) * Math.sin(gammaRad) * Math.sin(deltaRad) / deltaRad;
            this.termN_ = Math.sqrt(nSq);
        }
        this.invN_ = 1.0 / this.termN_;
        this.rhoC_ = this.termF_ - this.phiCRad_;
        LOGGER.trace("F {}, n {}, rhoC {}", this.termF_, this.termN_, this.rhoC_);
    }
}

