/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;

public class GottMugnoloAzimuthal
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Gott-Mugnolo Azimuthal";
    private static final double CONST_A = 0.446;
    private static final double INV_A = 2.242152466367713;
    private static final double DEFAULT_CLIP_ANGLE = 90.0;
    private static final double MAX_CLIP_ANGLE = 180.0;

    public GottMugnoloAzimuthal(int width, int height) {
        this(width, height, 0, 0);
    }

    public GottMugnoloAzimuthal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addEdgeAngleParameter(90.0, 180.0, true);
        this.addAzimuthalFillParameter();
        this.finishConstruction();
    }

    @Override
    protected final void prepareScaling() {
        double rhoEdgeOverR = Math.sin(0.446 * this.edgeAngleRad_);
        this.setMaxXYOverRS(rhoEdgeOverR);
    }

    @Override
    protected final void finishScaling() {
        if (this.fillCorners_) {
            double rhoBOverR = Math.sin(1.4011503235010478);
            this.rhoBorder_ = rhoBOverR * this.rS_;
        } else {
            this.rhoBorder_ = this.xmRS_;
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        double z = Math.acos(cosZ);
        return Math.sin(0.446 * z) / Math.sin(z);
    }

    @Override
    protected double getZRadForRho(double rho) {
        return 2.242152466367713 * Math.asin(rho * this.invRS_);
    }
}

