/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.map.overlay.OutlineArea;
import gov.nasa.giss.map.overlay.OutlineOverlay;
import gov.nasa.giss.map.overlay.OutlineSegment;
import gov.nasa.giss.map.shapefile.ShapeRecord;
import gov.nasa.giss.map.shapefile.ShapeRecordType;
import gov.nasa.giss.map.shapefile.Shapefile;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapefileOverlay
extends OutlineOverlay {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ShapeRecordType shapeType_;

    public ShapefileOverlay(File f) throws FileNotFoundException, IOException {
        super(f);
    }

    public ShapefileOverlay(URL url) throws IOException {
        super(url);
    }

    public ShapefileOverlay(byte[] bytes, String id) throws IOException {
        super(bytes, id);
    }

    @Override
    protected boolean readHeader(InputStream istream) throws IOException {
        Shapefile sfile = new Shapefile(istream);
        try {
            this.shapeType_ = sfile.getShapeType();
            LOGGER.trace("shapeType {}", (Object)this.shapeType_);
        }
        catch (IllegalArgumentException exc) {
            LOGGER.debug("IllegalArgumentException with getShapeType: {}", (Object)exc.getMessage());
            throw new IllegalArgumentException("Invalid value(s) in shape type definition of " + this.getName());
        }
        catch (Exception exc) {
            LOGGER.debug("Exception with getShapeType: {}", (Object)exc.getMessage());
            throw new RuntimeException("Unable to read header for " + this.getName());
        }
        return true;
    }

    @Override
    public boolean isMask() {
        return false;
    }

    @Override
    public boolean isOutline() {
        return !this.isPoints();
    }

    @Override
    public boolean isPoints() {
        return this.shapeType_ == ShapeRecordType.POINT || this.shapeType_ == ShapeRecordType.POINT_M || this.shapeType_ == ShapeRecordType.POINT_Z;
    }

    @Override
    protected void readFullContent(InputStream istream) throws IOException {
        Shapefile sfile = new Shapefile(istream);
        LonLatEdges bounds = sfile.getBounds();
        LOGGER.trace("bounds {}", (Object)bounds);
        this.setBounds(bounds);
        int numShapes = sfile.size();
        LOGGER.trace("numShapes {}", (Object)numShapes);
        for (int i = 0; i < numShapes; ++i) {
            OutlineSegment.SegmentType stype;
            ShapeRecord shape = sfile.getShape(i);
            if (shape.isNull() || shape.isMultiPatch()) continue;
            if (shape.isPoint() || shape.isMultiPoint()) {
                stype = OutlineSegment.SegmentType.POINTS;
            } else if (shape.isPolyline()) {
                stype = OutlineSegment.SegmentType.SHAPES;
            } else {
                if (!shape.isPolygon()) continue;
                stype = OutlineSegment.SegmentType.SHAPES;
            }
            OutlineArea area = new OutlineArea();
            try {
                area.setBounds(shape.getBounds());
            }
            catch (Exception exc) {
                LOGGER.trace("Exception setting bounds for shape {}, {}", (Object)i, (Object)exc.getMessage());
                continue;
            }
            int numParts = shape.numberOfParts();
            for (int j = 0; j < numParts; ++j) {
                Point2D.Double[] pts = shape.getPoints(j);
                OutlineSegment segment = new OutlineSegment(stype);
                for (int k = 0; k < pts.length; ++k) {
                    if (pts[k].y > 90.0) {
                        pts[k].y = 90.0;
                    } else if (pts[k].y < -90.0) {
                        pts[k].y = -90.0;
                    }
                    PointLL p = new PointLL(pts[k].x, pts[k].y);
                    segment.addPoint(p);
                }
                if (segment.size() <= 0) continue;
                area.addSegment(segment);
            }
            if (area.size() <= 0) continue;
            this.addArea(area);
        }
        this.setContentRead();
    }
}

