/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map;

import gov.nasa.giss.text.StringUtils;
import java.lang.invoke.MethodHandles;
import java.text.Collator;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProjNameComparator
implements Comparator<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern ROMAN_PATTERN = Pattern.compile(" (I|V|X|L)+ ");
    private static final Collator LOCAL_COLLATOR = Collator.getInstance();

    ProjNameComparator() {
    }

    @Override
    public int compare(String str1, String str2) {
        String name1 = ProjNameComparator.comparatorString(str1);
        String name2 = ProjNameComparator.comparatorString(str2);
        return LOCAL_COLLATOR.compare(name1, name2);
    }

    private static String comparatorString(String str) {
        Object strx = str.replace("(", "");
        if (((String)(strx = ((String)strx).replace(")", ""))).matches(".* (I|V|X|L)+")) {
            int space = ((String)strx).lastIndexOf(" ");
            String root = ((String)strx).substring(0, space + 1);
            Object roman = Integer.toString(StringUtils.romanOfString(((String)strx).substring(space + 1)));
            if (((String)roman).length() < 2) {
                roman = "0" + (String)roman;
            }
            strx = root + (String)roman;
            return strx;
        }
        if (((String)strx).matches(".* (I|V|X|L)+ .*")) {
            Matcher matcher = ROMAN_PATTERN.matcher((CharSequence)strx);
            matcher.find();
            int mstart = matcher.start();
            int mend = matcher.end();
            String root = ((String)strx).substring(0, mstart + 1);
            Object roman = Integer.toString(StringUtils.romanOfString(((String)strx).substring(mstart + 1, mend - 1)));
            String extra = ((String)strx).substring(mend - 1);
            if (((String)roman).length() < 2) {
                roman = "0" + (String)roman;
            }
            strx = root + (String)roman + extra;
            return strx;
        }
        return strx;
    }
}

