/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGridding;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjGridding;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.sat.Geostationary;

public class NcArrayLonLatGoesImager
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean USE_NJ_PROJ = false;
    private Projection njProj_;
    private double req2OverRpol2_;
    private double rpol2OverReq2_;
    private double hh_;
    private double cc_;

    public NcArrayLonLatGoesImager(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjGridding.GOES_IMAGER);
        this.initMe();
    }

    private void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcLLAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcLLAltGriddingVarType)vtype).isGrid(NcLLAltGridding.GOES_IMAGER)) {
            throw new NcException("Variable is not projected type GOES Imager.");
        }
        this.initGissProj();
    }

    private void initGissProj() {
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("geostationary")) {
            LOGGER.trace("Found unusable mapping name {}", (Object)this.mappingName_);
            throw new NcException("Mapping name is not geostationary");
        }
        String mvname = this.mappingVarDS_.getShortName();
        if (!"goes_imager_projection".equalsIgnoreCase(mvname)) {
            LOGGER.trace("Grid mapping variable has name '{}'", (Object)mvname);
            throw new NcException("Variable is geostationary but it is not GOES Imager.");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        double req2 = this.semimajor_ * this.semimajor_;
        this.req2OverRpol2_ = req2 / (this.semiminor_ * this.semiminor_);
        this.rpol2OverReq2_ = 1.0 / this.req2OverRpol2_;
        Attribute pphA = this.mappingVarDS_.findAttribute("perspective_point_height");
        if (pphA == null) {
            LOGGER.trace("Grid mapping var omits perspective point height.");
            LOGGER.trace("Setting satellite distance from center of Earth to default.");
            this.hh_ = 4.216416E7;
        } else {
            this.hh_ = this.semimajor_ + pphA.getNumericValue().doubleValue();
        }
        this.cc_ = this.hh_ * this.hh_ - req2;
    }

    private void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List csList = njvarDS.getCoordinateSystems();
        LOGGER.trace("csList size {}", (Object)csList.size());
        if (csList.isEmpty()) {
            throw new NcException("No coordinate system(s) reported.");
        }
        CoordinateSystem cs = (CoordinateSystem)csList.get(0);
        LOGGER.trace("cs[0] {}", (Object)cs);
        ProjectionImpl pj = cs.getProjection();
        if (pj == null) {
            throw new NcNullException("C.S. returned null projection handler.");
        }
        LOGGER.trace("C.S. returned projection {}", (Object)pj.getClass().getSimpleName());
        if (!(pj instanceof Geostationary)) {
            LOGGER.warn("Expected Geostationary class but got {}", (Object)pj.getClass().getSimpleName());
            throw new NcException("C.S. returned projection class " + pj.getClass().getSimpleName() + " when Geostationary was expected");
        }
        this.njProj_ = pj;
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        double sz;
        double sz2;
        double sy;
        double sy2;
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRadC = Math.atan(Math.tan(phiRad) * this.rpol2OverReq2_);
        double cosPhiC = Math.cos(phiRadC);
        double rc = this.semiminor_ / Math.sqrt(1.0 - this.eccen2_ * cosPhiC * cosPhiC);
        double sx = this.hh_ - rc * cosPhiC * Math.cos(lambdaRad);
        if (this.hh_ * (this.hh_ - sx) < (sy2 = (sy = -rc * cosPhiC * Math.sin(lambdaRad)) * sy) + this.req2OverRpol2_ * (sz2 = (sz = rc * Math.sin(phiRadC)) * sz)) {
            return null;
        }
        double x = Math.asin(-sy / Math.sqrt(sx * sx + sy2 + sz2));
        double y = Math.atan2(sz, sx);
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double sinX = Math.sin(x);
        double cosX = Math.cos(x);
        double sinY = Math.sin(y);
        double cosY = Math.cos(y);
        double cosXcosY = cosX * cosY;
        double a = sinX * sinX + cosX * cosX * (cosY * cosY + this.req2OverRpol2_ * sinY * sinY);
        double b = -2.0 * this.hh_ * cosXcosY;
        double rs = (-b - Math.sqrt(b * b - 4.0 * a * this.cc_)) / (2.0 * a);
        double sx = rs * cosXcosY;
        double sy = -rs * sinX;
        double sz = rs * cosX * sinY;
        double hMinusSx = this.hh_ - sx;
        double phiRad = Math.atan2(this.req2OverRpol2_ * sz, Math.sqrt(hMinusSx * hMinusSx + sy * sy));
        double lambdaRad = -Math.atan(sy / hMinusSx);
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }
}

