/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcConfig;
import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcStructureMember;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVarVisibility;
import gov.nasa.giss.data.nc.ui.NcDataTreeTableModel;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Variable;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;

public class NcStructure
extends NcDataNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final StructureDS njstructDS_;

    public NcStructure(NcDataNode parent, StructureDS s) throws IOException {
        super(parent);
        this.njstructDS_ = s;
        this.initChildren();
    }

    protected void initChildren() {
        this.initAllChildren();
        this.initVisibleChildren();
    }

    private void initAllChildren() {
        LOGGER.trace("{}", (Object)this.getShortName());
        if (this.njstructDS_ == null) {
            LOGGER.error("Backing NJ Structure is not set.");
            return;
        }
        this.childNameList_.clear();
        this.allChildren_ = new ArrayList(50);
        for (Variable var : this.njstructDS_.getVariables()) {
            LOGGER.debug("Child {} is a {}", (Object)var.getShortName(), (Object)var.getClass().getSimpleName());
            String fname = var.getFullName();
            this.childNameList_.add(fname);
            try {
                NcStructure ncstruct;
                if (var instanceof SequenceDS) {
                    SequenceDS njseqDS = (SequenceDS)var;
                    ncstruct = new NcStructure(this, njseqDS);
                    this.allChildren_.add(ncstruct);
                    continue;
                }
                if (var instanceof StructureDS) {
                    StructureDS njstructDS = (StructureDS)var;
                    ncstruct = new NcStructure(this, njstructDS);
                    this.allChildren_.add(ncstruct);
                    continue;
                }
                if (var instanceof VariableDS) {
                    VariableDS njvarDS = (VariableDS)var;
                    NcStructureMember ncv = new NcStructureMember(this, njvarDS);
                    this.allChildren_.add(ncv);
                    continue;
                }
                LOGGER.warn("** Not a Variable subclass we know how to handle.");
            }
            catch (Exception exc) {
                LOGGER.error("Exception constructing {}.{}, {}", this.getShortName(), var.getShortName(), exc.getMessage());
                if (!LOGGER.isTraceEnabled()) continue;
                exc.printStackTrace();
            }
        }
        LOGGER.trace("count {}", (Object)this.allChildren_.size());
    }

    private void initVisibleChildren() {
        NcVarVisibility vclass = this.getVarVisibility();
        this.clear();
        if (this.njstructDS_ == null) {
            return;
        }
        for (NcDataNode child : this.allChildren_) {
            if (child instanceof NcStructure) {
                this.addSorted(child);
                continue;
            }
            if (child instanceof NcStructureMember) {
                if (vclass != NcVarVisibility.ALL) continue;
                this.addSorted(child);
                continue;
            }
            LOGGER.warn("Unexpected NcType {}", (Object)child.getClass());
        }
    }

    @Override
    public void setVisibleVarClass(NcDataTreeTableModel model, NcVarVisibility vclass) {
        super.setVisibleVarClass(model, vclass);
        if (this.njstructDS_ == null) {
            LOGGER.warn("Backing NJ Structure is not set.");
            return;
        }
        TreeTableNode[] children = this.getChildren();
        if (vclass == NcVarVisibility.GEOREF || vclass == NcVarVisibility.GRIDDABLE) {
            for (int i = children.length - 1; i >= 0; --i) {
                NcDataNode node = (NcDataNode)children[i];
                if (!(node instanceof NcStructureMember)) continue;
                this.remove(node);
                if (model == null) continue;
                model.nodeRemoved(this, i, node);
            }
        }
        if (vclass == NcVarVisibility.ALL) {
            for (NcDataNode child : this.allChildren_) {
                try {
                    NcStructureMember ncv;
                    if (!(child instanceof NcStructureMember) || this.isChildVisible(ncv = (NcStructureMember)child)) continue;
                    int index = this.addSorted(ncv);
                    if (model == null) continue;
                    model.nodeInserted(this, index, ncv);
                }
                catch (Exception exc) {
                    LOGGER.error(exc.toString());
                    if (!LOGGER.isTraceEnabled()) continue;
                    exc.printStackTrace();
                }
            }
        }
    }

    private boolean isChildVisible(NcDataNode node) {
        TreeTableNode[] children = this.getChildren();
        if (children == null || children.length == 0) {
            return false;
        }
        String name = node.getName();
        for (TreeTableNode child : children) {
            boolean matches = name.equals(child.getName());
            if (!matches) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public Object getObject() {
        return this.njstructDS_;
    }

    @Override
    public String getName() {
        return this.getShortName();
    }

    @Override
    public String getNjPath() {
        return this.njstructDS_.getFullName();
    }

    @Override
    public String getLongName() {
        return NcUtils.getLongName(this.njstructDS_);
    }

    @Override
    public String getShortName() {
        return this.njstructDS_.getShortName();
    }

    @Override
    public String getNcType() {
        if (NcConfig.isDevo()) {
            return "[struct]";
        }
        return "&#8212;";
    }

    @Override
    public String getDetail(boolean enhanced) {
        String sname = this.njstructDS_.getShortName();
        String fname = this.njstructDS_.getFullName();
        Variable varUnenhanced = this.ncdataset_.getNjVariableUnenhanced(fname);
        Variable varOriginal = this.njstructDS_.getOriginalVariable();
        if (varOriginal instanceof VariableEnhanced) {
            LOGGER.trace("Original structure/variable is double enhanced!");
        }
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<html>").append("<head>");
        this.appendDetailStyle(sb);
        sb.append("</head>").append("<body>").append("<h2>Structure \"").append(sname).append("\"</h2>\n").append("<h3>In file \"").append(this.ncdataset_.getName()).append("\"</h3>\n");
        if (!sname.equals(fname)) {
            sb.append("<p>Structure full name: ").append(fname).append("</p>");
        }
        if (enhanced || varUnenhanced == null && varOriginal == null) {
            sb.append("<p><b>Showing enhanced mode description.</b></p>");
            sb.append("<pre>").append(StringUtils.escapeHtmlSimplistic(this.njstructDS_.toString())).append("</pre>");
        } else {
            sb.append("<pre>");
            if (varUnenhanced != null) {
                sb.append(StringUtils.escapeHtmlSimplistic(varUnenhanced.toString()));
            } else {
                sb.append(StringUtils.escapeHtmlSimplistic(varOriginal.toString()));
            }
            sb.append("</pre>");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    public int getRank() {
        return this.njstructDS_.getRank();
    }

    public int[] getShape() {
        return this.njstructDS_.getShape();
    }
}

