/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.table;

import gov.nasa.giss.ui.table.TableHeaderTheme;
import gov.nasa.giss.ui.table.TableThemeID;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableTheme {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Object SINGLETON_LOCK = new Object();
    private static final Color GRAY_217 = new Color(217, 217, 217);
    private static final Color GRAY_221 = new Color(221, 221, 221);
    private static final Color GRAY_229 = new Color(229, 229, 229);
    private static final Color GRAY_235 = new Color(235, 235, 235);
    private static final Color GRAY_240 = new Color(240, 240, 240);
    private static final Color AQUA_BLUE = new Color(237, 243, 254);
    private static final Color PALE_GREEN = new Color(221, 255, 221);
    private static final Color PALE_RED = new Color(255, 221, 221);
    private static final Color PALE_YELLOW = new Color(255, 255, 221);
    private static TableTheme macosGraphiteTheme_;
    private static TableTheme macosDarkModeTheme_;
    private static TableTheme macosAquaTheme_;
    private static TableTheme fanfoldTheme_;
    private static TableTheme fanfoldVTheme_;
    private static TableTheme spreadsheetTheme_;
    private static TableTheme candyStripeTheme_;
    private static TableTheme hudTheme_;
    private final Hashtable<TParamKey, Object> themeProps_ = new Hashtable();

    public TableTheme() {
        this.themeProps_.put(TParamKey.VERT_GRID_LINES, false);
        this.themeProps_.put(TParamKey.HORZ_GRID_LINES, false);
        this.themeProps_.put(TParamKey.BACKGROUND_COLORS, new Color[]{Color.WHITE});
        this.themeProps_.put(TParamKey.FOREGROUND_COLOR, Color.BLACK);
        this.themeProps_.put(TParamKey.GRID_COLOR, GRAY_235);
    }

    public TableTheme(Object ... props) {
        this();
        if (props.length % 2 != 0) {
            throw new IllegalArgumentException("Count of properties and keys must be a multiple of 2.");
        }
        for (int i = 0; i < props.length; i += 2) {
            if (props[i] == null) {
                throw new IllegalArgumentException("Property " + i / 2 + " key is null.");
            }
            if (!(props[i] instanceof TParamKey)) {
                throw new IllegalArgumentException("Property " + i / 2 + " key is not a TParamKey.");
            }
            if (props[i + 1] == null) {
                throw new IllegalArgumentException("Property " + (TParamKey)((Object)props[i]) + " cannot be null.");
            }
            this.themeProps_.put((TParamKey)((Object)props[i]), props[i + 1]);
        }
    }

    public TableHeaderTheme getHeaderTheme() {
        Object o = this.themeProps_.get((Object)TParamKey.HEADER_THEME);
        if (!(o instanceof TableHeaderTheme)) {
            o = TableHeaderTheme.getTheme(null);
            this.themeProps_.put(TParamKey.HEADER_THEME, o);
        }
        return (TableHeaderTheme)o;
    }

    public boolean getShowGrid() {
        return this.getShowVerticalLines() || this.getShowHorizontalLines();
    }

    public boolean getShowVerticalLines() {
        Object o = this.themeProps_.get((Object)TParamKey.VERT_GRID_LINES);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    public boolean getShowHorizontalLines() {
        Object o = this.themeProps_.get((Object)TParamKey.HORZ_GRID_LINES);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    public Color getForeground() {
        Object o = this.themeProps_.get((Object)TParamKey.FOREGROUND_COLOR);
        if (o instanceof Color) {
            return (Color)o;
        }
        return Color.BLACK;
    }

    public Color getBackground(int row) {
        Object o = this.themeProps_.get((Object)TParamKey.BACKGROUND_COLORS);
        if (o instanceof Color) {
            return (Color)o;
        }
        if (o instanceof Color[]) {
            Color[] colors = (Color[])o;
            if (colors.length == 0) {
                return Color.WHITE;
            }
            int index = row % colors.length;
            return colors[index];
        }
        return Color.WHITE;
    }

    public Color getGridColor() {
        Object o = this.themeProps_.get((Object)TParamKey.GRID_COLOR);
        if (o instanceof Color) {
            return (Color)o;
        }
        return GRAY_240;
    }

    public static TableTheme getTheme(TableThemeID themeID) {
        if (themeID == null) {
            return TableTheme.getMacosGraphiteTheme(themeID).copy();
        }
        switch (themeID) {
            case MACOS_GRAPHITE: {
                return TableTheme.getMacosGraphiteTheme(themeID).copy();
            }
            case MACOS_DARKMODE: {
                return TableTheme.getMacosDarkModeTheme(themeID).copy();
            }
            case MACOS_AQUA: {
                return TableTheme.getMacosAquaTheme(themeID).copy();
            }
            case FANFOLD1: {
                return TableTheme.getFanfoldTheme(themeID).copy();
            }
            case FANFOLD2: {
                return TableTheme.getFanfoldVTheme(themeID).copy();
            }
            case SPREADSHEET: {
                return TableTheme.getSpreadsheetTheme(themeID).copy();
            }
            case CANDYSTRIPE: {
                return TableTheme.getCandyStripeTheme(themeID).copy();
            }
            case HUD: {
                return TableTheme.getHudTheme(themeID).copy();
            }
        }
        return TableTheme.getMacosGraphiteTheme(themeID).copy();
    }

    private static TableTheme getMacosGraphiteTheme(TableThemeID themeID) {
        if (macosGraphiteTheme_ == null) {
            int macMajor = 10;
            int macMinor = 13;
            if (PlatformUtils.isMacintosh()) {
                macMajor = PlatformUtils.getOSMajor();
                macMinor = PlatformUtils.getOSMinor();
            }
            macosGraphiteTheme_ = macMajor < 11 && macMinor < 10 ? new TableTheme(new Object[]{TParamKey.VERT_GRID_LINES, true, TParamKey.HORZ_GRID_LINES, false, TParamKey.GRID_COLOR, GRAY_221, TParamKey.BACKGROUND_COLORS, new Color[]{GRAY_235, Color.WHITE}, TParamKey.HEADER_THEME, TableHeaderTheme.getTheme(TableThemeID.MACOS_AQUA)}) : (macMajor < 11 && macMinor < 13 ? new TableTheme(new Object[]{TParamKey.VERT_GRID_LINES, true, TParamKey.HORZ_GRID_LINES, false, TParamKey.GRID_COLOR, GRAY_240, TParamKey.BACKGROUND_COLORS, new Color[]{GRAY_235, Color.WHITE}, TParamKey.HEADER_THEME, TableHeaderTheme.getTheme(themeID)}) : new TableTheme(new Object[]{TParamKey.VERT_GRID_LINES, false, TParamKey.HORZ_GRID_LINES, false, TParamKey.GRID_COLOR, GRAY_240, TParamKey.BACKGROUND_COLORS, new Color[]{GRAY_235, Color.WHITE}, TParamKey.HEADER_THEME, TableHeaderTheme.getTheme(themeID)}));
        }
        return macosGraphiteTheme_;
    }

    private static TableTheme getMacosDarkModeTheme(TableThemeID themeID) {
        if (macosDarkModeTheme_ == null) {
            macosDarkModeTheme_ = new TableTheme(new Object[]{TParamKey.VERT_GRID_LINES, false, TParamKey.HORZ_GRID_LINES, false, TParamKey.GRID_COLOR, GRAY_240, TParamKey.BACKGROUND_COLORS, new Color[]{new Color(51, 53, 48), new Color(36, 38, 34)}, TParamKey.HEADER_THEME, TableHeaderTheme.getTheme(themeID)});
        }
        return macosDarkModeTheme_;
    }

    private static TableTheme getMacosAquaTheme(TableThemeID themeID) {
        if (macosAquaTheme_ == null) {
            macosAquaTheme_ = new TableTheme(new Object[]{TParamKey.VERT_GRID_LINES, true, TParamKey.HORZ_GRID_LINES, false, TParamKey.GRID_COLOR, GRAY_217, TParamKey.BACKGROUND_COLORS, new Color[]{Color.WHITE, AQUA_BLUE}, TParamKey.HEADER_THEME, TableHeaderTheme.getTheme(themeID)});
        }
        return macosAquaTheme_;
    }

    private static TableTheme getFanfoldTheme(TableThemeID themeID) {
        if (fanfoldTheme_ == null) {
            fanfoldTheme_ = new TableTheme(new Object[]{TParamKey.VERT_GRID_LINES, false, TParamKey.HORZ_GRID_LINES, false, TParamKey.BACKGROUND_COLORS, new Color[]{Color.WHITE, PALE_GREEN}, TParamKey.HEADER_THEME, TableHeaderTheme.getTheme(themeID)});
        }
        return fanfoldTheme_;
    }

    private static TableTheme getFanfoldVTheme(TableThemeID themeID) {
        if (fanfoldVTheme_ == null) {
            fanfoldVTheme_ = new TableTheme(new Object[]{TParamKey.VERT_GRID_LINES, true, TParamKey.HORZ_GRID_LINES, false, TParamKey.GRID_COLOR, GRAY_229, TParamKey.BACKGROUND_COLORS, new Color[]{Color.WHITE, PALE_GREEN}, TParamKey.HEADER_THEME, TableHeaderTheme.getTheme(themeID)});
        }
        return fanfoldVTheme_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TableTheme getSpreadsheetTheme(TableThemeID themeID) {
        Object object = SINGLETON_LOCK;
        synchronized (object) {
            if (spreadsheetTheme_ == null) {
                spreadsheetTheme_ = new TableTheme(new Object[]{TParamKey.VERT_GRID_LINES, true, TParamKey.HORZ_GRID_LINES, false, TParamKey.GRID_COLOR, GRAY_229, TParamKey.BACKGROUND_COLORS, new Color[]{PALE_YELLOW, PALE_GREEN}, TParamKey.HEADER_THEME, TableHeaderTheme.getTheme(themeID)});
            }
        }
        return spreadsheetTheme_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TableTheme getCandyStripeTheme(TableThemeID themeID) {
        Object object = SINGLETON_LOCK;
        synchronized (object) {
            if (candyStripeTheme_ == null) {
                candyStripeTheme_ = new TableTheme(new Object[]{TParamKey.VERT_GRID_LINES, false, TParamKey.HORZ_GRID_LINES, false, TParamKey.GRID_COLOR, GRAY_229, TParamKey.BACKGROUND_COLORS, new Color[]{Color.WHITE, PALE_RED}, TParamKey.HEADER_THEME, TableHeaderTheme.getTheme(themeID)});
            }
        }
        return candyStripeTheme_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TableTheme getHudTheme(TableThemeID themeID) {
        Object object = SINGLETON_LOCK;
        synchronized (object) {
            if (hudTheme_ == null) {
                hudTheme_ = new TableTheme(new Object[]{TParamKey.VERT_GRID_LINES, true, TParamKey.HORZ_GRID_LINES, false, TParamKey.GRID_COLOR, Color.GRAY, TParamKey.BACKGROUND_COLORS, new Color[]{Color.BLACK, Color.DARK_GRAY}, TParamKey.FOREGROUND_COLOR, Color.WHITE, TParamKey.HEADER_THEME, TableHeaderTheme.getTheme(themeID)});
            }
        }
        return hudTheme_;
    }

    public TableTheme copy() {
        TableTheme tcopy = new TableTheme();
        for (TParamKey key : this.themeProps_.keySet()) {
            Object val = this.themeProps_.get((Object)key);
            if (val == null) {
                LOGGER.trace("TableTheme param {} is unexpectedly null.");
            } else if (val instanceof Color[]) {
                Color[] valarray = (Color[])val;
                val = Arrays.copyOf(valarray, valarray.length);
            } else if (!(val instanceof Color)) {
                if (val instanceof TableHeaderTheme) {
                    val = ((TableHeaderTheme)val).copy();
                } else if (val instanceof Boolean) {
                    val = (Boolean)val;
                } else {
                    LOGGER.trace("TableTheme param {} has unexpected type {}", (Object)key, (Object)val.getClass().getSimpleName());
                }
            }
            tcopy.themeProps_.put(key, val);
        }
        return tcopy;
    }

    public static enum TParamKey {
        VERT_GRID_LINES,
        HORZ_GRID_LINES,
        GRID_COLOR,
        FOREGROUND_COLOR,
        BACKGROUND_COLORS,
        HEADER_THEME;

    }
}

