/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.SlowMessageListener;
import java.awt.Component;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlowMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void show(Component parent, String title, String message) {
        SlowMessage.show(parent, title, message, null);
    }

    public static void show(Component parent, String title, StringBuilder message) {
        SlowMessage.show(parent, title, message.toString(), null);
    }

    public static void show(Component parent, String title, String message, SlowMessageListener callback) {
        Component cc;
        Component component = cc = parent != null ? parent : GuiUtils.getActiveFrame();
        if (LOGGER.isTraceEnabled()) {
            if (cc == null) {
                LOGGER.trace("Parent frame is null.");
            } else {
                LOGGER.trace("Parent frame is class {}", (Object)cc.getClass().getSimpleName());
            }
        }
        String message2 = StringUtils.breakAndReassemble(message, 72);
        EventQueue.invokeLater(() -> {
            JOptionPane.showMessageDialog(cc, message2, title, 0);
            if (callback != null) {
                callback.slowMessageAcknowledged();
            }
        });
    }

    private SlowMessage() {
    }
}

