/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import gov.nasa.giss.text.DoubleDocument;
import gov.nasa.giss.text.IntegerDocument;
import gov.nasa.giss.text.PrintfFormat;
import javax.swing.JTextField;
import javax.swing.text.Document;

public final class GTextField
extends JTextField {
    private static final PrintfFormat PFORMAT_9G = new PrintfFormat("%.9g");

    private GTextField(String text) {
        this(null, text, 0);
    }

    private GTextField(Document doc, String text, int cols) {
        if (doc != null) {
            this.setDocument(doc);
        }
        if (text != null) {
            this.setText(text);
        }
        if (cols > 0) {
            this.setColumns(cols);
        }
    }

    public static GTextField create(String text, int cols) {
        GTextField jtf = new GTextField(null, text, cols);
        jtf.setHorizontalAlignment(2);
        return jtf;
    }

    public static GTextField createIntegerField(int initval) {
        GTextField jtf = new GTextField(new IntegerDocument(), Integer.toString(initval), 8);
        jtf.setHorizontalAlignment(4);
        return jtf;
    }

    public static GTextField createDoubleField() {
        GTextField jtf = new GTextField(new DoubleDocument(), PFORMAT_9G.sprintfx(0.0), 8);
        jtf.setHorizontalAlignment(4);
        return jtf;
    }

    public static GTextField createDoubleField(double initval) {
        GTextField jtf = new GTextField(new DoubleDocument(), PFORMAT_9G.sprintfx(initval), 8);
        jtf.setHorizontalAlignment(4);
        return jtf;
    }

    public static GTextField createDoubleField(double initval, int cols) {
        GTextField jtf = new GTextField(new DoubleDocument(), PFORMAT_9G.sprintfx(initval), cols);
        jtf.setHorizontalAlignment(4);
        return jtf;
    }

    public static GTextField createSearchField() {
        GTextField jtf = new GTextField(null, "", 0);
        jtf.putClientProperty("JTextField.variant", "search");
        jtf.setPreferredSize(null);
        jtf.setMaximumSize(null);
        return jtf;
    }
}

