/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.sources;

import gov.nasa.giss.img.ImageUtils;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.action.PanCombinePlotAction;
import gov.nasa.giss.panoply.action.PanCreatePlotAction;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.ToolBar;
import gov.nasa.giss.ui.ToolBarButton;
import gov.nasa.giss.util.PropertyList;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class PanSourcesToolBar
extends ToolBar {
    private static final PropertyList SOURCES_PROPS = PanProperties.SOURCES_PROPS;
    private final PanSourcesFrame parent_;
    private final ImageIcon hideInfoIcon_;
    private final ImageIcon showInfoIcon_;
    private final ToolBarButton createPlotBtn_;
    private final ToolBarButton combinePlotBtn_;
    private final ToolBarButton openDatasetBtn_;
    private final ToolBarButton removeOneBtn_;
    private final ToolBarButton removeAllBtn_;
    private final ToolBarButton toggleInfoBtn_;
    private final int lprefIconWidth_;
    private final int rprefIconWidth_;

    public PanSourcesToolBar(PanSourcesFrame parent) {
        this.parent_ = parent;
        this.setShowBottomEdge(false);
        PanActionHash actionHash = this.parent_.getActionHash();
        ImageIcon createPlotIcon = ImageUtils.getImageIconOfSize(this.getClass().getResource("resources/createplot_144x144.png"), 36, 36);
        ImageIcon combinePlotIcon = ImageUtils.getImageIconOfSize(this.getClass().getResource("resources/combineplot_144x144.png"), 36, 36);
        ImageIcon openDatasetIcon = ImageUtils.getImageIconOfSize(this.getClass().getResource("resources/opendataset_144x144.png"), 36, 36);
        ImageIcon removeOneIcon = ImageUtils.getImageIconOfSize(this.getClass().getResource("resources/removeone_144x144.png"), 36, 36);
        ImageIcon removeAllIcon = ImageUtils.getImageIconOfSize(this.getClass().getResource("resources/removeall_144x144.png"), 36, 36);
        this.showInfoIcon_ = ImageUtils.getImageIconOfSize(this.getClass().getResource("resources/showinfo_144x144.png"), 36, 36);
        this.hideInfoIcon_ = ImageUtils.getImageIconOfSize(this.getClass().getResource("resources/hideinfo_144x144.png"), 36, 36);
        this.createPlotBtn_ = new ToolBarButton(createPlotIcon, SOURCES_PROPS.getString("create-plot"), (Action)actionHash.get("create-plot"), SOURCES_PROPS.getString("create-plot-TIP"));
        this.combinePlotBtn_ = new ToolBarButton(combinePlotIcon, SOURCES_PROPS.getString("combine-plot"), (Action)actionHash.get("combine-plot"), SOURCES_PROPS.getString("combine-plot-tip"));
        this.openDatasetBtn_ = new ToolBarButton(openDatasetIcon, SOURCES_PROPS.getString("open-source"), (Action)actionHash.get("open-source"), SOURCES_PROPS.getString("open-source-tip"));
        this.removeOneBtn_ = new ToolBarButton(removeOneIcon, SOURCES_PROPS.getString("remove-one"), (Action)actionHash.get("remove-one"), SOURCES_PROPS.getString("remove-one-tip"));
        this.removeAllBtn_ = new ToolBarButton(removeAllIcon, SOURCES_PROPS.getString("remove-all"), (Action)actionHash.get("remove-all"), SOURCES_PROPS.getString("remove-all-tip"));
        this.toggleInfoBtn_ = new ToolBarButton(this.hideInfoIcon_, SOURCES_PROPS.getString("toggle-info"), (Action)actionHash.get("toggle-info"), SOURCES_PROPS.getString("toggle-info-tip"));
        this.add(this.createPlotBtn_);
        this.add(this.combinePlotBtn_);
        this.add(this.openDatasetBtn_);
        this.add(Box.createHorizontalGlue());
        this.add(this.removeOneBtn_);
        this.add(this.removeAllBtn_);
        this.add(Box.createHorizontalGlue());
        this.add(this.toggleInfoBtn_);
        this.lprefIconWidth_ = MathUtils.max(this.createPlotBtn_.getPreferredSize().width, this.combinePlotBtn_.getPreferredSize().width, this.openDatasetBtn_.getPreferredSize().width) + 4;
        this.rprefIconWidth_ = MathUtils.max(this.removeOneBtn_.getPreferredSize().width, this.removeAllBtn_.getPreferredSize().width, this.toggleInfoBtn_.getPreferredSize().width) + 4;
        this.refresh();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = new Dimension(this.getPreferredSize());
        d.width = 10000;
        return d;
    }

    public final void refresh() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        if (prefs.getBoolean("sources:toolbar.labels")) {
            this.createPlotBtn_.setText(SOURCES_PROPS.getString("create-plot"));
            this.combinePlotBtn_.setText(SOURCES_PROPS.getString("combine-plot"));
            this.openDatasetBtn_.setText(SOURCES_PROPS.getString("open-source"));
            this.removeOneBtn_.setText(SOURCES_PROPS.getString("remove-one"));
            this.removeAllBtn_.setText(SOURCES_PROPS.getString("remove-all"));
            if (prefs.getBoolean("sources:info.vis")) {
                this.toggleInfoBtn_.setText(SOURCES_PROPS.getString("hide-info"));
            } else {
                this.toggleInfoBtn_.setText(SOURCES_PROPS.getString("show-info"));
            }
        } else {
            this.openDatasetBtn_.setText(null);
            this.createPlotBtn_.setText(null);
            this.combinePlotBtn_.setText(null);
            this.removeOneBtn_.setText(null);
            this.removeAllBtn_.setText(null);
            this.toggleInfoBtn_.setText(null);
        }
        if (prefs.getBoolean("sources:info.vis")) {
            this.toggleInfoBtn_.setIcon(this.hideInfoIcon_);
        } else {
            this.toggleInfoBtn_.setIcon(this.showInfoIcon_);
        }
        this.refreshCreatePlotButton();
        this.refreshCombinePlotButton();
        this.createPlotBtn_.setPreferredSize(null);
        Dimension psize = this.createPlotBtn_.getPreferredSize();
        psize.width = this.lprefIconWidth_;
        this.createPlotBtn_.setPreferredSize(psize);
        this.combinePlotBtn_.setPreferredSize(psize);
        this.openDatasetBtn_.setPreferredSize(psize);
        this.createPlotBtn_.setMaximumSize(psize);
        this.combinePlotBtn_.setMaximumSize(psize);
        this.openDatasetBtn_.setMaximumSize(psize);
        this.removeOneBtn_.setPreferredSize(null);
        psize = this.removeOneBtn_.getPreferredSize();
        psize.width = this.rprefIconWidth_;
        this.removeOneBtn_.setPreferredSize(psize);
        this.removeAllBtn_.setPreferredSize(psize);
        this.toggleInfoBtn_.setPreferredSize(psize);
        this.removeOneBtn_.setMaximumSize(psize);
        this.removeAllBtn_.setMaximumSize(psize);
        this.toggleInfoBtn_.setMaximumSize(psize);
    }

    private void refreshCreatePlotButton() {
        PanActionHash actionHash = this.parent_.getActionHash();
        PanCreatePlotAction a = (PanCreatePlotAction)actionHash.get("create-plot");
        boolean createEnabled = a.isEnabled();
        this.createPlotBtn_.setEnabled(createEnabled && !PanPlotFrame.isAnimationInProgress());
    }

    private void refreshCombinePlotButton() {
        PanActionHash actionHash = this.parent_.getActionHash();
        final PanCombinePlotAction a = (PanCombinePlotAction)actionHash.get("combine-plot");
        this.combinePlotBtn_.setEnabled(a.isEnabled() && !PanPlotFrame.isAnimationInProgress());
        if (!this.combinePlotBtn_.isEnabled()) {
            return;
        }
        JPopupMenu popup = this.combinePlotBtn_.getComponentPopupMenu();
        if (popup == null) {
            popup = new JPopupMenu("Combine Plot");
            this.combinePlotBtn_.setComponentPopupMenu(popup);
        }
        popup.removeAll();
        final PanPlotFrame[] plotFrames = PanPlotFrame.getAllPlotFrames();
        int isize = plotFrames.length;
        for (int i = 0; i < isize; ++i) {
            final int ii = i;
            AbstractAction action = new AbstractAction("Combine in " + plotFrames[i].getTitle()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    a.addToExistingPlot(plotFrames[ii].getTitle());
                }
            };
            popup.add(action);
        }
    }
}

