/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.prefs.PanBookmarkNode;
import gov.nasa.giss.panoply.prefs.PanBookmarkType;
import gov.nasa.giss.panoply.prefs.PanExtraPrefsNode;
import gov.nasa.giss.panoply.ui.PanFrame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.DatasetUrl;

public class PanBookmark
extends PanBookmarkNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String UNNAMED = "Unnamed";
    private static String homeDir_ = System.getProperty("user.home");
    private PanBookmarkType btype_;
    private String addStr_;

    private PanBookmark() {
    }

    public PanBookmark(PanExtraPrefsNode parent, PanBookmarkType btype, Object address, String name) throws IOException, URISyntaxException {
        this(btype, address, name);
        super.setParent(parent);
    }

    public PanBookmark(String btype, Object address, String name) throws IOException, URISyntaxException {
        Objects.requireNonNull(btype, "Null bookmark type");
        if ("local".equals(btype) || "file".equals(btype)) {
            this.initMe(PanBookmarkType.LOCAL_DATASET, address, name);
        } else if ("remote".equals(btype)) {
            this.initMe(PanBookmarkType.REMOTE_DATASET, address, name);
        } else if ("catalog".equals(btype)) {
            this.initMe(PanBookmarkType.CATALOG, address, name);
        } else {
            throw new IllegalArgumentException("Uknown bookmark type");
        }
    }

    public PanBookmark(PanBookmarkType btype, Object address, String name) throws IOException, URISyntaxException {
        this.initMe(btype, address, name);
    }

    private void initMe(PanBookmarkType btype, Object address, String name) throws FileNotFoundException, IOException, URISyntaxException {
        block6: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block5: {
                                this.btype_ = btype;
                                this.setName(name);
                                if (!(address instanceof URI)) break block5;
                                this.addStr_ = ((URI)address).toString();
                                break block6;
                            }
                            if (!(address instanceof URL)) break block7;
                            this.addStr_ = ((URL)address).toString();
                            break block6;
                        }
                        if (!(address instanceof File)) break block8;
                        this.addStr_ = ((File)address).toString();
                        break block6;
                    }
                    if (!(address instanceof DatasetUrl)) break block9;
                    this.addStr_ = ((DatasetUrl)address).getTrueurl();
                    break block6;
                }
                if (!(address instanceof String)) break block10;
                this.addStr_ = (String)address;
                switch (btype) {
                    case LOCAL_DATASET: {
                        this.addStr_ = this.addStr_.replaceFirst("file:", "");
                        this.addStr_ = this.addStr_.replaceAll("/+", "/");
                        this.addStr_ = "file:" + this.addStr_;
                        URI uri = new URI(this.addStr_);
                        File f = new File(uri);
                        if (!f.exists()) {
                            throw new FileNotFoundException("No local file at address " + this.addStr_);
                        }
                        break block6;
                    }
                    case REMOTE_DATASET: 
                    case CATALOG: {
                        break block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown bookmark type");
                    }
                }
            }
            throw new IllegalArgumentException("Bookmark address must be a File, URL, or URI, or a String that may be parsed asone of those types.");
        }
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public Object getObject() {
        return this.addStr_;
    }

    @Override
    public String getName() {
        if (this.isNameSet()) {
            return super.getName();
        }
        String s = this.addStr_;
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    @Override
    public String getAddress() {
        if (this.addStr_ == null) {
            return "Null address";
        }
        Object s = this.addStr_;
        if (this.addStr_.startsWith("file:") && ((String)(s = ((String)s).substring(5))).startsWith(homeDir_)) {
            s = "~" + ((String)s).substring(homeDir_.length());
        }
        s = ((String)s).replaceAll("%20", " ");
        return s;
    }

    public PanBookmarkType getAccessType() {
        return this.btype_;
    }

    public void open(PanFrame pframe) {
        switch (this.btype_) {
            case LOCAL_DATASET: {
                PanFileUtils.openLocalDataset(pframe, this.addStr_);
                break;
            }
            case REMOTE_DATASET: {
                PanFileUtils.openDatasetUsingTask(this.addStr_);
                break;
            }
            case CATALOG: {
                PanFileUtils.openCatalogUsingTask(pframe, this.addStr_);
                break;
            }
            default: {
                LOGGER.debug("Switch default case: How did we get here? {}", (Object)this.btype_);
            }
        }
    }

    public PanBookmark copy() {
        try {
            String name = this.isNameSet() ? this.getName() : null;
            return new PanBookmark(this.getAccessType(), this.getObject(), name);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not copy bookmark due to {}", (Object)exc.getClass().getSimpleName());
            return null;
        }
    }
}

