/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui.table;

import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.panoply.plotui.table.PanArrayTableModel;

public final class PanArray1DTableModel
extends PanArrayTableModel {
    protected NcArray1D array_;
    protected Direction direction_;

    public PanArray1DTableModel(NcArray1D array, Direction direction) {
        this.array_ = array;
        this.direction_ = direction;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        int rows = this.array_.getLength();
        if (rows > 105000) {
            return 100001;
        }
        return rows;
    }

    public Class<String> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        return "Val";
    }

    @Override
    public String getRowName(int row) {
        int rows = this.array_.getLength();
        if (row == 100000 && rows > 105000) {
            return "more...";
        }
        try {
            int rowx;
            int n = rowx = this.flippedBT_ ? rows - 1 - row : row;
            if (this.showCellIndex_) {
                return Integer.toString(rowx + 1);
            }
            double val = this.array_.getAxis().valueAt(rowx);
            return this.hdrFormatter_.sprintfx(val);
        }
        catch (Exception exc) {
            return "";
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        int rows = this.array_.getLength();
        if (row == 100000 && rows > 105000) {
            return "more...";
        }
        try {
            int rowx = this.flippedBT_ ? rows - 1 - row : row;
            return this.valFormatter_.sprintfx(this.array_.valueAt(rowx));
        }
        catch (Exception ignore) {
            return "ERR";
        }
    }

    @Override
    public void setFlipBT(boolean flipped) {
        if (this.direction_ == Direction.HORIZONTAL) {
            // empty if block
        }
        this.flippedBT_ = flipped;
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
    }

    @Override
    public boolean canFlipLR() {
        return this.direction_ == Direction.HORIZONTAL;
    }

    @Override
    public void setFlipLR(boolean flipped) {
        if (this.direction_ == Direction.VERTICAL) {
            // empty if block
        }
        this.flippedLR_ = flipped;
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

