/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.panoply.plot.PanAxisTickFormatter;
import gov.nasa.giss.panoply.plot.PanLinePlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotScaleMeta;
import gov.nasa.giss.panoply.plot.PanScaleTick;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.panoply.util.PanGraphicUtils;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanVerticalLinePlot
extends PanLinePlot {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected PanAxisTickFormatter yAxisFormatter_;

    public PanVerticalLinePlot(PanPlotMeta pmeta) {
        super(pmeta);
        this.yAxisFormatter_ = new PanAxisTickFormatter(this.data1D_.getAxis());
        this.parameterChangedPrivate("all");
    }

    @Override
    public Point2D.Double transformXY2GridCoords(double x, double y) {
        double yval;
        double xval;
        this.prepareToPaint();
        if (x < (double)this.gridLeft_ || x > (double)this.gridRight_) {
            return null;
        }
        if (y < (double)this.gridTop_ || y > (double)this.gridBottom_) {
            return null;
        }
        PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        double logScaleMin = 0.0;
        double logScaleMax = 0.0;
        switch (smethod) {
            case LOG10: {
                logScaleMin = Math.log10(scaleMin);
                logScaleMax = Math.log10(scaleMax);
                xval = scaleMin - (logScaleMax - logScaleMin) * (y - (double)this.gridLeft_) / (double)this.gridWidth_;
                xval = Math.pow(10.0, xval);
                break;
            }
            case LOG_E: {
                logScaleMin = Math.log(scaleMin);
                logScaleMax = Math.log(scaleMax);
                xval = logScaleMin - (logScaleMax - logScaleMin) * (x - (double)this.gridLeft_) / (double)this.gridWidth_;
                xval = Math.pow(Math.E, xval);
                break;
            }
            default: {
                xval = scaleMin + (scaleMax - scaleMin) * (x - (double)this.gridLeft_) / (double)this.gridWidth_;
            }
        }
        switch (this.yaxisMethod_) {
            case LOG10: {
                yval = this.logBottom_ - (this.logTop_ - this.logBottom_) * (y - (double)this.gridBottom_) / (double)this.gridHeight_;
                yval = Math.pow(10.0, yval);
                break;
            }
            default: {
                yval = this.bBound_ - (this.tBound_ - this.bBound_) * (y - (double)this.gridBottom_) / (double)this.gridHeight_;
            }
        }
        return new Point2D.Double(xval, yval);
    }

    @Override
    protected void drawXAxis(Graphics2D g2d) {
        if (this.axesOffset_ && this.includeAxes_) {
            int sfactor = this.pmeta_.getInt("size.factor");
            g2d.setColor(this.getForeground());
            g2d.setStroke(PanGraphicUtils.solidStroke(100, sfactor));
            GraphicUtils.drawLine(g2d, this.gridLeft_, this.xAxisY_, this.gridRight_, this.xAxisY_);
        }
        this.drawXAxisTicks(g2d);
    }

    private void drawXAxisTicks(Graphics2D g2d) {
        PanScaleTick[] ticks;
        double xdelta;
        PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        PrintfFormat formatter = smeta.getFormatter();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        double logScaleMin = 0.0;
        double logScaleMax = 0.0;
        switch (smethod) {
            case LOG10: {
                logScaleMin = Math.log10(scaleMin);
                logScaleMax = Math.log10(scaleMax);
                xdelta = (logScaleMax - logScaleMin) / (double)this.gridWidth_;
                break;
            }
            case LOG_E: {
                logScaleMin = Math.log(scaleMin);
                logScaleMax = Math.log(scaleMax);
                xdelta = (logScaleMax - logScaleMin) / (double)this.gridWidth_;
                break;
            }
            default: {
                xdelta = (scaleMax - scaleMin) / (double)this.gridWidth_;
            }
        }
        double xscale = 1.0 / xdelta;
        for (PanScaleTick tick : ticks = smeta.getTicks()) {
            boolean isNearEdge;
            float x;
            double value = tick.getValue();
            double logValue = tick.getAlternativeValue();
            switch (smethod) {
                case LOG10: 
                case LOG_E: {
                    x = (float)((logValue - logScaleMin) * xscale);
                    break;
                }
                default: {
                    x = (float)((value - scaleMin) * xscale);
                }
            }
            x = this.gridLeft_ + x;
            boolean bl = isNearEdge = Math.abs(x - this.gridLeft_) < EDGE_TOLERANCE || Math.abs(x - this.gridRight_) < EDGE_TOLERANCE;
            if (tick.isMajor()) {
                switch (smethod) {
                    case LOG_E: {
                        this.drawXAxisTickLabelE(g2d, logValue, x);
                        break;
                    }
                    default: {
                        String labelstr = formatter.sprintfx(value);
                        this.drawXAxisTickLabel(g2d, labelstr, x);
                    }
                }
                if (this.gridStroke_ != null && !isNearEdge) {
                    g2d.setColor(this.getForeground());
                    g2d.setStroke(this.gridStroke_);
                    GraphicUtils.drawLine(g2d, x, this.gridTop_, x, this.gridBottom_);
                }
            }
            float tt = tick.isMajor() ? this.tickLengthMajor_ : this.tickLengthMinor_;
            g2d.setColor(this.getForeground());
            g2d.setStroke(this.tickStroke_);
            if (this.axesOffset_ && this.includeAxes_) {
                GraphicUtils.drawLine(g2d, x, this.xAxisY_ + 0.5f * tt, x, this.xAxisY_ - 0.5f * tt);
                continue;
            }
            if (isNearEdge) continue;
            GraphicUtils.drawLine(g2d, x, this.gridTop_, x, this.gridTop_ + tt);
            GraphicUtils.drawLine(g2d, x, this.gridBottom_, x, this.gridBottom_ - tt);
        }
        if (this.axesOffset_ && this.gridStroke_ != null) {
            g2d.setColor(this.getForeground());
            g2d.setStroke(this.gridStroke_);
            GraphicUtils.drawLine(g2d, this.gridLeft_, this.gridTop_, this.gridLeft_, this.gridBottom_);
            GraphicUtils.drawLine(g2d, this.gridRight_, this.gridTop_, this.gridRight_, this.gridBottom_);
        }
    }

    @Override
    protected String getXAxisLabelStr() {
        if (this.pmeta_.getBoolean("scale.label.custom")) {
            return this.pmeta_.getString("scale.label.text");
        }
        return this.data_.getDescription();
    }

    @Override
    protected int drawYAxis(Graphics2D g2d) {
        if (this.axesOffset_ && this.includeAxes_) {
            int sfactor = this.pmeta_.getInt("size.factor");
            g2d.setColor(this.getForeground());
            g2d.setStroke(PanGraphicUtils.solidStroke(100, sfactor));
            GraphicUtils.drawLine(g2d, this.yAxisX_, this.gridTop_, this.yAxisX_, this.gridBottom_);
        }
        switch (this.yaxisMethod_) {
            case LOG10: {
                return this.drawLogYAxisTicks(g2d);
            }
        }
        return this.drawScalarYAxisTicks(g2d);
    }

    private int drawScalarYAxisTicks(Graphics2D g2d) {
        int maxLabelWidth = 0;
        int divs = this.yMajorDiv_ * this.yMinorDiv_;
        double invDivs = 1.0 / (double)divs;
        float invDivsF = (float)invDivs;
        double delta = (this.tBound_ - this.bBound_) * invDivs;
        for (int i = 0; i <= divs; ++i) {
            boolean isMajor;
            float y = this.gridBottom_ - (float)i * this.gridHeight_ * invDivsF;
            boolean isNearEdge = Math.abs(y - this.gridTop_) < EDGE_TOLERANCE || Math.abs(y - this.gridBottom_) < EDGE_TOLERANCE;
            boolean bl = isMajor = i % this.yMinorDiv_ == 0;
            if (isMajor) {
                double val = this.bBound_ + (double)i * delta;
                String labelstr = this.yAxisFormatter_.format(val);
                int labelWidth = this.drawYAxisTickLabel(g2d, labelstr, y);
                maxLabelWidth = Math.max(maxLabelWidth, labelWidth);
                if (this.gridStroke_ != null && !isNearEdge) {
                    g2d.setColor(this.getForeground());
                    g2d.setStroke(this.gridStroke_);
                    GraphicUtils.drawLine(g2d, this.gridLeft_, y, this.gridRight_, y);
                }
            }
            float tt = i % this.yMinorDiv_ == 0 ? this.tickLengthMajor_ : this.tickLengthMinor_;
            g2d.setColor(this.getForeground());
            g2d.setStroke(this.tickStroke_);
            if (this.axesOffset_ && this.includeAxes_) {
                GraphicUtils.drawLine(g2d, this.yAxisX_ - 0.5f * tt, y, this.yAxisX_ + 0.5f * tt, y);
                continue;
            }
            if (isNearEdge) continue;
            GraphicUtils.drawLine(g2d, this.gridLeft_, y, this.gridLeft_ + tt, y);
            GraphicUtils.drawLine(g2d, this.gridRight_, y, this.gridRight_ - tt, y);
        }
        return maxLabelWidth;
    }

    protected int drawLogYAxisTicks(Graphics2D g2d) {
        if (this.isPatternTimeAxis_) {
            LOGGER.warn("Cannot draw log ticks for a time axis.");
            return 0;
        }
        int maxLabelWidth = 0;
        double logrange = this.logTop_ - this.logBottom_;
        double logmin = Math.min(this.logTop_, this.logBottom_);
        double logmax = Math.max(this.logTop_, this.logBottom_);
        int iMin = (int)Math.floor(logmin) - 1;
        int iMax = (int)Math.floor(logmax) + 1;
        int intDiv = iMax - iMin;
        int intStep = (intDiv - 2) / 10 + 1;
        boolean majorMarked = false;
        block0: for (int j = iMin; j <= iMax; ++j) {
            double value0 = Math.pow(10.0, j);
            for (int k = 0; k < 9; ++k) {
                boolean isNearEdge;
                double value;
                double logval;
                if (k > 0 && intDiv > 20 || (logval = Math.log10(value = value0 * (1.0 + (double)k))) < logmin) continue;
                if (logval > logmax) continue block0;
                float pct = (float)((logval - this.logBottom_) / logrange);
                float y = this.gridBottom_ - pct * this.gridHeight_;
                boolean bl = isNearEdge = Math.abs(y - this.gridTop_) < EDGE_TOLERANCE || Math.abs(y - this.gridBottom_) < EDGE_TOLERANCE;
                if (k == 0 && j % intStep == 0) {
                    String labelstr = this.yAxisFormatter_.format(Math.pow(10.0, j));
                    int labelWidth = this.drawYAxisTickLabel(g2d, labelstr, y);
                    maxLabelWidth = Math.max(maxLabelWidth, labelWidth);
                    if (this.gridStroke_ != null && !isNearEdge) {
                        g2d.setColor(this.getForeground());
                        g2d.setStroke(this.gridStroke_);
                        GraphicUtils.drawLine(g2d, this.gridLeft_, y, this.gridRight_, y);
                    }
                    majorMarked = true;
                }
                float tt = k == 0 ? this.tickLengthMajor_ : this.tickLengthMinor_;
                g2d.setColor(this.getForeground());
                g2d.setStroke(this.tickStroke_);
                if (this.axesOffset_ && this.includeAxes_) {
                    GraphicUtils.drawLine(g2d, this.yAxisX_ - 0.5f * tt, y, this.yAxisX_ + 0.5f * tt, y);
                    continue;
                }
                if (isNearEdge) continue;
                GraphicUtils.drawLine(g2d, this.gridLeft_, y, this.gridLeft_ + tt, y);
                GraphicUtils.drawLine(g2d, this.gridRight_, y, this.gridRight_ - tt, y);
            }
        }
        if (!majorMarked) {
            g2d.setColor(this.getForeground());
            if (this.axesOffset_ && this.includeAxes_) {
                g2d.setStroke(this.tickStroke_);
                float tt = this.tickLengthMinor_;
                GraphicUtils.drawLine(g2d, this.yAxisX_ - 0.5f * tt, this.gridTop_ + 0.0f, this.yAxisX_ + 0.5f * tt, this.gridTop_ + 0.0f);
                GraphicUtils.drawLine(g2d, this.yAxisX_ - 0.5f * tt, this.gridTop_ + this.gridHeight_, this.yAxisX_ + 0.5f * tt, this.gridTop_ + this.gridHeight_);
            }
            String labelstr = this.yAxisFormatter_.format(Math.pow(10.0, this.logTop_));
            int labelWidth = this.drawYAxisTickLabel(g2d, labelstr, this.gridTop_ + 0.0f);
            maxLabelWidth = Math.max(maxLabelWidth, labelWidth);
            labelstr = this.yAxisFormatter_.format(Math.pow(10.0, this.logBottom_));
            labelWidth = this.drawYAxisTickLabel(g2d, labelstr, this.gridTop_ + this.gridHeight_);
            maxLabelWidth = Math.max(maxLabelWidth, labelWidth);
        }
        return maxLabelWidth;
    }

    @Override
    protected String getYAxisLabelStr() {
        if (this.yAxisLabelText_ != null) {
            return this.yAxisLabelText_;
        }
        if (this.yaxisMethod_ == PanAxisMethod.INDEX) {
            return this.data1D_.getAxisShortName() + " (Grid Index)";
        }
        if (this.yAxisFormatter_.isFormattedTime()) {
            if (this.yAxisFormatter_.getPattern().charAt(0) == '%') {
                return "Time (" + this.yAxisFormatter_.getUnitsStr() + ")";
            }
            return "Time";
        }
        return this.data1D_.getAxisLabel();
    }

    @Override
    protected void drawCurve(Graphics2D g2d) {
        double xdelta;
        Rectangle oldClip = g2d.getClipBounds();
        Rectangle rr = new Rectangle((int)this.gridLeft_, (int)this.gridTop_ - 8, (int)this.gridWidth_, (int)this.gridHeight_ + 16);
        Rectangle ri = oldClip.intersection(rr);
        g2d.setClip(ri);
        PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        boolean isLogScale = false;
        boolean isLogAxis = this.yaxisMethod_ == PanAxisMethod.LOG10;
        double logScaleMin = 0.0;
        double logScaleMax = 0.0;
        switch (smethod) {
            case LOG10: {
                isLogScale = true;
                logScaleMin = Math.log10(scaleMin);
                logScaleMax = Math.log10(scaleMax);
                xdelta = (logScaleMax - logScaleMin) / (double)this.gridWidth_;
                break;
            }
            case LOG_E: {
                isLogScale = true;
                logScaleMin = Math.log(scaleMin);
                logScaleMax = Math.log(scaleMax);
                xdelta = (logScaleMax - logScaleMin) / (double)this.gridWidth_;
                break;
            }
            default: {
                isLogScale = false;
                xdelta = (scaleMax - scaleMin) / (double)this.gridWidth_;
            }
        }
        double xscale = 1.0 / xdelta;
        double ydelta = isLogAxis ? (this.logTop_ - this.logBottom_) / (double)this.gridHeight_ : (this.tBound_ - this.bBound_) / (double)this.gridHeight_;
        double yscale = 1.0 / ydelta;
        double value = this.data1D_.valueAt(0, 0);
        int istrokes = this.isCompare_ ? 2 : 1;
        for (int istroke = 0; istroke < istrokes; ++istroke) {
            if (this.lineStrokes_[istroke] == null) continue;
            g2d.setColor(this.lineColors_[istroke]);
            g2d.setStroke(this.lineStrokes_[istroke]);
            boolean lastPtWasGood = false;
            GeneralPath path = new GeneralPath();
            int numPts = this.data1D_.getAxisLength(istroke);
            int segments = 1;
            if (numPts > 50000) {
                segments = numPts / 45000 + 1;
            }
            LOGGER.trace("reduced numPts {}, segments {}", (Object)numPts, (Object)segments);
            for (int k = 0; k < segments; ++k) {
                int j0 = k * 45000;
                int j1 = Math.min((k + 1) * 45000, numPts - 1);
                path.reset();
                lastPtWasGood = false;
                for (int j = j0; j <= j1; ++j) {
                    float y;
                    double axisY = this.data1D_.axisValueAt(istroke, j);
                    value = this.data1D_.valueAt(istroke, j);
                    if (!Double.isNaN(value) && !Double.isInfinite(value)) {
                        switch (smethod) {
                            case LOG10: {
                                value = Math.log10(value);
                                break;
                            }
                            case LOG_E: {
                                value = Math.log(value);
                                break;
                            }
                        }
                    }
                    if (Double.isNaN(value)) {
                        if (lastPtWasGood) {
                            g2d.draw(path);
                            path.reset();
                        }
                        lastPtWasGood = false;
                        continue;
                    }
                    float x = Double.isInfinite(value) ? (value < 0.0 ? -1.0E9f : 1.0E9f) : (isLogScale ? (float)((value - logScaleMin) * xscale) : (float)((value - scaleMin) * xscale));
                    if (isLogAxis) {
                        if (Double.isNaN(axisY = Math.log10(axisY))) {
                            if (lastPtWasGood) {
                                g2d.draw(path);
                                path.reset();
                            }
                            lastPtWasGood = false;
                            continue;
                        }
                        y = (float)((axisY - this.logBottom_) * yscale);
                    } else {
                        y = (float)((axisY - this.bBound_) * yscale);
                    }
                    if (lastPtWasGood) {
                        path.lineTo(x + this.gridLeft_, this.gridBottom_ - y);
                    } else {
                        path.moveTo(x + this.gridLeft_, this.gridBottom_ - y);
                    }
                    lastPtWasGood = true;
                }
                g2d.draw(path);
                path.reset();
            }
        }
        g2d.setClip(oldClip);
    }

    @Override
    public String describePoint(int x, int y) {
        Point2D.Double p2dClose;
        double xdelta;
        Point2D.Double p2d = this.transformXY2GridCoords(x, y);
        if (p2d == null) {
            return null;
        }
        PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        double logScaleMin = 0.0;
        double logScaleMax = 0.0;
        switch (smethod) {
            case LOG10: {
                logScaleMin = Math.log10(scaleMin);
                logScaleMax = Math.log10(scaleMax);
                xdelta = (logScaleMax - logScaleMin) / (double)this.gridWidth_;
                break;
            }
            case LOG_E: {
                logScaleMin = Math.log(scaleMin);
                logScaleMax = Math.log(scaleMax);
                xdelta = (logScaleMax - logScaleMin) / (double)this.gridWidth_;
                break;
            }
            default: {
                xdelta = (scaleMax - scaleMin) / (double)this.gridWidth_;
            }
        }
        double xscale = 1.0 / xdelta;
        double leastDX = -1.0;
        int diyForLeast = -1;
        int istrokes = this.isCompare_ ? 2 : 1;
        for (int istroke = 0; istroke < istrokes; ++istroke) {
            for (int diy = -3; diy <= 3; ++diy) {
                float dx;
                double value;
                p2dClose = this.transformXY2GridCoords(x, y + diy);
                if (p2dClose == null || Double.isNaN(value = this.data1D_.valueAtAxisPt(istroke, p2dClose.y)) || Double.isInfinite(value)) continue;
                switch (smethod) {
                    case LOG10: {
                        value = Math.log10(value);
                        break;
                    }
                    case LOG_E: {
                        value = Math.log(value);
                        break;
                    }
                }
                if (Double.isNaN(value)) continue;
                switch (smethod) {
                    case LOG10: 
                    case LOG_E: {
                        dx = Double.isNaN(value) ? 1000.0f : (float)((double)x - ((double)this.gridLeft_ + (value - logScaleMin) * xscale));
                        break;
                    }
                    default: {
                        dx = Double.isNaN(value) ? 1000.0f : (float)((double)x - ((double)this.gridLeft_ + (value - scaleMin) * xscale));
                    }
                }
                double absDX = Math.abs(dx);
                if (!(leastDX < 0.0) && !(absDX < leastDX)) continue;
                leastDX = absDX;
                diyForLeast = diy;
            }
        }
        if (leastDX < 0.0 || leastDX > 10.0) {
            return null;
        }
        p2dClose = this.transformXY2GridCoords(x, y + diyForLeast);
        StringBuilder sb = new StringBuilder();
        sb.append("Y: ").append(this.yAxisFormatter_.formatRaw(p2dClose.y));
        if (this.isPatternTimeAxis_ && this.timeAxis_ != null) {
            sb.append(" (Time ").append(this.timeAxis_.formatValue(p2dClose.y)).append(')');
        }
        sb.append('\n');
        this.data1D_.describeDataAtAxisPt(sb, p2dClose.y);
        return sb.toString();
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private void parameterChangedPrivate(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("yaxis.tick.format")) {
            String s = this.pmeta_.getString("yaxis.tick.format");
            this.yAxisFormatter_.setPattern(s);
        }
        if (changeAll || pname.contains("yaxis.begin") || pname.contains("yaxis.end") || pname.contains("yaxis.method") || pname.contains("yaxis.units")) {
            double bBound = this.pmeta_.getDouble("yaxis.begin");
            double tBound = this.pmeta_.getDouble("yaxis.end");
            this.data1D_.setAxisBounds(bBound, tBound);
            this.needsDataRedraw_ = true;
        }
    }
}

