/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.graphics.plot.PlotPropertyMap;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.plot.PanPlot;
import gov.nasa.giss.panoply.plot.PanPlotConstraints;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.util.PanColorbarLabelLocation;
import gov.nasa.giss.panoply.util.PanColorbarLocation;
import gov.nasa.giss.panoply.util.PanPlotType;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotLayoutMeta
extends PlotPropertyMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int GWIDTH100 = 720;
    private static final int MARGIN100 = 6;
    private static final int GAP100 = 5;
    private final PanPlotMeta parent_;
    private boolean initialized_;

    protected PanPlotLayoutMeta(PanPlotMeta parent) {
        this.parent_ = parent;
    }

    public void setInitialized() {
        this.initialized_ = true;
        this.update();
    }

    private synchronized void update() {
        PanPlot pplot;
        float oheight;
        if (!this.initialized_) {
            return;
        }
        PanPlotType plotType = this.parent_.getType();
        int sfactor = (Integer)this.get("size.factor");
        float scaling = 0.01f * (float)sfactor;
        float hfactor = 0.01f * (float)((Integer)this.get("size.height")).intValue();
        float wfactor = 0.01f * (float)((Integer)this.get("size.width")).intValue();
        float vgap = 5.0f * scaling;
        boolean includeTitles = (Boolean)this.get("include.title");
        boolean includeColorbar = (Boolean)this.get("include.colorbar");
        boolean includeStrokeInfo = (Boolean)this.get("include.strokeinfo");
        boolean includeAxes = (Boolean)this.get("include.axes");
        boolean includeNotes = (Boolean)this.get("include.footnotes");
        boolean includeMargins = (Boolean)this.get("include.margins");
        PanColorbarLocation cbarLoc = PanColorbarLocation.matching((String)this.get("colorbar.location"));
        boolean horzColorbar = plotType.isLinePlot() ? false : cbarLoc.isHorizontal();
        float titleFHeight = scaling * ((Float)this.get("title.size")).floatValue();
        float subtitleFHeight = scaling * ((Float)this.get("subtitle.size")).floatValue();
        float scaleLabelFHeight = scaling * ((Float)this.get("scale.label.size")).floatValue();
        float scaleTickFHeight = scaling * ((Float)this.get("scale.tick.size")).floatValue();
        float xAxisLabelFHeight = 0.0f;
        float xAxisTickFHeight = 0.0f;
        if (!plotType.isLonLatMap()) {
            xAxisLabelFHeight = plotType == PanPlotType.VERT_LINE ? scaleLabelFHeight : scaling * PanPlotConstraints.constrainAxisLabelSize(((Float)this.get("xaxis.label.size")).floatValue());
            xAxisTickFHeight = plotType == PanPlotType.VERT_LINE ? scaleTickFHeight : scaling * PanPlotConstraints.constrainAxisTickLabelSize(((Float)this.get("xaxis.tick.size")).floatValue());
        }
        float notesFHeight = scaling * ((Float)this.get("footnote.size")).floatValue();
        float wmain = 720.0f * scaling + vgap;
        int wgridding = (int)(720.0f * scaling * wfactor);
        int hgridding = (int)(720.0f * scaling * hfactor);
        if (wgridding % 2 > 0) {
            ++wgridding;
        }
        if (hgridding % 2 > 0) {
            ++hgridding;
        }
        float hmain = hgridding;
        if (plotType.isLonLatMap()) {
            wmain += vgap;
            hmain += vgap;
        } else if (includeAxes) {
            hmain += vgap;
            hmain += 3.0f * scaling + 1.25f + xAxisTickFHeight + 1.25f * xAxisLabelFHeight;
            if (((Boolean)this.get("axes.offset")).booleanValue()) {
                hmain += 6.0f * scaling;
            }
        }
        int wmainInt = (int)wmain;
        int hmainInt = (int)hmain;
        if (wmainInt % 2 > 0) {
            ++wmainInt;
        }
        if (hmainInt % 2 > 0) {
            ++hmainInt;
        }
        int ymargin = 0;
        int wtotal = wmainInt;
        if (includeMargins) {
            int stdmargin = (int)(6.0f * scaling);
            wtotal += 2 * stdmargin;
            ymargin = stdmargin;
        }
        Rectangle titleBounds = new Rectangle();
        Rectangle subtitleBounds = new Rectangle();
        Rectangle figureBounds = new Rectangle();
        Rectangle colorbarBounds = new Rectangle();
        Rectangle strokeInfoBounds = new Rectangle();
        Rectangle noteBounds = new Rectangle();
        float y = 0.0f;
        if (includeMargins) {
            y += (float)ymargin;
        }
        if (includeTitles) {
            titleBounds.x = 0;
            titleBounds.y = (int)y;
            titleBounds.width = wmainInt;
            titleBounds.height = (int)(1.25f * titleFHeight);
            y += (float)titleBounds.height;
            subtitleBounds.x = 0;
            subtitleBounds.y = (int)(y += 0.5f * vgap);
            subtitleBounds.width = wmainInt;
            subtitleBounds.height = (int)(1.25f * subtitleFHeight);
            y += (float)subtitleBounds.height;
            y += vgap;
        }
        figureBounds.x = 0;
        figureBounds.y = (int)y;
        figureBounds.width = wmainInt;
        figureBounds.height = hmainInt;
        y += hmain;
        int xadd = 0;
        if (plotType.isLinePlot()) {
            if (includeStrokeInfo) {
                oheight = 2.0f * xAxisLabelFHeight;
                strokeInfoBounds.x = 0;
                strokeInfoBounds.y = (int)(y += 1.5f * vgap);
                strokeInfoBounds.width = wmainInt;
                strokeInfoBounds.height = (int)oheight;
                y += oheight;
            }
        } else {
            PanColorbarLabelLocation cbarLabelLoc = PanColorbarLabelLocation.matching((String)this.get("colorbar.label.location"));
            float oheight2 = 14.0f * scaling + vgap + scaleTickFHeight;
            if (includeColorbar) {
                if (horzColorbar) {
                    if (cbarLabelLoc != PanColorbarLabelLocation.NONE) {
                        oheight2 += scaleLabelFHeight + vgap;
                    }
                    colorbarBounds.x = 0;
                    colorbarBounds.y = (int)(y += 1.5f * vgap);
                    colorbarBounds.width = wmainInt;
                    colorbarBounds.height = (int)oheight2;
                    y += oheight2;
                } else {
                    float ioff = 3.0f * vgap;
                    colorbarBounds.x = figureBounds.width + (int)ioff;
                    colorbarBounds.y = figureBounds.y;
                    float shiftLeft = 0.0f;
                    shiftLeft = 0.5f * ((float)(figureBounds.width - wgridding) - vgap);
                    colorbarBounds.x = (int)((float)colorbarBounds.x - shiftLeft);
                    colorbarBounds.width = (int)(0.6 * (double)sfactor);
                    if (cbarLabelLoc == PanColorbarLabelLocation.ABOVE) {
                        colorbarBounds.width = (int)((float)colorbarBounds.width + (scaleLabelFHeight + vgap));
                    }
                    colorbarBounds.width = (int)((float)colorbarBounds.width + 0.5f * scaleLabelFHeight);
                    colorbarBounds.height = plotType.isLonLatMap() ? hmainInt : hgridding;
                    xadd = Math.max(0, colorbarBounds.width + (int)(ioff - shiftLeft));
                    wtotal += xadd;
                }
            } else {
                colorbarBounds.x = -wmainInt - 100;
                colorbarBounds.y = 0;
                colorbarBounds.width = wmainInt;
                colorbarBounds.height = (int)oheight2;
            }
        }
        if (includeNotes) {
            oheight = 1.25f * notesFHeight;
            noteBounds.x = 0;
            noteBounds.y = (int)(y += 1.5f * vgap);
            noteBounds.width = wmainInt;
            noteBounds.height = (int)oheight;
            y += oheight;
        }
        if (includeMargins) {
            y += (float)ymargin;
        }
        wtotal = wtotal / 16 * 16 + (wtotal % 16 > 0 ? 16 : 0);
        int wtotal16 = wtotal / 16 * 16 + (wtotal % 16 > 0 ? 16 : 0);
        int xmargin = (wtotal16 - figureBounds.width - xadd) / 2;
        if (includeTitles) {
            titleBounds.x = xmargin;
            subtitleBounds.x = xmargin;
        }
        figureBounds.x += xmargin;
        if (plotType.isLinePlot()) {
            if (includeColorbar) {
                strokeInfoBounds.x += xmargin;
            }
        } else if (includeColorbar) {
            colorbarBounds.x = horzColorbar ? xmargin : (colorbarBounds.x += xmargin);
        }
        if (includeNotes) {
            noteBounds.x = xmargin;
        }
        int yint = (int)y;
        int htotal = yint / 16 * 16 + (yint % 16 > 0 ? 16 : 0);
        int yextra = htotal - yint;
        if (includeNotes) {
            if (yextra > 6) {
                noteBounds.y += 4;
                yextra -= 4;
            } else if (yextra > 2) {
                noteBounds.y += 2;
                yextra -= 2;
            }
        }
        int yshift = (int)(0.5 * (double)yextra);
        if (includeTitles) {
            titleBounds.y += yshift;
            subtitleBounds.y += yshift;
        }
        figureBounds.y += yshift;
        if (plotType.isLinePlot()) {
            if (includeStrokeInfo) {
                strokeInfoBounds.y += yshift;
            }
        } else if (includeColorbar) {
            colorbarBounds.y += yshift;
        }
        if (includeNotes) {
            noteBounds.y += yshift;
        }
        Rectangle noteBoundsLeft = (Rectangle)noteBounds.clone();
        Rectangle noteBoundsCenter = (Rectangle)noteBounds.clone();
        Rectangle noteBoundsRight = (Rectangle)noteBounds.clone();
        if (includeNotes) {
            noteBoundsLeft.width = (int)(0.4 * (double)noteBounds.width);
            noteBoundsCenter.width = (int)(0.8 * (double)noteBounds.width);
            noteBoundsCenter.x = noteBounds.x + noteBounds.width / 2 - noteBoundsCenter.width / 2;
            noteBoundsRight.width = (int)(0.4 * (double)noteBounds.width);
            noteBoundsRight.x = noteBounds.x + noteBounds.width - noteBoundsRight.width;
        }
        int vlength = (int)(20.0 * (double)scaling);
        Dimension psize = new Dimension(wtotal, htotal);
        this.put("size.pixels", (Object)psize);
        this.put("size.gridding", (Object)new Dimension(wgridding, hgridding));
        this.put("bounds.figure", (Object)figureBounds);
        this.put("bounds.title", (Object)titleBounds);
        this.put("bounds.subtitle", (Object)subtitleBounds);
        this.put("bounds.colorbar", (Object)colorbarBounds);
        this.put("bounds.strokeinfo", (Object)strokeInfoBounds);
        this.put("bounds.note.left", (Object)noteBoundsLeft);
        this.put("bounds.note.center", (Object)noteBoundsCenter);
        this.put("bounds.note.right", (Object)noteBoundsRight);
        this.put("vector.length", (Object)vlength);
        PanData pdata = this.parent_.getData();
        if (pdata instanceof PanData2D) {
            ((PanData2D)pdata).setSize(wgridding, hgridding);
        }
        if ((pplot = this.parent_.getPlot()) != null) {
            pplot.setSize(psize);
        }
    }

    @Override
    public void set(String key, Object value) {
        super.set(key, value);
        this.update();
    }

    @Override
    public void addPlotPropertyListener(PlotPropertyListener ll) {
        LOGGER.warn("This subclass does not accept listeners.");
    }
}

