/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.log;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.Panoply;
import gov.nasa.giss.panoply.log.PanLoggingGroup;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.util.LogFormatter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanLoggingUtils {
    private static final String LOG_FILE = "panoply.log";
    private static boolean initted_;
    private static File logFile_;
    private static PrintStream loggerPS_;
    private static ArrayList<Handler> xtraHandlers;

    public static void initLogging() {
        boolean useLogfile = PanProperties.VERSION_PROPS.getString("use-logfile").equalsIgnoreCase("true");
        PanLoggingUtils.initLogging(useLogfile);
    }

    public static void initLogging(boolean useLogfile) {
        if (initted_) {
            PanLoggingUtils.getClassLogger().info("Logging previously initialized.");
            return;
        }
        if (useLogfile) {
            PanLoggingUtils.redirectToFile();
        }
        PanLoggingUtils.readConfig();
        initted_ = true;
    }

    private static void redirectToFile() {
        File logsDir = FileUtils.getGISSLogsDirectory();
        if (logsDir == null) {
            PanLoggingUtils.getClassLogger().warn("Logdir object is null.");
            PanLoggingUtils.getClassLogger().warn("Logging will continue on STDOUT/STDERR.");
            return;
        }
        try {
            if (!logsDir.exists()) {
                PanLoggingUtils.getClassLogger().info("Creating logs directory {}", (Object)logsDir);
                logsDir.mkdirs();
            }
        }
        catch (Exception exc) {
            PanLoggingUtils.getClassLogger().warn("Exception creating logdir: {}", (Object)exc.toString());
            PanLoggingUtils.getClassLogger().warn("Logging will continue on STDOUT/STDERR.");
            return;
        }
        logFile_ = new File(logsDir, LOG_FILE);
        if (logFile_ == null) {
            PanLoggingUtils.getClassLogger().warn("Logfile object is null.");
            PanLoggingUtils.getClassLogger().warn("Logging will continue on STDOUT/STDERR.");
            return;
        }
        PanLoggingUtils.getClassLogger().debug("Redirecting STDOUT and STDERR to log file at {}", (Object)logFile_);
        try {
            FileOutputStream fos = new FileOutputStream(logFile_);
            loggerPS_ = new PrintStream(fos, true);
        }
        catch (Exception exc) {
            PanLoggingUtils.getClassLogger().warn("Could not create logfile PrintStream: {}", (Object)exc.getMessage());
            PanLoggingUtils.getClassLogger().warn("Logging will continue on STDOUT/STDERR.");
            return;
        }
        try {
            System.setOut(loggerPS_);
        }
        catch (Exception exc) {
            PanLoggingUtils.getClassLogger().warn("Could not redirect STDOUT.");
            PanLoggingUtils.getClassLogger().warn("Exception reported was {}", (Object)exc.getMessage());
        }
        try {
            System.setErr(loggerPS_);
        }
        catch (Exception exc) {
            PanLoggingUtils.getClassLogger().warn("Could not redirect STDERR.");
            PanLoggingUtils.getClassLogger().warn("Exception reported was {}", (Object)exc.getMessage());
        }
    }

    private static void readConfig() {
        block9: {
            try (InputStream is = Panoply.class.getResourceAsStream("resources/logging.properties");){
                if (is == null) {
                    throw new RuntimeException("Got null loading logging.properties");
                }
                LogManager.getLogManager().readConfiguration(is);
            }
            catch (Exception exc) {
                System.err.println("initLogging - Error reading logging properties.");
                PanLoggingUtils.getClassLogger().error("Error reading logging properties.");
                if (!PanLoggingUtils.getClassLogger().isTraceEnabled()) break block9;
                exc.printStackTrace();
            }
        }
    }

    public static void setLogLevel(String level) {
        for (PanLoggingGroup grp : PanLoggingGroup.values()) {
            PanLoggingUtils.setLogLevel(grp, level);
        }
    }

    public static void setLogLevel(PanLoggingGroup pkggroup, String level) {
        String[] packages;
        Objects.requireNonNull(pkggroup, "Group cannot be null.");
        Objects.requireNonNull(level, "Log level cannot be null.");
        if (level.isEmpty()) {
            throw new IllegalArgumentException("Log level is the empty string");
        }
        PanLoggingUtils.getClassLogger().info("Setting {} log level to {}", (Object)pkggroup, (Object)level);
        Level newLevel = Level.parse(level.toUpperCase());
        for (String pkgname : packages = pkggroup.getPackageList()) {
            java.util.logging.Logger pkglogger = java.util.logging.Logger.getLogger(pkgname);
            try {
                PanLoggingUtils.getClassLogger().info("Changing {} log level to {}", (Object)pkgname, (Object)newLevel);
                pkglogger.setLevel(newLevel);
            }
            catch (Exception exc) {
                PanLoggingUtils.getClassLogger().warn("Changing log level failed: {}", (Object)exc.toString());
                if (!PanLoggingUtils.getClassLogger().isTraceEnabled()) continue;
                exc.printStackTrace();
            }
        }
    }

    public static void addHandler(Handler handler) {
        handler.setFormatter(new LogFormatter());
        handler.setLevel(Level.FINEST);
        java.util.logging.Logger rootlogger = java.util.logging.Logger.getLogger("");
        rootlogger.addHandler(handler);
        xtraHandlers.add(handler);
    }

    public static void closeLoggers() {
        if (loggerPS_ != null) {
            try {
                loggerPS_.flush();
                loggerPS_.close();
                loggerPS_ = null;
                for (Handler handler : xtraHandlers) {
                    handler.flush();
                    handler.close();
                    xtraHandlers.remove(handler);
                }
            }
            catch (Exception exc) {
                PanLoggingUtils.getClassLogger().warn("Failed to close primary logging PrintStream.");
            }
        }
        for (Handler handler : xtraHandlers) {
            try {
                handler.flush();
                handler.close();
            }
            catch (Exception exc) {
                PanLoggingUtils.getClassLogger().warn("Failed to close an extra handler's logging steam.");
            }
        }
        xtraHandlers.clear();
    }

    private static Logger getClassLogger() {
        return LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }

    private PanLoggingUtils() {
    }

    static {
        xtraHandlers = new ArrayList();
    }
}

