/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.log;

import gov.nasa.giss.panoply.log.PanLoggingUtils;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.log.LoggingListener;
import gov.nasa.giss.ui.log.TextAreaLoggingHandler;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanLoggingFrame
extends PanFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int INIT_WIDTH = 1000;
    private static final int INIT_HEIGHT = 480;
    private static final int MIN_WIDTH = 600;
    private static final int MIN_HEIGHT = 400;
    private JPanel contentBox_;
    private JTextArea tarea_;
    private TextAreaLoggingHandler lhandler_;
    private Dimension minSize_;
    private int chromeWidth_;
    private int chromeHeight_;

    public static PanLoggingFrame getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanLoggingFrame() {
        super("Logging");
        this.setName(this.getTitle());
        if (PlatformUtils.isWindows()) {
            this.setTitle("Panoply: " + this.getTitle());
        }
        this.setResizable(true);
        this.setDefaultCloseOperation(1);
        this.setPanMenuBar(new PanMenuBar(this));
        this.createLayout();
        this.initTALogging();
        this.placeOnScreen();
        this.attachListeners();
        this.placeOnScreen();
    }

    private void createLayout() {
        this.tarea_ = new JTextArea();
        this.tarea_.setEditable(true);
        this.tarea_.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.tarea_.setBackground(new Color(221, 221, 221));
        JScrollPane scrollPane = new JScrollPane(this.tarea_);
        scrollPane.setBorder(PanGuiUtils.NO_BORDER);
        this.contentBox_ = new JPanel();
        this.contentBox_.setLayout(new BoxLayout(this.contentBox_, 1));
        this.contentBox_.setBorder(PanGuiUtils.NO_BORDER);
        this.contentBox_.add(scrollPane);
        this.contentBox_.add(this.statusBar_);
        this.contentBox_.setPreferredSize(new Dimension(1000, 480));
        this.getContentPane().add(this.contentBox_);
        Dimension bbminsize = this.contentBox_.getMinimumSize();
        PanPreferences prefs = PanPreferences.getSharedInstance();
        int prefw = prefs.getInt("logging:bounds.width");
        int prefh = prefs.getInt("logging:bounds.height");
        int bbwidth = Math.max(bbminsize.width, prefw);
        int bbheight = Math.max(bbminsize.height, prefh);
        this.contentBox_.setPreferredSize(new Dimension(bbwidth, bbheight));
        this.contentBox_.setMaximumSize(new Dimension(9999, 9999));
        this.getContentPane().add(this.contentBox_);
        this.pack();
        Dimension dd = this.getSize();
        this.chromeWidth_ = dd.width - bbwidth;
        this.chromeHeight_ = dd.height - bbheight;
        this.minSize_ = new Dimension(bbminsize.width + this.chromeWidth_, bbminsize.height + this.chromeHeight_);
        if (PlatformUtils.isMacintosh() || PlatformUtils.isWindows()) {
            this.setMinimumSize(this.minSize_);
        }
    }

    @Override
    public void doLayout() {
        if (this.getWidth() < 600 || this.getHeight() < 400) {
            int w = Math.max(this.getWidth(), 600);
            int h = Math.max(this.getHeight(), 400);
            this.setSize(new Dimension(w, h));
        }
        super.doLayout();
    }

    @Override
    protected void placeOnScreen() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        try {
            int whereX = prefs.getInt("logging:bounds.left");
            int whereY = prefs.getInt("logging:bounds.top");
            if (whereX < 0 && whereY < 0) {
                Rectangle rr = GuiUtils.getActiveScreenBounds();
                Dimension psize = this.getSize();
                if (rr == null) {
                    whereX = 50;
                    whereY = 50;
                } else if (PlatformUtils.isMacintosh()) {
                    whereX = rr.x + (rr.width - psize.width) / 2;
                    whereY = rr.y + (rr.height - psize.height) / 2 + 10;
                } else {
                    whereX = rr.x + (rr.width - psize.width) / 2;
                    whereY = rr.y + (rr.height - psize.height) / 2;
                }
                prefs.setInt("logging:bounds.left", whereX);
                prefs.setInt("logging:bounds.top", whereY);
            }
            this.setLocation(new Point(whereX, whereY));
        }
        catch (Exception exc) {
            super.placeOnScreen();
        }
    }

    private void attachListeners() {
        final PanPreferences prefs = PanPreferences.getSharedInstance();
        this.tarea_.getDocument().addDocumentListener(new LoggingListener());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (!PanLoggingFrame.this.isVisible()) {
                    return;
                }
                Point p = PanLoggingFrame.this.getLocationOnScreen();
                prefs.setInt("logging:bounds.left", p.x);
                prefs.setInt("logging:bounds.top", p.y);
                if (PanLoggingFrame.this.needsResizeToFitDisplay()) {
                    PanLoggingFrame.this.resizeToFitDisplay();
                }
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension dd = PanLoggingFrame.this.getSize();
                if (!(PlatformUtils.isMacintosh() || PlatformUtils.isWindows() || dd.width >= PanLoggingFrame.this.minSize_.width && dd.height >= PanLoggingFrame.this.minSize_.height)) {
                    dd.width = Math.max(PanLoggingFrame.this.minSize_.width, dd.width);
                    dd.height = Math.max(PanLoggingFrame.this.minSize_.height, dd.height);
                    PanLoggingFrame.this.setSize(dd);
                    dd.width -= PanLoggingFrame.this.chromeWidth_;
                    dd.height -= PanLoggingFrame.this.chromeHeight_;
                    PanLoggingFrame.this.contentBox_.setSize(dd);
                    PanLoggingFrame.this.getContentPane().validate();
                    return;
                }
                prefs.setInt("logging:bounds.width", PanLoggingFrame.this.contentBox_.getWidth());
                prefs.setInt("logging:bounds.height", PanLoggingFrame.this.contentBox_.getHeight());
            }
        });
    }

    @Override
    public void resizeToFitDisplay() {
        if (this.contentBox_ == null) {
            LOGGER.trace("sp is null");
            return;
        }
        Dimension dd = this.getSize();
        Rectangle rr = this.isVisible() ? GuiUtils.getFrameScreenBounds(this) : GuiUtils.getActiveScreenBounds();
        Insets ins = this.isVisible() ? GuiUtils.getFrameScreenInsets(this) : GuiUtils.getActiveScreenInsets();
        int insW = Math.max(24, ins.left + ins.right);
        int insH = Math.max(24, ins.top + ins.bottom);
        int availW = rr.width - insW;
        int availH = rr.height - insH;
        int excessW = Math.max(0, dd.width - availW);
        int excessH = Math.max(0, dd.height - availH);
        Dimension bbSize = this.contentBox_.getSize();
        bbSize.width -= excessW;
        bbSize.height -= excessH;
        this.contentBox_.setPreferredSize(bbSize);
        this.contentBox_.invalidate();
        this.contentBox_.validate();
        this.pack();
        this.repaint();
    }

    public void initTALogging() {
        LOGGER.trace("lhandler exists? {}", (Object)(this.lhandler_ != null ? 1 : 0));
        if (this.lhandler_ == null) {
            LOGGER.trace("Adding logging handler");
            this.lhandler_ = new TextAreaLoggingHandler(this.tarea_);
            PanLoggingUtils.addHandler(this.lhandler_);
            LOGGER.info("TextAreaLoggingHandler is initialized");
        }
    }

    public void writeLog(File f) throws IOException {
        try {
            FileWriter fw = new FileWriter(f, true);
            this.tarea_.write(fw);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception exc) {
            throw exc;
        }
    }

    private static class Singleton {
        private static final PanLoggingFrame INSTANCE = new PanLoggingFrame();

        private Singleton() {
        }
    }
}

