/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.dialog;

import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanExportKmlOption;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanExportKmzDialog
extends JDialog {
    private final PanFrame pframe_;
    private PanCheckBox transparentCB_;
    private PanCheckBox scaleCB_;
    private PanCheckBox borderCB_;
    private JButton cancelBtn_;
    private JButton makeBtn_;
    private boolean success_;

    public PanExportKmzDialog(PanFrame pframe) {
        super(pframe, "KMZ Export Options", true);
        this.pframe_ = pframe;
        this.setResizable(false);
        this.createLayout();
        this.attachListeners();
    }

    private void createLayout() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        this.transparentCB_ = PanCheckBox.create("Fill color should be transparent", prefs.getBoolean("files:save.kmz.knockout"));
        this.scaleCB_ = PanCheckBox.create("Include scale colorbar overlay", prefs.getBoolean("files:save.kmz.scale"));
        this.borderCB_ = PanCheckBox.create("Map border should be visible", prefs.getBoolean("files:save.kmz.border"));
        QuickBox transparencyBox = QuickBox.createLeftBox(this.transparentCB_, Box.createHorizontalStrut(48));
        QuickBox scaleBox = QuickBox.createLeftBox(this.scaleCB_, Box.createHorizontalStrut(48));
        QuickBox borderBox = QuickBox.createLeftBox(this.borderCB_, Box.createHorizontalStrut(48));
        this.makeBtn_ = new JButton("Okay");
        this.cancelBtn_ = new JButton("Cancel");
        QuickBox buttonBox = PlatformUtils.isMacintosh() ? QuickBox.createRightBox(this.cancelBtn_, this.makeBtn_) : QuickBox.createRightBox(this.makeBtn_, this.cancelBtn_);
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(3, 5, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(PanGuiUtils.STD_BORDER);
        contentPanel.add((Component)transparencyBox, new FGConstraint(0, 0, 2, 1));
        contentPanel.add((Component)scaleBox, new FGConstraint(0, 1, 2, 1));
        contentPanel.add((Component)borderBox, new FGConstraint(0, 2, 2, 1));
        contentPanel.add((Component)new JLabel(" "), new FGConstraint(0, 3, 2, 1));
        contentPanel.add((Component)buttonBox, new FGConstraint(1, 4, 1.0));
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(this.makeBtn_);
        this.pack();
        Rectangle rr = this.pframe_.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
    }

    private void attachListeners() {
        this.makeBtn_.addActionListener(e -> {
            PanPreferences prefs = PanPreferences.getSharedInstance();
            prefs.setBoolean("files:save.kmz.knockout", this.transparentCB_.isSelected());
            prefs.setBoolean("files:save.kmz.scale", this.scaleCB_.isSelected());
            prefs.setBoolean("files:save.kmz.border", this.borderCB_.isSelected());
            this.success_ = true;
            this.setVisible(false);
        });
        this.cancelBtn_.addActionListener(e -> this.setVisible(false));
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public Hashtable<PanExportKmlOption, Object> getOptions() {
        Hashtable<PanExportKmlOption, Object> opts = new Hashtable<PanExportKmlOption, Object>(12);
        opts.put(PanExportKmlOption.BORDER, this.borderCB_.isSelected());
        opts.put(PanExportKmlOption.KNOCKOUT, this.transparentCB_.isSelected());
        opts.put(PanExportKmlOption.CBAR, this.scaleCB_.isSelected());
        return opts;
    }
}

